@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:Main
chcp 1251
set /a UseProfiler=0
set /a UseSimulation=0
set "NameLib=daqlib"
set "target=%~n0.crc"
if exist %target% del /f %target%
call :RadiationHazard                          >> %target%
call :AirBlower Right 0                        >> %target%
call :AirBlower Up    1                        >> %target%
call :AirBlower Left  2                        >> %target%
call :AirBlower Down  3                        >> %target%
call :FanBlower Right 0                        >> %target%
call :FanBlower Up    1                        >> %target%
call :FanBlower Left  2                        >> %target%
call :FanBlower Down  3                        >> %target%
call :WaterPump Right 0                        >> %target%
call :WaterPump Up    1                        >> %target%
call :WaterPump Left  2                        >> %target%
call :WaterPump Down  3                        >> %target%
call :TankLevel                                >> %target%
call :FlowMeter Right 0                        >> %target%
call :FlowMeter Up    1                        >> %target%
call :FlowMeter Left  2                        >> %target%
call :FlowMeter Down  3                        >> %target%
call :ManoMeter                                >> %target%
call :UniHeater                                >> %target%
goto :EOF

:Profiler
if "%~1" == "" goto :EOF
if not "%UseProfiler%" == "1" goto :EOF
if /i "%~1" == "Start" (
 if "%UseSimulation%" == "1" echo setsimulation^(1^)
 echo _profile_=mksecnow^(^)
) else (
 echo _profile_=mksecnow^(^)-_profile_
 if "%UseSimulation%" == "1" echo setsimulation^(0^)
 echo @echo Profile: %~1 takes %%_profile_ mks
)
goto :EOF

:RadiationHazard
echo ;===========================================================
echo ; Draw Radiation Hazard sign (U+2622).
echo ; Parameters required:
echo ; 1) glRadiationHazardBevel     - bevel thickness  (2)
echo ; 2) glRadiationHazardBackColor - background color (yellow)
echo ; 3) glRadiationHazardFillColor - foreground color (black)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = RadiationHazard
echo ;  [RadiationHazard]
echo ;  Pos = 10 10
echo ;  Painter(v) = (glRadiationHazardBevel=2)+(glRadiationHazardBackColor=clYellow)+(glRadiationHazardFillColor=clBlack)
echo ;  Painter(v) = [Painter(v).%NameLib%.RadiationHazard]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_48_48_4_silver.bmp
echo ;  Hint = Demo RadiationHazard
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.RadiationHazard]
call :Profiler Start
echo var glRadiationHazardBevel,glRadiationHazardBackColor,glRadiationHazardFillColor
echo (_x1_=glRadiationHazardBevel)+(_y1_=_x1_)+(_x2_=min(sensorWidth(),sensorHeight())-_x1_)+(_y2_=_x2_)+(_c1_=glRadiationHazardBackColor)+(_c2_=glRadiationHazardFillColor)
echo setPen(_c1_,psSolid,pmCopy,1)+setBrush(_c1_,bsSolid)+drawBar(_x1_,_y1_,_x2_,_y2_)+(_x2_=_x2_-_x1_)+(_y2_=_x2_)+(_x1_=_x1_+_x1_)+(_y1_=_x1_)
echo (_rd_=0.5*(_x2_-_x1_))+(_cx_=_x1_+_rd_)+(_cy_=_cx_)+(_fi_=-pi/6)+(_f0_=pi/2-_fi_*2)+setPen(_c2_,psSolid,pmCopy,1)+setBrush(_c2_,bsSolid)
echo drawPie(_x1_,_y1_,_x2_,_y2_,_cx_+_rd_*cos(_f0_+_fi_*1),_cy_+_rd_*sin(_f0_+_fi_*1),_cx_+_rd_*cos(_f0_+_fi_*3),_cy_+_rd_*sin(_f0_+_fi_*3))
echo drawPie(_x1_,_y1_,_x2_,_y2_,_cx_+_rd_*cos(_f0_+_fi_*5),_cy_+_rd_*sin(_f0_+_fi_*5),_cx_+_rd_*cos(_f0_+_fi_*7),_cy_+_rd_*sin(_f0_+_fi_*7))
echo drawPie(_x1_,_y1_,_x2_,_y2_,_cx_+_rd_*cos(_f0_+_fi_*9),_cy_+_rd_*sin(_f0_+_fi_*9),_cx_+_rd_*cos(_f0_+_fi_*11),_cy_+_rd_*sin(_f0_+_fi_*11))
echo (_r2_=_rd_*0.3)+setPen(_c1_,psSolid,pmCopy,1)+setBrush(_c1_,bsSolid)+drawEllipse(_cx_-_r2_,_cy_-_r2_,_cx_+_r2_,_cy_+_r2_)
echo (_r1_=_rd_*0.2)+setPen(_c2_,psSolid,pmCopy,1)+setBrush(_c2_,bsSolid)+drawEllipse(_cx_-_r1_,_cy_-_r1_,_cx_+_r1_,_cy_+_r1_)
echo (glRadiationHazardBevel=2)+(glRadiationHazardBackColor=clYellow)+(glRadiationHazardFillColor=clBlack)
call :Profiler RadiationHazard
echo []
echo [Circuit.StartupScript]
echo (glRadiationHazardBevel=2)+(glRadiationHazardBackColor=clYellow)+(glRadiationHazardFillColor=clBlack)
echo []
echo.
goto :EOF

:AirBlower
echo ;===========================================================
echo ; Draw AirBlower (%1).
echo ; Parameters required:
echo ; 1) glAirBlowerBevel     - bevel thickness  (2)
echo ; 2) glAirBlowerLineWidth - line width       (2)
echo ; 3) glAirBlowerFillColor - fill color       (silver)
echo ; 4) glAirBlowerLineColor - line color       (black)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = AirBlower.%1
echo ;  [AirBlower.%1]
echo ;  Pos = 10 10
echo ;  Painter(v) = (glAirBlowerBevel=2)+(glAirBlowerLineWidth=2)+(glAirBlowerFillColor=clSilver)+(glAirBlowerLineColor=clBlack)
echo ;  Painter(v) = [Painter(v).%NameLib%.AirBlower.%1]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_48_48_4_silver.bmp
echo ;  Hint = Demo AirBlower.%1
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.AirBlower.%1]
call :Profiler Start
echo var glAirBlowerBevel,glAirBlowerLineWidth,glAirBlowerFillColor,glAirBlowerLineColor
echo (_x1_=glAirBlowerBevel)+(_y1_=_x1_)+(_x2_=min(sensorWidth(),sensorHeight())-_x1_)+(_y2_=_x2_)+(_c1_=glAirBlowerFillColor)+(_c2_=glAirBlowerLineColor)+(_lw_=glAirBlowerLineWidth)
echo (_rd_=0.5*(_x2_-_x1_))+(_cx_=_x1_+_rd_)+(_cy_=_cx_)+(_f0_=pi-%2*pi/2)+(_f1_=pi*0.288)+(_f2_=pi*0.868)
echo setPen(_c2_,psSolid,pmCopy,_lw_)+setBrush(_c1_,bsSolid)+drawEllipse(_x1_,_y1_,_x2_,_y2_)+setPen(_c2_,psSolid,pmCopy,max(1,_lw_/2))
echo drawLine(_cx_+_rd_*cos(_f0_+_f1_),_cy_+_rd_*sin(_f0_+_f1_),_cx_+_rd_*cos(_f0_+_f2_),_cy_+_rd_*sin(_f0_+_f2_))
echo drawLine(_cx_+_rd_*cos(_f0_-_f1_),_cy_+_rd_*sin(_f0_-_f1_),_cx_+_rd_*cos(_f0_-_f2_),_cy_+_rd_*sin(_f0_-_f2_))
echo (glAirBlowerBevel=2)+(glAirBlowerLineWidth=2)+(glAirBlowerFillColor=clSilver)+(glAirBlowerLineColor=clBlack)
call :Profiler AirBlower.%1
echo []
echo [Circuit.StartupScript]
echo (glAirBlowerBevel=2)+(glAirBlowerLineWidth=2)+(glAirBlowerFillColor=clSilver)+(glAirBlowerLineColor=clBlack)
echo []
echo.
goto :EOF

:FanBlower
echo ;===========================================================
echo ; Draw FanBlower (%1).
echo ; Parameters required:
echo ; 1) glFanBlowerBevel     - bevel thickness  (2)
echo ; 2) glFanBlowerLineWidth - line width       (2)
echo ; 3) glFanBlowerFillColor - fill color       (silver)
echo ; 4) glFanBlowerLineColor - line color       (black)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = FanBlower.%1
echo ;  [FanBlower.%1]
echo ;  Pos = 10 10
echo ;  Painter(v) = (glFanBlowerBevel=2)+(glFanBlowerLineWidth=2)+(glFanBlowerFillColor=clSilver)+(glFanBlowerLineColor=clBlack)
echo ;  Painter(v) = [Painter(v).%NameLib%.FanBlower.%1]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_48_48_4_silver.bmp
echo ;  Hint = Demo FanBlower.%1
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.FanBlower.%1]
call :Profiler Start
echo var glFanBlowerBevel,glFanBlowerLineWidth,glFanBlowerFillColor,glFanBlowerLineColor
echo (_x1_=glFanBlowerBevel)+(_y1_=_x1_)+(_x2_=min(sensorWidth(),sensorHeight())-_x1_)+(_y2_=_x2_)+(_c1_=glFanBlowerFillColor)+(_c2_=glFanBlowerLineColor)+(_lw_=glFanBlowerLineWidth)
echo (_rd_=0.5*(_x2_-_x1_))+(_cx_=_x1_+_rd_)+(_cy_=_cx_)+(_f0_=pi-%2*pi/2)+(_f1_=pi*0.288)+(_f2_=pi*0.868)+(_f3_=pi/10)+(_r1_=_rd_*0.3)+(_r2_=_rd_*0.6)
echo setPen(_c2_,psSolid,pmCopy,_lw_)+setBrush(_c1_,bsSolid)+drawEllipse(_x1_,_y1_,_x2_,_y2_)+setPen(_c2_,psSolid,pmCopy,max(1,_lw_/2))
echo drawLine(_cx_+_rd_*cos(_f0_+_f1_),_cy_+_rd_*sin(_f0_+_f1_),_cx_+_rd_*cos(_f0_+_f2_),_cy_+_rd_*sin(_f0_+_f2_))
echo drawLine(_cx_+_rd_*cos(_f0_-_f1_),_cy_+_rd_*sin(_f0_-_f1_),_cx_+_rd_*cos(_f0_-_f2_),_cy_+_rd_*sin(_f0_-_f2_))
echo (_f0_=_f0_-pi)+drawPoly(0,0,plClear)+drawPoly(_cx_,_cy_,plAddPoint)+drawPoly(_cx_+_r1_*cos(_f0_+_f3_),_cy_+_r1_*sin(_f0_+_f3_),plAddPoint)
echo drawPoly(_cx_+_r2_*cos(_f0_),_cy_+_r2_*sin(_f0_),plAddPoint)+drawPoly(_cx_+_r1_*cos(_f0_-_f3_),_cy_+_r1_*sin(_f0_-_f3_),plAddPoint)
echo drawPoly(_cx_,_cy_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (_f0_=_f0_+pi*2/3)+drawPoly(0,0,plClear)+drawPoly(_cx_,_cy_,plAddPoint)+drawPoly(_cx_+_r1_*cos(_f0_+_f3_),_cy_+_r1_*sin(_f0_+_f3_),plAddPoint)
echo drawPoly(_cx_+_r2_*cos(_f0_),_cy_+_r2_*sin(_f0_),plAddPoint)+drawPoly(_cx_+_r1_*cos(_f0_-_f3_),_cy_+_r1_*sin(_f0_-_f3_),plAddPoint)
echo drawPoly(_cx_,_cy_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (_f0_=_f0_+pi*2/3)+drawPoly(0,0,plClear)+drawPoly(_cx_,_cy_,plAddPoint)+drawPoly(_cx_+_r1_*cos(_f0_+_f3_),_cy_+_r1_*sin(_f0_+_f3_),plAddPoint)
echo drawPoly(_cx_+_r2_*cos(_f0_),_cy_+_r2_*sin(_f0_),plAddPoint)+drawPoly(_cx_+_r1_*cos(_f0_-_f3_),_cy_+_r1_*sin(_f0_-_f3_),plAddPoint)
echo drawPoly(_cx_,_cy_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glFanBlowerBevel=2)+(glFanBlowerLineWidth=2)+(glFanBlowerFillColor=clSilver)+(glFanBlowerLineColor=clBlack)
call :Profiler FanBlower.%1
echo []
echo [Circuit.StartupScript]
echo (glFanBlowerBevel=2)+(glFanBlowerLineWidth=2)+(glFanBlowerFillColor=clSilver)+(glFanBlowerLineColor=clBlack)
echo []
echo.
goto :EOF

:WaterPump
echo ;===========================================================
echo ; Draw WaterPump (%1).
echo ; Parameters required:
echo ; 1) glWaterPumpBevel      - bevel thickness  (2)
echo ; 2) glWaterPumpLineWidth  - line width       (2)
echo ; 3) glWaterPumpFillColor  - fill color       (silver)
echo ; 4) glWaterPumpLineColor  - line color       (black)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = WaterPump.%1
echo ;  [WaterPump.%1]
echo ;  Pos = 10 10
echo ;  Painter(v) = (glWaterPumpBevel=2)+(glWaterPumpLineWidth=2)+(glWaterPumpFillColor=clSilver)+(glWaterPumpLineColor=clBlack)
echo ;  Painter(v) = [Painter(v).%NameLib%.WaterPump.%1]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_48_48_4_silver.bmp
echo ;  Hint = Demo WaterPump.%1
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.WaterPump.%1]
call :Profiler Start
echo var glWaterPumpBevel,glWaterPumpLineWidth,glWaterPumpFillColor,glWaterPumpLineColor
echo (_x1_=glWaterPumpBevel)+(_y1_=_x1_)+(_x2_=min(sensorWidth(),sensorHeight())-_x1_)+(_y2_=_x2_)+(_c1_=glWaterPumpFillColor)+(_c2_=glWaterPumpLineColor)+(_lw_=glWaterPumpLineWidth)
echo (_rd_=0.5*(_x2_-_x1_))+(_cx_=_x1_+_rd_)+(_cy_=_cx_)+(_f0_=pi-%2*pi/2)+(_f1_=pi*0.288)+(_f2_=pi*0.868)+(_dr_=2*_rd_*cos(_f1_))
echo setPen(_c2_,psSolid,pmCopy,_lw_)+setBrush(_c1_,bsSolid)+drawEllipse(_x1_,_y1_,_x2_,_y2_)+setPen(_c2_,psSolid,pmCopy,max(1,_lw_/2))
echo drawLine(_bx_=_cx_+_rd_*cos(_f0_+_f1_),_by_=_cy_+_rd_*sin(_f0_+_f1_),_cx_+_rd_*cos(_f0_+_f2_),_cy_+_rd_*sin(_f0_+_f2_))
echo drawLine(_ax_=_cx_+_rd_*cos(_f0_-_f1_),_ay_=_cy_+_rd_*sin(_f0_-_f1_),_cx_+_rd_*cos(_f0_-_f2_),_cy_+_rd_*sin(_f0_-_f2_))
echo drawArc(_cx_+_dr_*cos(_f0_)-_rd_,_cy_+_dr_*sin(_f0_)-_rd_,_cx_+_dr_*cos(_f0_)+_rd_,_cy_+_dr_*sin(_f0_)+_rd_,_ax_,_ay_,_bx_,_by_)
echo (glWaterPumpBevel=2)+(glWaterPumpLineWidth=2)+(glWaterPumpFillColor=clSilver)+(glWaterPumpLineColor=clBlack)
call :Profiler WaterPump.%1
echo []
echo [Circuit.StartupScript]
echo (glWaterPumpBevel=2)+(glWaterPumpLineWidth=2)+(glWaterPumpFillColor=clSilver)+(glWaterPumpLineColor=clBlack)
echo []
echo.
goto :EOF

:TankLevel
echo ;===========================================================
echo ; Draw TankLevel.
echo ; Parameters required:
echo ; 1) glTankLevelBevel       - bevel thickness  (1)
echo ; 2) glTankLevelLineWidth   - line width       (2)
echo ; 3) glTankLevelFillColor   - fill color       (teal)
echo ; 4) glTankLevelBackColor   - back color       (silver)
echo ; 5) glTankLevelLineColor   - line color       (black)
echo ; 6) glTankLevelPercent     - filling %% level  (0)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = TankLevel
echo ;  [TankLevel]
echo ;  Pos = 10 10
echo ;  Painter(v) = (glTankLevelBevel=2)+(glTankLevelLineWidth=2)+(glTankLevelFillColor=clTeal)+(glTankLevelBackColor=clSilver)
echo ;  Painter(v) = (glTankLevelLineColor=clBlack)+(glTankLevelPercent=0)
echo ;  Painter(v) = [Painter(v).%NameLib%.TankLevel]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_48_48_4_silver.bmp
echo ;  Hint = Demo TankLevel
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.TankLevel]
call :Profiler Start
echo var glTankLevelBevel,glTankLevelLineWidth,glTankLevelFillColor,glTankLevelBackColor,glTankLevelLineColor
echo (_x1_=glTankLevelBevel)+(_y1_=_x1_)+(_x2_=sensorWidth()-_x1_)+(_y2_=sensorHeight()-_y1_)+(_sx_=_x2_-_x1_)+(_sy_=_y2_-_y1_)
echo (_c1_=glTankLevelFillColor)+(_c2_=glTankLevelBackColor)+(_c3_=glTankLevelLineColor)+(_lw_=glTankLevelLineWidth)+(_n0_=6)+(_n1_=_n0_-1)+(_n2_=_n0_-2)
echo setPen(_c3_,psSolid,pmCopy,_lw_)+setBrush(_c2_,bsSolid)+(_dx_=_sx_/_n0_)+(_dy_=_sy_/_n0_)+(_v_=max(0,min(1,glTankLevelPercent/100)))
echo drawPoly(0,0,plClear)+drawPoly(_x1_+_dx_,_y1_,plAddPoint)+drawPoly(_x1_+_dx_*_n1_,_y1_,plAddPoint)+drawPoly(_x2_,_y1_+_dy_,plAddPoint)
echo drawPoly(_x2_,_y_=_y1_+_dy_*(1+(1-_v_)*_n2_),plAddPoint)+drawPoly(_x1_,_y_,plAddPoint)+drawPoly(_x1_,_y1_+_dy_,plAddPoint)
echo drawPoly(_x1_+_dx_,_y1_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)+setBrush(_c1_,bsSolid)
echo drawPoly(0,0,plClear)+drawPoly(_x1_,_y_,plAddPoint)+drawPoly(_x2_,_y_,plAddPoint)+drawPoly(_x2_,_y2_-_dy_,plAddPoint)
echo drawPoly(_x2_-_dx_,_y2_,plAddPoint)+drawPoly(_x1_+_dx_,_y2_,plAddPoint)+drawPoly(_x1_,_y2_-_dy_,plAddPoint)
echo drawPoly(_x1_,_y_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glTankLevelBevel=1)+(glTankLevelLineWidth=2)+(glTankLevelFillColor=clTeal)+(glTankLevelBackColor=clSilver)+(glTankLevelLineColor=clBlack)+(glTankLevelPercent=0)
call :Profiler TankLevel
echo []
echo [Circuit.StartupScript]
echo (glTankLevelBevel=1)+(glTankLevelLineWidth=2)+(glTankLevelFillColor=clTeal)+(glTankLevelBackColor=clSilver)+(glTankLevelLineColor=clBlack)+(glTankLevelPercent=0)
echo []
echo.
goto :EOF

:FlowMeter
echo ;===========================================================
echo ; Draw FlowMeter (%1).
echo ; Parameters required:
echo ; 1) glFlowMeterBevel      - bevel thickness  (2)
echo ; 2) glFlowMeterLineWidth  - line width       (2)
echo ; 3) glFlowMeterFillColor  - fill color       (silver)
echo ; 4) glFlowMeterLineColor  - line color       (black)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = FlowMeter.%1
echo ;  [FlowMeter.%1]
echo ;  Pos = 10 10
echo ;  Painter(v) = (glFlowMeterBevel=2)+(glFlowMeterLineWidth=2)+(glFlowMeterFillColor=clSilver)+(glFlowMeterLineColor=clBlack)
echo ;  Painter(v) = [Painter(v).%NameLib%.FlowMeter.%1]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_48_48_4_silver.bmp
echo ;  Hint = Demo FlowMeter.%1
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.FlowMeter.%1]
call :Profiler Start
echo var glFlowMeterBevel,glFlowMeterLineWidth,glFlowMeterFillColor,glFlowMeterLineColor
echo (_x1_=glFlowMeterBevel)+(_y1_=_x1_)+(_x2_=min(sensorWidth(),sensorHeight())-_x1_)+(_y2_=_x2_)+(_c1_=glFlowMeterFillColor)+(_c2_=glFlowMeterLineColor)+(_lw_=glFlowMeterLineWidth)
echo (_rd_=0.5*(_x2_-_x1_))+(_cx_=_x1_+_rd_)+(_cy_=_cx_)+(_r2_=0.5*_rd_)+(_f0_=pi-%2*pi/2)+(_f1_=pi/6)+(_f2_=pi+_f1_)+setPen(_c2_,psSolid,pmCopy,_lw_)+setBrush(_c1_,bsSolid)
echo drawPie(_x1_,_y1_,_x2_,_y2_,_p1x_=_cx_+_r2_*cos(_f0_+_f1_),_p1y_=_cy_+_r2_*sin(_f0_+_f1_),_p2x_=_cx_+_r2_*cos(_f0_-_f1_),_p2y_=_cy_+_r2_*sin(_f0_-_f1_))
echo drawPie(_x1_,_y1_,_x2_,_y2_,_p3x_=_cx_+_r2_*cos(_f0_+_f2_),_p3y_=_cy_+_r2_*sin(_f0_+_f2_),_p4x_=_cx_+_r2_*cos(_f0_-_f2_),_p4y_=_cy_+_r2_*sin(_f0_-_f2_))
echo setPen(_c2_,psClear,pmCopy,0)+drawBar(_p1x_,_p1y_,_p3x_,_p3y_)+setPen(_c2_,psSolid,pmCopy,_lw_)+drawLine(_p1x_,_p1y_,_p4x_,_p4y_)+drawLine(_p2x_,_p2y_,_p3x_,_p3y_)
echo setBrush(_c1_,bsClear)+drawEllipse(_x1_,_y1_,_x2_,_y2_)
::echo setPen(_c2_,psSolid,pmCopy,1)+(_ra_=0.3*_rd_)+(_rb_=0.85*_rd_)+drawArrow(_cx_-_ra_*cos(_f0_),_cy_-_ra_*sin(_f0_),_cx_-_rb_*cos(_f0_),_cy_-_rb_*sin(_f0_),4,2)
echo (glFlowMeterBevel=2)+(glFlowMeterLineWidth=2)+(glFlowMeterFillColor=clSilver)+(glFlowMeterLineColor=clBlack)
call :Profiler FlowMeter.%1
echo []
echo [Circuit.StartupScript]
echo (glFlowMeterBevel=2)+(glFlowMeterLineWidth=2)+(glFlowMeterFillColor=clSilver)+(glFlowMeterLineColor=clBlack)
echo []
echo.
goto :EOF

:ManoMeter
echo ;===========================================================
echo ; Draw ManoMeter.
echo ; Parameters required:
echo ; 1) glManoMeterBevel      - bevel thickness  (2)
echo ; 2) glManoMeterLineWidth  - line width       (2)
echo ; 3) glManoMeterFillColor  - fill color       (silver)
echo ; 4) glManoMeterLineColor  - line color       (black)
echo ; 5) glManoMeterAngle      - angle in degrees (45)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = ManoMeter
echo ;  [ManoMeter]
echo ;  Pos = 10 10
echo ;  Painter(v) = (glManoMeterBevel=2)+(glManoMeterLineWidth=2)+(glManoMeterFillColor=clSilver)+(glManoMeterLineColor=clBlack)+(glManoMeterAngle=45)
echo ;  Painter(v) = [Painter(v).%NameLib%.ManoMeter]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_48_48_4_silver.bmp
echo ;  Hint = Demo ManoMeter
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.ManoMeter]
call :Profiler Start
echo var glManoMeterBevel,glManoMeterLineWidth,glManoMeterFillColor,glManoMeterLineColor,glManoMeterAngle
echo (_x1_=glManoMeterBevel)+(_y1_=_x1_)+(_x2_=min(sensorWidth(),sensorHeight())-_x1_)+(_y2_=_x2_)+(_c1_=glManoMeterFillColor)+(_c2_=glManoMeterLineColor)+(_lw_=glManoMeterLineWidth)
echo (_rd_=0.5*(_x2_-_x1_))+(_cx_=_x1_+_rd_)+(_cy_=_cx_)+(_ra_=0.7*_rd_)+(_fi_=pi-glManoMeterAngle*pi/180)+(_la_=max(1,0.5*_lw_))+(_aw_=max(3,0.5*_ra_))+(_ah_=_aw_)
echo (_p1x_=_cx_+_ra_*cos(_fi_))+(_p1y_=_cy_+_ra_*sin(_fi_))+(_p2x_=_cx_+_ra_*cos(_fi_+pi))+(_p2y_=_cy_+_ra_*sin(_fi_+pi))
echo setPen(_c2_,psSolid,pmCopy,_lw_)+setBrush(_c1_,bsSolid)+drawEllipse(_x1_,_y1_,_x2_,_y2_)
echo setPen(_c2_,psSolid,pmCopy,_la_)+drawArrow(_p1x_,_p1y_,_p2x_,_p2y_,_aw_,_ah_)
echo (glManoMeterBevel=2)+(glManoMeterLineWidth=2)+(glManoMeterFillColor=clSilver)+(glManoMeterLineColor=clBlack)+(glManoMeterAngle=45)
call :Profiler ManoMeter.%1
echo []
echo [Circuit.StartupScript]
echo (glManoMeterBevel=2)+(glManoMeterLineWidth=2)+(glManoMeterFillColor=clSilver)+(glManoMeterLineColor=clBlack)+(glManoMeterAngle=45)
echo []
echo.
goto :EOF

:UniHeater
echo ;===========================================================
echo ; Draw UniHeater.
echo ; Parameters required:
echo ; 1) glUniHeaterBevel - bevel thickness (2)
echo ; 2) glUniHeaterColor - color           (clBlack)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = UniHeater
echo ;  [UniHeater]
echo ;  Pos = 10 10
echo ;  Painter(v) = (glUniHeaterBevel=2)+(glUniHeaterColor=clBlack)
echo ;  Painter(v) = [Painter(v).%NameLib%.UniHeater]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_48_48_4_silver.bmp
echo ;  Hint = Demo UniHeater
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.UniHeater]
call :Profiler Start
echo var glUniHeaterBevel,glUniHeaterColor
echo (_sw_=min(sensorWidth(),sensorHeight()))+(_x1_=glUniHeaterBevel)+(_x2_=_sw_-1-_x1_)+(_xm_=0.5*(_x1_+_x2_))+(_sx_=_x2_-_x1_)
echo (_sh_=min(sensorWidth(),sensorHeight()))+(_y1_=glUniHeaterBevel)+(_y2_=_sh_-1-_y1_)+(_ym_=0.5*(_y1_+_y2_))+(_sy_=_y2_-_y1_)
echo (_cl_=glUniHeaterColor)+(_yh_=_ym_-_sy_/4)+(_yl_=_ym_+_sy_/4)+(_lw_=int(_sy_/20))
echo setPen(_cl_,psSolid,pmCopy,1+_lw_*2)+drawLine(_x1_,_ym_,_x2_,_ym_)
echo (_n_=5)+(_xi_=_x1_)+(_dx_=_sx_/_n_-1)+setPen(_cl_,psSolid,pmCopy,max(1,_lw_))
echo drawLine(_xi_,_yh_,_xi_+_dx_,_yl_)+drawLine(_xi_,_yl_,_xi_+_dx_,_yh_)+(_xi_=_xi_+_dx_+1)
echo drawLine(_xi_,_yh_,_xi_+_dx_,_yl_)+drawLine(_xi_,_yl_,_xi_+_dx_,_yh_)+(_xi_=_xi_+_dx_+1)
echo drawLine(_xi_,_yh_,_xi_+_dx_,_yl_)+drawLine(_xi_,_yl_,_xi_+_dx_,_yh_)+(_xi_=_xi_+_dx_+1)
echo drawLine(_xi_,_yh_,_xi_+_dx_,_yl_)+drawLine(_xi_,_yl_,_xi_+_dx_,_yh_)+(_xi_=_xi_+_dx_+1)
echo drawLine(_xi_,_yh_,_xi_+_dx_,_yl_)+drawLine(_xi_,_yl_,_xi_+_dx_,_yh_)+(_xi_=_xi_+_dx_+1)
echo (glUniHeaterBevel=2)+(glUniHeaterColor=clBlack)
call :Profiler UniHeater
echo []
echo [Circuit.StartupScript]
echo (glUniHeaterBevel=2)+(glUniHeaterColor=clBlack)
echo []
echo.
goto :EOF
