#!/bin/bash

declare nsucc=0; # Success operation counter
declare nfail=0; # Failure operation counter

function dirs_to_lower_case(){
 local targdir="$1";
 if [ -z "$targdir" ]; then return 1; fi;
 if pushd $targdir > /dev/null; then
  local names="$(find . -type d | grep -v '^\.$')";
  for iname in $names; do
   lname="$(echo $iname  | tr '[:upper:]' '[:lower:]')";
   if [ "$iname" = "$lname" ]; then continue; fi;
   if mv -v $iname $lname; then let nsucc+=1; else let nerr+=1; fi;
  done;
 fi;
 popd > /dev/null;
};

function files_to_lower_case(){
 local targdir="$1";
 if [ -z "$targdir" ]; then return 1; fi;
 if pushd $targdir > /dev/null; then
  local names="$(find . -type f)";
  for iname in $names; do
   lname="$(echo $iname  | tr '[:upper:]' '[:lower:]')";
   if [ "$iname" = "$lname" ]; then continue; fi;
   if mv -v $iname $lname; then let nsucc+=1; else let nerr+=1; fi;
  done;
 fi;
 popd > /dev/null;
};

function files_validate_eol(){
 local targdir="$1"; shift;
 if [ -z "$targdir" ]; then return 1; fi;
 if pushd $targdir > /dev/null; then
  while [ -n "$1" ]; do
   local pattern="$1"; shift;
   local names="$(find . -type f -name $pattern)";
   for iname in $names; do
    if dos2unix -k -o -q $iname; then let nsucc+=1; else let nerr+=1; fi;
   done;
  done;
 fi;
 popd > /dev/null;
};

# files_iconv $PWD cp1251 utf8 *.ini *.cfg;
function files_iconv(){
 local targdir="$1"; shift;
 local cpf="$1"; shift;
 local cpt="$1"; shift;
 if [ -z "$targdir" ]; then return 1; fi;
 if pushd $targdir > /dev/null; then
  while [ -n "$1" ]; do
   local pattern="$1"; shift;
   local names="$(find . -type f -name $pattern)";
   for iname in $names; do
    if iconv -f $cpf -t $cpt $iname -o $iname.tmp; then
     let nsucc+=1;
     cp -f $iname.tmp $iname;
     rm -f $iname.tmp;
    else
     let nerr+=1;
     rm -f $iname.tmp;
    fi;
   done;
  done;
 fi;
 popd > /dev/null;
};

function has_option(){
 local opt="$1"; shift;
 if [ -z "$opt" ]; then return 1; fi;
 while [ -n "$1" ]; do
  if [ "$1" = "$opt" ]; then return 0; fi;
 done;
 return 1;
};

function crwsanizer(){
 dirs_to_lower_case  $PWD;
 files_to_lower_case $PWD;
 files_validate_eol  $PWD *.ini *.ini.old *.xml *.csv *.htm *.cal;
 if has_option -u "$@"; then files_iconv $PWD cp1251 utf8 *.ini *.ini.old *.xml *.csv *.cal; fi;
 echo "$nfail error(s), $nsucc success sanizer operations done.";
 if [ "$nfail" = "0" ]; then return 0; else return 1; fi;
};

crwsanizer "$@";

##############
## END OF FILE
##############
