@echo off
SetLocal EnableExtensions EnableDelayedExpansion

chcp 65001

if "%CRW_DAQ_SYS_HOME_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )
if "%CRW_DAQ_VAR_TMP_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )

path %path%;%CRW_DAQ_SYS_HOME_DIR%

call :DetectLanguage

:VerifyIntegrity
set /a VerifyIntegrity=0
echo VerifyIntegrity: 
checksum -csecure.md5 > "%CRW_DAQ_VAR_TMP_DIR%\checksum.log" || set /a VerifyIntegrity=1
type                    "%CRW_DAQ_VAR_TMP_DIR%\checksum.log"
if /I "%Language%" == "Russian" goto :Russian
:English
if "%VerifyIntegrity%" == "0" call :IntegritySuccessDetected "crwdaq_%CRW_DAQ_SYS_SESSION_NB% : Integrity Check is Successful." "view Log"
if "%VerifyIntegrity%" == "1" call :IntegrityFailureDetected "crwdaq_%CRW_DAQ_SYS_SESSION_NB% : Integrity Check is Failed."     "view Log"
goto :EOF
:Russian
if "%VerifyIntegrity%" == "0" call :IntegritySuccessDetected "crwdaq_%CRW_DAQ_SYS_SESSION_NB% : Целостность в норме."  "см. Журнал"
if "%VerifyIntegrity%" == "1" call :IntegrityFailureDetected "crwdaq_%CRW_DAQ_SYS_SESSION_NB% : Целостность НАРУШЕНА." "см. Журнал"
goto :EOF

:DetectLanguage
set Language=English
for /F "eol=; tokens=1,2* delims= " %%i in ('unix inifile %CRW_DAQ_SYS_HOME_DIR%\settings\crwdaq.lng [System] Language') do if /I "%%i" == "set" %%i %%j
goto :EOF

:syslog_success_cmnd
set "checkMsg=%checkMsg%@silent @syslog INFO/SUCCESS System - %~1\n"
goto :EOF

:syslog_failure_cmnd
set "checkMsg=%checkMsg%@silent @syslog ERROR/ALARM  System - %~1\n"
goto :EOF

:syslog_success_check
set "checkMsg="
call :syslog_success_cmnd "______________"
call :syslog_success_cmnd "Session Check."
call :syslog_success_cmnd "\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E"
call :syslog_success_cmnd "%~1"
unix printf "%checkMsg%" | %CRW_DAQ_SYS_HOME_DIR%\resource\shell\send2crwdaq.exe 
goto :EOF

:syslog_failure_check
set "checkMsg="
call :syslog_failure_cmnd "______________"
call :syslog_failure_cmnd "Session Check."
call :syslog_failure_cmnd "\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E\x5E"
call :syslog_failure_cmnd "%~1"
unix printf "%checkMsg%" | %CRW_DAQ_SYS_HOME_DIR%\resource\shell\send2crwdaq.exe 
goto :EOF

:IntegritySuccessDetected
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
call :Tooltip text "%~1" preset stdSuccess delay 15000    btn1 "%~2" cmd1 "unix grun lister %CRW_DAQ_VAR_TMP_DIR%\checksum.log"
call :syslog_success_check "%~1"
goto :EOF

:IntegrityFailureDetected
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
call :Tooltip text "%~1" preset stdSiren   delay 86400000 btn1 "%~2" cmd1 "unix grun lister %CRW_DAQ_VAR_TMP_DIR%\checksum.log"
call :syslog_failure_check "%~1"
goto :EOF

:Tooltip
if "%~1" == "" goto :EOF
call "%CRW_DAQ_SYS_HOME_DIR%\Resource\Shell\tooltip.cmd" %*
goto :EOF
