@echo off
SetLocal EnableExtensions EnableDelayedExpansion

echo.
echo ****************************************************
echo CRW-DAQ Open With Menu batch. Run by user on demand.
echo The script expected location is  Crw32exe\Resource\.
echo ****************************************************
echo.

chcp 65001

if "%CRW_DAQ_SYS_HOME_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )
if "%CRW_DAQ_VAR_TMP_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )

set MySelf=%~f0

pushd "%~dp0.." && call :OwMenu %*
popd

goto :EOF

:OwMenu
call :EnterLogFile
call :ClearTempDir
call :HandleOwMenu %*
call :LeaveLogFile
goto :EOF

:EnterLogFile
set "logFile=%CRW_DAQ_VAR_TMP_DIR%\%~n0.log"
echo %Date%-%Time%: >> "%logFile%"
echo Enter "%MySelf%" >> "%logFile%"
goto :EOF

:LeaveLogFile
echo %Date%-%Time%: >> "%logFile%"
echo Leave "%MySelf%" >> "%logFile%"
goto :EOF

:ClearTempDir
echo ClearTempDir: >> "%logFile%"
pushd "%CRW_DAQ_VAR_TMP_DIR%" && call :DoClearTempDir
popd
goto :EOF

:DoClearTempDir
del /F /S /Q *.lst >> "%logFile%"
del /F /S /Q *.tmp >> "%logFile%"
set /a sizeKeep=1024*512
unix purger -ra !sizeKeep! *.* >> "%logFile%"
goto :EOF

:HandleOwMenu
echo HandleOwMenu: >> "%logFile%"
set prog=%cd%\crwdaq.exe
set item=%prog:.=[dot]%
set item=%item::=[colon]%
set item=%item:\=[backslash]%
set args=--install "%item%" --command "%prog%" --prompt "Open with %prog:\=\\%" --extlist ".cfg;.crc;.cal;.dpr"
if "%~1" == "-u"          set args=-u "%item%"
if "%~1" == "--uninstall" set args=-u "%item%"
echo .cmdtoolkit -i >> "%logFile%"
call .cmdtoolkit -i >> "%logFile%" 2>&1
echo handleopenwithmenu %args% >> "%logFile%"
call handleopenwithmenu %args% >> "%logFile%" 2>&1
goto :EOF
