program _crypt;
var
 b         : Boolean;
 Ok        : Boolean;
 errors    : Integer;
 errorcode : Integer;
 i         : Integer;
 s,t,f,key   : String;
 procedure TestCrypt(k,m:String);
 begin
  writeln('Test crypt ',k,',',m);
  errors:=errors+ord(not IsSameText(crypt_ctrl('Kind='+k),k));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Mode='+m),m));
  t:=crypt_encode(s,key);
  errors:=errors+ord(t='')+ord(t=s)+ord(crypt_decode(t,key)<>s);
  writeln('t=',t,crlf,'Errors=',errors:1);
 end;
begin
 if runcount=1 then begin
  errors:=0;
  errorcode:=registererr(devname);
  s:='';t:='';f:='';key:='';
  writeln('START');
  key:='Alex Kuryakin,kouriakine@mail.ru';
  s:=ParamStr('DaqConfigFile');
  i:=text_new;
  b:=text_addln(i,s);
  writeln('MD5(str) =',hex_encode(GetMd5FromStr(s+crlf)));
  writeln('MD5(text)=',hex_encode(GetMd5FromText(i)));
  writeln('MD5(file)=',hex_encode(GetMd5FromFile(s)));
  b:=text_free(i);
  errors:=errors+ord(not IsSameText(crypt_ctrl('Kind=Blowfish'),'Blowfish'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Kind=Gost'),'Gost'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Kind=RC2'),'RC2'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Kind=RC4'),'RC4'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Kind=RC5'),'RC5'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Kind=RC6'),'RC6'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Mode=CBC'),'CBC'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Mode=OFB'),'OFB'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Mode=CFB'),'CFB'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Mode=OFBC'),'OFBC'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Ei=Bin'),'Bin'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Ei=Hex'),'Hex'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Ei=Mime'),'Mime'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Eo=Bin'),'Bin'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Eo=Hex'),'Hex'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Eo=Mime'),'Mime'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Di=Bin'),'Bin'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Di=Hex'),'Hex'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Di=Mime'),'Mime'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Do=Bin'),'Bin'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Do=Hex'),'Hex'));
  errors:=errors+ord(not IsSameText(crypt_ctrl('Do=Mime'),'Mime'));
  writeln('Crypt current:');
  writeln(crypt_ctrl(''));
  writeln('Crypt defaults:');
  writeln(crypt_ctrl('*'));
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 if isinf(runcount) then begin
  writeln('STOP');
  s:='';t:='';f:='';key:='';
 end else
 if Ok then begin
  writeln('--------------RunCount=',runcount:1:0,'--------------');
  s:='';
  for i:=1 to Round(Random(1,40)) do s:=s+Chr(Round(Random(0,255)));
  s:=mime_encode(s);
  writeln('s=',s);
  writeln('Test MIME:');
  t:=mime_encode(s); errors:=errors+ord(t='')+ord(t=s)+ord(mime_decode(t)<>s);
  writeln('t=',t,crlf,'Errors=',errors);
  writeln('Test HEX:');
  t:=hex_encode(s); errors:=errors+ord(t='')+ord(t=s)+ord(hex_decode(t)<>s);
  writeln('t=',t,crlf,'Errors=',errors:1);
  TestCrypt('Blowfish','CBC');
  TestCrypt('Blowfish','OFB');
  TestCrypt('Blowfish','CFB');
  TestCrypt('Blowfish','OFBC');
  TestCrypt('Gost','CBC');
  TestCrypt('Gost','OFB');
  TestCrypt('Gost','CFB');
  TestCrypt('Gost','OFBC');
  TestCrypt('RC2','CBC');
  TestCrypt('RC2','OFB');
  TestCrypt('RC2','CFB');
  TestCrypt('RC2','OFBC');
  TestCrypt('RC4','CBC');
  TestCrypt('RC4','OFB');
  TestCrypt('RC4','CFB');
  TestCrypt('RC4','OFBC');
  TestCrypt('RC5','CBC');
  TestCrypt('RC5','OFB');
  TestCrypt('RC5','CFB');
  TestCrypt('RC5','OFBC');
  TestCrypt('RC6','CBC');
  TestCrypt('RC6','OFB');
  TestCrypt('RC6','CFB');
  TestCrypt('RC6','OFBC');
 end;
end.
