@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

echo E14-140 config generator.

pushd "%~dp0\" && call :E140Table "%~n0.gen" "%~n0.cfg"
popd
echo Done.
unix sleep 2
unix true
goto :EOF

:E140Table
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
set gen=%~1
set cfg=%~2
rem Initialize   Prefix  History  DataPath         Freq,kHz  FIR
call :InitParams DEMO.   100000   ..\..\E140_DATA  1         1  
call :DeleteFile "%cfg%"
call :AddHeader3 "%gen%" "%cfg%"
rem Add E140 ADC  genfile  cfgfile  Suffix  SerialNum   Simul  Gate-mapping (32 channels)        Gain-mapping (32 channels)        Comment-Note
call :AddE140Adc  "%gen%"  "%cfg%"  ""      "        "  01110  11000000000000000000000000000000  11111111111111111111111111111111  "Demo test, single card."
goto :EndOfTable
call :AddE140Adc  "%gen%"  "%cfg%"  "_1"    "1D157614"  01110  11111111000000000000000000000000  11111111111111111111111111111111  "Demo test, card #1."
call :AddE140Adc  "%gen%"  "%cfg%"  "_2"    "1D699929"  01110  11111111000000000000000000000000  11111111111111111111111111111111  "Demo test, card #2."
:EndOfTable
unix true
goto :EOF

:InitParams
echo Call :InitParams %*
set prefix=%~1
set history=%~2
set datapath=%~3
set freq=%~4
set fir=%~5
unix true
goto :EOF

:DeleteFile
if "%~1" == "" goto :EOF
if exist "%~1" unix rm -f "%~1" 
unix true
goto :EOF

:AddHeader3
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
rem use unix dog -l 1-4 to print first 4 lines
if exist "%~1" unix dog -l 1-4 "%~1" | unix u2d >> "%~2"
unix true
goto :EOF

:AddE140Adc
echo Call :AddE140Adc %*
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
set simx=%~5
set sim=0
set sim1=-
set sim2=-
set sim3=-
set sim4=-
if "%simx:~0,1%" == "1" set sim=1
if "%simx:~1,1%" == "1" set sim1=
if "%simx:~2,1%" == "1" set sim2=
if "%simx:~3,1%" == "1" set sim3=
if "%simx:~4,1%" == "1" set sim4=
set gate=%~6
set gain=%~7
set note=%~8
if "%gate%" == "" gate=11000000000000000000000000000000
if "%gain%" == "" gain=00000000000000000000000000000000
rem use unix dog -l 5- to skip first 4 lines
if exist "%~1" unix dog -l 5- "%~1"^
 | unix replacestr {PRE}    "%prefix%"^
 | unix replacestr {FREQ}   "%freq%"^
 | unix replacestr {FIR}    "%fir%"^
 | unix replacestr {HIST}   "%history%"^
 | unix replacestr {DPATH}  "%datapath%"^
 | unix replacestr {GATE0}  "%gate:~0,1%"^
 | unix replacestr {GATE1}  "%gate:~1,1%"^
 | unix replacestr {GATE2}  "%gate:~2,1%"^
 | unix replacestr {GATE3}  "%gate:~3,1%"^
 | unix replacestr {GATE4}  "%gate:~4,1%"^
 | unix replacestr {GATE5}  "%gate:~5,1%"^
 | unix replacestr {GATE6}  "%gate:~6,1%"^
 | unix replacestr {GATE7}  "%gate:~7,1%"^
 | unix replacestr {GATE8}  "%gate:~8,1%"^
 | unix replacestr {GATE9}  "%gate:~9,1%"^
 | unix replacestr {GATE10} "%gate:~10,1%"^
 | unix replacestr {GATE11} "%gate:~11,1%"^
 | unix replacestr {GATE12} "%gate:~12,1%"^
 | unix replacestr {GATE13} "%gate:~13,1%"^
 | unix replacestr {GATE14} "%gate:~14,1%"^
 | unix replacestr {GATE15} "%gate:~15,1%"^
 | unix replacestr {GATE16} "%gate:~16,1%"^
 | unix replacestr {GATE17} "%gate:~17,1%"^
 | unix replacestr {GATE18} "%gate:~18,1%"^
 | unix replacestr {GATE19} "%gate:~19,1%"^
 | unix replacestr {GATE20} "%gate:~20,1%"^
 | unix replacestr {GATE21} "%gate:~21,1%"^
 | unix replacestr {GATE22} "%gate:~22,1%"^
 | unix replacestr {GATE23} "%gate:~23,1%"^
 | unix replacestr {GATE24} "%gate:~24,1%"^
 | unix replacestr {GATE25} "%gate:~25,1%"^
 | unix replacestr {GATE26} "%gate:~26,1%"^
 | unix replacestr {GATE27} "%gate:~27,1%"^
 | unix replacestr {GATE28} "%gate:~28,1%"^
 | unix replacestr {GATE29} "%gate:~29,1%"^
 | unix replacestr {GATE30} "%gate:~30,1%"^
 | unix replacestr {GATE31} "%gate:~31,1%"^
 | unix replacestr {GAIN0}  "%gain:~0,1%"^
 | unix replacestr {GAIN1}  "%gain:~1,1%"^
 | unix replacestr {GAIN2}  "%gain:~2,1%"^
 | unix replacestr {GAIN3}  "%gain:~3,1%"^
 | unix replacestr {GAIN4}  "%gain:~4,1%"^
 | unix replacestr {GAIN5}  "%gain:~5,1%"^
 | unix replacestr {GAIN6}  "%gain:~6,1%"^
 | unix replacestr {GAIN7}  "%gain:~7,1%"^
 | unix replacestr {GAIN8}  "%gain:~8,1%"^
 | unix replacestr {GAIN9}  "%gain:~9,1%"^
 | unix replacestr {GAIN10} "%gain:~10,1%"^
 | unix replacestr {GAIN11} "%gain:~11,1%"^
 | unix replacestr {GAIN12} "%gain:~12,1%"^
 | unix replacestr {GAIN13} "%gain:~13,1%"^
 | unix replacestr {GAIN14} "%gain:~14,1%"^
 | unix replacestr {GAIN15} "%gain:~15,1%"^
 | unix replacestr {GAIN16} "%gain:~16,1%"^
 | unix replacestr {GAIN17} "%gain:~17,1%"^
 | unix replacestr {GAIN18} "%gain:~18,1%"^
 | unix replacestr {GAIN19} "%gain:~19,1%"^
 | unix replacestr {GAIN20} "%gain:~20,1%"^
 | unix replacestr {GAIN21} "%gain:~21,1%"^
 | unix replacestr {GAIN22} "%gain:~22,1%"^
 | unix replacestr {GAIN23} "%gain:~23,1%"^
 | unix replacestr {GAIN24} "%gain:~24,1%"^
 | unix replacestr {GAIN25} "%gain:~25,1%"^
 | unix replacestr {GAIN26} "%gain:~26,1%"^
 | unix replacestr {GAIN27} "%gain:~27,1%"^
 | unix replacestr {GAIN28} "%gain:~28,1%"^
 | unix replacestr {GAIN29} "%gain:~29,1%"^
 | unix replacestr {GAIN30} "%gain:~30,1%"^
 | unix replacestr {GAIN31} "%gain:~31,1%"^
 | unix replacestr {SIM}    "%sim%"^
 | unix replacestr {SIM1}   "%sim1%"^
 | unix replacestr {SIM2}   "%sim2%"^
 | unix replacestr {SIM3}   "%sim3%"^
 | unix replacestr {SIM4}   "%sim4%"^
 | unix replacestr {NOTE}   "%note%"^
 | unix replacestr {N}      "%~3"^
 | unix replacestr {SN}     "%~4"^
 | unix u2d >> "%~2"
unix printf "\n" | unix u2d >> "%~2"
unix true
goto :EOF
