 {
 ***********************************************************************
 Daq Pascal application program Template.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Demo ex1 ex2    - Evaluate 2 expressions, just for demo.
| @SaveForm        - Save WaveForm in osc and csv file.
| @CopyWaveForm    - Copy waveform
| @AssignTag       - ...
|********************************************************
[]
[Compiler.Options]
Compiler.sLenMax = 1024*1024*64;
[]
 }
program WJ300AWaveForm;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 stt_None                = 0;    {                                  }
 stt_Handle              = 1;    {                                  }
 stt_Clear               = 2;    {                                  }
 {------------------------------}{ Analog outputs:                  }
 ao_WAVFORM_C1            = 1;   {                                  }
 ao_WAVFORM_C2            = 2;   {                                  }
 ao_WAVFORM_C3            = 3;   {                                  }
 ao_WAVFORM_C4            = 4;   {                                  }
 ao_WAVFORM_M1            = 5;   {                                  }
 {------------------------------}{                                  }
 VoltPerDivConstant      = 8192; {                                  }
 WaveformOffset          = 8;    {                                  }
 {------------------------------}{                                  }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 TChanRec = record               { Channel data                     }
  OFFS      : TTagRef;           { Channel offset                   }
  SCAL      : TTagRef;           { Channel scale                    }
  WAVFORM   : TTagRef;           { Channel waveform                 }
  POINTS    : TVector;           { Channel dynamic array            }
  AO        : Integer;           { Channel analog output            }
 end;                            {                                  }
 {------------------------------}{                                  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 WJ300A              : record    {                                  }
  PointCount         : Integer;  {                                  }
  PathDirWave        : String;   {                                  }
  DfltName           : String;   {  Dflt                            }
  FileNameCSV        : String;   {                                  }
  FileNameOSC        : String;   {                                  }
  Status             : Integer;  {                                  }
  ChanNum            : Integer;  {                                  }
  DIRBASE            : TTagRef;  {                                  }
  DIREXP             : TTagRef;  {                                  }
  DEFAULTDIR         : TTagRef;  {                                  }
  EXTRACTNUM         : TTagRef;  {                                  }
  SAVESTAT           : TTagRef;  {                                  }
  C1,C2,C3,C4,M1     : TChanRec; {                                  }
  PARAM              : record    {                                  }
   TDIV              : TTagRef;  {                                  }
   TRDL              : TTagRef;  {                                  }
   TRMD              : TTagRef;  {                                  }
  end;                           {                                  }
 end;                            {                                  }
 cmd_Edit            : Integer;  {                                  }
 cmd_CopyWaveForm    : Integer;  {                                  }
 cmd_CalculateData   : Integer;  {                                  }
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Make directory
 }
 procedure MakeDirectory;
 var DirBase,DirExp,DirWave,DeflDir:String;
  procedure Cleanup;
  begin
   DirBase:=''; DirExp:=''; DirWave:=''; DeflDir:='';
  end;
 begin
  Cleanup;
  DeflDir:=sGetTag(WJ300A.DEFAULTDIR.tag);
  DirBase:=sGetTag(WJ300A.DIRBASE.tag);
  DirExp:=sGetTag(WJ300A.DIREXP.tag);
  DirWave:=DirBase+DirExp;
  WJ300A.PathDirWave:=DirWave;
  if IsSameText(DirWave,DeflDir) then begin
   if not DirExists(DeflDir) then bNul(mkDir(DeflDir));
   WJ300A.DfltName:=DeflDir;
  end else begin
   if not DirExists(DirWave) then bNul(mkDir(DirWave));
   if not DirExists(DeflDir) then bNul(mkDir(DeflDir));
   WJ300A.DfltName:=DeflDir;
  end;
 end;
 {
 Copy file
 }
 procedure CopyFile;
 var i,n:Integer;
 begin
  MakeDirectory;
  if direxists(WJ300A.PathDirWave) then
  begin
   DevSendCmdLocal('@CopyWaveForm '+(WJ300A.DfltName+WJ300A.FileNameOSC)+' '+(WJ300A.PathDirWave+WJ300A.FileNameOSC));
   DevSendCmdLocal('@CopyWaveForm '+(WJ300A.DfltName+WJ300A.FileNameCSV)+' '+(WJ300A.PathDirWave+WJ300A.FileNameCSV));
  end else Problem('Путь не существует: "'+sGetTag(WJ300A.DIREXP.tag)+'"');
 end;
 {
 Init tags
 }
 procedure WJ300AInitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   InitTag(WJ300A.DIRBASE.tag,    Prefix+'.DIRBASE',    3);
   InitTag(WJ300A.DIREXP.tag,     Prefix+'.DIREXP',     3);
   InitTag(WJ300A.DEFAULTDIR.tag, Prefix+'.DEFAULTDIR', 3);
   InitTag(WJ300A.EXTRACTNUM.tag, Prefix+'.EXTRACTNUM', 3);
   InitTag(WJ300A.C1.OFFS.tag,    Prefix+'.OFST_C1',    2);
   InitTag(WJ300A.C1.SCAL.tag,    Prefix+'.VDIV_C1',    2);
   InitTag(WJ300A.C1.WAVFORM.tag, Prefix+'.WAVFORM_C1', 3);
   InitTag(WJ300A.C2.OFFS.tag,    Prefix+'.OFST_C2',    2);
   InitTag(WJ300A.C2.SCAL.tag,    Prefix+'.VDIV_C2',    2);
   InitTag(WJ300A.C2.WAVFORM.tag, Prefix+'.WAVFORM_C2', 3);
   InitTag(WJ300A.C3.OFFS.tag,    Prefix+'.OFST_C3',    2);
   InitTag(WJ300A.C3.SCAL.tag,    Prefix+'.VDIV_C3',    2);
   InitTag(WJ300A.C3.WAVFORM.tag, Prefix+'.WAVFORM_C3', 3);
   InitTag(WJ300A.C4.OFFS.tag,    Prefix+'.OFST_C4',    2);
   InitTag(WJ300A.C4.SCAL.tag,    Prefix+'.VDIV_C4',    2);
   InitTag(WJ300A.C4.WAVFORM.tag, Prefix+'.WAVFORM_C4', 3);
   InitTag(WJ300A.PARAM.TDIV.tag, Prefix+'.TDIV',       2);
   InitTag(WJ300A.PARAM.TRDL.tag, Prefix+'.TRDL',       2);
   InitTag(WJ300A.PARAM.TRMD.tag, Prefix+'.TRMD',       1);
   InitTag(WJ300A.SAVESTAT.tag,   Prefix+'.SAVESTAT',   1);
  end;
 end;
 {
 Swap bytes, words, dwords (correspond to SwapMode bit 0,1,2).
 }
 function modbus_swap2(dat:String; SwapMode:Integer):String;
 var s,t : array[1..2] of Char;
 begin
  s:=dat;
  case iAnd(SwapMode,1) of
   0: begin t[1]:=s[1]; t[2]:=s[2]; end;
   1: begin t[1]:=s[2]; t[2]:=s[1]; end;
  end;
  modbus_swap2:=t;
 end;
 {
 ConvertToSigned
 }
 function ConvertToSigned(IntRawPoint:Integer):Integer;
 var SignedInt:Integer;
 begin
  SignedInt:=IntRawPoint;
  if isbit(IntRawPoint,15) then SignedInt:=IntRawPoint-65280;
  ConvertToSigned:=SignedInt;
 end;
 {
 Calculate PointTime for WaveForm
 }
 function GetPointTime(Index:integer;TimeBase:real;PointCount:integer):real;
 var TimeDiv:real;
 begin
  TimeDiv:=TimeBase*10/PointCount;
  GetPointTime:=index*TimeDiv;
 end;
 {
 Create file header
 }
 function FileHeader(format:String):String;
 var Header:String;
  procedure Cleanup;
  begin
   Header:='';
  end;
 begin
  FileHeader:='';
  Cleanup;
  if IsSameText(format,'osc') then begin
   Header:='[Common]'+EOL;
   Header:=Header+'TimeDiv = '+str(rGetTag(WJ300A.PARAM.TDIV.tag))+EOL;
   Header:=Header+'TrigDelay = '+str(rGetTag(WJ300A.PARAM.TRDL.tag))+EOL;
   Header:=Header+'SampleRate = '+str(rGetTag(WJ300A.PARAM.TDIV.tag)*10/WJ300A.PointCount)+EOL;
   Header:=Header+'[C1]'+EOL;
   Header:=Header+'Offset = '+str(rGetTag(WJ300A.C1.OFFS.tag))+EOL;
   Header:=Header+'Scale = '+str(rGetTag(WJ300A.C1.SCAL.tag))+EOL;
   Header:=Header+'[C2]'+EOL;
   Header:=Header+'Offset = '+str(rGetTag(WJ300A.C2.OFFS.tag))+EOL;
   Header:=Header+'Scale = '+str(rGetTag(WJ300A.C2.SCAL.tag))+EOL;
   Header:=Header+'[C3]'+EOL;
   Header:=Header+'Offset = '+str(rGetTag(WJ300A.C3.OFFS.tag))+EOL;
   Header:=Header+'Scale = '+str(rGetTag(WJ300A.C3.SCAL.tag))+EOL;
   Header:=Header+'[C4]'+EOL;
   Header:=Header+'Offset = '+str(rGetTag(WJ300A.C4.OFFS.tag))+EOL;
   Header:=Header+'Scale = '+str(rGetTag(WJ300A.C4.SCAL.tag))+EOL;
  end else if IsSameText(format,'csv') then begin
   Header:='Time div:'+CHR(_HT)+str(rGetTag(WJ300A.PARAM.TDIV.tag))+Eol;
   Header:=Header+'Trigger delay'+CHR(_HT)+str(rGetTag(WJ300A.PARAM.TRDL.tag))+Eol;
   Header:=Header+'Channel Scale:'+CHR(_HT)+str(rGetTag(WJ300A.C1.SCAL.tag))+CHR(_HT)+str(rGetTag(WJ300A.C2.SCAL.tag))+CHR(_HT)+str(rGetTag(WJ300A.C3.SCAL.tag))+CHR(_HT)+str(rGetTag(WJ300A.C4.SCAL.tag))+Eol;
   Header:=Header+'Channel Offset:'+CHR(_HT)+str(rGetTag(WJ300A.C1.OFFS.tag))+CHR(_HT)+str(rGetTag(WJ300A.C2.OFFS.tag))+CHR(_HT)+str(rGetTag(WJ300A.C3.OFFS.tag))+CHR(_HT)+str(rGetTag(WJ300A.C4.OFFS.tag))+Eol;
   Header:=Header+'Channel Name:'+Eol+'Channel 1'+CHR(_HT)+'Channel 2'+CHR(_HT)+'Channel 3'+CHR(_HT)+'Channel 4';
  end;
  FileHeader:=Header;
  Cleanup;
 end;
 {
 Save CSV file
 }
 procedure WaveDataSaveCSV;
 var i,io:Integer; DeflFile:String; C1,C2,C3,C4:real;
  procedure Cleanup;
  begin
   DeflFile:='';
  end;
 begin
  Cleanup;
  if IsEmptyStr(WJ300A.PathDirWave) then DeflFile:=WJ300A.DfltName+WJ300A.FileNameCSV
  else begin
   DeflFile:=WJ300A.DfltName+WJ300A.FileNameCSV;
  end;
  if FileExists(DeflFile) then io:=f_reset(DeflFile,2) else io:=f_rewrite(DeflFile,2);
  if io=0 then begin
   iNul(f_write(FileHeader('csv')+Eol));
   for i:=0 to WJ300A.PointCount do begin
    C1:=rVec_get(WJ300A.C1.POINTS,i);
    C2:=rVec_get(WJ300A.C2.POINTS,i);
    C3:=rVec_get(WJ300A.C3.POINTS,i);
    C4:=rVec_get(WJ300A.C4.POINTS,i);
    iNul(f_write(str(C1)+_SemiColon+CHR(_HT)+str(C2)+_SemiColon+CHR(_HT)+str(C3)+_SemiColon+CHR(_HT)+str(C4)+_SemiColon+EOL));
   end;
   writeln('Wrote '+Str(f_size)+' byte(s) to '+DeflFile);
   bNul(f_close);
   bNul(iSetTagBitState(WJ300A.SAVESTAT.tag,2,true));
  end else begin
   Trouble('Error create file');
   bNul(iSetTagBitState(WJ300A.SAVESTAT.tag,2,false));
  end;
  Cleanup;
 end;
 {
 Save OSC file and reflection curve
 }
 procedure WaveDataSaveOSC;
 var io:Integer; DeflFile,PointString:String;
  procedure Cleanup;
  begin
    DeflFile:='';
    PointString:='';
  end;
 begin
  Cleanup;
  PointString:=Str(WJ300A.PointCount);
  if IsEmptyStr(WJ300A.PathDirWave) then DeflFile:=WJ300A.DfltName+WJ300A.FileNameOSC
  else begin
   DeflFile:=WJ300A.DfltName+WJ300A.FileNameOSC;
  end;
  if FileExists(DeflFile) then io:=f_reset(DeflFile,2) else io:=f_rewrite(DeflFile,2);
  if io=0 then begin
   iNul(f_write(FileHeader('osc')+Eol
      +'DAT1,#9'+LeftPad(PointString,9,'0')+WJ300A.C1.POINTS
      +'DAT2,#9'+LeftPad(PointString,9,'0')+WJ300A.C2.POINTS
      +'DAT3,#9'+LeftPad(PointString,9,'0')+WJ300A.C3.POINTS
      +'DAT4,#9'+LeftPad(PointString,9,'0')+WJ300A.C4.POINTS));
   writeln('Wrote '+Str(f_size)+' byte(s) to '+DeflFile); // bNul(sleep(5000));
   bNul(f_close);
   WJ300A.Status:=stt_Clear;
   bNul(iSetTagBitState(WJ300A.SAVESTAT.tag,1,true));
  end else begin
   Trouble('Error generate file');
   bNul(iSetTagBitState(WJ300A.SAVESTAT.tag,1,false));
  end;
  Cleanup;
  DevSendCmdLocal('@WinDraw '+ReadIni('tagPrefix')+'.PLOT |Range=xmin;ymin;xmax;ymax');
  DevSendCmdLocal('@WinSelect '+ReadIni('tagPrefix')+'.PLOT');
 end;
 {
 Generate file name for save wavedata
 }
 procedure GenerateFileName;
 var ExtractionNum,FileName:String;
  procedure Cleanup;
  begin
   ExtractionNum:=''; FileName:='';
  end;
 begin
  Cleanup;
  ExtractionNum:=sGetTag(WJ300A.EXTRACTNUM.tag);
  FileName:=ExtractionNum+'_osc'+copy(ExtractWord(2,ReadIni('tagprefix')),5,1)+'_'+ExtractWord(5,ReadIni('tagprefix'))+StrTimeFmt('yyyymmdd_hhnnss',msecnow);
  FileName:=LoCaseStr(AdaptFileName(FileName));
  WJ300A.FileNameOSC:=FileName+'.osc';
  WJ300A.FileNameCSV:=FileName+'.csv';
  Cleanup;
 end;
 {
 Decode WaveData #8XXXXXXXXD1D2D3D#
 Formula: ((ChannelScale/8192)  X  RawPoint) - ChannelOffset = PointY
 }
 procedure WaveDecodeCrv(var ChId:TChanRec);
 var i:Integer; Data, RawPoint:String;
 Point,cref,TimeBase:Real;
 ChannelScale,ChannelOffset:Real;
  procedure Cleanup;
  begin
   Data:='';
   RawPoint:='';
  end;
 begin
  Cleanup;
  cref:=refao(ChId.AO);
  if crvlock(cref) then begin
   rNul(crvdel(cref, 1, crvlen(cref)));
   bNul(crvunlock(cref));
  end;
  TimeBase:=rGetTag(WJ300A.PARAM.TDIV.tag);
  ChannelScale:=rGetTag(ChId.SCAL.tag);
  ChannelOffset:=rGetTag(ChId.OFFS.tag);
  Data:=sGetTag(ChId.WAVFORM.tag);
  WJ300A.PointCount:=round(Val(Copy(Data,3,8))/2); // Two bytes per dot
  ChId.POINTS:=rVec_Init(WJ300A.PointCount);
  for i:=0 to WJ300A.PointCount-1 do begin
   RawPoint:=modbus_swap2(Copy(Data,19+i*2,2),7); // 19 = '#8'+LengthData+WaveformOffset
   Details('#'+str(i)+' '+hex_encode(RawPoint));
   Point:=(ChannelScale/VoltPerDivConstant)*ConvertToSigned(Dump2i(RawPoint))-ChannelOffset;
   rVec_Set(ChId.POINTS,i,Point);
   bNul(CrvPut(Cref, CrvLen(cref)+1, GetPointTime(i,timebase,WJ300A.PointCount), Point));
  end;
  WJ300A.ChanNum:=ChId.AO+1;
  Cleanup;
 end;
 {
 Data handling
 }
 procedure WaveDataHandling(n:Integer);
 var PointX,PointInterval:Real;
 begin
  bNul(iSetTag(WJ300A.SAVESTAT.tag,0));
  if n=0 then WaveDecodeCrv(WJ300A.C1) else
  if n=1 then WaveDecodeCrv(WJ300A.C2) else
  if n=2 then WaveDecodeCrv(WJ300A.C3) else
  if n=3 then WaveDecodeCrv(WJ300A.C4) else
  if n=4 then begin
   WaveDataSaveOSC;
   WaveDataSaveCSV;
   CopyFile;
   WJ300A.Status:=stt_Clear;
   bNul(iSetTagBitState(WJ300A.SAVESTAT.tag,0,true));
  end;
 end;
 {
 Post command (cmd) to console on tag click.
 }
 procedure DevSendCmdEdit(tag:Integer; par:String);
 begin
  if CLickTag=tag then begin
   DevPostCmdLocal('@Edit '+NameTag(tag)+' '+par);
   bNul(Voice(snd_Click));
  end;
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var s:String; ClickCurve,i:Integer;
  procedure Cleanup;
  begin
   s:=''; DIM_GuiClickBuff:='';
  end;
 begin
  Cleanup;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Copy GUI click to DIM buffer for remote execution.
   }
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle local clicks
     }
     if ClickIsLocal then begin
      {
      Handle sensor clicks...
      }
      if ClickSensor<>'' then begin
       bNul(Voice(snd_Click));
       if ClickSensor='WAVE_COPY'        then CopyFile;
       if ClickSensor='DRAW_CURVE'       then begin
        i:=refao(0);
        iNul(WinSelectByCurve(i,0));
        bNul(Voice(snd_Click));
       end;
      end;
      {
      Handle tag clicks
      }
      if (ClickTag<>0) then begin
       s:=mime_encode(SetFormUnderSensorLeftBottom(ClickParams('')));
      end;
      {
      Select Plot & Tab windows by curve
      }
      ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
      if IsRefCurve(ClickCurve) then begin
       iNul(WinSelectByCurve(ClickCurve,ClickCurve));
       bNul(Voice(snd_Wheel));
      end;
      {
      Console commands
      }
      if LooksLikeCommand(ClickSensor) then begin
       DevPostCmd(devMySelf,url_decode(ClickSensor));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Handle remote clicks comes from DIM via @DimGuiClick message.
     @DimGuiClick default handler decode and write events to FIFO,
     so we can find it as ckicks and can handle it in usual way.
     }
     if ClickIsRemote then begin
      {
      Show time defference.
      }
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      {
      Handle remote console commands...
      }
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  Cleanup;
 end;
 {
 Initialization calculate process
 }
 procedure CalculateInit;
 begin
  WJ300A.ChanNum:=0;
  WJ300A.Status:=stt_Handle;
  MakeDirectory;
  GenerateFileName;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  WJ300A.PathDirWave:='';
  WJ300A.FileNameCSV:='';
  WJ300A.FileNameOSC:='';
  WJ300A.DfltName   :='';
  WJ300A.C1.Points  :=rVec_Init(0);
  WJ300A.C2.Points  :=rVec_Init(0);
  WJ300A.C3.Points  :=rVec_Init(0);
  WJ300A.C4.Points  :=rVec_Init(0);
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  bNul(sSetTag(WJ300A.DIRBASE.tag,'-'));
  bNul(sSetTag(WJ300A.DIREXP.tag,'-'));
  WJ300AInitTags(ReadIni('tagPrefix'));
  WJ300A.C1.AO:=0;
  WJ300A.C2.AO:=1;
  WJ300A.C3.AO:=2;
  WJ300A.C4.AO:=3;
  WJ300A.M1.AO:=4;
  cmd_CopyWaveForm   :=RegisterStdInCmd('@CopyWaveForm',   '');
  cmd_CalculateData  :=RegisterStdInCmd('@CalculateData',  '');
  cmd_Edit           :=RegisterStdInCmd('@Edit',           '');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  rVec_Free(WJ300A.C1.Points);
  rVec_Free(WJ300A.C2.Points);
  rVec_Free(WJ300A.C3.Points);
  rVec_Free(WJ300A.C4.Points);
 end;
 {
 Status Wavedata handling update
 }
 procedure WaveDataHandlingUpdate;
 begin
  if WJ300A.Status=stt_Handle then begin
   WaveDataHandling(WJ300A.ChanNum)
  end else
  if WJ300A.Status=stt_Clear then begin
   bNul(sSetTag(WJ300A.C1.WAVFORM.tag,''));
   bNul(sSetTag(WJ300A.C2.WAVFORM.tag,''));
   bNul(sSetTag(WJ300A.C3.WAVFORM.tag,''));
   bNul(sSetTag(WJ300A.C4.WAVFORM.tag,''));
   WJ300A.Status:=stt_None;
  end;
  if (iGetTag(WJ300A.PARAM.TRMD.tag)=4) then bNul(iSetTag(WJ300A.SAVESTAT.tag,0)); // is SINGLE mode
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  GUIHandler;
  WaveDataHandlingUpdate;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,DeflFile,PathFile,s,par:String; cmdid,i,tag:Integer; r:Real;
  procedure Cleanup;
  begin
   cmd:=''; arg:=''; DeflFile:=''; PathFile:=''; s:=''; par:='';
  end;
 begin
  Cleanup;
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @CalculateData
   }
   if (cmdid=cmd_CalculateData) then begin
    CalculateInit;
    Data:='';
   end else
   {
   @CopyWaveForm DeflFile PathFile
   }
   if (cmdid=cmd_CopyWaveForm) then begin
    DeflFile:=ExtractWord(1,arg);
    PathFile:=ExtractWord(2,arg);
    if not IsSameText(DeflFile,PathFile) then
    if FileCopy(DeflFile+EOL+PathFile) then begin
     if pos('.osc',DeflFile)<>0 then bNul(iSetTagBitState(WJ300A.SAVESTAT.tag,3,true))
     else if pos('.csv',DeflFile)<>0 then bNul(iSetTagBitState(WJ300A.SAVESTAT.tag,4,true));
    end else begin
     if pos('.osc',DeflFile)<>0 then bNul(iSetTagBitState(WJ300A.SAVESTAT.tag,3,false))
     else if pos('.osc',DeflFile)<>0 then bNul(iSetTagBitState(WJ300A.SAVESTAT.tag,4,false));
    end;
   end else
   {
   @Edit
   }
   if (cmdid=cmd_Edit) then begin
    par:=mime_decode(ExtractWord(2,arg));
    s:=ExtractWord(1,arg);
    tag:=FindTag(s);
    if Pos('DIRBASE',s)>0  then StartEditTagEx(tag,'Введите : ',par);
    if Pos('DIREXP',s)>0   then StartEditTagEx(tag,'Введите : ',par);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  Cleanup;
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
