{
[@Help]
|Command list: StdIn "@cmd=arg" or "@cmd arg"
|******************************************************
| @Help          - This help.
| @DebugFlags=n  - Set DebugFlags,1/2/4/8=!/:/>/< view.
| @EditTag n=v   - &VkbdSrv message: tag name n want new value v.
|******************************************************
[]
}
program DemoEdit;
const
 dfTrouble         = 1;       { DebugFlags - Trouble             }
 dfSuccess         = 2;       { DebugFlags - Success             }
 dfViewExp         = 4;       { DebugFlags - ViewExp             }
 dfViewImp         = 8;       { DebugFlags - ViewImp             }
 snd_Click         = 'Click'; { Sound on button click            }
 snd_Fails         = 'Fails'; { Sound on operation failure       }
var
 s                 : String;  { Temporary                        }
 i                 : Integer; { Temporary                        }
 b                 : Boolean; { Temporary                        }
 Ok                : Boolean; { Program initialization is Ok?    }
 errors            : Integer; { Program error counter            }
 errorcode         : Integer; { Error code for this device       }
 fixmaxavail       : Integer; { String manager leak control      }
 DebugFlags        : Integer; { Debug bit flags                  }
 StdIn_Line        : String;  { Temporary                        }
 tagEdit1          : integer; { Tag to edit - integer            }
 tagEdit2          : integer; { Tag to edit - real               }
 tagEdit3          : integer; { Tag to edit - string             }
 tagLanguage       : integer; { 0/1 = Rus/Eng                    }
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Check I/O status.
 }
 function IoError:Boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var Data:string):boolean;
 begin
  Data:='';
  if not IoError then
  if not Eof then Readln(Data);
  if IoError then Data:='';
  StdIn_Readln:=Length(Data)>0;
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|top=317|left=0|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
 {
 Show help in device console and echo to Main console if AllowEcho.
 Help text should be placed in program comment is [@Help] section.
 First symbol of help block should be | and will be ignored.
 }
 procedure ShowHelp(AllowEcho:Boolean);
 var i,p,sect:Integer; b:Boolean;
 begin
  sect:=ReadIniSection(text_New,12,DaqFileRef(ReadIni('ProgramSource'),'.pas'),'[@Help]');
  for i:=0 to text_NumLn(sect)-1 do begin
   if Copy(text_GetLn(sect,i),1,1)='|' then p:=2 else p:=1;
   if AllowEcho then b:=echo(devname+' : '+Copy(text_GetLn(sect,i),p));
   Success(Copy(text_GetLn(sect,i),p));
  end;
  b:=text_Free(sect);
  if AllowEcho then b:=WinSelect(ParamStr('MainConsole'));
 end;
 {
 Speak, i.e. send message to speech server.
 }
 procedure Speak(msg:String);
 var b:Boolean; ref:Integer;
 begin
  msg:=Trim(msg);
  if Length(msg)>0 then begin
   ref:=RefFind('Device &SpeakSrv');
   if ref<>0 then b:=DevSend(ref,'@speak='+msg+EOL)>0;
  end;
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:='';
  StdIn_Line:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ)
  then Trouble('Could not init tag: '+name);
 end;
 {
 Update tag with new value and with range checking.
 }
 procedure UpdateTag(tag:Integer; newValue:String; min,max:Real);
 var rValue:Real;
 begin
  rValue:=0;
  case TypeTag(tag) of
   0:;
   1:begin
      rValue:=rVal(newValue);
      if rValue<min then rValue:=_Nan;
      if rValue>max then rValue:=_Nan;
      if not IsNan(rValue) then b:=iSetTag(tag,Round(rValue));
     end;
   2:begin
      rValue:=rVal(newValue);
      if rValue<min then rValue:=_Nan;
      if rValue>max then rValue:=_Nan;
      if not IsNan(rValue) then b:=rSetTag(tag,rValue);
     end;
   3:b:=sSetTag(tag,newValue);
  end;
 end;
 {
 Return tag content as dump string.
 }
 function TagAsDump(tag:Integer):String;
 begin
  if TypeTag(tag)=1 then TagAsDump:=Dump(iGetTag(tag)) else
  if TypeTag(tag)=2 then TagAsDump:=Dump(rGetTag(tag)) else
  if TypeTag(tag)=3 then TagAsDump:=     sGetTag(tag)  else TagAsDump:='';
 end;
 {
 Return tag content as ASCII text.
 }
 function TagAsText(tag:Integer):String;
 begin
  if TypeTag(tag)=1 then TagAsText:=Str(iGetTag(tag)) else
  if TypeTag(tag)=2 then TagAsText:=Str(rGetTag(tag)) else
  if TypeTag(tag)=3 then TagAsText:=    sGetTag(tag)  else TagAsText:='';
 end;
 {
 Skip n words of string s, return trailing part of string s after n'th word.
 }
 function SkipWords(n:Integer;s:String):String;
  function SkipLeft(s:String):String;
  var P:Integer;
  begin
   P:=Pos(ExtractWord(1,s),s);
   if P>0 then SkipLeft:=Copy(s,P) else SkipLeft:='';
  end;
  function SkipWord(w,s:String):String;
  var P,L:Integer;
  begin
   L:=Length(w);
   if L>0 then P:=Pos(w,s) else P:=0;
   if P>0 then SkipWord:=SkipLeft(Copy(s,P+L+1)) else SkipWord:='';
  end;
 begin
  if (n>0) and (Length(s)>0)
  then SkipWords:=SkipWords(n-1,SkipWord(ExtractWord(1,s),s))
  else SkipWords:=s;
 end;
 {
 Send message to Virtual Keyboard server.
 }
 function VkbdSend(msg:String):Integer;
 var dev:Integer;
 begin
  if Length(msg)>0 then dev:=RefFind('Device &VkbdSrv') else dev:=0;
  if dev<>0 then VkbdSend:=Round(DevSend(dev,msg)) else VkbdSend:=0;
 end;
 {
 Start edit tag via &VkbdSrv.
 Set Language=0/1=Rus/Eng, Shift state Bit0=0/1=Rus/Eng,Bit1=0/1=Lo/Up.
 Set Label text, default is Edit tag ...
 }
 function VkbdEditTag(tag,Lang,Shift:Integer; Lab:String):Integer;
 begin
  if Length(Lab)=0
  then if iAnd(Lang,1)=1
  then Lab:='Edit tag '+NameTag(tag)
  else Lab:='Ввести тег '+NameTag(tag);
  if TypeTag(tag)=1 then begin
   VkbdEditTag:=VKbdSend('@Home'+EOL+'@State='+Str(Shift)
    +EOL+'@CharSet='+Url_Packed('0123456789-+*/%$()')
    +EOL+'@Language='+Str(Lang)
    +EOL+'@Label='+Lab
    +EOL+'@Text='+TagAsText(tag)
    +EOL+'@Prev='+TagAsText(tag)
    +EOL+'@DevMsg='+DevName+' @Vkbd.EditTag '+NameTag(tag)+'=%Text%'
    +EOL+'@WinShow'+EOL+'@WinSelect'+EOL);  
  end else
  if TypeTag(tag)=2 then begin 
   VkbdEditTag:=VKbdSend('@Home'+EOL+'@State='+Str(Shift)
    +EOL+'@CharSet='+Url_Packed('0123456789.eE-+*/%$()')
    +EOL+'@Language='+Str(Lang)
    +EOL+'@Label='+Lab
    +EOL+'@Text='+TagAsText(tag)
    +EOL+'@Prev='+TagAsText(tag)
    +EOL+'@DevMsg='+DevName+' @Vkbd.EditTag '+NameTag(tag)+'=%Text%'
    +EOL+'@WinShow'+EOL+'@WinSelect'+EOL);  
  end else
  if TypeTag(tag)=3 then begin
   VkbdEditTag:=VKbdSend('@Home'+EOL+'@State='+Str(Shift)
    +EOL+'@CharSet='+Url_Packed('')
    +EOL+'@Language='+Str(Lang)
    +EOL+'@Label='+Lab
    +EOL+'@Text='+TagAsText(tag)
    +EOL+'@Prev='+TagAsText(tag)
    +EOL+'@DevMsg='+DevName+' @Vkbd.EditTag '+NameTag(tag)+'=%Text%'
    +EOL+'@WinShow'+EOL+'@WinSelect'+EOL);  
  end else VkbdEditTag:=0;
 end;
 {
 Analyse data coming from standard input.
 }
 procedure StdIn_Process(Data:string);
 var cmd,arg:String; b:Boolean; tag:Integer;
 begin
  if iAnd(DebugFlags,dfViewImp)<>0 then ViewImp('CON: '+Data);
  {
  "@cmd=arg" or "@cmd args" commands:
  }
  cmd:='';
  arg:='';
  if Length(Data)>0 then
  if Data[1]='@' then begin
   cmd:=ExtractWord(1,Data);
   arg:=Copy(Data,Pos(cmd,Data)+Length(cmd)+1);
   {}
   if IsSameText(cmd,'@Help') then begin
    ShowHelp(true);
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@DebugFlags') then begin
    if not IsNan(rVal(arg)) then DebugFlags:=Round(rVal(arg));
    Success(cmd+'='+Str(DebugFlags));
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@Vkbd.EditTag') then begin
    tag:=FindTag(ExtractWord(1,arg));
    if TypeTag(tag)>0 then begin
     if tag=tagEdit1 then UpdateTag(tag,SkipWords(1,arg),_MinusInf,_PlusInf);
     if tag=tagEdit2 then UpdateTag(tag,SkipWords(1,arg),_MinusInf,_PlusInf);
     if tag=tagEdit3 then UpdateTag(tag,SkipWords(1,arg),_MinusInf,_PlusInf);
     Success(cmd+' '+NameTag(tag)+'='+TagAsText(tag));
    end;
    Data:='';
   end;
   {}
   if Length(Data)>0 then begin
    Trouble(' Unrecognized command "'+Data+'".');
    Data:='';
   end;
  end;
  cmd:='';
  arg:='';
 end;
begin
 {
 Initialization actions on Start...
 }
 if runcount=1 then begin
  {
  Initialize errors...
  }
  errors:=0;
  errorcode:=registererr(devname);
  {
  Clear and initialize variables...
  }
  ClearStrings;
  DebugFlags:=Val(ReadIni('DebugFlags'));
  OpenConsole(Val(ReadIni('OpenConsole')));
  Success('Starting...');
  {
  Initialize tags...
  }
  InitTag(tagEdit1,     'EditTag#1', 1);
  InitTag(tagEdit2,     'EditTag#2', 2);
  InitTag(tagEdit3,     'EditTag#3', 3);
  InitTag(tagLanguage,  'Language',  1);
  b:=WinShow('DemoVkbd') and WinSelect('DemoVkbd');
  b:=WinDraw('DemoVkbd|Top=0|Left=167|Width=250|Height=400');
  b:=WinDraw('DemoVkbd|Options=-Min,-Max,-Close,-VScroll,-HScroll');
  //for i:=0 to 4 do Success(' '+SkipWords(i,'One = Two, Three, Four'));
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop...
 }
 if isinf(runcount) then begin
  ClearStrings;
  Success('Stop.');
 end else
 {
 Actions on Poll...
 }
 if Ok then begin
  {
  Process standard input...
  }
  while StdIn_Readln(StdIn_Line) do StdIn_Process(StdIn_Line);
  {
  Process editing...
  }
  if ClickButton=1 then begin
   if IsSameText(ClickSensor,'English') then begin
    b:=iSetTag(tagLanguage,1);
    b:=Voice(snd_Click);
   end;
   if IsSameText(ClickSensor,'Russian') then begin
    b:=iSetTag(tagLanguage,0);
    b:=Voice(snd_Click);
   end;
   if ClickTag=tagEdit1 then
   if VKbdEditTag(tagEdit1,iGetTag(tagLanguage),3,'Введите тег № 1.')>0
   then begin
    b:=Voice(snd_Click);
    Speak('Введите тег № 1.');
   end else begin
    b:=Voice(snd_Fails);
    Trouble('Could not call VKBD!');
   end;
   if ClickTag=tagEdit2 then
   if VKbdEditTag(tagEdit2,iGetTag(tagLanguage),3,'Введите тег № 2.')>0
   then begin
    b:=Voice(snd_Click);
    Speak('Введите тег № 2.');
   end else begin
    b:=Voice(snd_Fails);
    Trouble('Could not call VKBD!');
   end;
   if ClickTag=tagEdit3 then
   if VKbdEditTag(tagEdit3,iGetTag(tagLanguage),3,'Введите тег № 3.')>0
   then begin
    b:=Voice(snd_Click);
    Speak('Введите тег № 3.');
   end else begin
    b:=Voice(snd_Fails);
    Trouble('Could not call VKBD!');
   end;
  end;
  //writeln('RunCount=',RunCount:7:0,' maxavail=',maxavail:1);
 end;
end.
