@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

rem #################################################
rem The script is to be called on DAQ start and stop.
rem #################################################

chcp 65001

call :RequiredParentCrwDaq || exit /b 1

:CheckComputer
rem if /I not "%ComputerName%" == "demo-daq-pc" goto :EOF

:Main
if /i "%~1" == "pre"  call :PreProcessor
if /i "%~1" == "post" call :PostProcessor
goto :EOF

:PreProcessor
echo Running preprocessor ...
if not defined CRW_DAQ_CONFIG_HOME_DIR goto :EOF
pushd "%CRW_DAQ_CONFIG_HOME_DIR%" && call :PreProcessorAction
popd
goto :EOF

:PostProcessor
echo Running postprocessor ...
if not defined CRW_DAQ_CONFIG_HOME_DIR goto :EOF
pushd "%CRW_DAQ_CONFIG_HOME_DIR%" && call :PostProcessorAction
popd
goto :EOF

:PreProcessorAction
set "nsel=%~n0"
unix cltimer -start
call ..\utility\daqsys.logon.cmd
call :DeleteFiles %nsel%_selector.txt
for /f %%i in ('unix dirname %CRW_DAQ_SYS_TITLE% ^| unix tr "#" "_"') do set head=%%i
set "Caption=%head% - DUH: SELECT CONFIGURATION …"
unix -n grun -h unix sleep 1 ^& unix window /top %Caption%
unix -n grun -h unix sleep 2 ^& unix movewindow "%Caption%" 167 0
unix zenity --title "%Caption%" ^
       --list --modal --timeout 30 --width 300 --height 300 ^
       --text "<big><b>Select number of Heaters for UniHeat.</b></big>" ^
       --radiolist --column "Check" --column "Number" --column "Of Heaters" ^
       --separator " " --print-column=2 ^
       true   "8"  "Heaters" ^
       false  "10" "Heaters" ^
       false  "16" "Heaters" ^
       false  "20" "Heaters" ^
       false  "24" "Heaters" ^
       false  "30" "Heaters" ^
       false  "32" "Heaters" ^
       > %nsel%_selector.txt
for /f %%i in ('unix cat %nsel%_selector.txt') do set Item=%%i
if not defined Item set "Item=8"
if "%Item%" == "" set "Item=8"
echo SelectedItem = %Item%
set "UH_NumHeaters=%Item%"
call ..\config\duh_simulator_make.cmd %Item%
call :DeleteFiles %nsel%_selector.txt
unix cltimer -stop
goto :EOF

:PostProcessorAction
call ..\utility\daqsys.logout.cmd
call ..\clear.bat
call ..\config\demo_uniheater_zero.cmd
call :DeleteFiles ..\Config\duh_simulator.cfg
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift /1 & goto :DeleteFiles
goto :EOF

:TaskExePidIsRunning
if "%~1" == "" exit /b 1 & rem EXE name
if "%~2" == "" exit /b 1 & rem PID number
SetLocal EnableExtensions EnableDelayedExpansion
for /f "tokens=1,2*" %%i in ('tasklist /nh /fi "imagename eq %~nx1"') do if /i "%%i" == "%~nx1" if /i "%%j" == "%~2" exit /b 0
exit /b 1
goto :EOF

:RequiredParentCrwDaq
if not defined CRW_DAQ_SYS_EXE_PID  goto :FailureParentCrwDaq
if not defined CRW_DAQ_SYS_HOME_DIR goto :FailureParentCrwDaq
if not defined CRW_DAQ_SYS_EXE_FILE goto :FailureParentCrwDaq
if not exist %CRW_DAQ_SYS_HOME_DIR% goto :FailureParentCrwDaq
call :TaskExePidIsRunning "%CRW_DAQ_SYS_EXE_FILE%" "%CRW_DAQ_SYS_EXE_PID%" && exit /b 0
:FailureParentCrwDaq
1>&2 echo ERROR in %~nx0 : parent CRW-DAQ is not found. Run this script from CRW-DAQ.
exit /b 1
goto :EOF
