@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

rem #################################################
rem The script is to be called on DAQ start and stop.
rem #################################################

:CheckComputer
rem if /I not "%ComputerName%" == "demo-daq-pc" goto :EOF

:Main
if /i "%~1" == "pre"  call :PreProcessor
if /i "%~1" == "post" call :PostProcessor
goto :EOF

:PreProcessor
echo Running preprocessor ...
if not defined CRW_DAQ_CONFIG_HOME_DIR goto :EOF
pushd "%CRW_DAQ_CONFIG_HOME_DIR%" && call :PreProcessorAction
popd
goto :EOF

:PostProcessor
echo Running postprocessor ...
if not defined CRW_DAQ_CONFIG_HOME_DIR goto :EOF
pushd "%CRW_DAQ_CONFIG_HOME_DIR%" && call :PostProcessorAction
popd
goto :EOF

:PreProcessorAction
chcp 65001
unix cltimer -start
call ..\utility\daqsys.logon.cmd
call :DeleteFiles duh_selector.txt
for /f %%i in ('unix dirname %CRW_DAQ_SYS_TITLE% ^| unix tr "#" "_"') do set head=%%i
set "Caption=%head% - DUH: SELECT CONFIGURATION …"
unix -n grun -h unix sleep 1 ^& unix window /top %Caption%
unix -n grun -h unix sleep 2 ^& unix movewindow "%Caption%" 167 0
unix zenity --title "%Caption%" ^
       --list --modal --timeout 30 --width 300 --height 300 ^
       --text "<big><b>Select number of Heaters for UniHeat.</b></big>" ^
       --radiolist --column "Check" --column "Number" --column "Of Heaters" ^
       --separator " " --print-column=2 ^
       true   "8"  "Heaters" ^
       false  "10" "Heaters" ^
       false  "16" "Heaters" ^
       false  "20" "Heaters" ^
       false  "24" "Heaters" ^
       false  "30" "Heaters" ^
       false  "32" "Heaters" ^
       > duh_selector.txt
for /f %%i in ('unix cat duh_selector.txt') do set Item=%%i
unix printf "Selected item = %%s\n" "!Item!"
call ..\config\uh_make_sim.cmd !Item!
call :DeleteFiles duh_selector.txt
unix cltimer -stop
goto :EOF

:PostProcessorAction
call ..\utility\daqsys.logout.cmd
call :DeleteFiles ..\config\uniheat.cfg
call :DeleteFiles ..\config\duh_tags.cfg
call :DeleteFiles ..\config\duh_datsrv.cfg
call :DeleteFiles ..\config\duh_main_gui.cfg
call :DeleteFiles ..\config\duh_simulator.cfg
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift 1 && goto :DeleteFiles
goto :EOF
