@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

call :Main %*
goto :EOF

:Main
chcp 65001 > nul
if "%~1" == "" goto :EOF
call :UniHeatSim %1 > "%~dp0duh_simulator.cfg"
call :UniHeatTag %1 > "%~dp0duh_tags.cfg"
call :UniHeatSel %1 > "%~dp0UniHeat.cfg"
call :DUHMainGui %1 > "%~dp0duh_main_gui.cfg"
call :DUH_DatSrv %1 > "%~dp0duh_datsrv.cfg"
goto :EOF

:UniHeatSim
call :GeneralMap %1
call :LinkAI %1
call :LinkAO %1
call :LinkDI %1
call :SimText %1
call :EndSimText
goto :EOF
:GeneralMap
echo ;********************************************
echo ; Симулятор нагревателей для проверки UniHeat
echo ;********************************************
echo [DeviceList]
echo ^&DUH.SIM = device software script
echo [^&DUH.SIM]
echo Comment       = UniHeat simulation
echo InquiryPeriod = 1
echo DevicePolling = 100, tpNormal
echo ScriptSection = ^&DUH.SIM.TEXT
goto :EOF
:LinkAI
echo AnalogInputs  = %1
for /L %%n in (1,1,%1) do call :LinkAIs %%n
goto :EOF
:LinkAIs
set /a ai=%1-1
echo Link AnalogInput   %ai% with curve DUH.SIM.T%1
goto :EOF
:LinkAO
set /a numao=%1*2
echo AnalogOutputs = %numao%
for /L %%n in (1,1,%1) do call :LinkAOsT %%n
for /L %%n in (1,1,%1) do call :LinkAOsP %%n %1
goto :EOF
:LinkAOsT
set /a ao=%1-1
echo Link AnalogOutput %ao% with curve DUH.SIM.T%1  history 10000
goto :EOF
:LinkAOsP
set /a ao=%1-1+%2
echo Link AnalogOutput %ao% with curve DUH.SIM.P%1  history 10000
goto :EOF
:LinkDI
set /a numdi=%1*2
echo DigitalInputs = %numdi%
for /L %%n in (1,1,%1) do call :LinkDIsBLK %%n
for /L %%n in (1,1,%1) do call :LinkDIsGAT %%n %1
goto :EOF
:LinkDIsBLK
set /a di=%1-1
echo Link DigitalInput %di% with curve UH_BLK%1  inverted bit 0 ; BS%1  POWER
goto :EOF
:LinkDIsGAT
set /a di=%1-1+%2
echo Link DigitalInput %di% with curve UH_GATE%1          bit 0 ; BS%1  SSR
goto :EOF
:SimText
echo []
echo [^&DUH.SIM.TEXT]
echo var runcount
echo runcount=runcount+1
echo Noise=0.0
echo RoomTemp=20
echo HeatRate=1e-1
echo CoolRate=1e-4
echo n=NumAis()
echo i=0
echo mas=vnew(n)
call :SimTextVar %1
for /L %%n in (1,1,%1) do call :SimTextTagsRead %%n
goto :EOF
:SimTextVar
if %1==8 (
call :Vars8
)
if %1==10 (
call :Vars10
)
if %1==16 (
call :Vars8
call :Vars16
)
if %1==20 (
call :Vars10
call :Vars20
)
if %1==24 (
call :Vars8
call :Vars16
call :Vars24
)
if %1==30 (
call :Vars10
call :Vars20
call :Vars30
)
if %1==32 (
call :Vars8
call :Vars16
call :Vars24
call :Vars32
)
goto :EOF
:Vars8
echo var tagMode1,  tagMode2,  tagMode3,  tagMode4
echo var tagMode5,  tagMode6,  tagMode7,  tagMode8
goto :EOF
:Vars10
echo var tagMode1,  tagMode2,  tagMode3,  tagMode4,  tagMode5
echo var tagMode6,  tagMode7,  tagMode8,  tagMode9,  tagMode10
goto :EOF
:Vars16
echo var tagMode9,  tagMode10, tagMode11, tagMode12
echo var tagMode13, tagMode14, tagMode15, tagMode16
goto :EOF
:Vars20
echo var tagMode11, tagMode12, tagMode13, tagMode14, tagMode15
echo var tagMode16, tagMode17, tagMode18, tagMode19, tagMode20
goto :EOF
:Vars24
echo var tagMode17, tagMode18, tagMode19, tagMode20
echo var tagMode21, tagMode22, tagMode23, tagMode24
goto :EOF
:Vars30
echo var tagMode21, tagMode22, tagMode23, tagMode24, tagMode25
echo var tagMode26, tagMode27, tagMode28, tagMode29, tagMode30
goto :EOF
:Vars32
echo var tagMode25, tagMode26, tagMode27, tagMode28
echo var tagMode29, tagMode30, tagMode31, tagMode32
goto :EOF
:SimTextTagsRead
set /a num=%1-1
echo if not(tagMode%1) then tagMode%1=@findtag UH_MODE%1
echo mode=iGetTag(tagMode%1)
echo vput(mas,%num%,mode)
goto :EOF
:EndSimText
echo Loop:
echo  j=i+n
echo  pow=eq(getdi_yn(i),0)
echo  ssr=ne(getdi_yn(j),0)
echo  temp=getai_yn(i)+RoomTemp*eq(runcount,1)
echo  if eq(vget(mas,i),0) then temp=temp+pow*ssr*HeatRate-(temp-RoomTemp)*CoolRate
echo  if eq(vget(mas,i),1) then temp=temp-pow*ssr*HeatRate-(temp-RoomTemp)*CoolRate
echo  temp=temp+Noise*random(-1,1)
echo  pres=temp/2
echo  putao(i, time(), temp)
echo  putao(j, time(), pres)
echo  i=i+1
echo if lt(i,n) then goto Loop
echo vfree(mas)
echo []
echo.
echo ;****************************************************************
echo ;*** Включить речевой синтезатор для UniHeat                  ***
echo ;****************************************************************
echo [^&UH_CTRL]
echo UsesSpeakSrv = 1
echo []
echo.
echo ;****************************************************************
echo ;*** Поместить основные параметры печей на главную мнемосхему ***
echo ;****************************************************************
echo [DUH.MAIN.GUI]
echo Link sensor   UH_BT1     with   tag   UH_ST1    device ^&UH_CTRL
echo Link sensor   UH_TGOAL1  with   tag   UH_TGOAL1 device ^&UH_CTRL
echo Link sensor   UH_TREAL1  with   curve UH_TREAL1 device ^&UH_CTRL
echo Link sensor   UH_GATE1   with   curve UH_GATE1  device ^&UH_CTRL
echo Link sensor   UH_PROP1   with                   device ^&UH_CTRL
echo Link sensor   UH_TNAME1  with   tag   UH_TNAME1 device ^&UH_CTRL
echo Link sensor   UH_PNAME1  with   tag   UH_PNAME1 device ^&UH_CTRL
echo Link sensor   UH_BT2     with   tag   UH_ST2    device ^&UH_CTRL
echo Link sensor   UH_TGOAL2  with   tag   UH_TGOAL2 device ^&UH_CTRL
echo Link sensor   UH_TREAL2  with   curve UH_TREAL2 device ^&UH_CTRL
echo Link sensor   UH_GATE2   with   curve UH_GATE2  device ^&UH_CTRL
echo Link sensor   UH_PROP2   with                   device ^&UH_CTRL
echo Link sensor   UH_TNAME2  with   tag   UH_TNAME2 device ^&UH_CTRL
echo Link sensor   UH_PNAME2  with   tag   UH_PNAME2 device ^&UH_CTRL
echo Link sensor   UH_BT3     with   tag   UH_ST3    device ^&UH_CTRL
echo Link sensor   UH_TGOAL3  with   tag   UH_TGOAL3 device ^&UH_CTRL
echo Link sensor   UH_TREAL3  with   curve UH_TREAL3 device ^&UH_CTRL
echo Link sensor   UH_GATE3   with   curve UH_GATE3  device ^&UH_CTRL
echo Link sensor   UH_PROP3   with                   device ^&UH_CTRL
echo Link sensor   UH_TNAME3  with   tag   UH_TNAME3 device ^&UH_CTRL
echo Link sensor   UH_PNAME3  with   tag   UH_PNAME3 device ^&UH_CTRL
echo []
goto :EOF

:UniHeatTag
echo ;***************************
echo ; Demo_UniHeat Curves ^& tags
echo ;***************************
echo.
echo [TagList] ; ToolBar commands
echo DUH.CMD.HELP     = integer 0
echo DUH.CMD.HOME     = integer 0
echo DUH.CMD.OPEN     = integer 0
echo DUH.CMD.SAVE     = integer 0
echo DUH.CMD.LOADINI  = integer 0
echo DUH.CMD.SAVEINI  = integer 0
echo DUH.CMD.TOOLS    = integer 0
echo DUH.CMD.SOUND    = integer 0
echo DUH.CMD.SMILE    = integer 0
echo DUH.CMD.CLOSE    = integer 0
echo []
echo.
echo [DataStorage] ; UniHeat T,P simulation
for /L %%n in (1,1,%1) do call :UniHeatDST %%n
for /L %%n in (1,1,%1) do call :UniHeatDSP %%n
echo []
goto :EOF
:UniHeatDST
echo DUH.SIM.T%1  = Curve 0 10 Black  15 1
goto :EOF
:UniHeatDSP
echo DUH.SIM.P%1  = Curve 0 10 Black  15 1
goto :EOF

:UniHeatSel
echo ;***********************************************************
echo ;*** КОНФИГУРАЦИОННЫЙ ФАЙЛ CRW-DAQ ДЛЯ СОЗДАНИЯ ПРОГРАММ  **
echo ;*** УПРАВЛЕНИЯ ПЕЧАМИ (ЗАГОТОВКА НА 8,16,24 или 32 ПЕЧИ) **
echo ;*** Подсистема селектора каналов для управления UniHeat  **
echo ;*** Этот файл надо настраивать индивидуально для каждой  **
echo ;*** системы, т.к. кривые источников данных меняются      **
echo ;*** Для задействования 8,16,24 или 32 печей используйте  **
echo ;*** конфигурации UH_8,UH_16,UH_24,UH_32 соответственно.  **
echo ;***********************************************************
echo [ConfigFileList] ; Подключение конфигурации UniHeat
echo ConfigFile =~~\Resource\DaqSite\UniHeat\Config\UH_%1.cfg
echo []
echo.
echo ;************************************
echo ;*** Селектор каналов температуры ***
echo ;*** Редактируются AnalogInputs и ***
echo ;*** UH_TNAMES - имена датчиков T ***
echo ;*** Имена датчиков без пробелов, ***
echo ;*** разделяются слэшем: T1/T2/.. ***
echo ;*** Имена датчиков должны строго ***
echo ;*** соответствовать AnalogInputs ***
echo ;************************************
echo [^&UH_REDIR_T]
echo UsesSmoothing  = 1
set /a numai=%1+1
echo AnalogInputs   = %numai%
for /L %%n in (1,1,%1) do call :UniHeatSelAIT %%n %1
echo []
echo [TagList]
call :UniHeatSelT %1
echo []
echo.
echo ;************************************
echo ;*** Селектор каналов давлений    ***
echo ;*** Редактируются AnalogInputs и ***
echo ;*** UH_PNAMES - имена датчиков P ***
echo ;*** Имена датчиков без пробелов, ***
echo ;*** разделяются слэшем: P1/P2/.. ***
echo ;*** Имена датчиков должны строго ***
echo ;*** соответствовать AnalogInputs ***
echo ;************************************
echo [^&UH_REDIR_P]
echo UsesSmoothing  = 1
set /a numai=%1+1
echo AnalogInputs   = %numai%
for /L %%n in (1,1,%1) do call :UniHeatSelAIP %%n %1
echo []
echo [TagList]
call :UniHeatSelP %1
echo []
goto :EOF
:UniHeatSelAIT
echo Link AnalogInput %1  with curve DUH.SIM.T%1  smoothing 1e-4 0 2 2
goto :EOF
:UniHeatSelT
if %1==8 (
call :UHSelT8
)
if %1==10 (
call :UHSelT10
)
if %1==16 (
call :UHSelT16
)
if %1==20 (
call :UHSelT20
)
if %1==24 (
call :UHSelT24
)
if %1==30 (
call :UHSelT30
)
if %1==32 (
call :UHSelT32
)
goto :EOF
:UHSelT8
echo UH_TNAMES = string SIMT1/SIMT2/SIMT3/SIMT4/SIMT5/SIMT6/SIMT7/SIMT8
goto :EOF
:UHSelT10
echo UH_TNAMES = string SIMT1/SIMT2/SIMT3/SIMT4/SIMT5/SIMT6/SIMT7/SIMT8/SIMT9/SIMT10
goto :EOF
:UHSelT16
echo UH_TNAMES = string SIMT1/SIMT2/SIMT3/SIMT4/SIMT5/SIMT6/SIMT7/SIMT8/SIMT9/SIMT10/SIMT11/SIMT12/SIMT13/SIMT14/SIMT15/SIMT16
goto :EOF
:UHSelT20
echo UH_TNAMES = string SIMT1/SIMT2/SIMT3/SIMT4/SIMT5/SIMT6/SIMT7/SIMT8/SIMT9/SIMT10/SIMT11/SIMT12/SIMT13/SIMT14/SIMT15/SIMT16/SIMT17/SIMT18/SIMT19/SIMT20
goto :EOF
:UHSelT24
echo UH_TNAMES = string SIMT1/SIMT2/SIMT3/SIMT4/SIMT5/SIMT6/SIMT7/SIMT8/SIMT9/SIMT10/SIMT11/SIMT12/SIMT13/SIMT14/SIMT15/SIMT16/SIMT17/SIMT18/SIMT19/SIMT20/SIMT21/SIMT22/SIMT23/SIMT24
goto :EOF
:UHSelT30
echo UH_TNAMES = string SIMT1/SIMT2/SIMT3/SIMT4/SIMT5/SIMT6/SIMT7/SIMT8/SIMT9/SIMT10/SIMT11/SIMT12/SIMT13/SIMT14/SIMT15/SIMT16/SIMT17/SIMT18/SIMT19/SIMT20/SIMT21/SIMT22/SIMT23/SIMT24/SIMT25/SIMT26/SIMT27/SIMT28/SIMT29/SIMT30
goto :EOF
:UHSelT32
echo UH_TNAMES = string SIMT1/SIMT2/SIMT3/SIMT4/SIMT5/SIMT6/SIMT7/SIMT8/SIMT9/SIMT10/SIMT11/SIMT12/SIMT13/SIMT14/SIMT15/SIMT16/SIMT17/SIMT18/SIMT19/SIMT20/SIMT21/SIMT22/SIMT23/SIMT24/SIMT25/SIMT26/SIMT27/SIMT28/SIMT29/SIMT30/SIMT31/SIMT32
goto :EOF
:UniHeatSelAIP
echo Link AnalogInput %1  with curve DUH.SIM.P%1  smoothing 1e-4 0 2 2
goto :EOF
:UniHeatSelP
if %1==8 (
call :UHSelP8
)
if %1==10 (
call :UHSelP10
)
if %1==16 (
call :UHSelP16
)
if %1==20 (
call :UHSelP20
)
if %1==24 (
call :UHSelP24
)
if %1==30 (
call :UHSelP30
)
if %1==32 (
call :UHSelP32
)
goto :EOF
:UHSelP8
echo UH_PNAMES = string SIMP1/SIMP2/SIMP3/SIMP4/SIMP5/SIMP6/SIMP7/SIMP8
goto :EOF
:UHSelP10
echo UH_PNAMES = string SIMP1/SIMP2/SIMP3/SIMP4/SIMP5/SIMP6/SIMP7/SIMP8/SIMP9/SIMP10
goto :EOF
:UHSelP16
echo UH_PNAMES = string SIMP1/SIMP2/SIMP3/SIMP4/SIMP5/SIMP6/SIMP7/SIMP8/SIMP9/SIMP10/SIMP11/SIMP12/SIMP13/SIMP14/SIMP15/SIMP16
goto :EOF
:UHSelP20
echo UH_PNAMES = string SIMP1/SIMP2/SIMP3/SIMP4/SIMP5/SIMP6/SIMP7/SIMP8/SIMP9/SIMP10/SIMP11/SIMP12/SIMP13/SIMP14/SIMP15/SIMP16/SIMP17/SIMP18/SIMP19/SIMP20
goto :EOF
:UHSelP24
echo UH_PNAMES = string SIMP1/SIMP2/SIMP3/SIMP4/SIMP5/SIMP6/SIMP7/SIMP8/SIMP9/SIMP10/SIMP11/SIMP12/SIMP13/SIMP14/SIMP15/SIMP16/SIMP17/SIMP18/SIMP19/SIMP20/SIMP21/SIMP22/SIMP23/SIMP24
goto :EOF
:UHSelP30
echo UH_PNAMES = string SIMP1/SIMP2/SIMP3/SIMP4/SIMP5/SIMP6/SIMP7/SIMP8/SIMP9/SIMP10/SIMP11/SIMP12/SIMP13/SIMP14/SIMP15/SIMP16/SIMP17/SIMP18/SIMP19/SIMP20/SIMP21/SIMP22/SIMP23/SIMP24/SIMP25/SIMP26/SIMP27/SIMP28/SIMP29/SIMP30
goto :EOF
:UHSelP32
echo UH_PNAMES = string SIMP1/SIMP2/SIMP3/SIMP4/SIMP5/SIMP6/SIMP7/SIMP8/SIMP9/SIMP10/SIMP11/SIMP12/SIMP13/SIMP14/SIMP15/SIMP16/SIMP17/SIMP18/SIMP19/SIMP20/SIMP21/SIMP22/SIMP23/SIMP24/SIMP25/SIMP26/SIMP27/SIMP28/SIMP29/SIMP30/SIMP31/SIMP32
goto :EOF

:DUHMainGui
echo [DeviceList]
echo ^&DUH.MAIN.GUI = device software program
echo [^&DUH.MAIN.GUI]
echo Comment        = DEMO UNIHEAT MAIN GUI.
echo InquiryPeriod  = 0
echo DevicePolling  = 10, tpTimeCritical
echo ProgramSource  = ..\DaqPas\duh_main_gui.pas
echo DebugFlags     = 3
echo OpenConsole    = 2
echo StdInFifo      = 128
echo StdOutFifo     = 128
echo AnalogFifo     = 10000
echo DigitalFifo    = 10000
echo tagDUH         = DUH
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [CustomParameters.TagList]
echo CustomIniFileRef  = ..\Data\DUH_Custom.Ini
echo CustomIniSection  = [CustomParameters]
echo CustomIniBackups  = ..\..\DUH_Data\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 0
echo []
echo.
echo [ConfigFileList]
echo ConfigFile = ..\Data\duh_custom.ini
echo ConfigFile = ..\Config\duh_custom.cfg
echo []
echo.
echo [Windows]
echo DUH.MAIN.GUI = Circuit_Window 
echo [DUH.MAIN.GUI]
echo Circuit = ..\Circuits\duh_main_gui.crc
echo Link sensor DUH.CMD.HELP     with tag   DUH.CMD.HELP     device ^&DUH.MAIN.GUI
echo Link sensor DUH.CMD.HOME     with tag   DUH.CMD.HOME     device ^&DUH.MAIN.GUI
echo Link sensor DUH.CMD.OPEN     with tag   DUH.CMD.OPEN     device ^&DUH.MAIN.GUI
echo Link sensor DUH.CMD.SAVE     with tag   DUH.CMD.SAVE     device ^&DUH.MAIN.GUI
echo Link sensor DUH.CMD.LOADINI  with tag   DUH.CMD.LOADINI  device ^&DUH.MAIN.GUI
echo Link sensor DUH.CMD.SAVEINI  with tag   DUH.CMD.SAVEINI  device ^&DUH.MAIN.GUI
echo Link sensor DUH.CMD.SOUND    with tag   DUH.CMD.SOUND    device ^&DUH.MAIN.GUI
echo Link sensor DUH.CMD.SMILE    with tag   DUH.CMD.SMILE    device ^&DUH.MAIN.GUI
echo Link sensor DUH.CMD.CLOSE    with tag   DUH.CMD.CLOSE    device ^&DUH.MAIN.GUI
echo Link sensor @cron.run+UH_CONTROL.SELECT             with device ^&DUH.MAIN.GUI
if %1==8 (
 set /a num=8
) else (
 set /a num=10
)
for /L %%n in (1,1,%num%) do call :LinkSensT %%n
for /L %%n in (1,1,%num%) do call :LinkSensP %%n
echo []
echo.
echo [Windows]
echo DUH.T.PLOT = Curve_Window
echo [DUH.T.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.05
echo AxisY = ^^CT_Sensors_(Поджиг)^^N^^L___{C}, 0, 1000
call :DUHPlotT %1
echo []
echo.
echo [Windows]
echo DUH.P.PLOT = Curve_Window
echo [DUH.P.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.05
echo AxisY = ^^CP_Sensors^^N^^L___{Bar}, 0, 2500
call :DUHPlotP %1
echo []
goto :EOF
:LinkSensT
echo Link sensor DUH.T%1           with curve DUH.SIM.T%1       device ^&DUH.MAIN.GUI
goto :EOF
:LinkSensP
echo Link sensor DUH.P%1           with curve DUH.SIM.P%1       device ^&DUH.MAIN.GUI
goto :EOF
:DUHPlotT
if %1==8 (
call :DUHPlotT8
)
if %1==10 (
call :DUHPlotT10
)
if %1==16 (
call :DUHPlotT8
call :DUHPlotT16
)
if %1==20 (
call :DUHPlotT10
call :DUHPlotT20
)
if %1==24 (
call :DUHPlotT8
call :DUHPlotT16
call :DUHPlotT24
)
if %1==30 (
call :DUHPlotT10
call :DUHPlotT20
call :DUHPlotT30
)
if %1==32 (
call :DUHPlotT8
call :DUHPlotT16
call :DUHPlotT24
call :DUHPlotT32
)
goto :EOF
:DUHPlotT8
echo CurveList = DUH.SIM.T1,  DUH.SIM.T2,  DUH.SIM.T3,  DUH.SIM.T4
echo CurveList = DUH.SIM.T5,  DUH.SIM.T6,  DUH.SIM.T7,  DUH.SIM.T8
goto :EOF
:DUHPlotT10
echo CurveList = DUH.SIM.T1,  DUH.SIM.T2,  DUH.SIM.T3,  DUH.SIM.T4,  DUH.SIM.T5
echo CurveList = DUH.SIM.T6,  DUH.SIM.T7,  DUH.SIM.T8,  DUH.SIM.T9,  DUH.SIM.T10
goto :EOF
:DUHPlotT16
echo CurveList = DUH.SIM.T9,  DUH.SIM.T10, DUH.SIM.T11, DUH.SIM.T12
echo CurveList = DUH.SIM.T13, DUH.SIM.T14, DUH.SIM.T15, DUH.SIM.T16
goto :EOF
:DUHPlotT20
echo CurveList = DUH.SIM.T11, DUH.SIM.T12, DUH.SIM.T13, DUH.SIM.T14, DUH.SIM.T15
echo CurveList = DUH.SIM.T16, DUH.SIM.T17, DUH.SIM.T18, DUH.SIM.T19, DUH.SIM.T20
goto :EOF
:DUHPlotT24
echo CurveList = DUH.SIM.T17, DUH.SIM.T18, DUH.SIM.T19, DUH.SIM.T20
echo CurveList = DUH.SIM.T21, DUH.SIM.T22, DUH.SIM.T23, DUH.SIM.T24
goto :EOF
:DUHPlotT30
echo CurveList = DUH.SIM.T21, DUH.SIM.T22, DUH.SIM.T23, DUH.SIM.T24, DUH.SIM.T25
echo CurveList = DUH.SIM.T26, DUH.SIM.T27, DUH.SIM.T28, DUH.SIM.T29, DUH.SIM.T30
goto :EOF
:DUHPlotT32
echo CurveList = DUH.SIM.T25, DUH.SIM.T26, DUH.SIM.T27, DUH.SIM.T28
echo CurveList = DUH.SIM.T29, DUH.SIM.T30, DUH.SIM.T31, DUH.SIM.T32
goto :EOF
:DUHPlotP
if %1==8 (
call :DUHPlotP8
)
if %1==10 (
call :DUHPlotP10
)
if %1==16 (
call :DUHPlotP8
call :DUHPlotP16
)
if %1==20 (
call :DUHPlotP10
call :DUHPlotP20
)
if %1==24 (
call :DUHPlotP8
call :DUHPlotP16
call :DUHPlotP24
)
if %1==30 (
call :DUHPlotP10
call :DUHPlotP20
call :DUHPlotP30
)
if %1==32 (
call :DUHPlotP8
call :DUHPlotP16
call :DUHPlotP24
call :DUHPlotP32
)
goto :EOF
:DUHPlotP8
echo CurveList = DUH.SIM.P1,  DUH.SIM.P2,  DUH.SIM.P3,  DUH.SIM.P4
echo CurveList = DUH.SIM.P5,  DUH.SIM.P6,  DUH.SIM.P7,  DUH.SIM.P8
goto :EOF
:DUHPlotP10
echo CurveList = DUH.SIM.P1,  DUH.SIM.P2,  DUH.SIM.P3,  DUH.SIM.P4,  DUH.SIM.P5
echo CurveList = DUH.SIM.P6,  DUH.SIM.P7,  DUH.SIM.P8,  DUH.SIM.P9,  DUH.SIM.P10
goto :EOF
:DUHPlotP16
echo CurveList = DUH.SIM.P9,  DUH.SIM.P10, DUH.SIM.P11, DUH.SIM.P12
echo CurveList = DUH.SIM.P13, DUH.SIM.P14, DUH.SIM.P15, DUH.SIM.P16
goto :EOF
:DUHPlotP20
echo CurveList = DUH.SIM.P11, DUH.SIM.P12, DUH.SIM.P13, DUH.SIM.P14, DUH.SIM.P15
echo CurveList = DUH.SIM.P16, DUH.SIM.P17, DUH.SIM.P18, DUH.SIM.P19, DUH.SIM.P20
goto :EOF
:DUHPlotP24
echo CurveList = DUH.SIM.P17, DUH.SIM.P18, DUH.SIM.P19, DUH.SIM.P20
echo CurveList = DUH.SIM.P21, DUH.SIM.P22, DUH.SIM.P23, DUH.SIM.P24
goto :EOF
:DUHPlotP30
echo CurveList = DUH.SIM.P21, DUH.SIM.P22, DUH.SIM.P23, DUH.SIM.P24, DUH.SIM.P25
echo CurveList = DUH.SIM.P26, DUH.SIM.P27, DUH.SIM.P28, DUH.SIM.P29, DUH.SIM.P30
goto :EOF
:DUHPlotP32
echo CurveList = DUH.SIM.P25, DUH.SIM.P26, DUH.SIM.P27, DUH.SIM.P28
echo CurveList = DUH.SIM.P29, DUH.SIM.P30, DUH.SIM.P31, DUH.SIM.P32
goto :EOF

:DUH_DatSrv
echo [ConfigFileList]
echo ConfigFile = ~~\Resource\DaqSite\Default\DatSrv.cfg
echo []
echo [^&DATSRV]
echo IntegrityMode  = 1
echo SavePeriod     = 300
echo FilePrefix     = DUH_
echo DataPath       = ..\..\DUH_DATA
echo []
echo.
echo [^&DATSRV]
call :DUHPlotT %1
echo []
goto :EOF

