///////////////////////////////////////////////////////////////////// BSTR VACS funcs:
 {
 Prefix for DIM @remote commands.
 }
 function DimRemote:String;
 var CanRemote:Boolean;
 begin
  CanRemote:=DIM_IsServerMode or DIM_IsClientMode;
  if (DIM_GuiClickTag=0) then CanRemote:=false;
  if (devDimSrv=0) then CanRemote:=false;
  if CanRemote
  then DimRemote:='@remote '
  else DimRemote:='';
 end;
 {
 Xor bit on click (local version)
 }
 procedure ClickTagXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Xor bit on click (remote version).
 }
 procedure ClickTagXorRemote(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(tag)+' '+Str(iXor(iGetTag(tag),XorMask)));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then ShowTooltip('guid '+Str(getpid)+'@'+ProgName+' text "'+s+'" preset stdHelp delay 15000'
                      +' btn1 Справка cmd1 "cmd /c start '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm')+'"');
 end;
 {
 Switch button (tag) to given value.
 }
 procedure SWITCH_BT(tag:Integer; value:Integer);
 begin
  bNul(iSetTag(tag,value));
 end;
 {
 Initialize Rec.Val.
 }
 procedure TTagRef_InitVal(var Rec:TTagRef);
 begin
  Rec.val:=0; Rec.tim:=0;
 end;
 {
 Clear BSTR.VACS record strings
 }
 procedure TVACSRec_Clear(var Rec:TVACSRec);
 begin
  Rec.SERVID.tag:=0;
  Rec.CLOCK.tag:=0;
  Rec.SelfId:='';
 end;
 {
 Initialize BSTR.VACS record tags
 }
 procedure TVACSRec_Init(var Rec:TVACSRec; tagPrefix:String);
 begin
  DIM_GuiClickInit(tagPrefix+'.DIMGUICLICK');
  InitTag(Rec.SERVID.tag,        tagPrefix+'.SERVID',        3);
  InitTag(Rec.CLOCK.tag,         tagPrefix+'.CLOCK',         3);
  InitTag(Rec.SEC1.VP1.BT.tag,   tagPrefix+'.SEC1.VP1.BT',   1);
  InitTag(Rec.SEC1.VP2.BT.tag,   tagPrefix+'.SEC1.VP2.BT',   1);
  InitTag(Rec.SEC1.NG1.BT.tag,   tagPrefix+'.SEC1.NG1.BT',   1);
  InitTag(Rec.SEC1.NG2.BT.tag,   tagPrefix+'.SEC1.NG2.BT',   1);
  InitTag(Rec.SEC1.NG3.BT.tag,   tagPrefix+'.SEC1.NG3.BT',   1);
  InitTag(Rec.SEC1.NM1.BT.tag,   tagPrefix+'.SEC1.NM1.BT',   1);
  InitTag(Rec.SEC1.NM2.BT.tag,   tagPrefix+'.SEC1.NM2.BT',   1);
  InitTag(Rec.SEC1.NM3.BT.tag,   tagPrefix+'.SEC1.NM3.BT',   1);
  InitTag(Rec.SEC1.NM4.BT.tag,   tagPrefix+'.SEC1.NM4.BT',   1);
  InitTag(Rec.SEC1.PS1.MBAR.tag, tagPrefix+'.SEC1.PS1.MBAR', 2);
  InitTag(Rec.SEC2.VP3.BT.tag,   tagPrefix+'.SEC2.VP3.BT',   1);
  InitTag(Rec.SEC2.VP4.BT.tag,   tagPrefix+'.SEC2.VP4.BT',   1);
  InitTag(Rec.SEC2.NG4.BT.tag,   tagPrefix+'.SEC2.NG4.BT',   1);
  InitTag(Rec.SEC2.NG5.BT.tag,   tagPrefix+'.SEC2.NG5.BT',   1);
  InitTag(Rec.SEC2.NG6.BT.tag,   tagPrefix+'.SEC2.NG6.BT',   1);
  InitTag(Rec.SEC2.NG7.BT.tag,   tagPrefix+'.SEC2.NG7.BT',   1);
  InitTag(Rec.SEC2.NM5.BT.tag,   tagPrefix+'.SEC2.NM5.BT',   1);
  InitTag(Rec.SEC2.NM6.BT.tag,   tagPrefix+'.SEC2.NM6.BT',   1);
  InitTag(Rec.SEC2.NM7.BT.tag,   tagPrefix+'.SEC2.NM7.BT',   1);
  InitTag(Rec.SEC2.NM8.BT.tag,   tagPrefix+'.SEC2.NM8.BT',   1);
  InitTag(Rec.SEC2.PS2.MBAR.tag, tagPrefix+'.SEC2.PS2.MBAR', 2);
  InitTag(Rec.SEC3.VP5.BT.tag,   tagPrefix+'.SEC3.VP5.BT',   1);
  InitTag(Rec.SEC3.VP6.BT.tag,   tagPrefix+'.SEC3.VP6.BT',   1);
  InitTag(Rec.SEC3.NG8.BT.tag,   tagPrefix+'.SEC3.NG8.BT',   1);
  InitTag(Rec.SEC3.NG9.BT.tag,   tagPrefix+'.SEC3.NG9.BT',   1);
  InitTag(Rec.SEC3.NG10.BT.tag,  tagPrefix+'.SEC3.NG10.BT',  1);
  InitTag(Rec.SEC3.NM9.BT.tag,   tagPrefix+'.SEC3.NM9.BT',   1);
  InitTag(Rec.SEC3.NM10.BT.tag,  tagPrefix+'.SEC3.NM10.BT',  1);
  InitTag(Rec.SEC3.NM11.BT.tag,  tagPrefix+'.SEC3.NM11.BT',  1);
  InitTag(Rec.SEC3.NM12.BT.tag,  tagPrefix+'.SEC3.NM12.BT',  1);
  InitTag(Rec.SEC3.PS3.MBAR.tag, tagPrefix+'.SEC3.PS3.MBAR', 2);
  InitTag(Rec.SEC4.VP8.BT.tag,   tagPrefix+'.SEC4.VP8.BT',   1);
  InitTag(Rec.SEC4.VP9.BT.tag,   tagPrefix+'.SEC4.VP9.BT',   1);
  InitTag(Rec.SEC4.NG11.BT.tag,  tagPrefix+'.SEC4.NG11.BT',  1);
  InitTag(Rec.SEC4.NG12.BT.tag,  tagPrefix+'.SEC4.NG12.BT',  1);
  InitTag(Rec.SEC4.NG13.BT.tag,  tagPrefix+'.SEC4.NG13.BT',  1);
  InitTag(Rec.SEC4.NM13.BT.tag,  tagPrefix+'.SEC4.NM13.BT',  1);
  InitTag(Rec.SEC4.NM14.BT.tag,  tagPrefix+'.SEC4.NM14.BT',  1);
  InitTag(Rec.SEC4.NM15.BT.tag,  tagPrefix+'.SEC4.NM15.BT',  1);
  InitTag(Rec.SEC4.NM16.BT.tag,  tagPrefix+'.SEC4.NM16.BT',  1);
  InitTag(Rec.SEC4.PS4.MBAR.tag, tagPrefix+'.SEC4.PS4.MBAR', 2);
  InitTag(Rec.SEC5.VP10.BT.tag,  tagPrefix+'.SEC5.VP10.BT',  1);
  InitTag(Rec.SEC5.VP11.BT.tag,  tagPrefix+'.SEC5.VP11.BT',  1);
  InitTag(Rec.SEC5.NG14.BT.tag,  tagPrefix+'.SEC5.NG14.BT',  1);
  InitTag(Rec.SEC5.NG15.BT.tag,  tagPrefix+'.SEC5.NG15.BT',  1);
  InitTag(Rec.SEC5.NG16.BT.tag,  tagPrefix+'.SEC5.NG16.BT',  1);
  InitTag(Rec.SEC5.NG17.BT.tag,  tagPrefix+'.SEC5.NG17.BT',  1);
  InitTag(Rec.SEC5.NM17.BT.tag,  tagPrefix+'.SEC5.NM17.BT',  1);
  InitTag(Rec.SEC5.NM18.BT.tag,  tagPrefix+'.SEC5.NM18.BT',  1);
  InitTag(Rec.SEC5.NM19.BT.tag,  tagPrefix+'.SEC5.NM19.BT',  1);
  InitTag(Rec.SEC5.NM20.BT.tag,  tagPrefix+'.SEC5.NM20.BT',  1);
  InitTag(Rec.SEC5.PS5.MBAR.tag, tagPrefix+'.SEC5.PS5.MBAR', 2);
  InitTag(Rec.SEC6.VP12.BT.tag,  tagPrefix+'.SEC6.VP12.BT',  1);
  InitTag(Rec.SEC6.VP13.BT.tag,  tagPrefix+'.SEC6.VP13.BT',  1);
  InitTag(Rec.SEC6.NG18.BT.tag,  tagPrefix+'.SEC6.NG18.BT',  1);
  InitTag(Rec.SEC6.NG19.BT.tag,  tagPrefix+'.SEC6.NG19.BT',  1);
  InitTag(Rec.SEC6.NG20.BT.tag,  tagPrefix+'.SEC6.NG20.BT',  1);
  InitTag(Rec.SEC6.NM21.BT.tag,  tagPrefix+'.SEC6.NM21.BT',  1);
  InitTag(Rec.SEC6.NM22.BT.tag,  tagPrefix+'.SEC6.NM22.BT',  1);
  InitTag(Rec.SEC6.NM23.BT.tag,  tagPrefix+'.SEC6.NM23.BT',  1);
  InitTag(Rec.SEC6.NM24.BT.tag,  tagPrefix+'.SEC6.NM24.BT',  1);
  InitTag(Rec.SEC6.PS6.MBAR.tag, tagPrefix+'.SEC6.PS6.MBAR', 2);
  InitTag(Rec.ECOL.VP7.BT.tag,   tagPrefix+'.ECOL.VP7.BT',   1);
  InitTag(Rec.SEC1.NORMPS.tag,   tagPrefix+'.SEC1.NORMPS',   2);
  InitTag(Rec.SEC2.NORMPS.tag,   tagPrefix+'.SEC2.NORMPS',   2);
  InitTag(Rec.SEC3.NORMPS.tag,   tagPrefix+'.SEC3.NORMPS',   2);
  InitTag(Rec.SEC4.NORMPS.tag,   tagPrefix+'.SEC4.NORMPS',   2);
  InitTag(Rec.SEC5.NORMPS.tag,   tagPrefix+'.SEC5.NORMPS',   2);
  InitTag(Rec.SEC6.NORMPS.tag,   tagPrefix+'.SEC6.NORMPS',   2);
  InitTag(Rec.SEC1.WARNPS.tag,   tagPrefix+'.SEC1.WARNPS',   2);
  InitTag(Rec.SEC2.WARNPS.tag,   tagPrefix+'.SEC2.WARNPS',   2);
  InitTag(Rec.SEC3.WARNPS.tag,   tagPrefix+'.SEC3.WARNPS',   2);
  InitTag(Rec.SEC4.WARNPS.tag,   tagPrefix+'.SEC4.WARNPS',   2);
  InitTag(Rec.SEC5.WARNPS.tag,   tagPrefix+'.SEC5.WARNPS',   2);
  InitTag(Rec.SEC6.WARNPS.tag,   tagPrefix+'.SEC6.WARNPS',   2);
  InitTag(Rec.SEC1.FAILPS.tag,   tagPrefix+'.SEC1.FAILPS',   2);
  InitTag(Rec.SEC2.FAILPS.tag,   tagPrefix+'.SEC2.FAILPS',   2);
  InitTag(Rec.SEC3.FAILPS.tag,   tagPrefix+'.SEC3.FAILPS',   2);
  InitTag(Rec.SEC4.FAILPS.tag,   tagPrefix+'.SEC4.FAILPS',   2);
  InitTag(Rec.SEC5.FAILPS.tag,   tagPrefix+'.SEC5.FAILPS',   2);
  InitTag(Rec.SEC6.FAILPS.tag,   tagPrefix+'.SEC6.FAILPS',   2);
 end;
 {
 Initialize BSTR record tags
 }
 procedure TBSTRRec_Init(var Rec:TBSTRRec; tagPrefix:String);
 begin
  tagPrefix:=Trim(tagPrefix);
  if not IsEmptyStr(tagPrefix) then begin
   TVACSRec_Init(Rec.VACS,tagPrefix);
  end;
 end;
 //
 // Tags filling
 //
 procedure VACS_FillTags(InitVal:Real);
 begin
  BSTR.VACS.CLOCK.val:=InitVal;
  BSTR.VACS.SERVID.val:=InitVal;
  BSTR.VACS.SEC1.VP1.BT.val:=InitVal;
  BSTR.VACS.SEC1.VP2.BT.val:=InitVal;
  BSTR.VACS.SEC1.NG1.BT.val:=InitVal;
  BSTR.VACS.SEC1.NG2.BT.val:=InitVal;
  BSTR.VACS.SEC1.NG3.BT.val:=InitVal;
  BSTR.VACS.SEC1.NM1.BT.val:=InitVal;
  BSTR.VACS.SEC1.NM2.BT.val:=InitVal;
  BSTR.VACS.SEC1.NM3.BT.val:=InitVal;
  BSTR.VACS.SEC1.NM4.BT.val:=InitVal;
  BSTR.VACS.SEC2.VP3.BT.val:=InitVal;
  BSTR.VACS.SEC2.VP4.BT.val:=InitVal;
  BSTR.VACS.SEC2.NG4.BT.val:=InitVal;
  BSTR.VACS.SEC2.NG5.BT.val:=InitVal;
  BSTR.VACS.SEC2.NG6.BT.val:=InitVal;
  BSTR.VACS.SEC2.NG7.BT.val:=InitVal;
  BSTR.VACS.SEC2.NM5.BT.val:=InitVal;
  BSTR.VACS.SEC2.NM6.BT.val:=InitVal;
  BSTR.VACS.SEC2.NM7.BT.val:=InitVal;
  BSTR.VACS.SEC2.NM8.BT.val:=InitVal;
  BSTR.VACS.SEC3.VP5.BT.val:=InitVal;
  BSTR.VACS.SEC3.VP6.BT.val:=InitVal;
  BSTR.VACS.SEC3.NG8.BT.val:=InitVal;
  BSTR.VACS.SEC3.NG9.BT.val:=InitVal;
  BSTR.VACS.SEC3.NG10.BT.val:=InitVal;
  BSTR.VACS.SEC3.NM9.BT.val:=InitVal;
  BSTR.VACS.SEC3.NM10.BT.val:=InitVal;
  BSTR.VACS.SEC3.NM11.BT.val:=InitVal;
  BSTR.VACS.SEC3.NM12.BT.val:=InitVal;
  BSTR.VACS.SEC4.VP8.BT.val:=InitVal;
  BSTR.VACS.SEC4.VP9.BT.val:=InitVal;
  BSTR.VACS.SEC4.NG11.BT.val:=InitVal;
  BSTR.VACS.SEC4.NG12.BT.val:=InitVal;
  BSTR.VACS.SEC4.NG13.BT.val:=InitVal;
  BSTR.VACS.SEC4.NM13.BT.val:=InitVal;
  BSTR.VACS.SEC4.NM14.BT.val:=InitVal;
  BSTR.VACS.SEC4.NM15.BT.val:=InitVal;
  BSTR.VACS.SEC4.NM16.BT.val:=InitVal;
  BSTR.VACS.SEC5.VP10.BT.val:=InitVal;
  BSTR.VACS.SEC5.VP11.BT.val:=InitVal;
  BSTR.VACS.SEC5.NG14.BT.val:=InitVal;
  BSTR.VACS.SEC5.NG15.BT.val:=InitVal;
  BSTR.VACS.SEC5.NG16.BT.val:=InitVal;
  BSTR.VACS.SEC5.NG17.BT.val:=InitVal;
  BSTR.VACS.SEC5.NM17.BT.val:=InitVal;
  BSTR.VACS.SEC5.NM18.BT.val:=InitVal;
  BSTR.VACS.SEC5.NM19.BT.val:=InitVal;
  BSTR.VACS.SEC5.NM20.BT.val:=InitVal;
  BSTR.VACS.SEC6.VP12.BT.val:=InitVal;
  BSTR.VACS.SEC6.VP13.BT.val:=InitVal;
  BSTR.VACS.SEC6.NG18.BT.val:=InitVal;
  BSTR.VACS.SEC6.NG19.BT.val:=InitVal;
  BSTR.VACS.SEC6.NG20.BT.val:=InitVal;
  BSTR.VACS.SEC6.NM21.BT.val:=InitVal;
  BSTR.VACS.SEC6.NM22.BT.val:=InitVal;
  BSTR.VACS.SEC6.NM23.BT.val:=InitVal;
  BSTR.VACS.SEC6.NM24.BT.val:=InitVal;
  BSTR.VACS.ECOL.VP7.BT.val:=InitVal;
  BSTR.VACS.SEC1.PS1.MBAR.val:=InitVal;
  BSTR.VACS.SEC2.PS2.MBAR.val:=InitVal;
  BSTR.VACS.SEC3.PS3.MBAR.val:=InitVal;
  BSTR.VACS.SEC4.PS4.MBAR.val:=InitVal;
  BSTR.VACS.SEC5.PS5.MBAR.val:=InitVal;
  BSTR.VACS.SEC6.PS6.MBAR.val:=InitVal;
  BSTR.VACS.SEC1.NORMPS.val:=InitVal;
  BSTR.VACS.SEC2.NORMPS.val:=InitVal;
  BSTR.VACS.SEC3.NORMPS.val:=InitVal;
  BSTR.VACS.SEC4.NORMPS.val:=InitVal;
  BSTR.VACS.SEC5.NORMPS.val:=InitVal;
  BSTR.VACS.SEC6.NORMPS.val:=InitVal;
  BSTR.VACS.SEC1.WARNPS.val:=InitVal;
  BSTR.VACS.SEC2.WARNPS.val:=InitVal;
  BSTR.VACS.SEC3.WARNPS.val:=InitVal;
  BSTR.VACS.SEC4.WARNPS.val:=InitVal;
  BSTR.VACS.SEC5.WARNPS.val:=InitVal;
  BSTR.VACS.SEC6.WARNPS.val:=InitVal;
  BSTR.VACS.SEC1.FAILPS.val:=InitVal;
  BSTR.VACS.SEC2.FAILPS.val:=InitVal;
  BSTR.VACS.SEC3.FAILPS.val:=InitVal;
  BSTR.VACS.SEC4.FAILPS.val:=InitVal;
  BSTR.VACS.SEC5.FAILPS.val:=InitVal;
  BSTR.VACS.SEC6.FAILPS.val:=InitVal;
 end;
 {
 Update DIM services
 }
 procedure DimUpdateState;
 begin
  if DIM_IsServerMode then begin
   // Enforce update each 10 sec
   if SysTimer_Pulse(10000)>0 then VACS_FillTags(-MaxReal);
   if ShouldRefresh(BSTR.VACS.SEC1.VP1.BT.val,GetStampOfTag(BSTR.VACS.SEC1.VP1.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC1.VP2.BT.val,GetStampOfTag(BSTR.VACS.SEC1.VP2.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC1.NG1.BT.val,GetStampOfTag(BSTR.VACS.SEC1.NG1.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC1.NG2.BT.val,GetStampOfTag(BSTR.VACS.SEC1.NG2.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC1.NG3.BT.val,GetStampOfTag(BSTR.VACS.SEC1.NG3.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC1.NM1.BT.val,GetStampOfTag(BSTR.VACS.SEC1.NM1.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC1.NM2.BT.val,GetStampOfTag(BSTR.VACS.SEC1.NM2.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC1.NM3.BT.val,GetStampOfTag(BSTR.VACS.SEC1.NM3.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC1.NM4.BT.val,GetStampOfTag(BSTR.VACS.SEC1.NM4.BT.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC1.VP1.BT.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC2.VP3.BT.val,GetStampOfTag(BSTR.VACS.SEC2.VP3.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.VP4.BT.val,GetStampOfTag(BSTR.VACS.SEC2.VP4.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.NG4.BT.val,GetStampOfTag(BSTR.VACS.SEC2.NG4.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.NG5.BT.val,GetStampOfTag(BSTR.VACS.SEC2.NG5.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.NG6.BT.val,GetStampOfTag(BSTR.VACS.SEC2.NG6.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.NG7.BT.val,GetStampOfTag(BSTR.VACS.SEC2.NG7.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.NM5.BT.val,GetStampOfTag(BSTR.VACS.SEC2.NM5.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.NM6.BT.val,GetStampOfTag(BSTR.VACS.SEC2.NM6.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.NM7.BT.val,GetStampOfTag(BSTR.VACS.SEC2.NM7.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.NM8.BT.val,GetStampOfTag(BSTR.VACS.SEC2.NM8.BT.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC2.VP3.BT.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC3.VP5.BT.val,GetStampOfTag(BSTR.VACS.SEC3.VP5.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.VP6.BT.val,GetStampOfTag(BSTR.VACS.SEC3.VP6.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.NG8.BT.val,GetStampOfTag(BSTR.VACS.SEC3.NG8.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.NG9.BT.val,GetStampOfTag(BSTR.VACS.SEC3.NG9.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.NG10.BT.val,GetStampOfTag(BSTR.VACS.SEC3.NG10.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.NM9.BT.val,GetStampOfTag(BSTR.VACS.SEC3.NM9.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.NM10.BT.val,GetStampOfTag(BSTR.VACS.SEC3.NM10.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.NM11.BT.val,GetStampOfTag(BSTR.VACS.SEC3.NM11.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.NM12.BT.val,GetStampOfTag(BSTR.VACS.SEC3.NM12.BT.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC3.VP5.BT.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC4.VP8.BT.val, GetStampOfTag(BSTR.VACS.SEC4.VP8.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.VP9.BT.val, GetStampOfTag(BSTR.VACS.SEC4.VP9.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.NG11.BT.val,GetStampOfTag(BSTR.VACS.SEC4.NG11.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.NG12.BT.val,GetStampOfTag(BSTR.VACS.SEC4.NG12.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.NG13.BT.val,GetStampOfTag(BSTR.VACS.SEC4.NG13.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.NM13.BT.val,GetStampOfTag(BSTR.VACS.SEC4.NM13.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.NM14.BT.val,GetStampOfTag(BSTR.VACS.SEC4.NM14.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.NM15.BT.val,GetStampOfTag(BSTR.VACS.SEC4.NM15.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.NM16.BT.val,GetStampOfTag(BSTR.VACS.SEC4.NM16.BT.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC4.VP8.BT.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC5.VP10.BT.val,GetStampOfTag(BSTR.VACS.SEC5.VP10.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.VP11.BT.val,GetStampOfTag(BSTR.VACS.SEC5.VP11.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.NG14.BT.val,GetStampOfTag(BSTR.VACS.SEC5.NG14.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.NG15.BT.val,GetStampOfTag(BSTR.VACS.SEC5.NG15.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.NG16.BT.val,GetStampOfTag(BSTR.VACS.SEC5.NG16.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.NG17.BT.val,GetStampOfTag(BSTR.VACS.SEC5.NG17.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.NM17.BT.val,GetStampOfTag(BSTR.VACS.SEC5.NM17.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.NM18.BT.val,GetStampOfTag(BSTR.VACS.SEC5.NM18.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.NM19.BT.val,GetStampOfTag(BSTR.VACS.SEC5.NM19.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.NM20.BT.val,GetStampOfTag(BSTR.VACS.SEC5.NM20.BT.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC5.VP10.BT.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC6.VP12.BT.val,GetStampOfTag(BSTR.VACS.SEC6.VP12.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.VP13.BT.val,GetStampOfTag(BSTR.VACS.SEC6.VP13.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.NG18.BT.val,GetStampOfTag(BSTR.VACS.SEC6.NG18.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.NG19.BT.val,GetStampOfTag(BSTR.VACS.SEC6.NG19.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.NG20.BT.val,GetStampOfTag(BSTR.VACS.SEC6.NG20.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.NM21.BT.val,GetStampOfTag(BSTR.VACS.SEC6.NM21.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.NM22.BT.val,GetStampOfTag(BSTR.VACS.SEC6.NM22.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.NM23.BT.val,GetStampOfTag(BSTR.VACS.SEC6.NM23.BT.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.NM24.BT.val,GetStampOfTag(BSTR.VACS.SEC6.NM24.BT.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC6.VP12.BT.tag,'');
   if ShouldRefresh(BSTR.VACS.ECOL.VP7.BT.val,GetStampOfTag(BSTR.VACS.ECOL.VP7.BT.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.ECOL.VP7.BT.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC1.PS1.MBAR.val,GetStampOfTag(BSTR.VACS.SEC1.PS1.MBAR.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC1.PS1.MBAR.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC2.PS2.MBAR.val,GetStampOfTag(BSTR.VACS.SEC2.PS2.MBAR.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC2.PS2.MBAR.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC3.PS3.MBAR.val,GetStampOfTag(BSTR.VACS.SEC3.PS3.MBAR.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC3.PS3.MBAR.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC4.PS4.MBAR.val,GetStampOfTag(BSTR.VACS.SEC4.PS4.MBAR.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC4.PS4.MBAR.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC5.PS5.MBAR.val,GetStampOfTag(BSTR.VACS.SEC5.PS5.MBAR.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC5.PS5.MBAR.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC6.PS6.MBAR.val,GetStampOfTag(BSTR.VACS.SEC6.PS6.MBAR.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC6.PS6.MBAR.tag,'');
   if ShouldRefresh(BSTR.VACS.CLOCK.val, GetStampOfTag(BSTR.VACS.CLOCK.tag, 0))>0 then DIM_UpdateTag(BSTR.VACS.CLOCK.tag,'');
   if ShouldRefresh(BSTR.VACS.SERVID.val,GetStampOfTag(BSTR.VACS.SERVID.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SERVID.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC1.NORMPS.val,GetStampOfTag(BSTR.VACS.SEC1.NORMPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.NORMPS.val,GetStampOfTag(BSTR.VACS.SEC2.NORMPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.NORMPS.val,GetStampOfTag(BSTR.VACS.SEC3.NORMPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.NORMPS.val,GetStampOfTag(BSTR.VACS.SEC4.NORMPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.NORMPS.val,GetStampOfTag(BSTR.VACS.SEC5.NORMPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.NORMPS.val,GetStampOfTag(BSTR.VACS.SEC6.NORMPS.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC1.NORMPS.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC1.WARNPS.val,GetStampOfTag(BSTR.VACS.SEC1.WARNPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.WARNPS.val,GetStampOfTag(BSTR.VACS.SEC2.WARNPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.WARNPS.val,GetStampOfTag(BSTR.VACS.SEC3.WARNPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.WARNPS.val,GetStampOfTag(BSTR.VACS.SEC4.WARNPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.WARNPS.val,GetStampOfTag(BSTR.VACS.SEC5.WARNPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.WARNPS.val,GetStampOfTag(BSTR.VACS.SEC6.WARNPS.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC1.WARNPS.tag,'');
   if ShouldRefresh(BSTR.VACS.SEC1.FAILPS.val,GetStampOfTag(BSTR.VACS.SEC1.FAILPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC2.FAILPS.val,GetStampOfTag(BSTR.VACS.SEC2.FAILPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC3.FAILPS.val,GetStampOfTag(BSTR.VACS.SEC3.FAILPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC4.FAILPS.val,GetStampOfTag(BSTR.VACS.SEC4.FAILPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC5.FAILPS.val,GetStampOfTag(BSTR.VACS.SEC5.FAILPS.tag,0))
     +ShouldRefresh(BSTR.VACS.SEC6.FAILPS.val,GetStampOfTag(BSTR.VACS.SEC6.FAILPS.tag,0))>0 then DIM_UpdateTag(BSTR.VACS.SEC1.FAILPS.tag,'');
  end;
 end;
 {
 Close/Open valves on vacuum section[num]
 }
 procedure set_sect_valve_state(num,bt_State:Integer);
 begin
  case num of
   1:
   begin
    SWITCH_BT(BSTR.VACS.SEC1.VP1.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC1.VP2.BT.tag,bt_State);
   end;
   2:
   begin
    SWITCH_BT(BSTR.VACS.SEC2.VP3.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC2.VP4.BT.tag,bt_State);
   end;
   3:
   begin
    SWITCH_BT(BSTR.VACS.SEC3.VP5.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC3.VP6.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.ECOL.VP7.BT.tag,bt_State);
   end;
   4:
   begin
    SWITCH_BT(BSTR.VACS.SEC4.VP8.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC4.VP9.BT.tag,bt_State);
   end;
   5:
   begin
    SWITCH_BT(BSTR.VACS.SEC5.VP10.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC5.VP11.BT.tag,bt_State);
   end;
   6:
   begin
    SWITCH_BT(BSTR.VACS.SEC6.VP12.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC6.VP13.BT.tag,bt_State);
   end;
  end;
 end;
 {
 Enable/Disable pumps on vacuum section[num]
 }
 procedure set_sect_pumps_state(num,bt_State:Integer);
 begin
  case num of
   1:
   begin
    SWITCH_BT(BSTR.VACS.SEC1.NG1.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC1.NG2.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC1.NG3.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC1.NM1.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC1.NM2.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC1.NM3.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC1.NM4.BT.tag,bt_State);
   end;
   2:
   begin
    SWITCH_BT(BSTR.VACS.SEC2.NG4.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC2.NG5.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC2.NG6.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC2.NG7.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC2.NM5.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC2.NM6.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC2.NM7.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC2.NM8.BT.tag,bt_State);
   end;
   3:
   begin
    SWITCH_BT(BSTR.VACS.SEC3.NG8.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC3.NG9.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC3.NG10.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC3.NM9.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC3.NM10.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC3.NM11.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC3.NM12.BT.tag,bt_State);
   end;
   4:
   begin
    SWITCH_BT(BSTR.VACS.SEC4.NG11.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC4.NG12.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC4.NG13.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC4.NM13.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC4.NM14.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC4.NM15.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC4.NM16.BT.tag,bt_State);
   end;
   5:
   begin
    SWITCH_BT(BSTR.VACS.SEC5.NG14.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC5.NG15.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC5.NG16.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC5.NG17.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC5.NM17.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC5.NM18.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC5.NM19.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC5.NM20.BT.tag,bt_State);
   end;
   6:
   begin
    SWITCH_BT(BSTR.VACS.SEC6.NG18.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC6.NG19.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC6.NG20.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC6.NM21.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC6.NM22.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC6.NM23.BT.tag,bt_State);
    SWITCH_BT(BSTR.VACS.SEC6.NM24.BT.tag,bt_State);
   end;
  end;
 end;
 {
 Check if section is pumping state
 }
 function IsSectPump(num:Integer):Boolean;
 var result:Boolean;
 begin
  result:=false;
  case num of
   1:
   begin
    if iGetTagBitState(BSTR.VACS.SEC1.NG1.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC1.NG2.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC1.NG3.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC1.NM1.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC1.NM2.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC1.NM3.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC1.NM4.BT.tag,0) then result:=true;
   end;
   2:
   begin
    if iGetTagBitState(BSTR.VACS.SEC2.NG4.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC2.NG5.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC2.NG6.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC2.NG7.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC2.NM5.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC2.NM6.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC2.NM7.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC2.NM8.BT.tag,0) then result:=true;
   end;
   3:
   begin
    if iGetTagBitState(BSTR.VACS.SEC3.NG8.BT.tag, 0) or
       iGetTagBitState(BSTR.VACS.SEC3.NG9.BT.tag, 0) or
       iGetTagBitState(BSTR.VACS.SEC3.NG10.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC3.NM9.BT.tag, 0) or
       iGetTagBitState(BSTR.VACS.SEC3.NM10.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC3.NM11.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC3.NM12.BT.tag,0) then result:=true;
   end;
   4:
   begin
    if iGetTagBitState(BSTR.VACS.SEC4.NG11.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC4.NG12.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC4.NG13.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC4.NM13.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC4.NM14.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC4.NM15.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC4.NM16.BT.tag,0) then result:=true;
   end;
   5:
   begin
    if iGetTagBitState(BSTR.VACS.SEC5.NG14.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC5.NG15.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC5.NG16.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC5.NG17.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC5.NM17.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC5.NM18.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC5.NM19.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC5.NM20.BT.tag,0) then result:=true;
   end;
   6:
   begin
    if iGetTagBitState(BSTR.VACS.SEC6.NG18.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC6.NG19.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC6.NG20.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC6.NM21.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC6.NM22.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC6.NM23.BT.tag,0) or
       iGetTagBitState(BSTR.VACS.SEC6.NM24.BT.tag,0) then result:=true;
   end;
  end;
  IsSectPump:=result;
 end;
 {
 Check if section is open state
 }
 function IsSectOpen(num:Integer):Boolean;
 var result:Boolean;
 begin
  result:=false;
  case num of
   1:
   begin
    if iGetTagBitState(BSTR.VACS.SEC1.VP1.BT.tag,0) and
       iGetTagBitState(BSTR.VACS.SEC1.VP2.BT.tag,0) then result:=true;
   end;
   2:
   begin
    if iGetTagBitState(BSTR.VACS.SEC2.VP3.BT.tag,0) and
       iGetTagBitState(BSTR.VACS.SEC2.VP4.BT.tag,0) then result:=true;
   end;
   3:
   begin
    if iGetTagBitState(BSTR.VACS.SEC3.VP5.BT.tag,0) and
       iGetTagBitState(BSTR.VACS.SEC3.VP6.BT.tag,0) then result:=true;
   end;
   4:
   begin
    if iGetTagBitState(BSTR.VACS.SEC4.VP8.BT.tag,0) and
       iGetTagBitState(BSTR.VACS.SEC4.VP9.BT.tag,0) then result:=true;
   end;
   5:
   begin
    if iGetTagBitState(BSTR.VACS.SEC5.VP10.BT.tag,0) and
       iGetTagBitState(BSTR.VACS.SEC5.VP11.BT.tag,0) then result:=true;
   end;
   6:
   begin
    if iGetTagBitState(BSTR.VACS.SEC6.VP12.BT.tag,0) and
       iGetTagBitState(BSTR.VACS.SEC6.VP13.BT.tag,0) then result:=true;
   end;
  end;
  IsSectOpen:=result;
 end;
