 {
 Основная управляющая программа для PK-01
 Modified: 2004-12-03 Filchagin S.V.
 }
program HRM_CTRL;
const
 sndClick      = 'НАЖАТО';
 sndError      = 'ОШИБКА';
 ExpUnits      = 60;
 crvClearList  = 'HRM.CAM';
 winDrawList   = 'КРИВАЯ_ТОК_КАМЕРЫ';
var
 b             : boolean;
 i             : integer;
 r             : real;
 Ok            : boolean; 
 errors        : integer;
 errorcode     : integer;
 tagGoBt       : integer;
 tagGoTime     : integer;
 tagExpFull    : integer;
 tagExpRest    : integer;
 tagSaveBt     : integer;
 tagClrBt      : integer;
 tagAmpBt      : integer;
 tagCrvBt      : integer;
 tagCalcBt     : integer;
 tagErrCnt     : integer;
 tagSaveN      : integer;
 tagWinCaption : integer;
 LastGO        : integer;
 goTime        : real;
 {
 Select window on sensor click
 }
 procedure ClickWinSelect(Sen,Win:string);
 var b:boolean;
 begin
  if clicksensor=Sen then begin
   b:=voice(sndClick);
   b:=winselect(Win);
  end;
 end;
 {
 Call device Action on sensor click
 }
 procedure ClickAction(Sen,Dev:string);
 var b:boolean;
 begin
  if clicksensor=Sen then begin
   b:=voice(sndClick);
   b:=action(Dev);
  end;
 end;
 {
 Tag xor with given mask on sensor click (bit inversion on sensor click)
 }
 procedure ClickBitXor(Sen:string; tag,XorMask:integer);
 var b:boolean;
 begin
  if clicksensor=Sen then begin
   b:=voice(sndClick);
   b:=isettag(tag,ixor(igettag(tag),XorMask));
  end;
 end;
 {
 Initialize and test tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 {
 Start actions
 }
 if runcount=1 then begin
  {
  Initialize & clear tags
  }
  errors:=0;
  errorcode:=registererr('HRM_CTRL.PAS');
  InitTag(tagGoBt,       'HRM.GO.BT',       1);
  InitTag(tagGoTime,     'HRM.GO.TIME',     2);
  InitTag(tagExpFull,    'HRM.EXP.FULL',    2);
  InitTag(tagExpRest,    'HRM.EXP.REST',    2);
  InitTag(tagClrBt,      'HRM.CLR.BT',      1);
  InitTag(tagAmpBt,      'HRM.AMP.BT',      1);
  InitTag(tagCrvBt,      'HRM.CRV.BT',      1);
  InitTag(tagCalcBt,     'HRM.CALC.BT',     1);
  InitTag(tagErrCnt,     'HRM.ERR.CNT',     2);
  InitTag(tagSaveBt,     'HRM.SAVE.BT',     1);
  InitTag(tagSaveN,      'HRM.SAVE.N',      1);
  InitTag(tagWinCaption, 'HRM.WIN.CAPTION', 3);
  b:=isettag(tagGoBt,0);
  b:=isettag(tagClrBt,0);
  b:=isettag(tagAmpBt,0);
  b:=isettag(tagCrvBt,0);
  b:=isettag(tagCalcBt,0);
  b:=isettag(tagSaveBt,0);
  b:=rsettag(tagExpRest,0);
  b:=rsettag(tagErrCnt,0);
  LastGO:=0;
  GoTime:=0;
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
  b:=rsettag(tagErrCnt,geterrcount(-2));
 end else
 {
 Stop actions
 }
 if isinf(runcount) then begin
  b:=isettag(tagGoBt,0);
  b:=isettag(tagClrBt,0);
  b:=isettag(tagAmpBt,0);
  b:=isettag(tagCrvBt,0);
  b:=isettag(tagCalcBt,0);
  b:=rsettag(tagExpRest,0);
  b:=isettag(tagSaveBt,0);
 end else
 {
 Main polling loop
 }
 if Ok then begin
  {
  Update error counter
  }
  b:=rsettag(tagErrCnt,geterrcount(-2));
  {
  Doit on GO click
  }
  if (LastGo=0) and (igettag(tagGoBt)<>LastGO) then begin
   goTime:=secnow;
   b:=rsettag(tagGoTime,time);
   b:=rsettag(tagExpRest,rgettag(tagExpFull));
   LastGO:=igettag(tagGoBt);
  end;
  {
  Doit when GO pressed
  }
  if igettag(tagGoBt)<>0 then begin 
   b:=rsettag(tagExpRest,rgettag(tagExpFull)-(secnow-goTime)/ExpUnits);
   if rgettag(tagExpRest) <= 0 then begin
    b:=isettag(tagGoBt,0);   
    b:=rsettag(tagExpRest,0);
    b:=voice(sndClick);
   end;
  end;
  {
  Clear data curves and reset goTime on CLEAR button click
  }
  if igettag(tagClrBt)<>0 then begin
   LastGO:=0;
   b:=rsettag(tagGoTime,0);
   b:=rsettag(tagExpRest,0);
   b:=isettag(tagClrBt,0);
   for i:=1 to wordcount(crvClearList) do b:=clearcurve('0,'+extractword(i,crvClearList));
   for i:=1 to wordcount(winDrawList) do b:=windraw(extractword(i,winDrawList));
  end;
  {
  On AMP button click show amplifier control window
  }
  if igettag(tagAmpBt)<>0 then begin
   b:=isettag(tagAmpBt,0);
   b:=winselect(sgettag(findtag(readini('AmpMainWinTag'))));
  end;
  {
  On CRV button click show curve window
  }
  if igettag(tagCrvBt)<>0 then begin
   b:=isettag(tagCrvBt,0);
   for i:=1 to wordcount(winDrawList) do b:=winselect(extractword(i,winDrawList));
  end;
  {
  On CALC button click show calculator window
  }
  if igettag(tagCalcBt)<>0 then begin
   b:=isettag(tagCalcBt,0);
   b:=winselect(sgettag(findtag(readini('CalcWinTag#1'))));
   b:=winselect(sgettag(findtag(readini('CalcWinTag#2'))));
   b:=winselect(sgettag(findtag(readini('CalcWinTag#3'))));
  end;
  {
  Handle sensors click
  }
  if (clickbutton=1)  then begin
   {
   Buttons with 0 bit inversion on click
   }
   ClickBitXor(nametag(tagGoBt),   clicktag, 1);
   ClickBitXor(nametag(tagClrBt),  clicktag, 1);
   ClickBitXor(nametag(tagAmpBt),  clicktag, 1);
   ClickBitXor(nametag(tagCrvBt),  clicktag, 1);
   ClickBitXor(nametag(tagCalcBt), clicktag, 1);
   ClickBitXor(nametag(tagSaveBt), clicktag, 1);
   {
   CLR & SAVE buttons disabled when GO button pressed
   }
   if igettag(tagGoBt)<>0 then begin
    if igettag(tagClrBt)<>0  then begin
     b:=voice(sndError);
     b:=isettag(tagClrBt,0);
    end;
    if igettag(tagSaveBt)<>0 then begin
     b:=voice(sndError);
     b:=isettag(tagSaveBt,0);
    end;
   end;
   {
   On SAVE button click, save number should be incremented
   }
   if (clicksensor=nametag(tagSaveBt)) and (igettag(clicktag)>0) then begin
    r:=devmsg('&'+nametag(tagSaveN)+' ConstValue='+str(igettag(tagSaveN)+1));
    b:=ssettag(tagWinCaption,'РАДИОМЕТРИЯ-'+str(igettag(tagSaveN)+1));
   end;
  end;
 end;
end.
