program FOR_CTRL;
const
 SndClick    = 'нажато';
var
 Ok          : boolean;
 errors      : integer;
 errorcode   : integer;
 b           : boolean;
 i           : integer;
 r           : real;
 tagCalcBt   : integer;
 tagSaveBt   : integer;
 tagSaveInd  : integer;
 tagClearBt  : integer;
 tagSionBt   : integer;
 tagSion     : integer;
 tagK        : integer;
 tagA        : integer;
 v           : real;
 fname          : string;
 fpath          : string;

 {
 Procedure to fix error
 }
 procedure errorfound;
 begin
  errors:=errors+1;
 end;
 {
 Procedure to initialize and test tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
 {
 Инициирует диалог-предупреждение
 }
 procedure Warning(msg:string);
 var b:boolean;
 begin
  if editstate=0 
  then msg:=edit('('+msg)+edit(')Warning')
  else b:=Echo(msg);
 end;
 {
 Инициирует диалог редактирования тега
 }
 procedure StartEditTag(tag:integer; Caption,Comment:string);
 var s:string;
 begin
  s:='';
  if typetag(tag)>0 then begin
   if editstate=0 then begin
    if typetag(tag)=1 then s:=str(igettag(tag)) else
    if typetag(tag)=2 then s:=str(rgettag(tag)) else
    if typetag(tag)=3 then s:=sgettag(tag) else s:='';
    if pos('?',edit('('+Caption)
              +edit(' '+Comment+'|'+s)
              +edit(')StringGridEdit EDIT-TAG-'+nametag(tag)))>0
    then Warning('Error starting "'+Comment+'"!');
   end else Warning('Could not edit "'+Comment+'" now!');
  end;
  s:='';
 end;
 {
 Анализирует редактирование тега.
 }
 procedure CheckEditTag(tag:integer; minval,maxval:real);
 var s,d:string; r:real; b:boolean;
 begin
  s:='';
  d:='';
  r:=0;
  if editstate=1 then
  if typetag(tag)>0 then begin
   s:=edit('?ans 0');
   if extractword(1,s)='EDIT-TAG-'+nametag(tag) then begin
    if extractword(2,s)='1' then begin
     s:=edit('?ans 1');
     d:=worddelims('|');
     s:=extractword(2,s);
     d:=worddelims(d);
     if typetag(tag)=1 then begin
      r:=eval(s);
      if (r<minval) or (r>maxval) then r:=_nan;
      if not isnan(r) then b:=isettag(tag,round(r));
     end;
     if typetag(tag)=2 then begin
      r:=eval(s);
      if (r<minval) or (r>maxval) then r:=_nan;
      if not isnan(r) then b:=rsettag(tag,r);
     end;
     if typetag(tag)=3 then b:=ssettag(tag,s);
    end;
    s:=edit('');
   end;
   if isnan(r) then Warning('Ошибка ввода!')
  end;
  s:='';
  d:='';
 end;
 {
 Calculate 
 }
 procedure CalcHandler;
 begin
  b:=rsettag(tagA,(rgettag(tagSion)*rgettag(tagK)));
 end;
 {
 Fill string with zeros like this one: LeadZeros('12',5)='00012'
 }
 procedure LeadZeros(var s:string; n:integer);
 begin
  while length(s)<n do s:='0'+s;
 end;
  {
  Save result to file and to console window too
  }
 procedure SaveHandler;
 const
  w1 = 20; 
  w2 = 4;
 var
  i     : integer;
  n     : integer;
  t     : real;
  fname : string;
  year  : string;
  month : string;
  day   : string;
  hour  : string;
  minut : string;
  sec   : string;
  Main  : integer;
 begin
  {
  Calculate current date/time
  }
  t:=msecnow;
  year:=str(ms2year(t));   LeadZeros(year,  4);
  month:=str(ms2month(t)); LeadZeros(month, 2);
  day:=str(ms2day(t));     LeadZeros(day,   2);
  hour:=str(ms2hour(t));   LeadZeros(hour,  2);
  minut:=str(ms2min(t));   LeadZeros(minut, 2);
  sec:=str(ms2sec(t));     LeadZeros(sec,   2);
  {
  Calculate file name 
  }
  fname:=paramstr('DAQDATAPATH')+'\'+year+month+day+'.HDT';
  b:=rsettag(tagSaveInd,rval(year+month+day));
  {
  Save result to file and to console window too
  }
  for n:=0 to 1 do begin
   if n>0 then fname:='';
   if fileexists(fname) then i:=append(fname) else i:=rewrite(fname);
   if i=0 then begin
    writeln('');
    writeln('**********************************************************************');
    writeln('Измерение активности газа проведен ',year,'.',month,'.',day,'-',hour,':',minut,':',sec);
    writeln('**********************************************************************');
    writeln('Кэффициент К       ',' ',str(rgettag(tagK))     :w1,
                 ' ',''                           :w2);
    writeln('S пика ион. камеры ',' ',str(rgettag(tagSion))  :w1,
                 ' ',''                           :w2);
    writeln('Активность         ',' ',str(rgettag(tagA))    :w1,
                 ' ',''                           :w2);
    writeln('**********************************************************************');
    writeln('');
    if ioresult<>0 then b:=fixerror(errorcode);
    {if rewrite('')<>0 then b:=fixerror(errorcode);}
   end else begin
    b:=fixerror(errorcode);
   end;
  end;
  year:='';
  month:='';
  day:='';
  hour:='';
  minut:='';
  sec:='';
  fname:='';
 end;
 {
 Clear all tags
 }
 procedure ClearHandler;
 begin
  b:=isettag(tagCalcBt,0);
  b:=isettag(tagSaveBt,0);
  b:=rsettag(tagSaveInd,0);
  b:=isettag(tagClearBt,0);
  b:=isettag(tagSionBt,0);
  b:=rsettag(tagSaveInd,0);
  b:=rsettag(tagSion,0);
  b:=rsettag(tagA,0);
 end;

begin
 {
 Start actions
 }
 if runcount=1 then begin
  fname:='';
  fpath:='';
  errors:=0;
  errorcode:=registererr('ERROR IN FOR_CTRL.PAS');
  {
  read & check tags
  }
  InitTag( tagCalcBt,   'FOR.CALC.BTN',  1);
  InitTag( tagSaveBt,   'FOR.SAVE.BTN',  1);
  InitTag( tagSaveInd,  'FOR.SAVE.IND',  2);
  InitTag( tagClearBt,  'FOR.CLEAR.BTN', 1);
  InitTag( tagSionBt,   'FOR.SION.BTN',  1);
  InitTag( tagK,        'FOR.K',         2);
  InitTag( tagSion,     'FOR.Sion',      2);
  InitTag( tagA,        'FOR.A',         2);
  {
  Read & check file path
  }
  fpath:=readini('KPath');
  fpath:=paramstr('DefaultPath '+fpath+' '+
                  paramstr('ExtractFilePath '+paramstr('DaqConfigFile')));
  fpath:=paramstr('FExpand '+fpath);
  if length(fpath)=0 then errorfound else
  if iand(getfattr(fpath),16)<>16 then errorfound;
  fname:=fpath+'\'+readini('KName');
  {
  Read file of ADC zeros
  }
  if reset(fname)=0 then begin
    readln(r);
    if ioresult=0
    then b:=rsettag(tagK,r)
    else b:=fixerror(errorcode);
   if reset('')<>0 then b:=fixerror(errorcode);
  end else b:=fixerror(errorcode);
  {
  Is it Ok?
  }
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
  ClearHandler;
 end else
 {
 Stop actions
 }
 if isinf(runcount) then begin
  fname:='';
  fpath:='';
  errors:=0;
  if errors<>0 then b:=fixerror(errorcode);
  ClearHandler;
 end else 
 {
 Main loop actions
 }
 if Ok then begin
  {
  Action on CALC click
  }
  if igettag(tagCalcBt)>0 then begin
   b:=isettag(tagCalcBt,0);
   CalcHandler;
   if fileexists(fname) then b:=fileerase(fname);
   if not fileexists(fname) then begin
    if rewrite(fname)=0 then begin
     writeln(rgettag(tagK));
     if ioresult<>0 then b:=fixerror(errorcode);
    end else b:=fixerror(errorcode);
    if rewrite('')<>0 then b:=fixerror(errorcode);
   end else b:=fixerror(errorcode);
  end;
  {
  Action on SAVE click
  }
  if igettag(tagSaveBt)>0 then begin
   b:=isettag(tagSaveBt,0);
   SaveHandler;
  end;
  {
  Action on CLEAR click
  }
  if igettag(tagClearBt)>0 then begin
   b:=isettag(tagClearBt,0);
   ClearHandler;
  end;
  {
  Обработка нажатий кнопок
  }
  if clickbutton=1 then begin
   if clicktag=tagK         then StartEditTag(tagK,     'Коэффициент',   nametag(tagK));
   if clicktag=tagSion      then StartEditTag(tagSion,  'Площадь пика',  nametag(tagSion));
  end;
  if editstate=1 then begin
   CheckEditTag(tagK,0,10000000000);
   CheckEditTag(tagSion,0,10000000000);
  end;
  if editstate=1 then b:=echo('Edit error! '+edit(''));
  if editstate=8 then b:=echo('Edit error! '+edit(''));
  {
  Click CALC,SAVE,CLEAR...
  }
  if (clicktag=tagCalcBt)
  or (clicktag=tagSaveBt)
  or (clicktag=tagClearBt)
  then begin
   b:=isettag(clicktag,ord(igettag(clicktag)=0));
   b:=voice(SndClick);
  end;
  {
  Запись результата вычисления интеграла по кнопке 
  }
  if clicktag=tagSionBt then begin
   if igettag(tagSionBt)>0 then v:=0 else v:=global('int_mean');
   b:=rsettag(tagSion,v);
   b:=isettag(clicktag,ord(igettag(clicktag)=0));
  end;
 end;
end.
