 {
 ***********************************************************************
 Daq Pascal application program PID.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Edit tag - Start edit tag dialog
|********************************************************
[]
 }
program PID;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 ai_pid_0 = 0;
 ao_pid_0 = 0;

type
 TTagRef = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 PID         : record            { All PID Data                     }
  CTRL       : record            { PID Control data                 }
   TARG      : TTagRef;          { Target value (setpoint)          }
   ENB       : TTagRef;          { Enable/Disable PID               }
  end;                           {                                  }
  PAR        : record            { PID Parameters                   }
   QMAX      : TTagRef;          { Maximum amplitude output signal  }
   QMIN      : TTagRef;          { Minimum amplitude output signal  }
   K         : TTagRef;          { Коэффициент усиления регулятора  }
   TI        : TTagRef;          { Постоянная времени интегрирования     }
   TD        : TTagRef;          { Постоянная времени дифференцирования  }
   H         : TTagRef;          { Период выборки                        }
   TT        : TTagRef;          { Цикл дискретизации регулятора         }
   N         : TTagRef;          { Постоянная фильтра дифф. составляющей }
  end;                           {                                  }
  MEAS       : record            { Измеряемые значения                   }
   CURR      : Real;             { Текущее значение выхода системы       }
   LAST      : Real;             { Последнее значение выхода системы     }
   SECL      : Real;             { Предпоследнее значение выхода системы }
   LASTU     : Real;             { Последнее значение выхода регулятора  }
  end;                           {                                  }
  PollPeriod : Real;             { Polling period                   }
  PidOut     : Real;             { PID Output value                 }
 end;                            {                                  }
 cmd_Edit    : Integer;          { Common commands:                 }
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Send command (cmd) to device (dev) on tag click.
 }
 procedure ClickTagDevSendCmd(tag:Integer; cmd,s:String);
 begin
  if Length(cmd)>0 then
  if ClickTag=tag then begin
   DevPostCmd(devMySelf,cmd+' '+s);
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var ClickCurve:Integer; s:String;
 begin
  s:='';
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle tag clicks...
     }
     if ClickTag<>0 then begin
      s:=mime_encode(SetFormUnderSensorLeftBottom(ClickParams('')));
      ClickBitXorLocal(PID.CTRL.ENB.tag,1);
      ClickTagDevSendCmd(PID.CTRL.TARG.tag, '@Edit CTRL.TARG', s);
      ClickTagDevSendCmd(PID.PAR.QMAX.tag,  '@Edit PAR.QMAX',  s);
      ClickTagDevSendCmd(PID.PAR.QMIN.tag,  '@Edit PAR.QMIN',  s);
      ClickTagDevSendCmd(PID.PAR.K.tag,     '@Edit PAR.K',     s);
      ClickTagDevSendCmd(PID.PAR.TI.tag,    '@Edit PAR.TI',    s);
      ClickTagDevSendCmd(PID.PAR.TD.tag,    '@Edit PAR.TD',    s);
      ClickTagDevSendCmd(PID.PAR.H.tag,     '@Edit PAR.H',     s);
      ClickTagDevSendCmd(PID.PAR.TT.tag,    '@Edit PAR.TT',    s);
     end;
     {
     Handle sensor clicks...
     }
     if IsSameText(ClickSensor,'HELP') then begin
      DevPostCmdLocal('@BrowseHelp');
      bNul(Voice(snd_Click));
     end;
     {
     Select Plot & Tab windows by curve...
     }
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     {
     Console commands: @url_encoded_sensor ...
     }
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   CheckEditTagUpdate(PID.CTRL.TARG.tag, MinInt, maxReal);
   CheckEditTagUpdate(PID.PAR.QMAX.tag,  MinInt, maxReal);
   CheckEditTagUpdate(PID.PAR.QMIN.tag,  MinInt, maxReal);
   CheckEditTagUpdate(PID.PAR.K.tag,     MinInt, maxReal);
   CheckEditTagUpdate(PID.PAR.TI.tag,    0,      maxReal);
   CheckEditTagUpdate(PID.PAR.TD.tag,    0,      maxReal);
   CheckEditTagUpdate(PID.PAR.H.tag,     0,      maxReal);
   CheckEditTagUpdate(PID.PAR.TT.tag,    0,      maxReal);
   {
   Warning, Information dialog completion.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Uncompleted edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  s:='';
 end;
 {
 Чтение аналоговых/дискретных входов
 }
 procedure ReadAiDiState;
  {
  Чтение аналоговых входов
  }
  procedure ReadAiState;
  var Crv:Integer;
  begin
   if NumAis<>0 then begin
    Crv:=RefAi(ai_pid_0);
    if IsRefCurve(Crv) then begin
     PID.MEAS.CURR:=crvGetLastY(Crv);
     PID.MEAS.LAST:=CrvY(Crv,(CrvLen(Crv)-1));
     PID.MEAS.SECL:=CrvY(Crv,(CrvLen(Crv)-2));
    end;
   end;
  end;
 begin
  ReadAiState;
 end;
 {
 Logical control
 }
 procedure LogicControl;
  //
  // Алгоритм работы ПИД регулятора
  //
  procedure PID_LogicCtrl;
  var CurErr,LastErr,SeclErr,U:Real; N,Crv1:Integer;
   //
   // Очистка значений
   //
   procedure Reset;
   begin
    U:=0;
    CurErr:=0;
    LastErr:=0;
    SeclErr:=0;
    PID.MEAS.LASTU:=0;
   end;
  begin
   if iGetTag(PID.CTRL.ENB.tag)>0 then begin
    if mSecNow>=PID.PollPeriod+rGetTag(PID.PAR.H.tag) then begin
     CurErr:=rGetTag(PID.CTRL.TARG.tag)-PID.MEAS.CURR;
     LastErr:=rGetTag(PID.CTRL.TARG.tag)-PID.MEAS.LAST;
     SeclErr:=rGetTag(PID.CTRL.TARG.tag)-PID.MEAS.SECL;
     if NumAos<>0 then begin
      Crv1:=RefAo(ao_pid_0);
      if IsRefCurve(Crv1) then PID.MEAS.LASTU:=CrvY(Crv1,(CrvLen(Crv1)));
     end;
     N:=iGetTag(PID.PAR.N.tag);
     U:=PID.MEAS.LASTU+rGetTag(PID.PAR.K.tag)*(LastErr-SeclErr)+(rGetTag(PID.PAR.TT.tag)/rGetTag(PID.PAR.TI.tag))*CurErr
     +(N*rGetTag(PID.PAR.TD.tag)/(rGetTag(PID.PAR.TD.tag)+N*rGetTag(PID.PAR.TT.tag)))*(CurErr-LastErr-(LastErr-SeclErr));
     if U<=rGetTag(PID.PAR.QMIN.tag) then begin
      PID.PidOut:=rGetTag(PID.PAR.QMIN.tag);
      Reset;
     end;
     if ((U<rGetTag(PID.PAR.QMAX.tag)) and (U>rGetTag(PID.PAR.QMIN.tag))) then begin
      PID.PidOut:=U;
      Reset;
     end;
     if U>=rGetTag(PID.PAR.QMAX.tag) then begin
      PID.PidOut:=rGetTag(PID.PAR.QMAX.tag);
      Reset;
     end;
     PID.PollPeriod:=mSecNow;
    end;
   end;
  end;
 begin
  PID_LogicCtrl;
 end;
 {
 Запись аналоговых/дискретных выходов
 }
 procedure WriteAoDoState;
  {
  Запись аналоговых выходов
  }
  procedure WriteAoState;
  begin
   UpdateAo(ao_pid_0,time,PID.PidOut);
  end;
 begin
  WriteAoState;
 end;
 {
 Tags initialization
 }
 procedure Init_PID(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   InitTag(PID.CTRL.ENB.tag,  Prefix+'.CTRL.ENB',  1);
   InitTag(PID.CTRL.TARG.tag, Prefix+'.CTRL.TARG', 2);
   InitTag(PID.PAR.QMAX.tag,  Prefix+'.PAR.QMAX',  2);
   InitTag(PID.PAR.QMIN.tag,  Prefix+'.PAR.QMIN',  2);
   InitTag(PID.PAR.K.tag,     Prefix+'.PAR.K',     2);
   InitTag(PID.PAR.TI.tag,    Prefix+'.PAR.TI',    2);
   InitTag(PID.PAR.TD.tag,    Prefix+'.PAR.TD',    2);
   InitTag(PID.PAR.H.tag,     Prefix+'.PAR.H',     2);
   InitTag(PID.PAR.TT.tag,    Prefix+'.PAR.TT',    2);
   InitTag(PID.PAR.N.tag,     Prefix+'.PAR.N',     1);
  end;
  {
  Initialization values
  }
  PID.PollPeriod:=mSecNow;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  Init_PID(ReadIni('tagPID'));
  cmd_Edit:=RegisterStdInCmd('@Edit','');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  ReadAiDiState;
  GUIHandler;
  LogicControl;
  WriteAoDoState;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,par:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  par:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   if (cmdid=cmd_Edit) then begin
    par:=mime_decode(ExtractWord(2,arg))+'@set StringGrid.Font Name:PT_Mono\Size:10\Color:Black\Style:[Bold]';
    if IsSameText(ExtractWord(1,arg),'CTRL.TARG') then StartEditTagEx(PID.CTRL.TARG.tag, 'Задайте целевое значение',                           par);
    if IsSameText(ExtractWord(1,arg),'PAR.QMAX')  then StartEditTagEx(PID.PAR.QMAX.tag,  'Задайте максимальное значение управляющего сигнала', par);
    if IsSameText(ExtractWord(1,arg),'PAR.QMIN')  then StartEditTagEx(PID.PAR.QMIN.tag,  'Задайте минимальное значение управляющего сигнала',  par);
    if IsSameText(ExtractWord(1,arg),'PAR.K')     then StartEditTagEx(PID.PAR.K.tag,     'Задайте коэффициент усиления регулятора',            par);
    if IsSameText(ExtractWord(1,arg),'PAR.TI')    then StartEditTagEx(PID.PAR.TI.tag,    'Задайте постоянную времени интегрирования',          par);
    if IsSameText(ExtractWord(1,arg),'PAR.TD')    then StartEditTagEx(PID.PAR.TD.tag,    'Задайте постоянную времени дифференцирования',       par);
    if IsSameText(ExtractWord(1,arg),'PAR.H')     then StartEditTagEx(PID.PAR.H.tag,     'Задайте период выборки',                             par);
    if IsSameText(ExtractWord(1,arg),'PAR.TT')    then StartEditTagEx(PID.PAR.TT.tag,    'Задайте цикл дискретизации регулятора',              par);
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
  par:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
