@echo off
SetLocal EnableExtensions EnableDelayedExpansion

chcp 65001 > nul & rem Set CodePage UTF8

rem ***************************
rem Demo Paint config generator
rem ***************************

:Main
echo Enter windows number: 
set /P nums=
echo %nums%
call :InitializeVariables
pushd "%~dp0" && call :DemoPaint
popd
goto :EOF

:InitializeVariables
set cfgFile=demopaint.cfg
set crcFile=demopaint.crc
set pasFile=demopaint.pas
set /a X=0
set /a Y=0
set /a X_LIM=1200
set /a Y_LIM=250
set /a Y_MAX=250
set /a X_STEP=25
set /a ALARM1=10
set /a ALARM2=90
set /a ALARM_STEP=10
goto :EOF

:DemoPaint
call :genConf %nums% > %cfgFile%
call :genCirc %nums% > %crcFile%
goto :EOF

:genConf
call :commonf
echo.
for /L %%n in (1,1,%1) do call :cronsrv %%n
echo.
for /L %%n in (1,1,%1) do call :taglist %%n
echo.
for /L %%n in (1,1,%1) do call :windows %%n
echo.
for /L %%n in (1,1,%1) do call :devices %%n
goto :EOF

:genCirc
call :commonr
echo.
for /L %%n in (1,1,%1) do call :scripts %%n
echo.
call :sensors %%n
goto :EOF

:commonf
echo [DAQ]
echo HelpFile = .\DemoPaint.htm
echo DataPath = .\
echo []
echo.
echo [ConfigFileList] ; Default DAQ settings
echo ConfigFile = ~~\Resource\DaqSite\Default\DAQ.cfg
echo ConfigFile = ~~\Resource\DaqSite\Default\Integrity.cfg
echo []
echo [ConfigFileList] ; General Purpose Servers
echo ConfigFile = ~~\Resource\DaqSite\Default\CronSrv.cfg
echo []
goto :EOF
:cronsrv
echo [^&CronSrv.StartupScript]
echo @WinShow DemoPaint%1
echo @WinDraw DemoPaint%1^|Left=%X%^|Top=%Y%^|Width=600^|Height=300
echo @WinDraw DemoPaint%1^|Options=-Min,-Max,-Close,-VScroll,-HScroll,+StatusBar
echo @WinDraw DemoPaint%1^|Options=+Top,+Left,-Width,-Height
echo @WinSelect DemoPaint%1
echo []
set /a Y+=X_STEP
if %Y% EQU %Y_LIM% (
set /a X+=600
set /a Y-=Y_MAX
)
if %X% GTR %X_LIM% (
set /a X=0
set /a Y+=Y_MAX
set /a Y_LIM+=Y_MAX
)
goto :EOF
:taglist
echo [TagList]
echo %1.Alarm1  = real %ALARM1%
echo %1.Alarm2  = real %ALARM2%
echo %1.Signal1 = real 0
echo %1.Signal2 = real 0
echo %1.Signal3 = real 0
echo %1.Signal4 = real 0
echo %1.Signal5 = real 0
echo %1.Signal6 = real 0
echo %1.Signal7 = real 0
echo %1.Signal8 = real 0
echo []
set /a ALARM1+=ALARM_STEP
set /a ALARM2-=ALARM_STEP
if %ALARM1% GEQ %ALARM2% (
set /a ALARM1=5
set /a ALARM2=95
set /a ALARM_STEP=5
)
goto :EOF
:windows
echo [Windows]
echo Circuit%1 = Circuit_Window
echo [Circuit%1]
echo Name = DemoPaint%1                         ; Set window name
echo Hint = DemoPaint%1 - демонстрация рисования программируемых сенсоров
echo Circuit = .\DemoPaint.crc
echo Link sensor Help   with               device ^&DemoPaint%1
echo Link sensor Alarm1 with tag %1.Alarm1  device ^&DemoPaint%1
echo Link sensor Alarm2 with tag %1.Alarm2  device ^&DemoPaint%1
echo Link sensor Led1   with tag %1.Signal1 device ^&DemoPaint%1
echo Link sensor Bar1   with tag %1.Signal1 device ^&DemoPaint%1
echo Link sensor Led2   with tag %1.Signal2 device ^&DemoPaint%1
echo Link sensor Bar2   with tag %1.Signal2 device ^&DemoPaint%1
echo Link sensor Led3   with tag %1.Signal3 device ^&DemoPaint%1
echo Link sensor Bar3   with tag %1.Signal3 device ^&DemoPaint%1
echo Link sensor Led4   with tag %1.Signal4 device ^&DemoPaint%1
echo Link sensor Bar4   with tag %1.Signal4 device ^&DemoPaint%1
echo Link sensor Led5   with tag %1.Signal5 device ^&DemoPaint%1
echo Link sensor Bar5   with tag %1.Signal5 device ^&DemoPaint%1
echo Link sensor Led6   with tag %1.Signal6 device ^&DemoPaint%1
echo Link sensor Bar6   with tag %1.Signal6 device ^&DemoPaint%1
echo Link sensor Led7   with tag %1.Signal7 device ^&DemoPaint%1
echo Link sensor Bar7   with tag %1.Signal7 device ^&DemoPaint%1
echo Link sensor Led8   with tag %1.Signal8 device ^&DemoPaint%1
echo Link sensor Bar8   with tag %1.Signal8 device ^&DemoPaint%1
echo []
goto :EOF
:devices
echo [DeviceList]
echo ^&DemoPaint%1 = device software program
echo [^&DemoPaint%1]
echo DebugFlags  = 3
echo OpenConsole = 1
echo ProgramSource = .\DemoPaint.pas
echo tagPrefix = %1
echo []
goto :EOF

:commonr
echo [Circuit]
echo GeneralMap = .\DemoPaint.bmp             ; Set background picture
echo []
echo.
echo [ConfigFileList] ; Include standard GUI Library
echo ConfigFile = ~~\Resource\DaqSite\Default\Painter.crc
echo []
echo.
echo [LedFont]
echo CharSet = 204               ; Font charset, RUSSIAN_CHARSET=204
echo Color   = $000000           ; Font color, RGB
echo Height  = -13               ; Font height 10pt
echo Name    = PT Mono           ; Font family name
echo Pitch   = Fixed             ; Font width Default/Fixed/Variable
echo Style   = [Bold]            ; [Bold, Italic, Underline, StrikeOut]
echo []
echo.
echo [BigButtonFont]
echo CharSet = 204               ; Font charset, RUSSIAN_CHARSET=204
echo Color   = $000007           ; Font color, RGB
echo Height  = -27               ; Font height 20pt
echo Name    = PT Mono           ; Font family name
echo Pitch   = Fixed             ; Font width Default/Fixed/Variable
echo Style   = [Bold]            ; [Bold, Italic, Underline, StrikeOut]
echo []
goto :EOF
:scripts
echo [Circuit.StartupScript] ; Run on startup
echo alarm1=30               ; Set alarm1 level
echo alarm2=60               ; Set alarm2 level
echo setSimulation(0)        ; just for testing
echo []
goto :EOF
:sensors
echo [SensorList]
echo Sensor = Led1
echo [Led1]                                                     ; Display with variable background
echo Pos = 10, 10                                               ; Set sensor position
echo LED = 7, 0, 3, %%7.3f, [LedFont]                            ; Set display format
echo TagEval(v) = gt(v,alarm1)+gt(v,alarm2)                     ; Background depends on v
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07C.BMP  ; Background if v ^<= alarm1
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07Y.BMP  ; Background if alarm1 ^< v ^<= alarm2
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07R.BMP  ; Background if v ^> alarm2
echo Hint = Signal1
echo []
echo.
echo [SensorList]
echo Sensor = Bar1
echo [Bar1]                                                                            ; Sensor with script painting
echo Pos = 10 40                                                                       ; Set sensor position
echo Tag#1 = 0, BAR.BMP                                                                ; Set background picture
echo Painter(v) = [Bar1.Painter(v)]                                                    ; Set script to paint sensor
echo Hint = Signal1
echo []
echo [Bar1.Painter(v)]                                                                 ; Draw a line script
echo sw=sensorWidth()                                                                  ; Get sensor width
echo sh=sensorHeight()                                                                 ; Get sensor height
echo x1=2                                                                              ; Calculate coordinates of line
echo y1=sh-2-v*(sh-4)/100                                                              ;
echo x2=sw-2                                                                           ;
echo y2=y1                                                                             ;
echo color=clAqua*le(v,alarm1)+clYellow*gt(v,alarm1)*le(v,alarm2)+clRed*gt(v,alarm2)   ; Calculate color to draw
echo setPen(color,psSolid,pmCopy,4)+drawLine(x1,y1,x2,y2)                              ; Set pen style and draw a line
echo setBrush(clWhite,bsClear)                                                         ; Set brush style for text
echo fh=-round(1.33*16)                                                                ; Find height of font 16 pt
echo @font charset 204                                                                 ; Set font Charset Russian
echo @font style 1                                                                     ; Set font Style Bold
echo @font color %%clBlue                                                               ; Set font Color
echo @font height %%fh                                                                  ; Set font Height
echo @font name Courier New                                                            ; Set font Name
echo tw=@textwidth %%7.3f%%v                                                             ; Get text width
echo th=@textheight %%7.3f%%v                                                            ; Get text height
echo setCursor(sw/2-tw/2,max(5,min(y2+2-(th+4)*gt(y2,sh/2),sh-th-5)))                  ; Set text cursor
echo @print %%7.3f%%v                                                                    ; Print v value with format %%7.3f
echo []
echo.
echo [SensorList]
echo Sensor = Led2
echo [Led2]
echo Pos = 120, 10
echo LED = 7, 0, 3, %%7.3f, [LedFont]
echo TagEval(v) = gt(v,alarm1)+gt(v,alarm2)
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07C.BMP
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07Y.BMP
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07R.BMP
echo Hint = Signal2
echo []
echo.
echo [SensorList]
echo Sensor = Bar2
echo [Bar2]
echo Pos = 120 40
echo Tag#1 = 0, BAR.BMP
echo Painter(v) = [Bar2.Painter(v)]
echo Hint = Signal2
echo []
echo [Bar2.Painter(v)]
echo sw=sensorWidth()
echo sh=sensorHeight()
echo fi=pi*v/100
echo rd=0.5*(sw-4)
echo x1=sw/2
echo y1=sh-2
echo x2=sw/2-rd*cos(fi)
echo y2=sh-2-rd*sin(fi)
echo setPen(clBlue,psSolid,pmCopy,2)+setBrush(clDkGray,bsSolid)+drawEllipse(2,sh-2-rd,sw-2,sh-2+rd)
echo color=clAqua*le(v,alarm1)+clYellow*gt(v,alarm1)*le(v,alarm2)+clRed*gt(v,alarm2)
echo setPen(color,psSolid,pmCopy,4)+drawArrow(x1,y1,x2,y2,8,4)
echo []
echo.
echo [SensorList]
echo Sensor = Led3
echo [Led3]
echo Pos = 230, 10
echo LED = 7, 0, 3, %%7.3f, [LedFont]
echo TagEval(v) = gt(v,alarm1)+gt(v,alarm2)
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07C.BMP
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07Y.BMP
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07R.BMP
echo Hint = Signal3
echo []
echo.
echo [SensorList]
echo Sensor = Bar3
echo [Bar3]
echo Pos = 230 40
echo Tag#1 = 0, .\BAR.BMP
echo Painter(v) = [Bar3.Painter(v)]
echo LED = 7, 0, 3, %%7.3f, [LedFont]
echo Hint = Signal3
echo []
echo [Bar3.Painter(v)]
echo sw=sensorWidth()
echo sh=sensorHeight()
echo x1=2
echo y1=sh-2
echo x2=sw-2
echo y2=sh-2-v*(sh-4)/100
echo color=clAqua*le(v,alarm1)+clYellow*gt(v,alarm1)*le(v,alarm2)+clRed*gt(v,alarm2)
echo setPen(clLtGray,psSolid,pmCopy,1)+setBrush(color,bsSolid)+drawBar(x1,y1,x2,y2)
echo []
echo.
echo [SensorList]
echo Sensor = Led4
echo [Led4]
echo Pos = 340, 10
echo LED = 7, 0, 3, %%7.3f, [LedFont]
echo TagEval(v) = gt(v,alarm1)+gt(v,alarm2)
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07C.BMP
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07Y.BMP
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07R.BMP
echo Hint = Signal4
echo []
echo.
echo [SensorList]
echo Sensor = Bar4
echo [Bar4]
echo Pos = 340 40
echo Tag#1 = 0, BAR.BMP
echo Painter(v) = [Bar4.Painter(v)]
echo Hint = Signal4
echo []
echo [Bar4.Painter(v)]
echo sw=sensorWidth()
echo sh=sensorHeight()
echo fi=pi*v/100
echo rd=0.5*(sw-4)
echo x1=sw/2
echo y1=sh-2
echo x2=sw/2-rd*cos(fi)
echo y2=sh-2-rd*sin(fi)
echo setPen(clBlue,psSolid,pmCopy,2)+setBrush(clDkGray,bsSolid)+drawEllipse(2,sh-2-rd,sw-2,sh-2+rd)
echo color=clAqua*le(v,alarm1)+clYellow*gt(v,alarm1)*le(v,alarm2)+clRed*gt(v,alarm2)
echo setPen(color,psSolid,pmCopy,2)+setBrush(color,bsCross)+drawPie(2,sh-2-rd,sw-2,sh-2+rd,x2,y2,x1,y1)
echo []
echo.
echo [SensorList]
echo Sensor = Help
echo [Help]
echo Pos = 450 40
echo Tag#1 = 0, BAR.BMP, Help
echo LED = 0, 0, 0, *, [BigButtonFont]
echo Hint = Справка
echo []
echo.
echo [SensorList]
echo Sensor = Alarm1
echo [Alarm1]
echo Pos = 450, 120
echo LED = 7, 0, 3, %%7.3f, [LedFont]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07W.BMP
echo Hint = Alarm1 - значение порога "желтый"
echo []
echo.
echo [SensorList]
echo Sensor = Alarm2
echo [Alarm2]
echo Pos = 450, 150
echo LED = 7, 0, 3, %%7.3f, [LedFont]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07W.BMP
echo Hint = Alarm2 - значение порога "красный"
echo []
echo.
echo [SensorList]
echo Sensor = Led5
echo [Led5]                                                     ; Display with variable background
echo Pos = 10, 120                                               ; Set sensor position
echo LED = 7, 0, 3, %%7.3f, [LedFont]                            ; Set display format
echo TagEval(v) = gt(v,alarm1)+gt(v,alarm2)                     ; Background depends on v
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07C.BMP  ; Background if v ^<= alarm1
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07Y.BMP  ; Background if alarm1 ^< v ^<= alarm2
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07R.BMP  ; Background if v ^> alarm2
echo Hint = Signal5
echo []
echo.
echo [SensorList]
echo Sensor = Bar5
echo [Bar5]                                                                            ; Sensor with script painting
echo Pos = 10 150                                                                       ; Set sensor position
echo Tag#1 = 0, BAR.BMP                                                                ; Set background picture
echo Painter(v) = [Bar1.Painter(v)]                                                    ; Set script to paint sensor
echo Hint = Signal5
echo []
echo [Bar5.Painter(v)]                                                                 ; Draw a line script
echo sw=sensorWidth()                                                                  ; Get sensor width
echo sh=sensorHeight()                                                                 ; Get sensor height
echo x1=2                                                                              ; Calculate coordinates of line
echo y1=sh-2-v*(sh-4)/100                                                              ;
echo x2=sw-2                                                                           ;
echo y2=y1                                                                             ;
echo color=clAqua*le(v,alarm1)+clYellow*gt(v,alarm1)*le(v,alarm2)+clRed*gt(v,alarm2)   ; Calculate color to draw
echo setPen(color,psSolid,pmCopy,4)+drawLine(x1,y1,x2,y2)                              ; Set pen style and draw a line
echo setBrush(clWhite,bsClear)                                                         ; Set brush style for text
echo fh=-round(1.33*16)                                                                ; Find height of font 16 pt
echo @font charset 204                                                                 ; Set font Charset Russian
echo @font style 1                                                                     ; Set font Style Bold
echo @font color %%clBlue                                                               ; Set font Color
echo @font height %%fh                                                                  ; Set font Height
echo @font name Courier New                                                            ; Set font Name
echo tw=@textwidth %%7.3f%%v                                                             ; Get text width
echo th=@textheight %%7.3f%%v                                                            ; Get text height
echo setCursor(sw/2-tw/2,max(5,min(y2+2-(th+4)*gt(y2,sh/2),sh-th-5)))                  ; Set text cursor
echo @print %%7.3f%%v                                                                    ; Print v value with format %%7.3f
echo []
echo.
echo [SensorList]
echo Sensor = Led6
echo [Led6]
echo Pos = 120, 120
echo LED = 7, 0, 3, %%7.3f, [LedFont]
echo TagEval(v) = gt(v,alarm1)+gt(v,alarm2)
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07C.BMP
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07Y.BMP
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07R.BMP
echo Hint = Signal6
echo []
echo.
echo [SensorList]
echo Sensor = Bar6
echo [Bar6]
echo Pos = 120 150
echo Tag#1 = 0, BAR.BMP
echo Painter(v) = [Bar6.Painter(v)]
echo Hint = Signal6
echo []
echo [Bar6.Painter(v)]
echo sw=sensorWidth()
echo sh=sensorHeight()
echo fi=pi*v/100
echo rd=0.5*(sw-4)
echo x1=sw/2
echo y1=sh-2
echo x2=sw/2-rd*cos(fi)
echo y2=sh-2-rd*sin(fi)
echo setPen(clBlue,psSolid,pmCopy,2)+setBrush(clDkGray,bsSolid)+drawEllipse(2,sh-2-rd,sw-2,sh-2+rd)
echo color=clAqua*le(v,alarm1)+clYellow*gt(v,alarm1)*le(v,alarm2)+clRed*gt(v,alarm2)
echo setPen(color,psSolid,pmCopy,4)+drawArrow(x1,y1,x2,y2,8,4)
echo []
echo.
echo [SensorList]
echo Sensor = Led7
echo [Led7]
echo Pos = 230, 120
echo LED = 7, 0, 3, %%7.3f, [LedFont]
echo TagEval(v) = gt(v,alarm1)+gt(v,alarm2)
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07C.BMP
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07Y.BMP
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07R.BMP
echo Hint = Signal7
echo []
echo.
echo [SensorList]
echo Sensor = Bar7
echo [Bar7]
echo Pos = 230 150
echo Tag#1 = 0, .\BAR.BMP
echo Painter(v) = [Bar7.Painter(v)]
echo LED = 7, 0, 3, %%7.3f, [LedFont]
echo Hint = Signal7
echo []
echo [Bar7.Painter(v)]
echo sw=sensorWidth()
echo sh=sensorHeight()
echo x1=2
echo y1=sh-2
echo x2=sw-2
echo y2=sh-2-v*(sh-4)/100
echo color=clAqua*le(v,alarm1)+clYellow*gt(v,alarm1)*le(v,alarm2)+clRed*gt(v,alarm2)
echo setPen(clLtGray,psSolid,pmCopy,1)+setBrush(color,bsSolid)+drawBar(x1,y1,x2,y2)
echo []
echo.
echo [SensorList]
echo Sensor = Led8
echo [Led8]
echo Pos = 340, 120
echo LED = 7, 0, 3, %%7.3f, [LedFont]
echo TagEval(v) = gt(v,alarm1)+gt(v,alarm2)
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07C.BMP
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07Y.BMP
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\_LED07R.BMP
echo Hint = Signal8
echo []
echo.
echo [SensorList]
echo Sensor = Bar8
echo [Bar8]
echo Pos = 340 150
echo Tag#1 = 0, BAR.BMP
echo Painter(v) = [Bar8.Painter(v)]
echo Hint = Signal8
echo []
echo [Bar8.Painter(v)]
echo sw=sensorWidth()
echo sh=sensorHeight()
echo fi=pi*v/100
echo rd=0.5*(sw-4)
echo x1=sw/2
echo y1=sh-2
echo x2=sw/2-rd*cos(fi)
echo y2=sh-2-rd*sin(fi)
echo setPen(clBlue,psSolid,pmCopy,2)+setBrush(clDkGray,bsSolid)+drawEllipse(2,sh-2-rd,sw-2,sh-2+rd)
echo color=clAqua*le(v,alarm1)+clYellow*gt(v,alarm1)*le(v,alarm2)+clRed*gt(v,alarm2)
echo setPen(color,psSolid,pmCopy,2)+setBrush(color,bsCross)+drawPie(2,sh-2-rd,sw-2,sh-2+rd,x2,y2,x1,y1)
echo []
goto :EOF
