 {
 ***********************************************************************
 Daq Pascal application program DemoGuiLib.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @spam n - spam-test loop to estimate WinDraw performance
|********************************************************
[]
 }
program DemoGuiLib;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 tagButton1       : Integer;     { Button tag                       }
 tagRadioBtn1     : Integer;     { Radio Button 1 tag               }
 tagRadioBtn2     : Integer;     { Radio Button 2 tag               }
 tagCheckBox1     : Integer;     { CheckBox 1 tag                   }
 tagCheckBox2     : Integer;     { CheckBox 2 tag                   }
 tagProgressBar   : Integer;     { ProgressBar tag                  }
 tagClickWhat     : Integer;     { ClickWhat tag                    }
 tagClickWhereX   : Integer;     { ClickWhereX tag                  }
 tagClickWhereY   : Integer;     { ClickWhereY tag                  }
 cmdHelp          : Integer;     { Open Help                        }
 cmdHome          : Integer;     { Exec Home                        }
 cmdOpen          : Integer;     { Open DAT file(s)                 }
 cmdSave          : Integer;     { Save DAT file(s)                 }
 cmdLoadini       : Integer;     { Load INI file                    }
 cmdSaveini       : Integer;     { Save INI file                    }
 cmdNavigator     : Integer;     { Show Daq main window             }
 cmdTools         : Integer;     { Tools menu                       }
 cmdSound         : Integer;     { Sound menu                       }
 cmdSmile         : Integer;     { Smile menu                       }
 cmdClose         : Integer;     { Close DAQ/CRW/WIN                }
 cmdLoupe         : Integer;     { Loupe button                     }
 cmdFavorite      : Integer;     { Favorite button                  }
 cmdLock          : Integer;     { Lock button                      }
 cmdKey           : Integer;     { Key button                       }
 cmdCalculator    : Integer;     { Calculator button                }
 cmdErase         : Integer;     { Erase button                     }
 cmdSetting       : Integer;     { Setting button                   }
 cmdConsole       : Integer;     { Console button                   }
 cmdFlash         : Integer;     { Flash button                     }
 cmdFlashAlt      : Integer;     { FlashAlt button                  }
 cmdLightning     : Integer;     { Lightning button                 }
 cmdLightningAlt  : Integer;     { LightningAlt button              }
 cmdSnowflake     : Integer;     { Snowflake button                 }
 cmd_Spam         : Integer;     { Spam test StdIn command          }
 tagIndCircle     : Integer;     { Circle indicator                 }
 tagCross         : Integer;     { Cross button                     }
 valButton1       : Real;        { Button1 value                    }
 valCross         : Real;        { Cross   value                    }
 spamLoop         : Integer;     { Spam test loop                   }
 spamRate         : Integer;     { Spam rate counter                }
 tagWheelTestFlag : Integer;     { Wheel Test flag                  }
 tagWheelTestData : Integer;     { Wheel Test data                  }
 tagListBoxButton : Integer;     { List box button                  }
 CancelButton     : Integer;     { Cancel button                    }
 OkButton         : Integer;     { Ok button                        }
 cmdMenu          : Integer;     { Menu                             }
 cmdOptions       : Integer;     { Options                          }
 cmdArrowCircCW   : Integer;     { ArrowCircCW                      }
 cmdArrowCircCCW  : Integer;     { ArrowCircCCW                     }
 cmdArrowCW       : Integer;     { ArrowCW                          }
 cmdArrowCCW      : Integer;     { ArrowCCW                         }
 cmdArrowUp       : Integer;     { cmdArrowUp                       }
 cmdArrowDown     : Integer;     { cmdArrowDown                     }
 cmdArrowLeft     : Integer;     { cmdArrowLeft                     }
 cmdArrowRight    : Integer;     { cmdArrowRight                    }
 cmdPowerOn       : Integer;     { cmdPowerOn                       }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Xor bit on click (local version).
 }
 procedure ClickTagXorLocal(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  spamLoop:=0;
  spamRate:=0;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  cmd_Spam:=RegisterStdInCmd('@spam','');
  InitTag(tagButton1,       'Button1',         1);
  InitTag(tagRadioBtn1,     'RadioBtn1',       1);
  InitTag(tagRadioBtn2,     'RadioBtn2',       1);
  InitTag(tagCheckBox1,     'CheckBox1',       1);
  InitTag(tagCheckBox2,     'CheckBox2',       1);
  InitTag(cmdHelp,          'cmdHelp',         1);
  InitTag(cmdHome,          'cmdHome',         1);
  InitTag(cmdOpen,          'cmdOpen',         1);
  InitTag(cmdSave,          'cmdSave',         1);
  InitTag(cmdLoadini,       'cmdLoadini',      1);
  InitTag(cmdSaveini,       'cmdSaveini',      1);
  InitTag(cmdNavigator,     'cmdNavigator',    1);
  InitTag(cmdTools,         'cmdTools',        1);
  InitTag(cmdSound,         'cmdSound',        1);
  InitTag(cmdSmile,         'cmdSmile',        1);
  InitTag(cmdClose,         'cmdClose',        1);
  InitTag(cmdLoupe,         'cmdLoupe',        1);
  InitTag(cmdFavorite,      'cmdFavorite',     1);
  InitTag(cmdLock,          'cmdLock',         1);
  InitTag(cmdKey,           'cmdKey',          1);
  InitTag(cmdCalculator,    'cmdCalculator',   1);
  InitTag(cmdErase,         'cmdErase',        1);
  InitTag(cmdSetting,       'cmdSetting',      1);
  InitTag(cmdConsole,       'cmdConsole',      1);
  InitTag(cmdFlash,         'cmdFlash',        1);
  InitTag(cmdFlashAlt,      'cmdFlashAlt',     1);
  InitTag(cmdLightning,     'cmdLightning',    1);
  InitTag(cmdLightningAlt,  'cmdLightningAlt', 1);
  InitTag(cmdSnowflake,     'cmdSnowflake',    1);
  InitTag(tagProgressBar,   'ProgressBar',     2);
  InitTag(tagClickWhat,     'ClickWhat',       3);
  InitTag(tagClickWhereX,   'ClickWhereX',     1);
  InitTag(tagClickWhereY,   'ClickWhereY',     1);
  InitTag(tagIndCircle,     'IndCircle',       1);
  InitTag(tagCross,         'Cross',           1);
  InitTag(tagWheelTestFlag, 'WheelTestFlag',   1);
  InitTag(tagWheelTestData, 'WheelTestData',   2);
  InitTag(tagListBoxButton, 'ListBoxButton',   1);
  InitTag(CancelButton,     'CancelButton',    1);
  InitTag(OkButton,         'OkButton',        1);
  InitTag(cmdMenu,          'cmdMenu',         1);
  InitTag(cmdOptions,       'cmdOptions',      1);
  InitTag(cmdArrowCircCW,   'cmdArrowCircCW',  1);
  InitTag(cmdArrowCircCCW,  'cmdArrowCircCCW', 1);
  InitTag(cmdArrowCW,       'cmdArrowCW',      1);
  InitTag(cmdArrowCCW,      'cmdArrowCCW',     1);
  InitTag(cmdArrowUp,       'cmdArrowUp',      1);
  InitTag(cmdArrowDown,     'cmdArrowDown',    1);
  InitTag(cmdArrowLeft,     'cmdArrowLeft',    1);
  InitTag(cmdArrowRight,    'cmdArrowRight',   1);
  InitTag(cmdPowerOn,       'cmdPowerOn',      1);
  valButton1:=MaxReal;
  valCross:=MaxReal;
  bNul(iSetTag(tagRadioBtn1,0));
  bNul(iSetTag(tagRadioBtn2,0));
  iNul(ClickFilter(ClickFilter(1))); // Reset to defaults
  iNul(ClickAwaker(ClickAwaker(1))); // Reset to defaults
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 ListBox menu start editing.
 }
 procedure ListBoxStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('List box example');
   n:=n+EditAddInputLn('Make your choice:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Choice 1');
   n:=n+EditAddInputLn('Choice 2');
   n:=n+EditAddInputLn('Choice 3');
   n:=n+EditAddInputLn('Choice 4');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('LIST_BOX'),Str(iGetTag(tagListBoxButton)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 var i:Integer; t,v1:Real;
 begin
  {
  Spam test
  }
  if spamLoop>0 then begin
   for i:=1 to spamLoop do begin
    //if iGetTag(tagButton1)=0 then bNul(WinDraw('Demo_GuiLib|Fast|Eval=(Border2Color=clRed) ')) else
    //if iGetTag(tagButton1)=1 then bNul(WinDraw('Demo_GuiLib|Fast|Eval=(Border2Color=clLime)|DrawSensor=Border2'));
    if iGetTag(tagCross)=0 then bNul(WinDraw('Demo_GuiLib|Fast|Eval=(CrossWidth=2)|UpdateSensor=Cross2')) else
    if iGetTag(tagCross)=1 then bNul(WinDraw('Demo_GuiLib|Fast|Eval=(CrossWidth=0)'));
    spamRate:=spamRate+1;
   end;
   if SysTimer_Pulse(1000)>0 then begin
    Success('Spam Rate = '+Str(spamRate));
    spamRate:=0;
   end;
  end;
  {
  Simulate signals...
  }
  t:=(mSecNow-FixmSecNow)/60000;
  v1:=100*(1+sin(2*pi*t))/2;
  bNul(rSetTag(tagProgressBar,v1));
  {
  Use CheckBox1 to set ClickAwaker
  }
  if SysTimer_Pulse(1000)>0 then begin
   i:=ClickAwaker(0);
   i:=iSetBitState(i, cw_MouseDown, IsBit(iGetTag(tagCheckBox1),0)); // MouseDown
   i:=iSetBitState(i, cw_MouseUp,   IsBit(iGetTag(tagCheckBox1),1)); // MouseUp
   i:=iSetBitState(i, cw_MouseMove, IsBit(iGetTag(tagCheckBox1),2)); // MouseMove
   i:=iSetBitState(i, cw_KeyDown,   IsBit(iGetTag(tagCheckBox1),3)); // KeyDown
   i:=iSetBitState(i, cw_KeyUp,     IsBit(iGetTag(tagCheckBox1),4)); // KeyUp
   iNul(ClickAwaker(i));
  end;
  {
  Use CheckBox2 to set ClickFilter
  }
  if SysTimer_Pulse(1000)>0 then begin
   i:=ClickFilter(0);
   i:=iSetBitState(i, cw_MouseUp,   IsBit(iGetTag(tagCheckBox2),0)); // MouseUp
   i:=iSetBitState(i, cw_MouseMove, IsBit(iGetTag(tagCheckBox2),1)); // MouseMove
   i:=iSetBitState(i, cw_KeyUp,     IsBit(iGetTag(tagCheckBox2),2)); // KeyUp
   iNul(ClickFilter(i));
  end;
  {
  Update Border2Color...
  }
  if ShouldRefresh(valButton1,iGetTag(tagButton1))>0 then begin
   if iGetTag(tagButton1)=0 then bNul(WinDraw('Demo_GuiLib|Fast|Eval=(Border2Color=clRed) |DrawSensor=Border2')) else
   if iGetTag(tagButton1)=1 then bNul(WinDraw('Demo_GuiLib|Fast|Eval=(Border2Color=clLime)|DrawSensor=Border2'));
  end;
  {
  Update Cross...
  }
  if ShouldRefresh(valCross,iGetTag(tagCross))>0 then begin
   if iGetTag(tagCross)=0 then bNul(WinDraw('Demo_GuiLib|Fast|Eval=(CrossWidth=2)|UpdateSensor=Cross2')) else
   if iGetTag(tagCross)=1 then bNul(WinDraw('Demo_GuiLib|Fast|Eval=(CrossWidth=0)|UpdateSensor=Cross2'));
  end;
  {
  Use WheelTestFlag to set ClickFilter
  }
  if SysTimer_Pulse(1000)>0 then begin
   i:=ClickFilter(0);
   i:=iSetBitState(i,cw_MouseWheel,IsBit(iGetTag(tagWheelTestFlag),0));
   iNul(ClickFilter(i));
  end;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   // Handle MouseDown/KeyDown
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    if (ClickButton=VK_LBUTTON) then begin
     Success('Click detected:'+EOL+ClickParams(''));
     if IsSameText(ClickSensor,'HELP') then begin
      Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
      bNul(Voice(snd_Click));
     end;
     {
     Toolbar buttons clicks
     }
     ClickTagXorLocal(cmdHome,1);
     ClickTagXorLocal(cmdOpen,1);
     ClickTagXorLocal(cmdSave,1);
     ClickTagXorLocal(cmdLoadini,1);
     ClickTagXorLocal(cmdSaveini,1);
     ClickTagXorLocal(cmdNavigator,1);
     ClickTagXorLocal(cmdTools,1);
     ClickTagXorLocal(cmdSound,1);
     ClickTagXorLocal(cmdHelp,1);
     ClickTagXorLocal(cmdClose,1);
     ClickTagXorLocal(cmdLoupe,1);
     ClickTagXorLocal(cmdFavorite,1);
     ClickTagXorLocal(cmdLock,1);
     ClickTagXorLocal(cmdKey,1);
     ClickTagXorLocal(cmdCalculator,1);
     ClickTagXorLocal(cmdErase,1);
     ClickTagXorLocal(cmdSetting,1);
     ClickTagXorLocal(cmdConsole,1);
     ClickTagXorLocal(cmdFlash,1);
     ClickTagXorLocal(cmdFlashAlt,1);
     ClickTagXorLocal(cmdLightning,1);
     ClickTagXorLocal(cmdLightningAlt,1);
     ClickTagXorLocal(cmdSnowflake,1);
     ClickTagXorLocal(OkButton,1);
     ClickTagXorLocal(CancelButton,1);
     ClickTagXorLocal(cmdMenu,1);
     ClickTagXorLocal(cmdOptions,1);
     ClickTagXorLocal(cmdArrowCircCW,1);
     ClickTagXorLocal(cmdArrowCircCCW,1);
     ClickTagXorLocal(cmdArrowCW,1);
     ClickTagXorLocal(cmdArrowCCW,1);
     ClickTagXorLocal(cmdArrowUp,1);
     ClickTagXorLocal(cmdArrowDown,1);
     ClickTagXorLocal(cmdArrowLeft,1);
     ClickTagXorLocal(cmdArrowRight,1);
     ClickTagXorLocal(cmdPowerOn,1);
     if ClickTag=cmdSmile then begin
      if iGetTag(cmdSmile)=0 then bNul(iSetTag(cmdSmile,2)) else
      if iGetTag(cmdSmile)=1 then bNul(iSetTag(cmdSmile,0)) else
      if iGetTag(cmdSmile)=2 then bNul(iSetTag(cmdSmile,1));
     end;
     {
     Click on Buttons...
     }
     ClickTagXorLocal(tagButton1,1);
     ClickTagXorLocal(tagCross,1);
     {
     Click on circle indicator
     }
     if ClickTag=tagIndCircle then begin
      if iGetTag(tagIndCircle)=0 then bNul(iSetTag(tagIndCircle,1)) else
      if iGetTag(tagIndCircle)=1 then bNul(iSetTag(tagIndCircle,2)) else
      if iGetTag(tagIndCircle)=2 then bNul(iSetTag(tagIndCircle,3)) else
      if iGetTag(tagIndCircle)=3 then bNul(iSetTag(tagIndCircle,4)) else
      if iGetTag(tagIndCircle)=4 then bNul(iSetTag(tagIndCircle,0));
     end;
     {
     Click on CheckBox1
     }
     if ClickTag=tagCheckBox1 then begin
      for i:=0 to 3 do
      if IsSameText(Copy(ExtractFileExt(ClickSensor),2,1),str(i)) then begin
       bNul(iSetTagXor(tagCheckBox1,Round(Power(2,i))));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Click on CheckBox2
     }
     if ClickTag=tagCheckBox2 then begin
      for i:=0 to 2 do
      if IsSameText(Copy(ExtractFileExt(ClickSensor),2,1),str(i)) then begin
       bNul(iSetTagXor(tagCheckBox2,Round(Power(2,i))));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Click on Radio Button 1
     }
     if ClickTag=tagRadioBtn1 then begin
      for i:=0 to 3 do
      if IsSameText(Copy(ExtractFileExt(ClickSensor),2,1),str(i)) then begin
       bNul(iSetTag(tagRadioBtn1,i));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Click on Radio Button 2
     }
     if ClickTag=tagRadioBtn2 then begin
      for i:=0 to 1 do
      if IsSameText(Copy(ExtractFileExt(ClickSensor),2,1),str(i)) then begin
       bNul(iSetTag(tagRadioBtn2,i));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Click on WheelTestFlag
     }
     if ClickTag=tagWheelTestFlag then begin
      bNul(iSetTagXor(tagWheelTestFlag,1));
      bNul(Voice(snd_Click));
     end;
     {
     Click on ListBox button
     }
     if ClickTag=tagListBoxButton then begin
      ListBoxStarter;
      bNul(Voice(snd_Click));
     end;
    end;
   end;
   //
   // Handle mouse wheel
   //
   if ClickWhat=cw_MouseWheel then begin
    if ClickTag=tagWheelTestData then begin
     i:=Round(iValDef(ClickParams('Wheel'),0)/WHEEL_DELTA);
     if i<>0 then bNul(rAtomicTagOp(tagWheelTestData,'+',i));
    end;
   end;
   //
   // Print any event...
   //
   if ClickWhat<>0 then begin
    bNul(sSetTag(tagClickWhat,ClickParams('What')));
    bNul(iSetTag(tagClickWhereX,Val(ExtractWord(1,ClickParams('Where')))));
    bNul(iSetTag(tagClickWhereY,Val(ExtractWord(2,ClickParams('Where')))));
    Success('Click Sensor='+ClickSensor
           +' What='+ClickParams('What')
           +', Where='+ClickParams('Where')
           +', Wheel='+ClickParams('Wheel')
           +', Button='+ClickParams('Button')
           +', Filter='+Str(ClickFilter(0))
           +', Awaker='+Str(ClickAwaker(0)));
   end;
   {
   // Test click simulation
   if ClickWhat<>0 then begin
    if ClickWhat=3 then begin
    end else begin
     writeln('ClickWhat ',ClickWhat);
     writeln(ClickParams(''));
     writeln('ClickWrite ',ClickWrite(ClickParams('')+EOL+'Item1=adc'+EOL+'Item2=123'));
     writeln('ClickRead ',ClickRead,' ',ClickWrote);
     writeln(ClickParams(''));
     writeln('Item1 ',ClickParams('Item1'));
     writeln('Item2 ',ClickParams('Item2'));
     writeln('Item3 ',ClickParams('Item3'));
    end;
   end;
   }
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   //
   // ListBox menu
   //
   if EditTestResultName(EditGetUID('LIST_BOX')) then begin
    if EditTestResultCode(mr_OK) then bNul(iSetTag(tagListBoxButton,EditGetMenuListSelectedIndex));
    EditReset;
   end;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Spam 10
   }
   if (cmdid=cmd_Spam) then begin
    spamLoop:=iValDef(arg,spamLoop);
    Success(cmd+' '+Str(spamLoop));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
