@echo off
SetLocal EnableExtensions EnableDelayedExpansion

if "%CRW_DAQ_SYS_HOME_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )
if "%CRW_DAQ_CONFIG_HOME_DIR%" == "" ( echo The script should be called from DAQ system only. & goto :EOF )

path %path%;%CRW_DAQ_SYS_HOME_DIR%

call :DetectLanguage
chcp 65001

:VerifyIntegrity
echo VerifyIntegrity: 
set /a VerifyIntegrity=0
unix checksum > "%cd%\temp\checksum.log" || set /a VerifyIntegrity=1
type            "%cd%\temp\checksum.log"
if /I "%Language%" == "Russian" goto :Russian
:English
if "%VerifyIntegrity%" == "0" call :IntegritySuccessDetected "%cd% : Integrity Check is Successful." "view Log"
if "%VerifyIntegrity%" == "1" call :IntegrityFailureDetected "%cd% : Integrity Check is Failed."     "view Log"
goto :EOF
:Russian
if "%VerifyIntegrity%" == "0" call :IntegritySuccessDetected "%cd% : Целостность в норме."  "см. Журнал"
if "%VerifyIntegrity%" == "1" call :IntegrityFailureDetected "%cd% : Целостность НАРУШЕНА." "см. Журнал"
goto :EOF

:DetectLanguage
set Language=English
for /F "eol=; tokens=1,2* delims= " %%i in ('unix inifile %CRW_DAQ_SYS_HOME_DIR%\settings\crwdaq.lng [System] Language') do if /I "%%i" == "set" %%i %%j
goto :EOF

:IntegritySuccessDetected
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
call :Tooltip text "%~1" preset stdSuccess delay 15000    btn1 "%~2" cmd1 "unix grun lister %cd%\temp\checksum.log"
goto :EOF

:IntegrityFailureDetected
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
call :Tooltip text "%~1" preset stdSiren   delay 86400000 btn1 "%~2" cmd1 "unix grun lister %cd%\temp\checksum.log"
goto :EOF

:Tooltip
if "%~1" == "" goto :EOF
unix tooltip-notifier %*
goto :EOF
