---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Демонстрационная конфигурация demo_gnuplot

Эта **ДЕМО** конфигурация показывает как использовать сервер
научной графики -  **[&PlotSrv](../../../resource/daqsite/plotserver/plotsrv.htm)**
для рисования красивых графиков на мнемосхемах и для автоматической
генерации отчетов или **Web** страниц.
При этом сервер **&PlotSrv** генерирует файлы изображений с графиками,
а текстовая часть создается в виде **HTML**.

Сервер основан на использовании пакета **[GNUPLOT](http://gnuplot.sourceforge.net/)**,
свободно распространяемого с исходными кодами. См. также
 **[1](http://gnuplot.info)**,
 **[2](../../../resource/tools/gnuplot/docs/gnuplot.pdf)**,
 **[3](http://mydebianblog.blogspot.com/2006/08/gnuplot.html)**.

---

## Как это работает

Если очень кратко, это работает так.
При клике на сенсор тега клиент вызывает **PlotSend** с заданием на рисование,
например:

``` pascal
// Если нажат сенсор - начать рисование...
if ClickButton=1 then
if ClickTag=tagPlot1 then begin
 b:=PlotSend('@Clear'+EOL
            +'@TimeOut 5000'+EOL
            +'@HomeDir '+AdaptFileName('..\Temp')+EOL
            +'@DoneMsg &DemoPlot @Done '+AdaptFileName('..\bitmaps\plot1.bmp')+EOL
            +'@FailMsg &DemoPlot @Fail '+AdaptFileName('..\bitmaps\plot1.bmp')+EOL
            +'@> set encoding utf8'+EOL
            +'@> set output "plot1.gif"'+EOL
            +'@> set terminal gif small size 300,200'+EOL
            +'@> set title "График по формуле (impulses, lines)" font "PT Mono,8"'+EOL
            +'@> set xlabel "Время, секунд" font "PT Sans,12"'+EOL
            +'@> set ylabel "Значение, отн.ед." font "PT Serif,10"'+EOL
            +'@> plot [0:10] sin(x+'+StrFix(random(0,5),1,3)+')/sqrt(x) with impulses,\'+EOL
            +'@>             cos(x+'+StrFix(random(0,5),1,3)+')/sqrt(x) with lines lw 2 lc 3'+EOL
            +'@! unix gif2bmp plot1.gif '+AdaptFileName('..\bitmaps\plot1.bmp')+EOL
            +'@run plot1.job plot1.dat '+AdaptExeFileName('plot1.bat')+EOL)>0;
 nPlot1:=nPlot1+1;
 b:=Voice(snd_Click);
end;
```
Посланное задание выполняет сервер **[&PlotSrv](../../../resource/daqsite/plotserver/plotsrv.htm)**.

Результатом рисования будет генерация файла **`..\bitmaps\plot1.bmp`** с графиком.  
По окончании генерации файла клиент получает сообщение **`@Done ..\bitmaps\plot1.bmp`**.  
Клиентский код должен обновить сенсоры на мнемосхемах, связанные с графиком.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Клиентский код обработки

В обработчике консольных команд клиент по сообщению **@Done** обновляет и перезагружает
изображение сенсора мнемосхемы, чтобы показать созданный график на экране.  
Собственно, это делает вызов типа **`WinDraw('DemoPlot|Reload=plot1')`**.  
Например:
``` pascal
{
Analyse data coming from standard input.
}
procedure StdIn_Process(Data:string);
var cmd,arg:String; b:Boolean;
begin
 cmd:=''; arg:='';
 if GotCommand(Data,cmd,arg) then begin
  {}
  if IsSameText(cmd,'@Done') then begin
   if IsSameText(ExtractFileName(arg),'plot1')
   then b:=WinDraw('DemoPlot|Reload=plot1');
   Data:='';
  end;
  {}
  if IsSameText(cmd,'@Fail') then begin
   Problem('Could not draw '+arg);
   Data:='';
  end;
  {}
  if Length(Data)>0 then begin
   Trouble(' Unrecognized command "'+Data+'".');
   Data:='';
  end;
 end;
 cmd:=''; arg:='';
end;
```

Естественно, надо следить, чтобы имена сенсора и файла были согласованы.  
Также следует избегать избыточных операций рисования без необходимости.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

Желаем успешного использования **demo_gnuplot**.

---

> **CRW-DAQ** Copyright (c) 2001-2024 Alexey Kuryakin <daqgroup@mail.ru>

---
