 {
 ***********************************************************************
 Simulator for FC1300 devices.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
 [@Help]
 |Command list: StdIn "@cmd=arg" or "@cmd arg"
 |*****************************************************
 | @Help          - This help.
 | @DebugFlags=n  - Set DebugFlags,1/2/4/8=!/:/>/< view
|******************************************************
[]
 }
program FC1300_SIM;
const
 dfTrouble         = 1;          { DebugFlags - Trouble             }
 dfSuccess         = 2;          { DebugFlags - Success             }
 dfViewExp         = 4;          { DebugFlags - ViewExp             }
 dfViewImp         = 8;          { DebugFlags - ViewImp             }
var
 b                 : Boolean;    { Temporary                        }
 Ok                : Boolean;    { Program initialization is Ok?    }
 errors            : Integer;    { Program error counter            }
 errorcode         : Integer;    { Error code for this device       }
 fixmaxavail       : Integer;    { String manager leak control      }
 DebugFlags        : Integer;    { Debug bit flags                  }
 StdIn_Line        : String;     { Temporary variable               }
 Com_Line,Com_Buff : String;     { Temporary variable               }
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Check I/O status.
 }
 function IoError:Boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var Data:string):boolean;
 begin
  Data:='';
  if not IoError then
  if not Eof then Readln(Data);
  if IoError then Data:='';
  StdIn_Readln:=Length(Data)>0;
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|Top=0|Left=167|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
 {
 Show help in device console and echo to Main console if AllowEcho.
 Help text should be placed in program comment is [@Help] section.
 First symbol of help block should be | and will be ignored.
 }
 procedure ShowHelp(AllowEcho:Boolean);
 var i,p,sect:Integer; b:Boolean;
 begin
  sect:=ReadIniSection(text_New,12,DaqFileRef(ReadIni('ProgramSource'),'.pas'),'[@Help]');
  for i:=0 to text_NumLn(sect)-1 do begin
   if Copy(text_GetLn(sect,i),1,1)='|' then p:=2 else p:=1;
   if AllowEcho then b:=echo(devname+' : '+Copy(text_GetLn(sect,i),p));
   Success(Copy(text_GetLn(sect,i),p));
  end;
  b:=text_Free(sect);
  if AllowEcho then b:=WinSelect(ParamStr('MainConsole'));
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  StdIn_Line:='';
  Com_Line:=''; Com_Buff:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Get string like 2006.09.21-00:12:30
 }
 function GetDateTime(ms:Real):String;
 var s:String;
 begin
  s:='';
  s:=Str(ms2sec(ms))+s;   while Length(s)<2  do s:='0'+s; s:=':'+s;
  s:=Str(ms2min(ms))+s;   while Length(s)<5  do s:='0'+s; s:=':'+s;
  s:=Str(ms2hour(ms))+s;  while Length(s)<8  do s:='0'+s; s:='-'+s;
  s:=Str(ms2day(ms))+s;   while Length(s)<11 do s:='0'+s; s:='.'+s;
  s:=Str(ms2month(ms))+s; while Length(s)<14 do s:='0'+s; s:='.'+s;
  s:=Str(ms2year(ms))+s;  while Length(s)<19 do s:='0'+s;
  GetDateTime:=s;
  s:='';
 end;
 {
 Read line from port with CR terminator and LF ignore.
 }
 function Com_Readln(var DataLine,TempBuff:String):Boolean;
 const MaxLeng = 1024;
 var i,p,L:Integer;
 begin
  DataLine:='';
  Com_Readln:=false;
  if ComCount>0 then begin
   L:=Length(TempBuff);
   p:=pos(chr(13),TempBuff);
   if p=0 then begin
    if L<MaxLeng then TempBuff:=TempBuff+ComRead(255);
    L:=Length(TempBuff);
   end;
   if L>0 then begin
    if p=0 then p:=Pos(chr(13),TempBuff);
    if p>0 then begin
     Com_Readln:=true;
     i:=1;
     while (i<p) and (TempBuff[i]=chr(10)) do i:=i+1;
     if i<p then DataLine:=Copy(TempBuff,i,p-i);
     i:=p+1;
     while i<=L do begin
      if TempBuff[i]=chr(10) then p:=i else i:=L;
      i:=i+1;
     end;
     TempBuff:=Copy(TempBuff,p+1);
    end else begin
     if Length(TempBuff)>=MaxLeng then begin
      Trouble('Received line is too long!');
      TempBuff:='';
     end;
    end;
   end;
  end;
 end;
 {
 Handle FC1300 request for simulation.
 }
 procedure HandleRequest(Request:String);
 var r:Real; ans:String;
 begin
  ans:='';
  if Length(Request)>0 then begin
    ViewImp('COM: '+Request);
    if IsSameText(Request,':READ?') then begin
     ans:=Str(10000000+100*sin(1*time*timeunits/1000)+Random(-20,20));
    end;
    if IsSameText(Request,':INP:IMP?') then begin
     ans:='+5.00000000E+01';
    end;
    if IsSameText(Request,':FREQ:ARM:STOP:TIM?') then begin
     ans:='+5.00000000E-01';
    end;
   end;
   if Length(ans)>0 then begin
     b:=ComWrite(ans+CRLF);
     ViewExp('COM: '+ans);
   end;
  ans:='';
 end;
 {
 Analyse data coming from standard input.
 }
 procedure StdIn_Process(Data:string);
 var cmd,arg:String; b:Boolean;
 begin
  if iAnd(DebugFlags,dfViewImp)<>0 then ViewImp('CON: '+Data);
  {
  "@cmd=arg" or "@cmd args" commands:
  }
  cmd:='';
  arg:='';
  if Length(Data)>0 then
  if Data[1]='@' then begin
   cmd:=ExtractWord(1,Data);
   arg:=Copy(Data,Pos(cmd,Data)+Length(cmd)+1);
   {}
   if IsSameText(cmd,'@Help') then begin
    ShowHelp(true);
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@DebugFlags') then begin
    if not IsNan(rVal(arg)) then DebugFlags:=Round(rVal(arg));
    Success(cmd+'='+Str(DebugFlags));
    Data:='';
   end;
   {}
   if Length(Data)>0 then begin
    Trouble(' Unrecognized command "'+Data+'".');
    Data:='';
   end;
  end;
  cmd:='';
  arg:='';
 end;
begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  {
  Initialize errors...
  }
  errors:=0;
  errorcode:=registererr(devname);
  {
  Clear and initialize variables...
  }
  ClearStrings;
  DebugFlags:=val(ReadIni('DebugFlags'));
  OpenConsole(Val(ReadIni('OpenConsole')));
  Success('Start at '+GetDateTime(msecnow));
  {
  Open COM port
  }
  if not ComOpen(ReadIni('PortSection'))
  then Trouble('Could not open COM, stopped.')
  else b:=ComClear;
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop
 }
 if isinf(runcount) then begin
  Success('Stop.');
  ClearStrings;
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  {
  Process standard input...
  }
  while StdIn_Readln(StdIn_Line) do StdIn_Process(StdIn_Line);
  {
  FC1300 protocol - simulator...
  }
  if Com_ReadLn(Com_Line,Com_Buff) then HandleRequest(Com_Line);
 end;
end.
