 {
 ***********************************************************************
 Daq Pascal application program SIM9H External Setpoint.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|**********************************************
| @Edit P  - Edit EXT parameter P, which may be
|            one of: SPV1, SPV2, TIME.
| @LoadIni - load params from INI file.
| @SaveIni - save params to   INI file.
|**********************************************
[]
 }
program sim9h_ext;               { SIM9xx external setpoint         }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SetPointStep1 = 0.0001;         {                                  }
 SetPointStep2 = 0.001;          {                                  }
 SetPointStep3 = 0.01;           {                                  }

type
 TTagRef     = record tag,nai,ndi,nao,ndo:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 SIM9H             : record      { Stanford Intr.Modules 9 handreds }
  EXT              : record      {                                  }
   SETP            : TTagRef;    {                                  }
   SPV1            : TTagRef;    {                                  }
   SPV2            : TTagRef;    {                                  }
   TIME            : TTagRef;    {                                  }
   RATE            : TTagRef;    {                                  }
   RAMP            : TTagRef;    {                                  }
   ENAB            : TTagRef;    {                                  }
   SETV            : Real;       {                                  }
  end;                           {                                  }
  GUI              : record      { Graphical User Interface data    }
   CMD             : record      { Commands                         }
    SAVEINI        : TTagRef;    {                                  }
    LOADINI        : TTagRef;    {                                  }
   end;                          {                                  }
   RampTime        : Real;       {                                  }
   RampTm          : Real;       {                                  }
   val_U1          : Real;       {                                  }
   val_U2          : Real;       {                                  }
   Rate            : Real;       {                                  }
  end;                           {                                  }
 end;                            {                                  }
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Apply bit XOR mask to tag
 }
 procedure iBitXorTag(tag,XorMask:Integer);
 begin
  bNul(iSetTagXor(tag,XorMask));
 end;
 {
 Handle GUI commands, edit tags etc.
 }
 procedure SIM9H_GUI_POLL;
 var i:Integer; val_V1,val_V2,val_V:Real; s:String;
  //
  // Start ramping
  //
  procedure Ramping_Start;
  begin
   SIM9H.Gui.RampTime:=mSecNow;
   SIM9H.Gui.RampTm:=mSecNow;
   SIM9H.Gui.val_U1:=rGetTag(SIM9H.EXT.SPV1.tag);
   SIM9H.Gui.val_U2:=rGetTag(SIM9H.EXT.SPV2.tag);
   SIM9H.Gui.Rate:=rGetTag(SIM9H.EXT.RATE.tag);
  end;
  //
  // Setting current and voltage on ramping time mode
  //
  procedure Ramp_Set_Time(var val1,val2:Real);
  var t1,t2,dv,dt,k,y,Time:Real;
  begin
   Time:=iGetTag(SIM9H.EXT.TIME.tag);
   t1:=SIM9H.Gui.RampTime;
   t2:=t1+(Time*1000);
   dv:=val2-val1;
   dt:=t2-mSecNow;
   k:=dv/(t1-t2);
   y:=k*dt+val2;
   if mSecNow<=t2 then begin
    if mSecNow>=SIM9H.Gui.RampTm+200 then begin
     SIM9H.Gui.RampTm:=mSecNow;
     bNul(rSetTag(SIM9H.EXT.SPV1.tag,y));
    end;
   end else begin
    bNul(rSetTag(SIM9H.EXT.SPV1.tag,rGetTag(SIM9H.EXT.SPV2.tag)));
   end;
  end;
  //
  // Setting current and voltage on ramping rate mode
  //
  procedure Ramp_Set_Rate(var val1,val2:Real);
  var val:Real;
  begin
   if mSecNow-SIM9H.Gui.RampTime>=1000 then begin
    if SIM9H.Gui.val_U1>SIM9H.Gui.val_U2 then begin
     val:=val1-SIM9H.Gui.Rate;
     if val<=SIM9H.Gui.val_U2
     then bNul(rSetTag(SIM9H.EXT.SPV1.tag,rGetTag(SIM9H.EXT.SPV2.tag)))
     else bNul(rSetTag(SIM9H.EXT.SPV1.tag,val));
     SIM9H.Gui.RampTime:=SIM9H.Gui.RampTime+1000;
    end;
    if SIM9H.Gui.val_U1<SIM9H.Gui.val_U2 then begin
     val:=val1+SIM9H.Gui.Rate;
     if val>=SIM9H.Gui.val_U2
     then bNul(rSetTag(SIM9H.EXT.SPV1.tag,rGetTag(SIM9H.EXT.SPV2.tag)))
     else bNul(rSetTag(SIM9H.EXT.SPV1.tag,val));
     SIM9H.Gui.RampTime:=SIM9H.Gui.RampTime+1000;
    end;
   end;
  end;
 begin
  s:='';
  val_V1:=rGetTag(SIM9H.EXT.SPV1.tag);
  val_V2:=rGetTag(SIM9H.EXT.SPV2.tag);
  if iGetTag(SIM9H.EXT.RAMP.tag)<>0 then begin
   if rGetTag(SIM9H.EXT.SPV1.tag)<>rGetTag(SIM9H.EXT.SPV2.tag) then begin
    if iGetTag(SIM9H.EXT.TIME.tag)<>0 then Ramp_Set_Time(SIM9H.Gui.val_U1,SIM9H.Gui.val_U2);
    if rGetTag(SIM9H.EXT.RATE.tag)<>0 then Ramp_Set_Rate(val_V1,val_V2);
   end else bNul(iSetTag(SIM9H.EXT.RAMP.tag,0));
  end;
  //
  // Handle commands...
  //
  if iGetTag(SIM9H.GUI.CMD.SAVEINI.tag)<>0 then begin
   bNul(iSetTag(SIM9H.GUI.CMD.SAVEINI.tag,0));
   DevSendCmd(DevMySelf,'@SaveIni');
  end;
  if iGetTag(SIM9H.GUI.CMD.LOADINI.tag)<>0 then begin
   bNul(iSetTag(SIM9H.GUI.CMD.LOADINI.tag,0));
   DevSendCmd(DevMySelf,'@LoadIni');
  end;
  if iGetTag(SIM9H.EXT.ENAB.tag)<>0
  then bNul(iSetTag(SIM9H.EXT.SETP.tag,1))
  else begin
   bNul(iSetTag(SIM9H.EXT.SETP.tag,0));
   //Cron('@cron.run EMAPS.SIM9H.EXT.CTRL.HIDE');
  end;
  //
  // Handle sensor clicks...
  //
  if ClickButton=1 then begin
   if ClickTag=SIM9H.EXT.SPV1.tag then begin
    DevSendCmd(devMySelf,'@Edit SPV1');
    bNul(Voice(snd_Click));
   end;
   if ClickTag=SIM9H.EXT.SPV2.tag then begin
    DevSendCmd(devMySelf,'@Edit SPV2');
    bNul(Voice(snd_Click));
   end;
   if ClickTag=SIM9H.EXT.RATE.tag then begin
    DevSendCmd(devMySelf,'@Edit RATE');
    bNul(Voice(snd_Click));
   end;
   if ClickTag=SIM9H.EXT.TIME.tag then begin
    DevSendCmd(devMySelf,'@Edit TIME');
    bNul(Voice(snd_Click));
   end;
   if ClickTag=SIM9H.EXT.SETP.tag then
   if iGetTag(SIM9H.EXT.ENAB.tag)<>0 then begin
    Cron('@cron.run EMAPS.SIM9H.EXT.CTRL.SELECT');
    bNul(Voice(snd_Click));
   end;
   if ClickTag=SIM9H.EXT.RAMP.tag then begin
    if iGetTag(SIM9H.EXT.TIME.tag)<>0 then begin
     Ramping_Start;
     if SIM9H.Gui.val_U1<>SIM9H.Gui.val_U2 then begin
      iBitXorTag(SIM9H.EXT.RAMP.tag,1);
     end;
    end;
    if rGetTag(SIM9H.EXT.RATE.tag)<>0 then begin
     Ramping_Start;
     if SIM9H.Gui.val_U1<>SIM9H.Gui.val_U2 then begin
      iBitXorTag(SIM9H.EXT.RAMP.tag,1);
     end;
    end;
    bNul(Voice(snd_Click));
   end;
   ClickBitXorLocal(SIM9H.GUI.CMD.SAVEINI.tag,1);
   ClickBitXorLocal(SIM9H.GUI.CMD.LOADINI.tag,1);
   if iGetTag(SIM9H.EXT.RAMP.tag)=0 then begin
    for i:=1 to 3 do begin
     if IsSameText(ClickSensor, 'SIM9H.EXT.UP'+Str(i)) then begin
      if i=1 then val_V:=SetPointStep1;
      if i=2 then val_V:=SetPointStep2;
      if i=3 then val_V:=SetPointStep3;
      val_V:=val_V1+val_V;
      if val_V>=0
      then bNul(rSetTag(SIM9H.EXT.SPV1.tag, val_V))
      else bNul(rSetTag(SIM9H.EXT.SPV1.tag, 0));
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor, 'SIM9H.EXT.DN'+Str(i)) then begin
      if i=1 then val_V:=SetPointStep1;
      if i=2 then val_V:=SetPointStep2;
      if i=3 then val_V:=SetPointStep3;
      val_V:=val_V1-val_V;
      if val_V>=0
      then bNul(rSetTag(SIM9H.EXT.SPV1.tag, val_V))
      else bNul(rSetTag(SIM9H.EXT.SPV1.tag, 0));
      bNul(Voice(snd_Click));
     end;
    end;
   end;
  end;
  //
  // Edit tags...
  //
  if EditState=ef_Done then begin
   if iGetTag(SIM9H.EXT.RAMP.tag)=0 then begin
    CheckEditTagUpdate(SIM9H.EXT.SPV1.tag,0,_PlusInf);
    CheckEditTagUpdate(SIM9H.EXT.SPV2.tag,0,_PlusInf);
    if CheckEditTag(SIM9H.EXT.RATE.tag,s) then begin
     UpdateTag(SIM9H.EXT.RATE.tag,s,0,_PlusInf);
     bNul(iSetTag(SIM9H.EXT.TIME.tag,0));
    end;
    if CheckEditTag(SIM9H.EXT.TIME.tag,s) then begin
     UpdateTag(SIM9H.EXT.TIME.tag,s,0,_PlusInf);
     bNul(rSetTag(SIM9H.EXT.RATE.tag,0));
    end;
   end;
   //
   // Warning.
   //
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Warning') then sNul(Edit(''));
   //
   // Information.
   //
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Information') then sNul(Edit(''));
  end;
  if EditState=ef_Done then begin
   Problem('Unknown tag edition!');
   sNul(Edit(''));
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Dialog error detected!');
   sNul(Edit(''));
  end;
  s:='';
 end;
 {
 Initialize tags.
 }
 procedure SIM9H_InitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   InitTag(SIM9H.EXT.SETP.tag,        Prefix+'.EXT.SETP',    1);
   InitTag(SIM9H.EXT.SPV1.tag,        Prefix+'.EXT.SPV1',    2);
   InitTag(SIM9H.EXT.SPV2.tag,        Prefix+'.EXT.SPV2',    2);
   InitTag(SIM9H.EXT.TIME.tag,        Prefix+'.EXT.TIME',    1);
   InitTag(SIM9H.EXT.RATE.tag,        Prefix+'.EXT.RATE',    2);
   InitTag(SIM9H.EXT.RAMP.tag,        Prefix+'.EXT.RAMP',    1);
   InitTag(SIM9H.EXT.ENAB.tag,        Prefix+'.PID.INPT',    1);
   InitTag(SIM9H.GUI.CMD.SAVEINI.tag, Prefix+'.EXT.SAVEINI', 1);
   InitTag(SIM9H.GUI.CMD.LOADINI.tag, Prefix+'.EXT.LOADINI', 1);
  end;
 end;
 {
 SIM9H cleanup.
 }
 procedure SIM9H_Clear;
 begin
 end;
 {
 SIM9H initialization.
 }
 procedure SIM9H_Init;
 begin
  SIM9H_InitTags(ReadIni('tagSIM9H'));
 end;
 {
 SIM9H finalization.
 }
 procedure SIM9H_Free;
 begin
 end;
 {
 SIM9H polling.
 }
 procedure SIM9H_Poll;
 begin
  SIM9H_GUI_POLL;
  SIM9H.EXT.SETV:=rGetTag(SIM9H.EXT.SPV1.tag);
  bNul(putao(0,time,SIM9H.EXT.SETV*1000));
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  SIM9H_Clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  SIM9H_Init;
  RunStartupScript;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  RunFinallyScript;
  SIM9H_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  SIM9H_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Edit SPV1
   }
   if IsSameText(cmd,'@Edit') then begin
    if IsSameText(ExtractWord(1,arg),'SPV1')
    then StartEditTag(SIM9H.EXT.SPV1.tag,'Уставка напр 1, В');
    if IsSameText(ExtractWord(1,arg),'SPV2')
    then StartEditTag(SIM9H.EXT.SPV2.tag,'Уставка напр 2, В');
    if IsSameText(ExtractWord(1,arg),'TIME')
    then StartEditTag(SIM9H.EXT.TIME.tag,'Уставка времени, сек');
    if IsSameText(ExtractWord(1,arg),'RATE')
    then StartEditTag(SIM9H.EXT.RATE.tag,'Плавность уставки, В/сек');
    Data:='';
   end else
   {
   @LoadIni
   }
   if IsSameText(cmd,'@LoadIni') then begin
    iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @SaveIni
   }
   if IsSameText(cmd,'@SaveIni') then begin
    iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
