 {
 ***********************************************************************
 Daq Pascal application program SIM9H.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @PID.n v       - Assign PID parameter n to new value v.
|                  n: PCTL,ICTL,DCTL,OCTL,AMAN,INPT,RAMP,STRT,
|                  GAIN,INTG,DERV,OFST,SETP,RATE,MOUT,ULIM,LLIM
| @Edit PID.n    - Edit PID parameter n, which may be one of:
|                  GAIN,INTG,DERV,OFST,SETP,RATE,MOUT,ULIM,LLIM
| @LoadIni       - load params from INI file.
| @SaveIni       - save params to   INI file.
|********************************************************
[]
 }
program sim9h_drv;               { SIM9xx driver                    }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 st_NoReq           = 0;         { No request sent                  }
 st_WaitAns         = 1;         { Waiting answer                   }
 st_WaitGap         = 2;         { Waiting time gap                 }
 st_TimeOut         = 3;         { TimeOut found                    }
 cm_MFR_XIDN        = 1;         { SIM900 *IDN?                     }
 cm_PID_XIDN        = 2;         { SIM960 *IDN?                     }
 cm_PID_PCTL        = 3;         { SIM960 PCTL?                     }
 cm_PID_ICTL        = 4;         { SIM960 ICTL?                     }
 cm_PID_DCTL        = 5;         { SIM960 DCTL?                     }
 cm_PID_OCTL        = 6;         { SIM960 OCTL?                     }
 cm_PID_GAIN        = 7;         { SIM960 GAIN?                     }
 cm_PID_INTG        = 8;         { SIM960 INTG?                     }
 cm_PID_DERV        = 9;         { SIM960 DERV?                     }
 cm_PID_OFST        = 10;        { SIM960 OFST?                     }
 cm_PID_MMON        = 11;        { SIM960 MMON?                     }
 cm_PID_OMON        = 12;        { SIM960 OMON?                     }
 cm_PID_AMAN        = 13;        { SIM960 AMAN?                     }
 cm_PID_INPT        = 14;        { SIM960 INPT?                     }
 cm_PID_SETP        = 15;        { SIM960 SETP?                     }
 cm_PID_RAMP        = 16;        { SIM960 RAMP?                     }
 cm_PID_RATE        = 17;        { SIM960 RATE?                     }
 cm_PID_MOUT        = 18;        { SIM960 MOUT?                     }
 cm_PID_APOL        = 19;        { SIM960 APOL?                     }
 cm_PID_SMON        = 20;        { SIM960 SMON?                     }
 cm_PID_EMON        = 21;        { SIM960 EMON?                     }
 cm_PID_RMPS        = 22;        { SIM960 RMPS?                     }
 cm_PID_ULIM        = 23;        { SIM960 ULIM?                     }
 cm_PID_LLIM        = 24;        { SIM960 LLIM?                     }
 MaxCmdNum          = 24;        { Max command id number            }
 cf_RW              = 1;         { Read/Write                       }
 cf_RO              = 0;         { Read Only                        }
 ao_POLLRATE        = 0;         { Analog outputs...                }
 ao_ERRORCNT        = 1;         {                                  }
 ao_PID_PCTL        = 2;         {                                  }
 ao_PID_ICTL        = 3;         {                                  }
 ao_PID_DCTL        = 4;         {                                  }
 ao_PID_OCTL        = 5;         {                                  }
 ao_PID_GAIN        = 6;         {                                  }
 ao_PID_INTG        = 7;         {                                  }
 ao_PID_DERV        = 8;         {                                  }
 ao_PID_OFST        = 9;         {                                  }
 ao_PID_MMON        = 10;        {                                  }
 ao_PID_OMON        = 11;        {                                  }
 ao_PID_AMAN        = 12;        {                                  }
 ao_PID_INPT        = 13;        {                                  }
 ao_PID_SETP        = 14;        {                                  }
 ao_PID_RAMP        = 15;        {                                  }
 ao_PID_RATE        = 16;        {                                  }
 ao_PID_MOUT        = 17;        {                                  }
 ao_PID_APOL        = 18;        {                                  }
 ao_PID_SMON        = 19;        {                                  }
 ao_PID_EMON        = 20;        {                                  }
 ao_PID_RMPS        = 21;        {                                  }
 ao_PID_ULIM        = 22;        {                                  }
 ao_PID_LLIM        = 23;        {                                  }
 GetnLeng           = 128;       { GETN? readout length             }
 si_OFFLINE         = 'OFFLINE'; { To identify offline state        }
 si_SRS_MAGIC       = 'Stanford_Research_Systems'; { Stanford ID    }
 si_LIST_0          = 'OFF,NEG,MAN,INT,STOP,IDLE';    { 0 values    }
 si_LIST_1          = 'ON,POS,PID,EXT,START,PENDING'; { 1 values    }
 si_LIST_2          = 'RAMPING';                      { 2 values    }
 si_LIST_3          = 'PAUSED';                       { 3 values    }


type
 TTagRef     = record tag,nai,ndi,nao,ndo:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 SIM9H             : record      { Stanford Intr.Modules 9 handreds }
  Simulator        : Boolean;    { Simulator mode                   }
  ecTimeOut        : Integer;    { Error code: TimeOut              }
  Com              : record      { COM port data                    }
   Port            : Integer;    {  Port number                     }
   Status          : Integer;    {  Status flag                     }
   TimeOut         : Integer;    {  TimeOut, ms                     }
   TimeGap         : Integer;    {  Time delay after poll, ms       }
   PollPeriod      : Integer;    { Poll period, ms                  }
   Req,Ans,Buf     : String;     {  Request, Answer                 }
   ReqTime,AnsTime : Real;       {  Request, Answer time, ms        }       
   LastPoll        : Real;       { Time of last poll, ms            }
   PollRate        : Integer;    { Poll rate, poll/sec              }
  end;                           {                                  }
  Cmd              : record      {  Command cycle data              }
   Num             : Integer;    {   Current command number         }
   Enabled         : array [1..MaxCmdNum] of Boolean; {             }
   Acronim         : array [1..MaxCmdNum] of String;  {             }
   Comment         : array [1..MaxCmdNum] of String;  {             }
   OpData          : array [1..MaxCmdNum] of Real;    {             }
   OpBuff          : array [1..MaxCmdNum] of Real;    {             }
   AoNum           : array [1..MaxCmdNum] of Integer; {             }
   Flags           : array [1..MaxCmdNum] of Integer; {             }
   Port            : array [1..MaxCmdNum] of Integer; {             }
   Tag             : array [1..MaxCmdNum] of Integer; {             }
   Min             : array [1..MaxCmdNum] of Real;    {             }
   Max             : array [1..MaxCmdNum] of Real;    {             }
  end;                           {                                  }
  MFR              : record      { SIM900 MainFrame                 }
   XIDN            : TTagRef;    {                                  }
  end;                           {                                  }
  PID              : record      { SIM960 PID                       }
   Port            : Integer;    {  Port number                     }
   XIDN            : TTagRef;    {                                  }
   STRT            : Real;       { STRT command                     }
  end;                           {                                  }
  GUI              : record      { Graphical User Interface data    }
   CMD             : record      { Commands                         }
    HELP           : TTagRef;    {                                  }
    RESET          : TTagRef;    {                                  }
    SAVEINI        : TTagRef;    {                                  }
    LOADINI        : TTagRef;    {                                  }
   end;                          {                                  }
  end;                           {                                  }
 end;                            {                                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Apply bit XOR mask to tag
 }
 procedure iBitXorTag(tag,XorMask:Integer);
 begin
  bNul(iSetTagXor(tag,XorMask));
 end;
 {
 Return Data with bit number n assigned according to value SetOn.
 }
 function iSetBitNum(Data,BitNum:Integer; SetOn:Boolean):Integer;
 begin
  if SetOn
  then iSetBitNum:=iOr(Data,iShift(1,BitNum))
  else iSetBitNum:=iAnd(Data,iNot(iShift(1,BitNum)));
 end;
 {
 Set bit in integer tag
 }
 procedure iSetTagBitNum(tag,BitNum:Integer; SetOn:Boolean);
 begin
  if TypeTag(tag)=1 then
  bNul(iSetTag(tag,iSetBitNum(iGetTag(tag),BitNum,SetOn)));
 end;
 {
 Check if COM port opened.
 }
 function ComOpened:Boolean;
 begin
  ComOpened:=(ComSpace>=0);
 end;
 {
 Return position of CR or LF.
 }
 function PosCrLf(s:String):Integer;
 var pcr,plf:Integer;
 begin
  pcr:=Pos(Chr(_CR),s);
  plf:=Pos(Chr(_LF),s);
  if pcr=0 then PosCrLf:=plf else
  if pcr<plf then PosCrLf:=pcr else PosCrLf:=plf;
 end;
 {
 Check command number. 
 }
 function IsValidCmdNum(n:Integer):Boolean;
 begin
  IsValidCmdNum:=(n>=1) and (n<=MaxCmdNum);
 end;
 {
 Clear commands.
 }
 procedure SIM9H_Clear_Cmd;
 var i:Integer;
 begin
  for i:=1 to MaxCmdNum do begin
   SIM9H.Cmd.Acronim[i]:='';
   SIM9H.Cmd.Comment[i]:='';
   SIM9H.Cmd.Enabled[i]:=False;
   SIM9H.Cmd.OpData[i]:=_NAN;
   SIM9H.Cmd.OpBuff[i]:=_NAN;
   SIM9H.Cmd.AoNum[i]:=-1;
   SIM9H.Cmd.Flags[i]:=0;
   SIM9H.Cmd.Port[i]:=0;
   SIM9H.Cmd.Tag[i]:=0;
   SIM9H.Cmd.Min[i]:=0;
   SIM9H.Cmd.Max[i]:=0;
  end;
 end;
 {
 Initialize commands.
 }
 procedure SIM9H_Init_Cmd(Pid:Integer);
  procedure CmdSet(n,port:Integer; Acronim,Comment:String; Enabled:Boolean; AoNum,Flags:Integer; OpData,Min,Max:Real);
  begin
   if not SIM9H.Simulator then OpData:=_NAN;
   if IsValidCmdNum(n) then begin
    SIM9H.Cmd.Acronim[n]:=Acronim;
    SIM9H.Cmd.Comment[n]:=Comment;
    SIM9H.Cmd.Enabled[n]:=Enabled;
    SIM9H.Cmd.OpData[n]:=OpData;
    SIM9H.Cmd.AoNum[n]:=AoNum;
    SIM9H.Cmd.Flags[n]:=Flags;
    SIM9H.Cmd.Port[n]:=Port;
    SIM9H.Cmd.Tag[n]:=FindTag(CrvName(RefAo(AoNum)));
    SIM9H.Cmd.Min[n]:=Min;
    SIM9H.Cmd.Max[n]:=Max;
   end;
  end;
 begin
  SIM9H.Cmd.Num:=1;
  ////// Command      Port Acronim Comment                          Enab  AoNum        Flags  OpData Min    Max
  CmdSet(cm_MFR_XIDN, 0,   '*IDN', 'Имя основного модуля',          True, -1,          cf_RO, _NAN,  0,     0);
  CmdSet(cm_PID_XIDN, Pid, '*IDN', 'PID имя модуля',                True, -1,          cf_RO, _NAN,  0,     0);
  CmdSet(cm_PID_GAIN, Pid, 'GAIN', 'PID коэффициент P, В/В',        True, ao_PID_GAIN, cf_RW, +1E+0, +1E-1, +1E+3);
  CmdSet(cm_PID_INTG, Pid, 'INTG', 'PID коэффициент I, В/(В*с)',    True, ao_PID_INTG, cf_RW, +1E+0, +1E-2, +5E+5);
  CmdSet(cm_PID_DERV, Pid, 'DERV', 'PID коэффициент D, В/(В/с)',    True, ao_PID_DERV, cf_RW, +1E-6, +1E-6, +1E+1);
  CmdSet(cm_PID_OFST, Pid, 'OFST', 'PID сдвиг выхода, В',           True, ao_PID_OFST, cf_RW, +0E+0, -1E+1, +1E+1);
  CmdSet(cm_PID_PCTL, Pid, 'PCTL', 'PID разрешить P',               True, ao_PID_PCTL, cf_RW, 0,     0,     1);
  CmdSet(cm_PID_ICTL, Pid, 'ICTL', 'PID разрешить I',               True, ao_PID_ICTL, cf_RW, 0,     0,     1);
  CmdSet(cm_PID_DCTL, Pid, 'DCTL', 'PID разрешить D',               True, ao_PID_DCTL, cf_RW, 0,     0,     1);
  CmdSet(cm_PID_OCTL, Pid, 'OCTL', 'PID разрешить смещение выхода', True, ao_PID_OCTL, cf_RW, 0,     0,     1);
  CmdSet(cm_PID_MMON, Pid, 'MMON', 'PID монитор выхода, В',         True, ao_PID_MMON, cf_RO, +0E+0, -1E+1, +1E+1);
  CmdSet(cm_PID_OMON, Pid, 'OMON', 'PID монитор входа, В',          True, ao_PID_OMON, cf_RO, +0E+0, -1E+1, +1E+1);
  CmdSet(cm_PID_AMAN, Pid, 'AMAN', 'PID контроль включить',         True, ao_PID_AMAN, cf_RW, 0,     0,     1);
  CmdSet(cm_PID_INPT, Pid, 'INPT', 'PID внеш/внутренний вход',      True, ao_PID_INPT, cf_RW, 0,     0,     1);
  CmdSet(cm_PID_SETP, Pid, 'SETP', 'PID уставка входа, В',          True, ao_PID_SETP, cf_RW, +0E+0, -1E+1, +1E+1);
  CmdSet(cm_PID_RAMP, Pid, 'RAMP', 'PID разрешить плавную уставку', True, ao_PID_RAMP, cf_RW, 0,     0,     1);
  CmdSet(cm_PID_RATE, Pid, 'RATE', 'PID скорость уставки, В/с',     True, ao_PID_RATE, cf_RW, +1E+0, +1E-3, +1E+4);
  CmdSet(cm_PID_MOUT, Pid, 'MOUT', 'PID ручной выход, В',           True, ao_PID_MOUT, cf_RW, +0E+0, -1E+1, +1E+1);
  CmdSet(cm_PID_APOL, Pid, 'APOL', 'PID полярность выхода',         True, ao_PID_APOL, cf_RW, 0,     0,     1);
  CmdSet(cm_PID_SMON, Pid, 'SMON', 'PID монитор уставки',           True, ao_PID_SMON, cf_RO, +0E+0, -1E+1, +1E+1);
  CmdSet(cm_PID_EMON, Pid, 'EMON', 'PID монитор ошибки',            True, ao_PID_EMON, cf_RO, +0E+0, -1E+1, +1E+1);
  CmdSet(cm_PID_RMPS, Pid, 'RMPS', 'PID статус роста уставки',      True, ao_PID_RMPS, cf_RO, 0,     0,     3);
  CmdSet(cm_PID_ULIM, Pid, 'ULIM', 'PID верхний предел выхода, В',  True, ao_PID_ULIM, cf_RW, +1E+1, -1E+1, +1E+1);
  CmdSet(cm_PID_LLIM, Pid, 'LLIM', 'PID нижний предел выхода, В',   True, ao_PID_LLIM, cf_RW, -1E+1, -1E+1, +1E+1);
  SIM9H.PID.STRT:=_NAN;
 end;
 {
 Main command cycle.
 }
 procedure SIM9H_CMD_CYCLE;
  function ValidateCmdNum(Num:Integer):Integer;
  begin
   if IsValidCmdNum(Num)
   then ValidateCmdNum:=Num
   else ValidateCmdNum:=1;
  end;
  function NextCmdNum(Num:Integer):Integer;
  var i:Integer;
  begin
   i:=0;
   while (i<MaxCmdNum) do begin
    Num:=ValidateCmdNum(Num+1);
    if SIM9H.Cmd.Enabled[Num]
    then i:=MaxCmdNum
    else i:=i+1;
   end; 
   NextCmdNum:=Num;
  end;
  procedure ClearRequest(Num,Status:Integer);
  begin
   SIM9H.Com.Req:='';
   SIM9H.Com.Ans:='';
   SIM9H.Com.Buf:='';
   SIM9H.Com.ReqTime:=0;
   SIM9H.Com.AnsTime:=0;
   SIM9H.Com.Status:=Status;
   SIM9H.Cmd.Num:=ValidateCmdNum(Num);
  end;
  procedure PrepareRequest(n,Phase:Integer);
  var OpData:Real;
  begin
   if IsValidCmdNum(n) then
   if (SIM9H.Cmd.Port[n]=0) or (Phase=0) then begin
    SIM9H.Com.Req:=SIM9H.Cmd.Acronim[n]+'?';
    if iAnd(SIM9H.Cmd.Flags[n],cf_RW)>0 then OpData:=SIM9H.Cmd.OpData[n] else OpData:=_NAN;
    if not IsNan(OpData) and (OpData<SIM9H.Cmd.Min[n]) then OpData:=_NAN;
    if not IsNan(OpData) and (OpData>SIM9H.Cmd.Max[n]) then OpData:=_NAN;
    if not IsNan(OpData) then SIM9H.Com.Req:=SIM9H.Cmd.Acronim[n]+' '+Str(OpData)+'; '+SIM9H.Com.Req;
    if (SIM9H.Cmd.Port[n]=0)
    then SIM9H.Com.Req:=SIM9H.Com.Req+CRLF
    else SIM9H.Com.Req:='SNDT '+Str(SIM9H.Cmd.Port[n])+',"'+SIM9H.Com.Req+'"'+CRLF;
   end else begin
    SIM9H.Com.Req:='GETN? '+Str(SIM9H.Cmd.Port[n])+','+Str(GetnLeng)+CRLF;
   end;
  end;
  procedure UpdateXIDN(tag:Integer; data:String);
  var Comma:Char;
  begin
   if not IsEmptyStr(data) then
   if TypeTag(tag)=3 then begin
    if Pos(',',sGetTag(tag))=0 then Comma:=',' else Comma:=';';
    if IsSameText(ExtractWord(1,data),si_SRS_MAGIC)
    then data:=ExtractWord(2,data)+Comma+ExtractWord(3,data)
    else data:=si_OFFLINE;
    if IsEmptyStr(data) then data:=si_OFFLINE;
    bNul(sSetTag(tag,data));
   end;
  end;
  procedure DecodeData(n:Integer; data:String);
  var value:Real;
  begin
   if IsValidCmdNum(n) then begin
    data:=Trim(data);
    if Length(data)>0 then begin
     if n=cm_MFR_XIDN then UpdateXIDN(SIM9H.MFR.XIDN.tag,data) else
     if n=cm_PID_XIDN then UpdateXIDN(SIM9H.PID.XIDN.tag,data) else begin
      value:=rVal(data);
      if IsNan(value) then if WordIndex(data,si_LIST_0)>0 then value:=0;
      if IsNan(value) then if WordIndex(data,si_LIST_1)>0 then value:=1;
      if IsNan(value) then if WordIndex(data,si_LIST_2)>0 then value:=2;
      if IsNan(value) then if WordIndex(data,si_LIST_3)>0 then value:=3;
      if not IsNan(value) then begin
       if SIM9H.Cmd.AoNum[n]>=0 then UpdateAo(SIM9H.Cmd.AoNum[n],time,value);
       if TypeTag(SIM9H.Cmd.Tag[n])=1 then bNul(iSetTag(SIM9H.Cmd.Tag[n],Round(value)));
       if TypeTag(SIM9H.Cmd.Tag[n])=2 then bNul(rSetTag(SIM9H.Cmd.Tag[n],value));
      end;
     end;
     SIM9H.Cmd.OpData[n]:=_NAN;
    end;
   end;
  end;
  function IsReqSNDT:Boolean;
  begin
   IsReqSNDT:=(Pos('SNDT',SIM9H.Com.Req)=1);
  end;
  function IsReqGETN:Boolean;
  begin
   IsReqGETN:=(Pos('GETN?',SIM9H.Com.Req)=1);
  end;
  procedure Request_GETN(n:Integer);
  begin
   if IsValidCmdNum(n) then begin
    PrepareRequest(n,1);
    if Length(SIM9H.Com.Req)>0 then begin        
     if ComWrite(SIM9H.Com.Req) then begin
      ViewExp('COM > '+Trim(SIM9H.Com.Req));
     end else begin
      Trouble('Could not send request '+SIM9H.Com.Req);
      ClearRequest(NextCmdNum(SIM9H.Cmd.Num),st_NoReq);
     end;
    end;
   end;
  end;
  function HandleRequest(n:Integer):Boolean;
  var Handled:Boolean; PosDelim,DataLen:Integer;
  begin
   Handled:=false;
   if IsValidCmdNum(n) then begin
    SIM9H.Com.Ans:=TrimLeft(SIM9H.Com.Ans);
    if PosCrLf(SIM9H.Com.Ans)>0 then begin
     ViewImp('COM < '+Trim(SIM9H.Com.Ans));
     if IsReqGETN then begin
      if Pos('#3',SIM9H.Com.Ans)=1 then begin
       DataLen:=Val(Copy(SIM9H.Com.Ans,3,3));
       SIM9H.Com.Buf:=SIM9H.Com.Buf+Copy(SIM9H.Com.Ans,6,DataLen);
       SIM9H.Com.Ans:=TrimLeft(Copy(SIM9H.Com.Ans,6+DataLen));
       if PosCrLf(SIM9H.Com.Buf)>0 then begin
        PosDelim:=PosCrLf(SIM9H.Com.Buf);
        DecodeData(n,Copy(SIM9H.Com.Buf,1,PosDelim));
        Handled:=True;
       end else begin
        Request_GETN(n);
       end;
      end;
     end else begin
      PosDelim:=PosCrLf(SIM9H.Com.Ans);
      DecodeData(n,Copy(SIM9H.Com.Ans,1,PosDelim));
      Handled:=True;
     end;
    end;
   end;
   HandleRequest:=Handled;
  end;
  procedure FullReset(gap:Integer);
   procedure Send(data:String);
   begin
    if ComWrite(data) then ViewExp('COM > '+Trim(data));
    bNul(Sleep(gap));
   end;
  begin
   Send('*RST'+CRLF); Send('SRST'+CRLF);
   Send('SNDT '+Str(SIM9H.Pid.Port)+',"*RST"'+CRLF);
  end;
  procedure HandleReset;
  begin
   if iGetTag(SIM9H.GUI.CMD.RESET.tag)<>0 then begin
    bNul(sSetTag(SIM9H.MFR.XIDN.tag,''));
    bNul(sSetTag(SIM9H.PID.XIDN.tag,''));
    FullReset(200);
    bNul(iSetTag(SIM9H.GUI.CMD.RESET.tag,0));
   end;
  end;
  procedure UpdateOpData;
  var n:Integer;
  begin
   for n:=1 to MaxCmdNum do
   if not IsNan(SIM9H.Cmd.OpBuff[n]) then begin
    SIM9H.Cmd.OpData[n]:=SIM9H.Cmd.OpBuff[n];
    SIM9H.Cmd.OpBuff[n]:=_NAN;
   end;
  end;
  procedure HandlePidStrt;
   procedure Send(gap:Integer; data:String);
   begin
    if ComWrite(data) then ViewExp('COM > '+Trim(data));
    bNul(Sleep(gap));
   end;
  begin
   if not IsNan(SIM9H.PID.STRT) then begin
    Send(50,'SNDT '+Str(SIM9H.PID.Port)+',"STRT '+Str(Round(SIM9H.PID.STRT))+'"'+CRLF);
    SIM9H.PID.STRT:=_NAN;
   end;
  end;
  procedure ExecuteIdleActions;
  begin
   HandleReset;
   UpdateOpData;
   HandlePidStrt;
  end;
 begin
  SIM9H.Cmd.Num:=ValidateCmdNum(SIM9H.Cmd.Num);
  if SIM9H.Cmd.Enabled[SIM9H.Cmd.Num] then begin
   if iAnd(DebugFlags,dfDetails)>0 then Details('Run '+Str(RunCount)
    +', Cmd '+SIM9H.Cmd.Acronim[SIM9H.Cmd.Num]
    +', Sta '+Str(SIM9H.Com.Status)
    +', Req '+Trim(SIM9H.Com.Req)
    +', Ans '+Trim(SIM9H.Com.Ans)
    +', Buf '+Trim(SIM9H.Com.Buf)
    );
   if SIM9H.Com.Status=st_NoReq then begin
    ExecuteIdleActions;
    ClearRequest(SIM9H.Cmd.Num,SIM9H.Com.Status);
    if mSecNow>=SIM9H.Com.LastPoll+SIM9H.Com.PollPeriod then PrepareRequest(SIM9H.Cmd.Num,0);
    if Length(SIM9H.Com.Req)=0 then SIM9H.Cmd.Num:=NextCmdNum(SIM9H.Cmd.Num) else begin
     PurgeComPort;
     if ComWrite(SIM9H.Com.Req) then begin
      ViewExp('COM > '+Trim(SIM9H.Com.Req));
      SIM9H.Com.Status:=st_WaitAns;
      SIM9H.Com.ReqTime:=mSecNow;
     end else begin
      Trouble('Could not send request '+SIM9H.Com.Req);
      ClearRequest(NextCmdNum(SIM9H.Cmd.Num),st_NoReq);
     end;
     SIM9H.Com.LastPoll:=mSecNow;
    end;
   end else
   if SIM9H.Com.Status=st_WaitAns then begin
    if IsReqSNDT then begin
     SIM9H.Com.Ans:=SIM9H.Com.Ans+ComRead(255);
     if mSecNow>SIM9H.Com.ReqTime+SIM9H.Com.TimeGap then begin
      SIM9H.Com.Req:=''; SIM9H.Com.Ans:=''; SIM9H.Com.Buf:='';
      Request_GETN(SIM9H.Cmd.Num);
     end else
     if mSecNow>SIM9H.Com.ReqTime+SIM9H.Com.TimeOut then begin
      SIM9H.Com.Status:=st_TimeOut;
     end;
    end else begin
     SIM9H.Com.Ans:=SIM9H.Com.Ans+ComRead(255);
     if HandleRequest(SIM9H.Cmd.Num) then begin
      SIM9H.Com.PollRate:=SIM9H.Com.PollRate+1;
      SIM9H.Com.Status:=st_WaitGap;
      SIM9H.Com.AnsTime:=mSecNow;
     end else
     if mSecNow>SIM9H.Com.ReqTime+SIM9H.Com.TimeOut then begin
      SIM9H.Com.Status:=st_TimeOut;
     end;
    end;
   end;
   if SIM9H.Com.Status=st_WaitGap then begin
    if mSecNow>=SIM9H.Com.AnsTime+SIM9H.Com.TimeGap
    then ClearRequest(NextCmdNum(SIM9H.Cmd.Num),st_NoReq);
   end;
   if SIM9H.Com.Status=st_TimeOut then begin
    if SIM9H.Cmd.Num=cm_MFR_XIDN then UpdateXIDN(SIM9H.MFR.XIDN.tag,si_OFFLINE);
    if SIM9H.Cmd.Num=cm_PID_XIDN then UpdateXIDN(SIM9H.PID.XIDN.tag,si_OFFLINE);
    Failure(SIM9H.ecTimeOut,'TimeOut on command '+SIM9H.Cmd.Acronim[SIM9H.Cmd.Num]+' request '+Trim(SIM9H.Com.Req));
    ClearRequest(NextCmdNum(SIM9H.Cmd.Num),st_NoReq);
   end;
  end else ClearRequest(NextCmdNum(SIM9H.Cmd.Num),st_NoReq);
 end;
 {
 Handle data requests in simulation mode.
 }
 procedure SIM9H_Sim(msg:String);
 var n,m,cmd,port:Integer;
  function EnPackData(data:String):String;
  begin
   if Length(data)>0
   then EnPackData:='#3'+LeftPad(Str(Length(data)),3,'0')+data
   else EnPackData:='';
  end;
 begin
  if Length(msg)>0 then begin
   ViewImp('COM < '+Trim(msg));
   if PosCrLf(msg)>0 then begin
    SIM9H.Com.Req:=Copy(msg,1,PosCrLf(msg)-1);
    if IsSameText(ExtractWord(1,SIM9H.Com.Req),'SNDT')
    then port:=Val(ExtractWord(2,SIM9H.Com.Req)) else port:=0;
    if port>0 then SIM9H.Com.Req:=StrRemoveQuotes(SkipWords(2,SIM9H.Com.Req),'"');
    cmd:=0;
    for n:=1 to MaxCmdNum do if SIM9H.Cmd.Port[n]=port then begin
     if IsSameText(ExtractWord(1,SIM9H.Com.Req),SIM9H.Cmd.Acronim[n]+'?') then cmd:=n;
     if IsSameText(ExtractWord(3,SIM9H.Com.Req),SIM9H.Cmd.Acronim[n]+'?') then cmd:=n;
     if IsSameText(ExtractWord(1,SIM9H.Com.Req),SIM9H.Cmd.Acronim[n])
     then SIM9H.Cmd.OpData[n]:=rVal(ExtractWord(2,SIM9H.Com.Req));
    end;
    if IsValidCmdNum(cmd) then begin
     SIM9H.Com.Ans:=Str(SIM9H.Cmd.OpData[cmd]);
     if cmd=cm_MFR_XIDN then SIM9H.Com.Ans:=si_SRS_MAGIC+',SIM900,s/n123456,ver1.23';
     if cmd=cm_PID_XIDN then SIM9H.Com.Ans:=si_SRS_MAGIC+',SIM960,s/n123456,ver1.23';
    end;
    if port>0 then
    if Length(SIM9H.Com.Ans)>0 then begin
     SIM9H.Com.Buf:=SIM9H.Com.Ans+CRLF;
     SIM9H.Com.Ans:='';
    end;
    if IsSameText(ExtractWord(1,SIM9H.Com.Req),'GETN?') then begin
     m:=Length(SIM9H.Com.Buf);
     if m>10 then m:=Round(Random(10,m));
     SIM9H.Com.Ans:=Copy(SIM9H.Com.Buf,1,m);
     SIM9H.Com.Buf:=Copy(SIM9H.Com.Buf,1+m);
     if Length(SIM9H.Com.Ans)>0 then
     SIM9H.Com.Ans:=EnPackData(SIM9H.Com.Ans);
    end;
    if Length(SIM9H.Com.Ans)>0 then begin
     if ComWrite(SIM9H.Com.Ans+CRLF)
     then ViewExp('COM > '+Trim(SIM9H.Com.Ans))
     else Trouble('Sould no send '+Trim(SIM9H.Com.Ans));
    end;
   end;
  end;
  SIM9H.Com.Req:='';
  SIM9H.Com.Ans:='';
 end;
 {
 Handle GUI commands, edit tags etc.
 }
 procedure SIM9H_GUI_POLL;
 var s:String; ClickCurve:Integer;
  procedure ClickEditPidCmd(n:Integer);
  begin
   if IsValidCmdNum(n) then
   if SIM9H.Cmd.Port[n]=SIM9H.Pid.Port then
   if ClickTag=SIM9H.Cmd.Tag[n] then begin
    DevSendCmd(devMySelf,'@Edit PID.'+SIM9H.Cmd.Acronim[n]);
    bNul(Voice(snd_Click));
   end;
  end;
  procedure ClickCheckPidCmd(n:Integer);
  begin
   if IsValidCmdNum(n) then
   if TypeTag(SIM9H.Cmd.Tag[n])=1 then
   if SIM9H.Cmd.Port[n]=SIM9H.Pid.Port then
   if ClickTag=SIM9H.Cmd.Tag[n] then begin
    DevSendCmd(devMySelf,'@PID.'+SIM9H.Cmd.Acronim[n]+' '+Str(Ord(iGetTag(SIM9H.Cmd.Tag[n])=0)));
    bNul(Voice(snd_Click));
   end;
  end;
  procedure DevSendPidCmd(n:Integer; data:String; min,max:Real);
  var v:Real;
  begin
   if IsValidCmdNum(n) then
   if not IsEmptyStr(data) then
   if SIM9H.Cmd.Port[n]=SIM9H.Pid.Port then
   if TypeTag(SIM9H.Cmd.Tag[n])=1 then begin
    v:=rVal(data);
    if isNan(v) then Problem('Invalid tag edit') else
    if (v<min) or (v>max) then Problem('Tag edit out of range') else
    DevSendCmd(devMySelf,'@PID.'+SIM9H.Cmd.Acronim[n]+' '+Str(Round(v)));
   end else
   if TypeTag(SIM9H.Cmd.Tag[n])=2 then begin
    v:=rVal(data);
    if isNan(v) then Problem('Invalid tag edit') else
    if (v<min) or (v>max) then Problem('Tag edit out of range') else
    DevSendCmd(devMySelf,'@PID.'+SIM9H.Cmd.Acronim[n]+' '+Str(v));
   end else
   if TypeTag(SIM9H.Cmd.Tag[n])=3 then begin
    DevSendCmd(devMySelf,'@PID.'+SIM9H.Cmd.Acronim[n]+' '+Trim(data));
   end;
  end;
  procedure CheckEditPidCmd(n:Integer);
  var s:String;
  begin
   s:='';
   if IsValidCmdNum(n) then
   if SIM9H.Cmd.Port[n]=SIM9H.Pid.Port then
   if CheckEditTag(SIM9H.Cmd.Tag[n],s) then begin
    DevSendPidCmd(n,s,SIM9H.Cmd.Min[n],SIM9H.Cmd.Max[n]);
    sNul(Edit(''));
   end;
   s:='';
  end;
 begin
  s:='';
  //
  // Handle commands...
  //
  if iGetTag(SIM9H.GUI.CMD.HELP.tag)<>0 then begin
   DevPostCmdLocal('@BrowseHelp '+DaqFileRef(AdaptFileName(ReadIni('HelpFile')),'.htm'));
   bNul(iSetTag(SIM9H.GUI.CMD.HELP.tag,0));
  end;
  if iGetTag(SIM9H.GUI.CMD.SAVEINI.tag)<>0 then begin
   bNul(iSetTag(SIM9H.GUI.CMD.SAVEINI.tag,0));
   DevSendCmd(DevMySelf,'@SaveIni');
  end;
  if iGetTag(SIM9H.GUI.CMD.LOADINI.tag)<>0 then begin
   bNul(iSetTag(SIM9H.GUI.CMD.LOADINI.tag,0));
   DevSendCmd(DevMySelf,'@LoadIni');
  end;
  //
  // Handle sensor clicks...
  //
  if ClickButton=1 then begin
   if (ClickTag=SIM9H.MFR.XIDN.tag)
   or (ClickTag=SIM9H.PID.XIDN.tag) then begin
    bNul(sSetTag(ClickTag,''));
    bNul(Voice(snd_Click));
   end;
   if (ClickTag=SIM9H.Cmd.Tag[cm_PID_RMPS]) then begin
    if iGetTag(SIM9H.Cmd.Tag[cm_PID_RMPS])=2 then DevSendCmd(devMySelf,'@PID.STRT 0');
    if iGetTag(SIM9H.Cmd.Tag[cm_PID_RMPS])=3 then DevSendCmd(devMySelf,'@PID.STRT 1');
    bNul(Voice(snd_Click));
   end;
   ClickBitXorLocal(SIM9H.GUI.CMD.HELP.tag,1);
   ClickBitXorLocal(SIM9H.GUI.CMD.RESET.tag,1);
   ClickBitXorLocal(SIM9H.GUI.CMD.SAVEINI.tag,1);
   ClickBitXorLocal(SIM9H.GUI.CMD.LOADINI.tag,1);
   ClickEditPidCmd(cm_PID_GAIN);
   ClickEditPidCmd(cm_PID_INTG);
   ClickEditPidCmd(cm_PID_DERV);
   ClickEditPidCmd(cm_PID_OFST);
   ClickEditPidCmd(cm_PID_SETP);
   ClickEditPidCmd(cm_PID_RATE);
   ClickEditPidCmd(cm_PID_MOUT);
   ClickEditPidCmd(cm_PID_ULIM);
   ClickEditPidCmd(cm_PID_LLIM);
   ClickCheckPidCmd(cm_PID_PCTL);
   ClickCheckPidCmd(cm_PID_ICTL);
   ClickCheckPidCmd(cm_PID_DCTL);
   ClickCheckPidCmd(cm_PID_OCTL);
   ClickCheckPidCmd(cm_PID_AMAN);
   ClickCheckPidCmd(cm_PID_INPT);
   ClickCheckPidCmd(cm_PID_RAMP);
   ClickCheckPidCmd(cm_PID_APOL);
   {
   Plot & Tab windows
   }
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if ClickCurve<>0 then begin
    iNul(WinSelectByCurve(ClickCurve,ClickCurve));
    bNul(Voice(snd_Wheel));
   end;
  end;
  //
  // Edit tags...
  //
  if EditState=ef_Done then begin
   CheckEditPidCmd(cm_PID_GAIN);
   CheckEditPidCmd(cm_PID_INTG);
   CheckEditPidCmd(cm_PID_DERV);
   CheckEditPidCmd(cm_PID_OFST);
   CheckEditPidCmd(cm_PID_SETP);
   CheckEditPidCmd(cm_PID_RATE);
   CheckEditPidCmd(cm_PID_MOUT);
   CheckEditPidCmd(cm_PID_ULIM);
   CheckEditPidCmd(cm_PID_LLIM);
   {
   Warning.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Warning') then sNul(Edit(''));
   {
   Information.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Information') then sNul(Edit(''));
  end;
  if EditState=ef_Done then begin
   Problem('Unknown tag edition!');
   sNul(Edit(''));
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Dialog error detected!');
   sNul(Edit(''));
  end;
  s:='';
 end;
 {
 Initialize tags.
 }
 procedure SIM9H_InitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   InitTag(SIM9H.MFR.XIDN.tag,        Prefix+'.MFR.XIDN',    3);
   InitTag(SIM9H.PID.XIDN.tag,        Prefix+'.PID.XIDN',    3);
   InitTag(SIM9H.GUI.CMD.HELP.tag,    Prefix+'.CMD.HELP',    1);
   InitTag(SIM9H.GUI.CMD.RESET.tag,   Prefix+'.CMD.RESET',   1);
   InitTag(SIM9H.GUI.CMD.SAVEINI.tag, Prefix+'.CMD.SAVEINI', 1);
   InitTag(SIM9H.GUI.CMD.LOADINI.tag, Prefix+'.CMD.LOADINI', 1);
  end;
 end;
 {
 SIM9H cleanup.
 }
 procedure SIM9H_Clear;
 begin
  SIM9H.Com.Req:='';
  SIM9H.Com.Ans:='';
  SIM9H.Com.Buf:='';
  SIM9H_Clear_Cmd;
 end;
 {
 SIM9H initialization.
 }
 procedure SIM9H_Init;
 var i:Integer;
 begin
  //
  // Register error codes
  //
  SIM9H.ecTimeOut:=RegisterErr(progname+': TimeOut');
  //
  // Read ini file variables
  //
  SIM9H.Simulator:=iValDef(ReadIni('Simulator'),0)<>0;
  if SIM9H.Simulator
  then Success('Run simulator mode.')
  else Success('Run as driver mode.');
  SIM9H.PID.Port:=iValDef(ReadIni('PidPort'),0);
  Success('PidPort = '+Str(SIM9H.PID.Port));
  SIM9H.Com.Port:=iValDef(ReadIni('ComPort'),0);
  Success('ComPort = '+Str(SIM9H.Com.Port));
  SIM9H.Com.TimeOut:=iValDef(ReadIni('ComTimeOut'),0);
  Success('ComTimeOut = '+Str(SIM9H.Com.TimeOut));
  SIM9H.Com.TimeGap:=iValDef(ReadIni('ComTimeGap'),0);
  Success('ComTimeGap = '+Str(SIM9H.Com.TimeGap));
  SIM9H.Com.PollPeriod:=iValDef(ReadIni('PollPeriod'),100);
  Success('PollPeriod = '+Str(SIM9H.Com.PollPeriod));
  //
  // Initialize tags...
  //
  SIM9H_InitTags(ReadIni('tagSIM9H'));
  //
  // Initialize COM port
  //
  if ComOpen('[SerialPort-COM'+Str(SIM9H.Com.Port)+']')
  then Success('COM port initialized.')
  else Trouble('COM port failed.');
  //
  // Initialize variables
  //
  SIM9H.Com.ReqTime:=0;
  SIM9H.Com.AnsTime:=0;
  SIM9H.Com.LastPoll:=0;
  SIM9H.Com.Status:=st_NoReq;
  SIM9H_Init_Cmd(SIM9H.PID.Port);
 end;
 {
 SIM9H finalization.
 }
 procedure SIM9H_Free;
 begin
  bNul(ComClose);
 end;
 {
 SIM9H polling.
 }
 procedure SIM9H_Poll;
 begin
  if SIM9H.Simulator then begin
   if ComOpened then SIM9H_Sim(ComRead(255));
  end else begin
   SIM9H_GUI_POLL;
   if SysTimer_Pulse(1000)>0 then begin
    UpdateAo(ao_ERRORCNT,time,GetErrCount(-1));
    UpdateAo(ao_POLLRATE,time,SIM9H.Com.PollRate);
    SIM9H.Com.PollRate:=0;
   end;
   //if SysTimer_Pulse(SIM9H.Com.PollPeriod)>0 then
   //if mSecNow>FixmSecNow+2000 then
   if ComOpened then SIM9H_CMD_CYCLE;
  end;
 end;
 
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  SIM9H_Clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  SIM9H_Init;
  RunStartupScript;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  RunFinallyScript;
  SIM9H_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  SIM9H_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n:Integer;
  procedure SetCommand(n:Integer; v:Real);
  begin
   if IsValidCmdNum(n) then begin
    SIM9H.Cmd.Enabled[n]:=True;
    Success(cmd+' '+Str(v));
    SIM9H.Cmd.OpBuff[n]:=v;
   end;
  end;
  procedure CheckEditCmd(n:Integer);
  begin
   if IsValidCmdNum(n) then
   if TypeTag(SIM9H.Cmd.Tag[n])>=1 then
   if TypeTag(SIM9H.Cmd.Tag[n])<=2 then
   if SIM9H.Cmd.Port[n]=SIM9H.Pid.Port then
   if IsSameText(ExtractWord(1,arg),'PID.'+SIM9H.Cmd.Acronim[n]) then
   StartEditTag(SIM9H.Cmd.Tag[n],SIM9H.Cmd.Acronim[n]+': '+SIM9H.Cmd.Comment[n]);
  end;
  procedure UpdatePidCmd(n:Integer);
  begin
   if IsValidCmdNum(n) then
   if TypeTag(SIM9H.Cmd.Tag[n])>=1 then
   if TypeTag(SIM9H.Cmd.Tag[n])<=2 then
   if SIM9H.Cmd.Port[n]=SIM9H.Pid.Port then
   DevSendCmd(DevMySelf,'@PID.'+SIM9H.Cmd.Acronim[n]+' '+ TagAsText(SIM9H.Cmd.Tag[n]));
  end;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @PID.GAIN 1.0
   @PID.INTG 100.0
   @PID.DERV 0.0
   @PID.OFST 0.0
   }
   for n:=1 to MaxCmdNum do
   if not SIM9H.Simulator then
   if SIM9H.Cmd.Port[n]=SIM9H.PID.Port then
   if IsSameText(cmd,'@PID.'+SIM9H.Cmd.Acronim[n]) then begin
    SetCommand(n,rVal(ExtractWord(1,arg)));
    Data:='';
   end;
   {
   @PID.STRT 0
   }
   if IsSameText(cmd,'@PID.STRT') then begin
    SIM9H.PID.STRT:=rVal(ExtractWord(1,arg));
    Data:='';
   end else
   {
   @Edit PID.GAIN
   @Edit PID.INTG
   @Edit PID.DERV
   @Edit PID.OFST
   @Edit PID.SETP
   @Edit PID.RATE
   @Edit PID.MOUT
   }
   if IsSameText(cmd,'@Edit') then begin
    if not SIM9H.Simulator then begin
     CheckEditCmd(cm_PID_GAIN);
     CheckEditCmd(cm_PID_INTG);
     CheckEditCmd(cm_PID_DERV);
     CheckEditCmd(cm_PID_OFST);
     CheckEditCmd(cm_PID_SETP);
     CheckEditCmd(cm_PID_RATE);
     CheckEditCmd(cm_PID_MOUT);
     CheckEditCmd(cm_PID_ULIM);
     CheckEditCmd(cm_PID_LLIM);
    end;
    Data:='';
   end else
   {
   @LoadIni
   }
   if IsSameText(cmd,'@LoadIni') then begin
    if not SIM9H.Simulator then begin
     iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
     UpdatePidCmd(cm_PID_PCTL);
     UpdatePidCmd(cm_PID_ICTL);
     UpdatePidCmd(cm_PID_DCTL);
     UpdatePidCmd(cm_PID_OCTL);
     UpdatePidCmd(cm_PID_GAIN);
     UpdatePidCmd(cm_PID_INTG);
     UpdatePidCmd(cm_PID_DERV);
     UpdatePidCmd(cm_PID_OFST);
     UpdatePidCmd(cm_PID_AMAN);
     UpdatePidCmd(cm_PID_INPT);
     UpdatePidCmd(cm_PID_SETP);
     UpdatePidCmd(cm_PID_RAMP);
     UpdatePidCmd(cm_PID_RATE);
     UpdatePidCmd(cm_PID_ULIM);
     UpdatePidCmd(cm_PID_LLIM);
     UpdatePidCmd(cm_PID_MOUT);
     UpdatePidCmd(cm_PID_APOL);
    end;
    Data:='';
   end else
   {
   @SaveIni
   }
   if IsSameText(cmd,'@SaveIni') then begin
    if not SIM9H.Simulator then
    iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
