package spark.skins.spark
{
   import mx.core.UIComponent;
   import mx.core.IDataRenderer;
   import spark.components.IItemRenderer;
   import mx.core.mx_internal;
   import mx.events.FlexEvent;
   import spark.components.supportClasses.TextBase;
   import spark.components.Label;
   import flash.display.DisplayObject;
   import flash.events.MouseEvent;
   
   use namespace mx_internal;
   
   [Exclude(kind="style",name="focusThickness")]
   [Exclude(kind="style",name="focusBlendMode")]
   [Style(inherit="yes",name="symbolColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="rollOverColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="focusColor",format="Color",theme="spark",type="uint")]
   [Style(arrayType="uint",inherit="yes",name="alternatingItemColors",format="Color",theme="spark",type="Array")]
   [Style(inherit="yes",name="unfocusedTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="inactiveTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="focusedTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="whiteSpaceCollapse",type="String",enumeration="collapse,preserve")]
   [Style(inherit="yes",name="textRotation",type="String",enumeration="auto,rotate0,rotate90,rotate180,rotate270")]
   [Style(minValue="0.0",inherit="yes",name="textIndent",format="Length",type="Number")]
   [Style(inherit="yes",name="tabStops",type="String")]
   [Style(inherit="yes",name="paragraphStartIndent",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphSpaceBefore",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphSpaceAfter",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphEndIndent",format="length",type="Number")]
   [Style(inherit="yes",name="leadingModel",type="String",enumeration="auto,romanUp,ideographicTopUp,ideographicCenterUp,ideographicTopDown,ideographicCenterDown,ascentDescentUp")]
   [Style(inherit="yes",name="firstBaselineOffset",type="Object")]
   [Style(inherit="yes",name="breakOpportunity",type="String",enumeration="auto,all,any,none")]
   [Style(inherit="yes",name="blockProgression",type="String",enumeration="tb,rl")]
   [Style(inherit="yes",name="typographicCase",type="String",enumeration="default,capsToSmallCaps,uppercase,lowercase,lowercaseToSmallCaps")]
   [Style(inherit="yes",name="trackingRight",type="Object")]
   [Style(inherit="yes",name="trackingLeft",type="Object")]
   [Style(inherit="yes",name="textJustify",type="String",enumeration="interWord,distribute")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="textAlpha",type="Number")]
   [Style(inherit="yes",name="textAlignLast",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="renderingMode",type="String",enumeration="cff,normal")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="lineThrough",type="Boolean")]
   [Style(inherit="yes",name="lineHeight",type="Object")]
   [Style(inherit="yes",name="ligatureLevel",type="String",enumeration="common,minimum,uncommon,exotic")]
   [Style(inherit="yes",name="kerning",type="String",enumeration="auto,on,off")]
   [Style(inherit="yes",name="justificationStyle",type="String",enumeration="auto,prioritizeLeastAdjustment,pushInKinsoku,pushOutOnly")]
   [Style(inherit="yes",name="justificationRule",type="String",enumeration="auto,space,eastAsian")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(minValue="1.0",maxValue="720.0",inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontLookup",type="String",enumeration="auto,device,embeddedCFF")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="dominantBaseline",type="String",enumeration="auto,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl")]
   [Style(inherit="yes",name="digitWidth",type="String",enumeration="default,proportional,tabular")]
   [Style(inherit="yes",name="digitCase",type="String",enumeration="default,lining,oldStyle")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(inherit="yes",name="cffHinting",type="String",enumeration="horizontalStem,none")]
   [Style(inherit="yes",name="baselineShift",type="Object")]
   [Style(inherit="yes",name="alignmentBaseline",type="String",enumeration="useDominantBaseline,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Event(name="dataChange",type="mx.events.FlexEvent")]
   public class DefaultItemRenderer extends UIComponent implements IDataRenderer, IItemRenderer
   {
       
      private var hovered:Boolean = false;
      
      private var _data:Object;
      
      private var _itemIndex:int;
      
      private var _label:String = "";
      
      public var labelDisplay:TextBase;
      
      private var _showsCaret:Boolean = false;
      
      private var _selected:Boolean = false;
      
      private var _dragging:Boolean = false;
      
      public function DefaultItemRenderer()
      {
         super();
         this.addHandlers();
      }
      
      override public function get baselinePosition() : Number
      {
         if(Boolean(!this.labelDisplay) || Boolean(!validateBaselinePosition()))
         {
            return super.baselinePosition;
         }
         return this.labelDisplay.y + this.labelDisplay.baselinePosition;
      }
      
      [Bindable("dataChange")]
      public function get data() : Object
      {
         return this._data;
      }
      
      public function set data(value:Object) : void
      {
         this._data = value;
         dispatchEvent(new FlexEvent(FlexEvent.DATA_CHANGE));
      }
      
      public function get itemIndex() : int
      {
         return this._itemIndex;
      }
      
      public function set itemIndex(value:int) : void
      {
         if(value == this._itemIndex)
         {
            return;
         }
         this._itemIndex = value;
         invalidateDisplayList();
      }
      
      public function get label() : String
      {
         return this._label;
      }
      
      public function set label(value:String) : void
      {
         if(value == this._label)
         {
            return;
         }
         this._label = value;
         if(this.labelDisplay)
         {
            this.labelDisplay.text = this._label;
         }
      }
      
      public function get showsCaret() : Boolean
      {
         return this._showsCaret;
      }
      
      public function set showsCaret(value:Boolean) : void
      {
         if(value == this._showsCaret)
         {
            return;
         }
         this._showsCaret = value;
         invalidateDisplayList();
      }
      
      public function get selected() : Boolean
      {
         return this._selected;
      }
      
      public function set selected(value:Boolean) : void
      {
         if(value != this._selected)
         {
            this._selected = value;
            invalidateDisplayList();
         }
      }
      
      public function get dragging() : Boolean
      {
         return this._dragging;
      }
      
      public function set dragging(value:Boolean) : void
      {
         if(value == this._dragging)
         {
            return;
         }
         this._dragging = value;
      }
      
      override protected function createChildren() : void
      {
         super.createChildren();
         if(!this.labelDisplay)
         {
            this.labelDisplay = new Label();
            addChild(DisplayObject(this.labelDisplay));
            if(this._label != "")
            {
               this.labelDisplay.text = this._label;
            }
         }
      }
      
      override protected function measure() : void
      {
         super.measure();
         measuredWidth = this.labelDisplay.getPreferredBoundsWidth() + 6;
         measuredHeight = this.labelDisplay.getPreferredBoundsHeight() + 10;
         measuredMinWidth = this.labelDisplay.getMinBoundsWidth() + 6;
         measuredMinHeight = this.labelDisplay.getMinBoundsHeight() + 10;
      }
      
      override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         var backgroundColor:uint = 0;
         var alternatingColors:Array = null;
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         graphics.clear();
         var drawBackground:Boolean = true;
         if(this.selected)
         {
            backgroundColor = getStyle("selectionColor");
         }
         else if(this.hovered)
         {
            backgroundColor = getStyle("rollOverColor");
         }
         else
         {
            alternatingColors = getStyle("alternatingItemColors");
            if(Boolean(alternatingColors) && Boolean(alternatingColors.length > 0))
            {
               styleManager.getColorNames(alternatingColors);
               backgroundColor = alternatingColors[this.itemIndex % alternatingColors.length];
            }
            else
            {
               drawBackground = false;
            }
         }
         graphics.beginFill(backgroundColor,!!drawBackground?Number(1):Number(0));
         if(this.showsCaret)
         {
            graphics.lineStyle(1,getStyle("selectionColor"));
            graphics.drawRect(0.5,0.5,unscaledWidth - 1,unscaledHeight - 1);
         }
         else
         {
            graphics.lineStyle();
            graphics.drawRect(0,0,unscaledWidth,unscaledHeight);
         }
         graphics.endFill();
         var childWidth:Number = unscaledWidth - 6;
         childWidth = Math.max(this.labelDisplay.getMinBoundsWidth(),Math.min(this.labelDisplay.getMaxBoundsWidth(),childWidth));
         var childHeight:Number = unscaledHeight - 10;
         childHeight = Math.max(this.labelDisplay.getMinBoundsHeight(),Math.min(this.labelDisplay.getMaxBoundsHeight(),childHeight));
         this.labelDisplay.setLayoutBoundsSize(childWidth,childHeight);
         this.labelDisplay.setLayoutBoundsPosition(3,5);
      }
      
      private function addHandlers() : void
      {
         addEventListener(MouseEvent.ROLL_OVER,this.itemRenderer_rollOverHandler);
         addEventListener(MouseEvent.ROLL_OUT,this.itemRenderer_rollOutHandler);
      }
      
      private function anyButtonDown(event:MouseEvent) : Boolean
      {
         var type:String = event.type;
         return Boolean(event.buttonDown) || Boolean(type == "middleMouseDown") || Boolean(type == "rightMouseDown");
      }
      
      protected function itemRenderer_rollOverHandler(event:MouseEvent) : void
      {
         if(!this.anyButtonDown(event))
         {
            this.hovered = true;
            invalidateDisplayList();
         }
      }
      
      protected function itemRenderer_rollOutHandler(event:MouseEvent) : void
      {
         this.hovered = false;
         invalidateDisplayList();
      }
   }
}
