package spark.effects.interpolation
{
   import mx.resources.IResourceManager;
   import mx.resources.ResourceManager;
   
   [ResourceBundle("sparkEffects")]
   public class NumberInterpolator implements IInterpolator
   {
      
      private static var theInstance:spark.effects.interpolation.NumberInterpolator;
       
      private var resourceManager:IResourceManager;
      
      public function NumberInterpolator()
      {
         this.resourceManager = ResourceManager.getInstance();
         super();
      }
      
      public static function getInstance() : spark.effects.interpolation.NumberInterpolator
      {
         if(!theInstance)
         {
            theInstance = new spark.effects.interpolation.NumberInterpolator();
         }
         return theInstance;
      }
      
      public function interpolate(fraction:Number, startValue:Object, endValue:Object) : Object
      {
         if(fraction == 0)
         {
            return startValue;
         }
         if(fraction == 1)
         {
            return endValue;
         }
         if(Boolean(startValue is Number) && Boolean(isNaN(Number(startValue))) || Boolean(endValue is Number) && Boolean(isNaN(Number(endValue))))
         {
            throw new Error(this.resourceManager.getString("sparkEffects","cannotCalculateValue",[startValue,endValue]));
         }
         return Number(startValue) + fraction * (Number(endValue) - Number(startValue));
      }
      
      public function increment(baseValue:Object, incrementValue:Object) : Object
      {
         return Number(baseValue) + Number(incrementValue);
      }
      
      public function decrement(baseValue:Object, decrementValue:Object) : Object
      {
         return Number(baseValue) - Number(decrementValue);
      }
   }
}
