package spark.effects.animation
{
   import mx.core.mx_internal;
   import spark.effects.interpolation.IInterpolator;
   import spark.effects.interpolation.NumberInterpolator;
   
   use namespace mx_internal;
   
   [DefaultProperty("keyframes")]
   public class MotionPath
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public var property:String;
      
      public var interpolator:IInterpolator;
      
      public var keyframes:Vector.<spark.effects.animation.Keyframe>;
      
      public function MotionPath(property:String = null)
      {
         this.interpolator = NumberInterpolator.getInstance();
         super();
         this.property = property;
      }
      
      public function clone() : MotionPath
      {
         var i:int = 0;
         var mp:MotionPath = new MotionPath(this.property);
         mp.interpolator = this.interpolator;
         if(this.keyframes !== null)
         {
            mp.keyframes = new Vector.<Keyframe>();
            for(i = 0; i < this.keyframes.length; i++)
            {
               mp.keyframes[i] = this.keyframes[i].clone();
            }
         }
         return mp;
      }
      
      mx_internal function scaleKeyframes(duration:Number) : void
      {
         var i:int = 0;
         var kf:spark.effects.animation.Keyframe = null;
         for(var n:int = this.keyframes.length; i < n; )
         {
            kf = this.keyframes[i];
            kf.timeFraction = kf.time / duration;
            i++;
         }
      }
      
      public function getValue(fraction:Number) : Object
      {
         var easedF:Number = NaN;
         var kf:spark.effects.animation.Keyframe = null;
         var t:Number = NaN;
         var easedT:Number = NaN;
         if(!this.keyframes)
         {
            return null;
         }
         var n:int = this.keyframes.length;
         if(Boolean(n == 2) && Boolean(this.keyframes[1].timeFraction == 1))
         {
            easedF = Boolean(this.keyframes[1].easer)?Number(this.keyframes[1].easer.ease(fraction)):Number(fraction);
            return this.interpolator.interpolate(easedF,this.keyframes[0].value,this.keyframes[1].value);
         }
         if(isNaN(this.keyframes[0].timeFraction))
         {
            this.scaleKeyframes(this.keyframes[this.keyframes.length - 1].time);
         }
         var prevT:Number = 0;
         var prevValue:Object = this.keyframes[0].value;
         for(var i:int = 1; i < n; i++)
         {
            kf = this.keyframes[i];
            if(Boolean(fraction >= prevT) && Boolean(fraction < kf.timeFraction))
            {
               t = (fraction - prevT) / (kf.timeFraction - prevT);
               easedT = Boolean(kf.easer)?Number(kf.easer.ease(t)):Number(t);
               return this.interpolator.interpolate(easedT,prevValue,kf.value);
            }
            prevT = kf.timeFraction;
            prevValue = kf.value;
         }
         return this.keyframes[n - 1].value;
      }
   }
}
