package org.alivepdf.fonts
{
   import flash.events.EventDispatcher;
   import flash.events.Event;
   
   public class CoreFont implements IFont
   {
       
      protected var _type:String;
      
      protected var _name:String;
      
      protected var _underlinePosition:int = -100;
      
      protected var _underlineThickness:int = 50;
      
      protected var _charactersWidth:Object;
      
      protected var _numGlyphs:int;
      
      protected var _resourceId:int;
      
      protected var _id:int;
      
      protected var dispatcher:EventDispatcher;
      
      public function CoreFont(name:String = "Helvetica")
      {
         super();
         this.dispatcher = new EventDispatcher();
         this._name = name;
         this._type = FontType.TYPE1;
         var metrics:FontMetrics = new FontMetrics();
         this._charactersWidth = FontMetrics.lookUp(name);
      }
      
      public function get charactersWidth() : Object
      {
         return this._charactersWidth;
      }
      
      public function get name() : String
      {
         return this._name;
      }
      
      public function get numGlyphs() : int
      {
         return this._numGlyphs;
      }
      
      public function get type() : String
      {
         return this._type;
      }
      
      public function get id() : int
      {
         return this._id;
      }
      
      public function set id(id:int) : void
      {
         this._id = id;
      }
      
      public function get underlineThickness() : int
      {
         return this._underlineThickness;
      }
      
      public function get underlinePosition() : int
      {
         return this._underlinePosition;
      }
      
      public function get resourceId() : int
      {
         return this._resourceId;
      }
      
      public function set resourceId(resourceId:int) : void
      {
         this._resourceId = resourceId;
      }
      
      public function toString() : String
      {
         return "[CoreFont name=" + this.name + " type=Type1]";
      }
      
      public function addEventListener(type:String, listener:Function, useCapture:Boolean = false, priority:int = 0, useWeakReference:Boolean = false) : void
      {
         this.dispatcher.addEventListener(type,listener,useCapture,priority,useWeakReference);
      }
      
      public function dispatchEvent(event:Event) : Boolean
      {
         return this.dispatcher.dispatchEvent(event);
      }
      
      public function hasEventListener(type:String) : Boolean
      {
         return this.dispatcher.hasEventListener(type);
      }
      
      public function removeEventListener(type:String, listener:Function, useCapture:Boolean = false) : void
      {
         this.dispatcher.removeEventListener(type,listener,useCapture);
      }
      
      public function willTrigger(type:String) : Boolean
      {
         return this.dispatcher.willTrigger(type);
      }
   }
}
