package mx.states
{
   import mx.utils.OnDemandEventDispatcher;
   import mx.core.UIComponent;
   import mx.events.PropertyChangeEvent;
   
   public class OverrideBase extends OnDemandEventDispatcher implements IOverride
   {
       
      protected var applied:Boolean = false;
      
      protected var parentContext:UIComponent;
      
      private var targetProperty:String;
      
      public function OverrideBase()
      {
         super();
      }
      
      public function initialize() : void
      {
      }
      
      public function apply(parent:UIComponent) : void
      {
      }
      
      public function remove(parent:UIComponent) : void
      {
      }
      
      public function initializeFromObject(properties:Object) : Object
      {
         var p:* = null;
         for(p in properties)
         {
            this[p] = properties[p];
         }
         return Object(this);
      }
      
      protected function getOverrideContext(target:Object, parent:UIComponent) : Object
      {
         if(target == null)
         {
            return parent;
         }
         if(target is String)
         {
            return parent[target];
         }
         return target;
      }
      
      protected function addContextListener(target:Object) : void
      {
         if(Boolean(target is String) && Boolean(this.parentContext != null))
         {
            this.targetProperty = target as String;
            this.parentContext.addEventListener(PropertyChangeEvent.PROPERTY_CHANGE,this.context_propertyChangeHandler);
         }
      }
      
      protected function removeContextListener() : void
      {
         if(this.parentContext != null)
         {
            this.parentContext.removeEventListener(PropertyChangeEvent.PROPERTY_CHANGE,this.context_propertyChangeHandler);
         }
      }
      
      protected function context_propertyChangeHandler(event:PropertyChangeEvent) : void
      {
         if(Boolean(event.property == this.targetProperty) && Boolean(event.newValue != null))
         {
            this.apply(this.parentContext);
            this.removeContextListener();
         }
      }
   }
}
