package flashx.textLayout.property
{
   import flashx.textLayout.tlf_internal;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class IntWithEnumProperty extends IntProperty
   {
       
      private var _range:Object;
      
      private var _defaultValue:Object;
      
      public function IntWithEnumProperty(nameValue:String, defaultValue:Object, inherited:Boolean, category:String, minValue:int, maxValue:int, ... rest)
      {
         this._range = EnumStringProperty.createRange(rest);
         var defaultIsEnum:Boolean = Boolean(defaultValue is String) && Boolean(this._range.hasOwnProperty(defaultValue));
         var numberDefault:int = !!defaultIsEnum?int(0):int(int(defaultValue));
         super(nameValue,numberDefault,inherited,category,minValue,maxValue);
         this._defaultValue = defaultValue;
      }
      
      override public function get defaultValue() : Object
      {
         return this._defaultValue;
      }
      
      public function get range() : Object
      {
         return Property.shallowCopy(this._range);
      }
      
      override public function setHelper(currVal:*, newObject:*) : *
      {
         if(newObject === null)
         {
            newObject = undefined;
         }
         if(newObject === undefined)
         {
            return newObject;
         }
         return !!this._range.hasOwnProperty(newObject)?newObject:super.setHelper(currVal,newObject);
      }
      
      override public function hash(val:Object, seed:uint) : uint
      {
         var hash:uint = this._range[val];
         if(hash != 0)
         {
            return UintProperty.doHash(hash,seed);
         }
         return super.hash(val,seed);
      }
   }
}
