package flashx.textLayout.operations
{
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.elements.SpanElement;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.edit.ParaEdit;
   import flashx.textLayout.elements.FlowLeafElement;
   import flash.utils.getQualifiedClassName;
   import flashx.textLayout.edit.SelectionState;
   
   use namespace tlf_internal;
   
   public class SplitParagraphOperation extends FlowTextOperation
   {
       
      private var delSelOp:flashx.textLayout.operations.DeleteTextOperation;
      
      private var _characterFormat:ITextLayoutFormat;
      
      public function SplitParagraphOperation(operationState:SelectionState)
      {
         super(operationState);
         this.characterFormat = operationState.pointFormat;
      }
      
      private function get characterFormat() : ITextLayoutFormat
      {
         return this._characterFormat;
      }
      
      private function set characterFormat(value:ITextLayoutFormat) : void
      {
         this._characterFormat = Boolean(value)?new TextLayoutFormat(value):null;
      }
      
      override public function doOperation() : Boolean
      {
         var newCharAttrs:TextLayoutFormat = null;
         var elementIdx:int = 0;
         var prevSpan:SpanElement = null;
         if(absoluteStart < absoluteEnd)
         {
            this.delSelOp = new flashx.textLayout.operations.DeleteTextOperation(originalSelectionState);
            this.delSelOp.doOperation();
         }
         var para:ParagraphElement = textFlow.findAbsoluteParagraph(absoluteStart);
         var paraSelBegIdx:int = absoluteStart - para.getAbsoluteStart();
         var nextPara:ParagraphElement = ParaEdit.splitParagraph(para,paraSelBegIdx,this._characterFormat);
         if(textFlow.interactionManager)
         {
            textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,1);
         }
         var lastParaLeaf:FlowLeafElement = para.getLastLeaf();
         if(Boolean(lastParaLeaf != null) && Boolean(lastParaLeaf.textLength == 1))
         {
            elementIdx = lastParaLeaf.parent.getChildIndex(lastParaLeaf);
            if(elementIdx > 0)
            {
               prevSpan = lastParaLeaf.parent.getChildAt(elementIdx - 1) as SpanElement;
               if(prevSpan != null)
               {
                  lastParaLeaf = prevSpan;
               }
            }
         }
         var firstNextParaLeaf:FlowLeafElement = nextPara.getFirstLeaf();
         if(getQualifiedClassName(lastParaLeaf.parent) != getQualifiedClassName(firstNextParaLeaf.parent))
         {
            newCharAttrs = new TextLayoutFormat();
         }
         else
         {
            newCharAttrs = new TextLayoutFormat(this._characterFormat);
            if(nextPara.textLength == 1)
            {
               if(lastParaLeaf.format != null)
               {
                  newCharAttrs.concat(lastParaLeaf.format);
               }
            }
            else
            {
               newCharAttrs.concat(lastParaLeaf.computedFormat);
               newCharAttrs.removeMatching(firstNextParaLeaf.computedFormat);
            }
         }
         return true;
      }
      
      override public function undo() : SelectionState
      {
         var para:ParagraphElement = textFlow.findAbsoluteParagraph(absoluteStart);
         ParaEdit.mergeParagraphWithNext(para);
         if(textFlow.interactionManager)
         {
            textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,-1);
         }
         return absoluteStart < absoluteEnd?this.delSelOp.undo():originalSelectionState;
      }
      
      override tlf_internal function merge(operation:FlowOperation) : FlowOperation
      {
         if(this.endGeneration != operation.beginGeneration)
         {
            return null;
         }
         if(Boolean(operation is SplitParagraphOperation) || Boolean(operation is InsertTextOperation))
         {
            return new CompositeOperation([this,operation]);
         }
         return null;
      }
   }
}
