package com.beka.util.calc
{
   import com.beka.util.EECalculator;
   
   public class Calc_ti
   {
       
      private var cei:com.beka.util.calc.Calc_ei;
      
      public function Calc_ti(cei:com.beka.util.calc.Calc_ei)
      {
         super();
         this.cei = cei;
      }
      
      public function calculate(p:Number, t:Number, e:Number) : Number
      {
         if(Boolean(p > 1500) || Boolean(p <= 0))
         {
            return NaN;
         }
         if(Boolean(e > this.cei.calculate(p,0.01,true)) || Boolean(e < this.cei.calculate(p,-100,true)))
         {
            return NaN;
         }
         if(t > 0.01)
         {
            return NaN;
         }
         var a:Number = 0.000575;
         var ti:Number = NaN;
         var tiMax:Number = 0.01;
         var tiMin:Number = -100;
         var pist:Number = 1000000;
         var cnt:int = 0;
         while(Boolean(Math.abs(e / pist - 1) > 1.0e-6) && Boolean(cnt < EECalculator.MAX_ITERATIONS))
         {
            ti = (tiMax + tiMin) / 2;
            pist = this.cei.calculate(p,ti,false) - a * p * (t - ti);
            if(pist > e)
            {
               tiMax = ti;
            }
            else
            {
               tiMin = ti;
            }
            cnt++;
         }
         return ti;
      }
   }
}
