package com.beka.util.calc
{
   public class Calc_ew
   {
       
      private var n0:Array;
      
      private var n1:Array;
      
      private var a0:Array;
      
      private var b0:Array;
      
      private var a1:Array;
      
      private var b1:Array;
      
      public function Calc_ew()
      {
         super();
         this.n0 = new Array();
         this.n0[0] = -6096.9385;
         this.n0[1] = 16.635794;
         this.n0[2] = -0.02711193;
         this.n0[3] = 0.00001673952;
         this.n0[4] = 2.433502;
         this.n1 = new Array();
         this.n1[0] = 1167.0521452767;
         this.n1[1] = -724213.16703206;
         this.n1[2] = -17.073846940092;
         this.n1[3] = 12020.82470247;
         this.n1[4] = -3232555.0322333;
         this.n1[5] = 14.91510861353;
         this.n1[6] = -4823.2657361591;
         this.n1[7] = 405113.40542057;
         this.n1[8] = -0.23855557567849;
         this.n1[9] = 650.17534844798;
         this.a0 = new Array();
         this.a0[0] = 0.000362183;
         this.a0[1] = 0.000026061244;
         this.a0[2] = 3.866777e-7;
         this.a0[3] = 3.8268958e-9;
         this.b0 = new Array();
         this.b0[0] = -10.7604;
         this.b0[1] = 0.063987441;
         this.b0[2] = -0.00026351566;
         this.b0[3] = 1.672508e-6;
         this.a1 = new Array();
         this.a1[0] = 0.000353624;
         this.a1[1] = 0.000029328363;
         this.a1[2] = 2.6168979e-7;
         this.a1[3] = 8.5813609e-9;
         this.b1 = new Array();
         this.b1[0] = -10.7588;
         this.b1[1] = 0.063268134;
         this.b1[2] = -0.00025368934;
         this.b1[3] = 6.3405286e-7;
      }
      
      public function calculate(p:Number, t:Number, clean:Boolean) : Number
      {
         var ew:Number = 0;
         if(Boolean(t >= -106) && Boolean(t <= 100))
         {
            ew = this.calcLow(t);
         }
         else if(Boolean(t > 100) && Boolean(t <= 220))
         {
            ew = this.calcHigh(t);
         }
         else
         {
            return NaN;
         }
         if(clean)
         {
            return ew;
         }
         return ew * this.fw(p,t,ew);
      }
      
      public function calcLow(t:Number) : Number
      {
         t = t + 273.15;
         var x0:Number = this.n0[0] / t;
         var x1:Number = this.n0[1];
         var x2:Number = this.n0[2] * t;
         var x3:Number = this.n0[3] * Math.pow(t,2);
         var x4:Number = this.n0[4] * Math.log(t);
         return Math.exp(x0 + x1 + x2 + x3 + x4);
      }
      
      private function calcHigh(t:Number) : Number
      {
         t = t + 273.15;
         var theta:Number = t + this.n1[8] / (t - this.n1[9]);
         var A:Number = Math.pow(theta,2) + this.n1[0] * theta + this.n1[1];
         var B:Number = this.n1[2] * Math.pow(theta,2) + this.n1[3] * theta + this.n1[4];
         var C:Number = this.n1[5] * Math.pow(theta,2) + this.n1[6] * theta + this.n1[7];
         var ps:Number = Math.pow(2 * C / (B * -1 + Math.pow(Math.pow(B,2) - 4 * A * C,0.5)),4);
         return ps * 10000;
      }
      
      public function fw(p:Number, t:Number, ew:Number) : Number
      {
         var i:int = 0;
         var j:int = 0;
         if(Boolean(t > 220) || Boolean(t < -105))
         {
            return NaN;
         }
         var alpha:Number = 0;
         var beta:Number = 0;
         if(ew > p)
         {
            return 1;
         }
         if(t < 0)
         {
            for(i = 0; i < 4; i++)
            {
               alpha = alpha + this.a0[i] * Math.pow(t,i);
               beta = beta + this.b0[i] * Math.pow(t,i);
            }
         }
         else
         {
            for(j = 0; j < 4; j++)
            {
               alpha = alpha + this.a1[j] * Math.pow(t,j);
               beta = beta + this.b1[j] * Math.pow(t,j);
            }
         }
         beta = Math.exp(beta);
         var result:Number = Math.exp(alpha * (1 - ew / p) + beta * (p / ew - 1));
         if(result < 1)
         {
            return 1;
         }
         return result;
      }
   }
}
