package com.beka.feuchterechner
{
   import mx.core.BitmapAsset;
   import mx.resources.IResourceManager;
   import flash.net.FileReference;
   import org.alivepdf.pdf.PDF;
   import org.alivepdf.layout.Orientation;
   import org.alivepdf.layout.Unit;
   import org.alivepdf.layout.Size;
   import org.alivepdf.fonts.CoreFont;
   import org.alivepdf.fonts.FontFamily;
   import org.alivepdf.colors.RGBColor;
   import org.alivepdf.layout.Resize;
   import org.alivepdf.layout.Mode;
   import org.alivepdf.layout.Position;
   import org.alivepdf.data.GridColumn;
   import org.alivepdf.layout.Align;
   import org.alivepdf.data.Grid;
   import org.alivepdf.drawing.Joint;
   import org.alivepdf.links.HTTPLink;
   import org.alivepdf.saving.Method;
   import flash.utils.ByteArray;
   
   public class PDFCreator
   {
      
      private static var instance:com.beka.feuchterechner.PDFCreator;
       
      private var curDate:Date;
      
      public function PDFCreator()
      {
         super();
         this.curDate = new Date();
      }
      
      public static function getInstance() : com.beka.feuchterechner.PDFCreator
      {
         if(instance == null)
         {
            instance = new com.beka.feuchterechner.PDFCreator();
         }
         return instance;
      }
      
      public function genPDF(data:Array, logo:BitmapAsset, footer:BitmapAsset, resourceManager:IResourceManager) : void
      {
         var file:FileReference = new FileReference();
         var pdf:PDF = new PDF(Orientation.PORTRAIT,Unit.MM,Size.A4);
         pdf.addPage();
         pdf.setFont(new CoreFont(FontFamily.ARIAL),12,false);
         pdf.textStyle(new RGBColor(0));
         var res:Resize = new Resize(Mode.FIT_TO_PAGE,Position.LEFT);
         pdf.addImage(logo,res);
         var gridColumnName:GridColumn = new GridColumn(resourceManager.getString("locale","name"),"name",95,Align.CENTER,Align.LEFT);
         var gridColumnValue:GridColumn = new GridColumn(resourceManager.getString("locale","value"),"value",25,Align.CENTER,Align.RIGHT);
         var gridColumnType:GridColumn = new GridColumn(resourceManager.getString("locale","unit"),"type",20,Align.CENTER,Align.LEFT);
         var gridColumnDev:GridColumn = new GridColumn(resourceManager.getString("locale","dev"),"dev",30,Align.CENTER,Align.CENTER);
         var gridColumnSym:GridColumn = new GridColumn(resourceManager.getString("locale","symbol"),"range",20,Align.CENTER,Align.CENTER);
         var columns:Array = new Array(gridColumnName,gridColumnSym,gridColumnValue,gridColumnDev,gridColumnType);
         pdf.addText(resourceManager.getString("locale","input") + ":",10,48);
         var grid:Grid = new Grid(data.splice(0,3),400,120,new RGBColor(6402081),new RGBColor(13624759),true,new RGBColor(0),1,Joint.ROUND,columns);
         pdf.setXY(10,50);
         pdf.addGrid(grid);
         pdf.addText(resourceManager.getString("locale","output") + ":",10,78);
         grid = new Grid(data,400,120,new RGBColor(6402081),new RGBColor(13624759),true,new RGBColor(0),1,Joint.ROUND,columns);
         pdf.setXY(10,80);
         pdf.addGrid(grid);
         pdf.addImage(footer,res,0,250);
         var pdfURL:HTTPLink = new HTTPLink("http://www.epluse.com/");
         pdf.addLink(150,283,45,10,pdfURL);
         var ba:ByteArray = pdf.save(Method.LOCAL);
         file.save(ba,"EECalc-" + this.curDate.getDate() + "-" + (this.curDate.getMonth() + 1) + "-" + this.curDate.getFullYear() + ".pdf");
      }
   }
}
