package com.beka.feuchterechner
{
   public class Converter
   {
      
      private static var instance:com.beka.feuchterechner.Converter;
       
      public function Converter()
      {
         super();
      }
      
      public static function getInstance() : com.beka.feuchterechner.Converter
      {
         if(instance == null)
         {
            instance = new com.beka.feuchterechner.Converter();
         }
         return instance;
      }
      
      public function convert(oldType:String, newType:String, value:Number) : Number
      {
         switch(oldType)
         {
            case "celsius":
            case "fahrenheit":
            case "kelvin":
               return this.convertTemperature(oldType,newType,value);
            case "hpa":
            case "psi":
               return this.convertPressure(oldType,newType,value);
            case "gkg":
            case "grlb":
               return this.convertMassPerMass(oldType,newType,value);
            case "gm3":
            case "grft3":
               return this.convertMassPerVolume(oldType,newType,value);
            case "per":
            case "ooo":
            case "ppm":
               return this.convertWv(oldType,newType,value);
            default:
               return value;
         }
      }
      
      public function convertDev(oldType:String, newType:String, value:Number) : Number
      {
         switch(oldType)
         {
            case "celsius":
            case "fahrenheit":
            case "kelvin":
               return this.convertTemperatureDev(oldType,newType,value);
            case "hpa":
            case "psi":
               return this.convertPressure(oldType,newType,value);
            case "gkg":
            case "grlb":
               return this.convertMassPerMass(oldType,newType,value);
            case "gm3":
            case "grft3":
               return this.convertMassPerVolume(oldType,newType,value);
            case "per":
            case "ooo":
            case "ppm":
               return this.convertWv(oldType,newType,value);
            case "btulb":
            case "kjkg":
               return this.convertHDev(oldType,newType,value);
            default:
               return value;
         }
      }
      
      public function converth(oldType:String, newType:String, h:Number, r:Number) : Number
      {
         if(oldType == "btulb")
         {
            h = this.btulbToKjkg(h,r);
         }
         if(newType == "btulb")
         {
            h = this.kjkgToBtulb(h,r);
         }
         return h;
      }
      
      private function convertTemperatureDev(oldType:String, newType:String, value:Number) : Number
      {
         if(oldType == "fahrenheit")
         {
            value = value * (5 / 9);
         }
         if(newType == "fahrenheit")
         {
            value = value * 1.8;
         }
         return value;
      }
      
      private function convertHDev(oldType:String, newType:String, value:Number) : Number
      {
         if(oldType == "btulb")
         {
            value = value / (1 / 2.326);
         }
         if(newType == "btulb")
         {
            value = value * (1 / 2.326);
         }
         return value;
      }
      
      private function convertTemperature(oldType:String, newType:String, value:Number) : Number
      {
         if(oldType == "kelvin")
         {
            value = this.kelvinToCelsius(value);
         }
         else if(oldType == "fahrenheit")
         {
            value = this.fahrenheitToCelsius(value);
         }
         if(newType == "kelvin")
         {
            value = this.celsiusToKelvin(value);
         }
         else if(newType == "fahrenheit")
         {
            value = this.celsiusToFahrenheit(value);
         }
         return value;
      }
      
      private function convertPressure(oldType:String, newType:String, value:Number) : Number
      {
         if(oldType == "psi")
         {
            value = this.psiToHpa(value);
         }
         if(newType == "psi")
         {
            value = this.hpaToPsi(value);
         }
         return value;
      }
      
      private function convertMassPerMass(oldType:String, newType:String, value:Number) : Number
      {
         if(oldType == "grlb")
         {
            value = this.grlbToGkg(value);
         }
         if(newType == "grlb")
         {
            value = this.gkgToGrlb(value);
         }
         return value;
      }
      
      private function convertMassPerVolume(oldType:String, newType:String, value:Number) : Number
      {
         if(oldType == "grft3")
         {
            value = this.grft4ToGm3(value);
         }
         if(newType == "grft3")
         {
            value = this.gm3ToGrft3(value);
         }
         return value;
      }
      
      private function convertWv(oldType:String, newType:String, value:Number) : Number
      {
         if(oldType == "ooo")
         {
            value = value / 10;
         }
         else if(oldType == "ppm")
         {
            value = value / 10000;
         }
         if(newType == "ooo")
         {
            value = value * 10;
         }
         else if(newType == "ppm")
         {
            value = value * 10000;
         }
         return value;
      }
      
      private function fahrenheitToCelsius(value:Number) : Number
      {
         return (value - 32) * (5 / 9);
      }
      
      private function kelvinToCelsius(value:Number) : Number
      {
         return value - 273.15;
      }
      
      private function celsiusToFahrenheit(value:Number) : Number
      {
         return value * 1.8 + 32;
      }
      
      private function celsiusToKelvin(value:Number) : Number
      {
         return value + 273.15;
      }
      
      private function psiToHpa(value:Number) : Number
      {
         return value * 68.94757293;
      }
      
      private function hpaToPsi(value:Number) : Number
      {
         return value / 68.94757293;
      }
      
      private function grlbToGkg(value:Number) : Number
      {
         return value / 7;
      }
      
      private function gkgToGrlb(value:Number) : Number
      {
         return value * 7;
      }
      
      private function grft4ToGm3(value:Number) : Number
      {
         return value / 0.436995724;
      }
      
      private function gm3ToGrft3(value:Number) : Number
      {
         return value * 0.436995724;
      }
      
      private function btulbToKjkg(h:Number, r:Number) : Number
      {
         return (h - 7.6847234164517 - 14.208006114455 * (r / 1000)) * 2.326;
      }
      
      private function kjkgToBtulb(h:Number, r:Number) : Number
      {
         return h * (1 / 2.326) + 7.6847234164517 + 14.208006114455 * (r / 1000);
      }
   }
}
