#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## HTML Style for DaqGroup.
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

function version(){
 echo "$scriptname version 1.0";
};

function print_help(){
 version;
 echo "Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru";
 echo "Utility to print HTML Style for DaqGroup.";
 echo "Usage: $scriptname [options]";
 echo "Options:";
 echo " --version    - print version";
 echo " -h,--help    - print help screen";
 echo " -p,--path    - print css file path";
 echo " -c,--cat     - cat css file content";
};

function markdownviewer_css(){
 local mv="$(unix which markdownviewer)";
 if [ -z "$mv" ]; then return 1; fi;
 mv="$(realpath "$mv")";
 if [ ! -e "$mv" ]; then return 1; fi;
 local css="$(dirname "$mv")/$(basename "$mv" .sh).css";
 if [ -e "$css" ]; then echo "$css"; fi;
};

function daqgroup_css(){
 local css="$(markdownviewer_css)";
 if [ -z "$css" ] || [ ! -e "$css" ]; then css="$scriptHOME/daqgroup.css"; fi;
 if [ -n "$css" ]; then echo "$css"; fi;
};

function path_css(){
 if [ -e "$1" ]; then
  echo "$1";
 else
  fatal 1 "Error: could not find css file.";
 fi;
};

function cat_css(){
 if [ -e "$1" ]; then
  cat "$1";
 else
  fatal 1 "Error: could not find css file.";
 fi;
};

function main(){
 local css="$(daqgroup_css)";
 case $1 in
  --version)          version; ;;
  -h|-help|--help)    print_help; ;;
  -p|-path|--path)    path_css "$css"; ;;
  -c|-cat|--cat)      cat_css "$css"; ;;
  *)                  fatal 1 "Usage: $scriptname --version|-h|--help|-p|--path|-c|--cat"; ;;
 esac;
};

main "$@";

#############
# END OF FILE
#############
