#!/bin/bash

astra_sources(){
 show_greetings() {
  echo " ";
  echo " Utility to set Astra Linux CE repository sources.list";
  echo " Copyright (c) 2023 Alexey Kuryakin kouriakine@mail.ru";
  echo " Version: 20230120";
  echo " ";
 };
 make_backup(){
  local sources=$1;
  [ -z $sources ] && return 1;
  [ -e $sources ] && {
   if [ -e $sources.backup ]; then
    echo "File $sources.backup is already exists.";
   else
    sudo cp $sources $sources.backup;
   fi;
  };
 };
 print_list(){
  local deb="# deb"; [ "$1" = "1" ] && deb="deb";
  echo "# Main Internet repository on AstraLinux.ru";
  echo "$deb https://download.astralinux.ru/astra/stable/orel/repository/ orel non-free contrib main";
  echo "";
  local deb="# deb"; [ "$1" = "2" ] && deb="deb";
  echo "# Fallback Internet repository on Yandex.ru";
  echo "$deb http://mirror.yandex.ru/astra/stable/orel/repository/ orel non-free contrib main";
  echo "";
  local deb="# deb"; [ "$1" = "3" ] && deb="deb";
  echo "# Shared repository on server simply in local area network";
  echo "$deb http://simply/mirror/astra/stable/orel/repository/ orel non-free contrib main";
  echo "";
  local deb="# deb"; [ "$1" = "4" ] && deb="deb";
  echo "# Local repository on hard disk drive";
  echo "$deb file:///srv/public/mirror/astra/stable/orel/repository/ orel non-free contrib main";
  echo "";
 };
 view_list(){
  local sources=$1;
  [ -z $sources ] && return 1;
  echo "";
  cat $sources;
  echo "";
 };
 clear;
 show_greetings;
 local sources="/etc/apt/sources.list";
 make_backup $sources;
 local ans;
 echo "";
 echo " Please select Astra Linux repository source.";
 echo "";
 echo " 1 - http://download.astralinux.ru - Internet main   repository.";
 echo " 2 - http://mirror.yandex.ru       - Internet mirror repository.";
 echo " 3 - http:/simply/mirror           - Local network   repository.";
 echo " 4 - file:///srv/public/mirror     - Local HDD disk  repository.";
 echo "   - [space]  just list repository list." ;
 echo "";
 if read -n 1 -t 180 -p " Your choise (1..4): " ans ; then
  echo ""; echo "";
  [ "$ans" = "1" ] && print_list 1 | sudo tee $sources;
  [ "$ans" = "2" ] && print_list 2 | sudo tee $sources;
  [ "$ans" = "3" ] && print_list 3 | sudo tee $sources;
  [ "$ans" = "4" ] && print_list 4 | sudo tee $sources;
 fi;
 echo "";
 sudo apt-get update;
 view_list $sources;
};
astra_sources;
