////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Text Find Dialog.                                                     //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231121 - Modified for FPC (A.K.)                                         //
// 20240626 - ApplyParams                                                     //
////////////////////////////////////////////////////////////////////////////////

unit form_textfinddialog; // Form Text Find Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus, 
 _crw_alloc, _crw_str, _crw_fio, _crw_eldraw, _crw_ef,
 _crw_appforms, _crw_apptools, _crw_apputils,
 form_crwdaqsyschild, form_texteditor;

type

  { TFormTextFindDialog }

  TFormTextFindDialog = class(TMasterForm)
    PanelControls: TPanel;
    PanelButtons: TPanel;
    CheckBoxWholeWord: TCheckBox;
    CheckBoxMatchCase: TCheckBox;
    LabelFindText: TLabel;
    BitBtnFind: TBitBtn;
    BitBtnClose: TBitBtn;
    EditFindText: TEdit;
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BitBtnFindClick(Sender: TObject);
    procedure BitBtnCloseClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    myEditor : TFormTextEditor;
    function  ValidEditor:Boolean;
    procedure SelectWordUnderCursor;
  public
    { Public declarations }
  end;

function NewFormTextFindDialog(aEditor:TFormTextEditor; const aParams:LongString=''):TFormTextFindDialog;

implementation

{$R *.lfm}

function NewFormTextFindDialog(aEditor:TFormTextEditor; const aParams:LongString=''):TFormTextFindDialog;
var apFlags:Integer;
begin
 Result:=nil;
 try
  if aEditor.Ok then begin
   Application.CreateForm(TFormTextFindDialog, Result);
   Result.Caption:=Format(RusEng('Поиск в "%s"','Find in "%s"'),[ExtractFileName(aEditor.Caption)]);
   apFlags:=Result.ApplyParams(aParams);
   if not HasFlags(apFlags,apf_FormPos)
   then Result.LocateToCenterOfScreen;
   Result.myEditor:=aEditor;
  end;
 except
  on E:Exception do BugReport(E,nil,'NewFormTextFindDialog');
 end;
end;

procedure TFormTextFindDialog.FormCreate(Sender: TObject);
begin
 myEditor:=nil;
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 SmartUpdate(BitBtnFind,RusEng('Найти далее','Find next'));
 SmartUpdate(BitBtnClose,RusEng('Закрыть','Close'));
 SmartUpdate(LabelFindText,RusEng('Текст, который надо найти:','Text to find:'));
 SmartUpdate(CheckBoxWholeWord,RusEng('Искать целое слово','Search whole word'));
 SmartUpdate(CheckBoxMatchCase,RusEng('Учитывать регистр','Match character case'));
end;

procedure TFormTextFindDialog.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
 if ValidEditor then CloseAction:=caHide else CloseAction:=caFree;
end;

function TFormTextFindDialog.ValidEditor:Boolean;
begin
 if Assigned(Self)
 then Result:=SdiMan.IsChild(myEditor,sf_SdiTextEdit)
 else Result:=False;
end;

procedure TFormTextFindDialog.FormActivate(Sender: TObject);
begin
 if Ok then
 try
  ActiveControl:=EditFindText;
 except
  on E:Exception do BugReport(E,Self,'FormActivate');
 end;
end;

procedure TFormTextFindDialog.BitBtnFindClick(Sender: TObject);
begin
 if Ok then
 try
  if ValidEditor then
  if (EditFindText.Text<>'') then
  myEditor.FindText(EditFindText.Text,
                    fr_WholeWord * ord(CheckBoxWholeWord.Checked) +
                    fr_MatchCase * ord(CheckBoxMatchCase.Checked));
 except
  on E:Exception do BugReport(E,Self,'BitBtnFindClick');
 end;
end;

procedure TFormTextFindDialog.BitBtnCloseClick(Sender: TObject);
begin
 if Ok then Hide;
end;

procedure TFormTextFindDialog.FormShow(Sender: TObject);
begin
 if Ok then SelectWordUnderCursor;
end;

procedure TFormTextFindDialog.SelectWordUnderCursor;
var sw:WideString;
begin
 if Ok then
 try
  if ValidEditor then begin
   sw:=GetWordUnderCursor(myEditor.PerformWideText,myEditor.PerformSelStart);
   if (sw<>'') then EditFindText.Text:=WideToStr(sw);
  end;
 except
  on E:Exception do BugReport(E,Self,'SelectWordUnderCursor');
 end;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_textfinddialog;
begin
end;

procedure Free_form_textfinddialog;
begin
end;

initialization

 Init_form_textfinddialog;

finalization

 Free_form_textfinddialog;

end.

//////////////
// END OF FILE
//////////////

