////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Spectr Zon Fit Edit Peak.                                             //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231205 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_spectrzonfiteditpeak; // Form Spectr Zon Fit Edit Peak

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_sort, _crw_ef, _crw_ee, _crw_zm,
 _crw_curves, _crw_riff, _crw_calib,
 _crw_daqsys, _crw_daqdev,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormSpectrZonFitEditPeak = class(TMasterForm)
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Edit3: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function FormSpectrZonFitEditPeakExecute(var Chan,Ampl,Fwhm:Double;
                                         var cFix,aFix,fFix:Boolean):Integer;

implementation

{$R *.lfm}

function FormSpectrZonFitEditPeakExecute;
const
 TheForm : TFormSpectrZonFitEditPeak = nil;
begin
 Result:=mrCancel;
 if CanShowModal(TheForm) then
 try
  if not TheForm.Ok then begin
   Application.CreateForm(TFormSpectrZonFitEditPeak, TheForm);
   TheForm.Master:=@TheForm;
  end;
  if TheForm.Ok then begin
   TheForm.Edit1.Text:=Format('%g',[Chan]);
   TheForm.Edit2.Text:=Format('%g',[Ampl]);
   TheForm.Edit3.Text:=Format('%g',[Fwhm]);
   TheForm.CheckBox1.Checked:=cFix;
   TheForm.CheckBox2.Checked:=aFix;
   TheForm.CheckBox3.Checked:=fFix;
   if (mrVoice(TheForm.ShowModal)=mrOk) then begin
    Result:=mrOk;
    SmartStr2Real(TheForm.Edit1.Text,Chan);
    SmartStr2Real(TheForm.Edit2.Text,Ampl);
    SmartStr2Real(TheForm.Edit3.Text,Fwhm);
    cFix:=TheForm.CheckBox1.Checked;
    aFix:=TheForm.CheckBox2.Checked;
    fFix:=TheForm.CheckBox3.Checked;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormSpectrZonFitEditPeakExecute');
 end;
end;

procedure TFormSpectrZonFitEditPeak.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Редактировать пик','Edit peak');
 Label1.Caption:=RusEng('Канал','Channel');
 Label2.Caption:=RusEng('Высота','Amplitude');
 Label3.Caption:=RusEng('Полуширина','Halfwidth');
 CheckBox1.Caption:=RusEng('Фикс.','Fixed');
 CheckBox2.Caption:=RusEng('Фикс.','Fixed');
 CheckBox3.Caption:=RusEng('Фикс.','Fixed');
 BitBtnOk.Caption:=mrCaption(mrOk);
 BitBtnCancel.Caption:=mrCaption(mrCancel);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrzonfiteditpeak;
begin
end;

procedure Free_form_spectrzonfiteditpeak;
begin
end;

initialization

 Init_form_spectrzonfiteditpeak;

finalization

 Free_form_spectrzonfiteditpeak;

end.

//////////////
// END OF FILE
//////////////

