unit _crw_softdevdialog;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Printers,
 lcltype, lclintf,
 Form_CrwDaqSysChild,
 Form_TextEditor, Form_CurveWindow,
 Form_SurfWindow, Form_CircuitWindow,
 Form_ConsoleWindow,  Form_TabWindow,
 Form_SpectrWindow, Form_Calculator,
 Form_ListBoxSelection, Form_UartTerminal,
 Form_CalibDialog, Form_DaqEditTagDialog,
 Unit_SystemConsole,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_ef, _crw_pio, _crw_curves, _crw_riff,
 _crw_calib, _crw_couple, _crw_daqtags, _crw_daqevnt,
 _crw_daqsys, _crw_daqdev, _crw_softdev,
 _crw_appforms, _crw_apptools, _crw_apputils;


 {
 *******************************************************************************
 Объект:       DialogDevice
 Объявление:   Device Software Dialog
 Назначение:   Служит для организации диалогов с пользователем.
 Входы:        Нет.
 Выходы:       Нет.
 Описание:     Устройство служит для организации диалогов. Диалоги описываются
               в текстовой форме в отдельной секции конфигурационного файла.
               Каждое поле диалога связано с тегом, который, собственно,
               и надо редактировать. Обмен данными между диалогом и тегами.
               происходит при нажатии кнопок подтверждения:
                Enter = "Ладно"  = запись значений из диалога в теги
                Esc   = "Отмена" = запись значений из тегов   в диалог
               При этом, если указан тег уведомления  NotifyTag, в него
               при нажатии кнопок записывается 1=Ok или 2=Cancel. Клиентская
               программа должна отреагировать и сама сбросить тег в 0.
               Реагирует на сообщения:
                devmsg('&devicename Confirm=n') n=1:Ok,n=2:Cancel
 Конфигурация: DialogSection = &Dialog.Section  - секция описания диалога
               CloseOnEnter = 1    - закрывать диалог по Enter?
               DebugMode = 0       - режим отладки
               Adjustment = 0      - при открытии выравнивать по курсору мыши
               NotifyTag = TagName - необязательный integer тег уведомления
                                     выставляется в 1=Ok/2=Cancel при нажатии
                                     кнопок подтверждения
               В секции [&Dialog.Section] содержится описание диалога,
               которое кратко можно описать так:
               [&Dialog.Section]
               Dialog x1 y1 x2 y2 Caption
               Label x1 y1 x2 y2 Caption
               FrameBar x1 y1 x2 y2 Caption
               StaticText x1 y1 x2 y2 Caption
               InputLine x1 y1 x2 y2 Tag
               CheckBoxes x1 y1 x2 y2 Tag Count
                Item(1)
                ..
                Item(Count)
               RadioButtons x1 y1 x2 y2 Tag Count
                Item(1)
                ..
                Item(Count)
               ComboBox x1 y1 x2 y2 Tag Count
                Item(1)
                ..
                Item(Count)
               ListBox x1 y1 x2 y2 Tag Count
                Item(1)
                ..
                Item(Count)
               Здесь
                Dialog,Label,InputLine,FrameBar,StaticText,CheckBoxes,
                RadioButtons,ComboBox,ListBox  - зарезервированные слова
                x1 y1 x2 y2 - расположение элемента (в пикселах)
                Tag - имя тега, связанного с данным полем
                Count - число элементов для списков
                Item(i) - текст i-го элемента списка
                Caption - текст, связанный с полем
               При определении Label метка прицепляется к следующему за ней
               полю.
 Пример:       Смотри daq\examples\config\_dialog.cfg
  [TagList]
  INPUT-I   = integer 0         ; поле связано с InputLine для integer
  INPUT-R   = real    0         ; поле связано с InputLine для real
  INPUT-S   = string  something ; поле связано с InputLine для string
  CHECKBOX  = integer 0         ; поле связано с CheckBoxes
  RADIO     = integer 0         ; поле связано с RadioButtons
  COMBOBOX  = integer 0         ; поле связано с ComboBox
  LISTBOX   = integer 0         ; поле связано с ListBox
  DlgNotify = integer 0         ; тег уведомления: 1=Ok=Enter, 2=Cancel=Esc
  [DeviceList]
  &Dialog  = device software dialog
  [&Dialog]
  DialogSection = &Dialog.Section ; Имя секции с описанием диалога
  CloseOnEnter = 0                ; Закрывать диалог по Enter,Esc?
  DebugMode = 1                   ; Выводить сообщения в файл отладки?
  Adjustment = 1                  ; Диалог при открытии выравнивать по положению мыши?
  NotifyTag = DlgNotify           ; Уведомление о нажатии 1=Ok,2=Cancel
  [&Dialog.Section]
  Dialog       0   0   400 400 Test dialog
  FrameBar     10  30  390 360 Frame Bar
  Label        20  50  180 65  Input integer
  InputLine    180 50  380 65  INPUT-I
  Label        20  70  180 85  Input real
  InputLine    180 70  380 85  INPUT-R
  Label        20  90  180 105 Input string
  InputLine    180 90  380 105 INPUT-S
  StaticText   20  110 380 125 Static Text
  Label        20  130 180 145 CheckBoxes
  CheckBoxes   20  150 180 200 CHECKBOX 3
   Check Item1
   Check Item2
   Check Item3
  Label        220 130 380 145 RadioButtons
  RadioButtons 220 150 380 200 RADIO 3
   Radio Item1
   Radio Item2
   Radio Item3
  Label        20  210 180 225 ListBox
  ListBox      20  230 180 280 LISTBOX 9
   List Item1
   List Item2
   List Item3
   List Item4
   List Item5
   List Item6
   List Item7
   List Item8
   List Item9
  Label        220 210 380 225 ComboBox
  ComboBox     220 230 380 245 COMBOBOX 9
   Combo Item1
   Combo Item2
   Combo Item3
   Combo Item4
   Combo Item5
   Combo Item6
   Combo Item7
   Combo Item8
   Combo Item9
 *******************************************************************************
 }
type
 TDialogDevice = class(TSoftwareDevice)
 public
  DialogText    : TText;
  DialogSection : LongString;
  CloseOnEnter  : Boolean;
  Adjustment    : Boolean;
  NotifyTag     : Integer;
  DebugMode     : Boolean;
  Confirm       : Integer;
  constructor Create(const aName:LongString);
  destructor  Destroy; override;
  procedure   Config(FileName:LongString); override;
  function    GetProperty(P:TText):TText; override;
  procedure   Idle; override;
  procedure   Handler; override;
  procedure   Action; override;
  function    NewPropertyDialog:TDaqDevicePropertyDialog; override;
  function    HandleMessage(const aMsg:LongString; aFlags:Cardinal=hf_Default):Double; override;
 end;

implementation

uses
 Form_DaqDialogDevice;

 {
 *******************************************************************************
 TDialogDevice implementation
 *******************************************************************************
 }
constructor TDialogDevice.Create(const aName:LongString);
begin
 inherited Create(AName);
 SetDeviceModel('DIALOG');
 AnalogFifoSize:=0;
 DigitalFifoSize:=0;
 NumAnalogInputs:=0;
 NumDigitalInputs:=0;
 NumAnalogOutputs:=0;
 NumDigitalOutputs:=0;
 NumCalibrations:=0;
 DialogText:=NewText;
 DialogSection:='';
 CloseOnEnter:=true;
 Adjustment:=false;
 NotifyTag:=0;
 DebugMode:=false;
 Confirm:=0;
end;

destructor TDialogDevice.Destroy;
begin
 Kill(DialogText);
 DialogSection:='';
 inherited Destroy;
end;

procedure TDialogDevice.Config(FileName:LongString);
var TagName:LongString;
begin
 FileName:=UnifyFileAlias(FileName);
 inherited Config(FileName);
 DialogSection:='';
 ReadIniFileAlpha(FileName,DevSection,'DialogSection%a',DialogSection);
 if DialogSection=''
 then Daq.AddWarning('Device:'+Name+' -> Not found DialogSection=...');
 DialogText.Text:=ExtractTextSection(FileName,'['+DialogSection+']',efLTrim+efRTrim+efDelCom);
 if not DialogText.Ok then Daq.AddWarning('Device:'+Name+' -> Not found ['+DialogSection+']');
 ReadIniFileBoolean(FileName,DevSection,'CloseOnEnter%b',CloseOnEnter);
 ReadIniFileBoolean(FileName,DevSection,'DebugMode%b',DebugMode);
 ReadIniFileBoolean(FileName,DevSection,'Adjustment%b',Adjustment);
 TagName:='';
 ReadIniFileAlpha(FileName,DevSection,'NotifyTag%a',TagName);
 NotifyTag:=findtag(TagName);
end;

function  TDialogDevice.GetProperty(P:TText):TText;
begin
 GetProperty:=inherited GetProperty(P);
 P.Addln('CloseOnEnter = '+d2s(ord(CloseOnEnter)));
 P.Addln('DebugMode = '+d2s(ord(DebugMode)));
 P.Addln('Adjustment = '+d2s(ord(Adjustment)));
 P.Addln('NotifyTag = '+nametag(NotifyTag));
 P.AddLn('DialogSection = '+DialogSection);
 if DialogText.Ok then begin
  P.Addln('['+DialogSection+']');
  P.Concat(DialogText);
 end;
end;

procedure  TDialogDevice.Idle;
begin
 inherited Idle;
 if (PropertyDialog is TFormDaqDialogDevice) then
 with TFormDaqDialogDevice(PropertyDialog) do begin
  case Confirm of
   1 : Transfer(true);
   2 : Transfer(false);
  end;
  Confirm:=0;
 end;
end;

procedure  TDialogDevice.Handler;
begin
end;

procedure TDialogDevice.Action;
begin
 OpenPropertyDialog;
 if Adjustment then
 if PropertyDialog.Ok then begin
  PropertyDialog.Left:=Mouse.CursorPos.X-28;
  PropertyDialog.Top:=Mouse.CursorPos.Y-38;
  PropertyDialog.Show;
  PropertyDialog.BringToFront;
  Confirm:=2;
 end;
end;

function TDialogDevice.NewPropertyDialog:TDaqDevicePropertyDialog;
begin
 Result:=NewFormDaqDialogDevice(Self);
end;

function TDialogDevice.HandleMessage(const aMsg:LongString; aFlags:Cardinal=hf_Default):Double;
var Buf:TParsingBuffer;
begin
 if (ScanVarInteger(svConfig,StrCopyBuff(Buf,UnifyAlias(aMsg)),'Confirm%i',Confirm)<>nil)
 then Result:=Confirm
 else Result:=0;
 if not HasFlags(aFlags,hf_SkipAwake) then Awake;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_crw_softdevdialog;
begin
end;

procedure Free_crw_softdevdialog;
begin
end;

initialization

 Init_crw_softdevdialog;

finalization

 Free_crw_softdevdialog;

end.

//////////////
// END OF FILE
//////////////

