readonly POSSOSVALUES="HP-UX,AIX,OSF1,SunOS,Solaris,LynxOS,Linux,Darwin,";

if [ -n "$OS" ]; then
    echo "Variable OS is set to $OS";
    TEMP="$OS,";
    echo "$POSSOSVALUES" | grep $TEMP>/dev/null;
    if [ "$?" != "0" ]; then
        echo "Unknown OS....setup failed";
        echo "Possible values are : $POSSOSVALUES";
        exit 1;
    fi;
else
    echo "Variable OS must be defined ... setup failed";
    echo "Possible values are : $POSSOSVALUES";
    exit 1;
fi;

setenv(){
    export $1="$2";
};


if [ -d ./src/stateManager ]; then
    setenv SMIDIR `pwd`;
    echo "Variable SMIDIR is set to $SMIDIR";
else
    if [ -n "$SMIDIR" ]; then
        echo "Variable SMIDIR is set to $SMIDIR";
    else
        echo "You are not in the right directory... setup failed";
        exit 1;
    fi;
fi;

setenv SMIRTLDIR $SMIDIR;

if [ -n "$DIMDIR" ]; then
    echo "Variable DIMDIR is set to $DIMDIR";
else
    echo "Variable DIMDIR has to be defined... setup failed";
    exit 1;
fi;

if [ -n "$ODIR" ]; then
    echo "Variable ODIR is set to $ODIR";
else
    case $OS in
        HP-UX)      setenv ODIR hp;         ;;
        AIX)        setenv ODIR aix;        ;;
        OSF1)       setenv ODIR osf;        ;;
        SunOS)      setenv ODIR sunos;      ;;
        Solaris)    setenv ODIR solaris;    ;;
        LynxOS)     setenv ODIR lynxos;     ;;
        Linux)      setenv ODIR linux;      ;;
        Darwin)     setenv ODIR darwin;     ;;
        *)          echo "OS variable $OS is not known... setup failed";
                    exit 1;
                    ;;
    esac;
    echo "Variable ODIR is set to $ODIR";
fi;

if [ "$OS" = "Linux" ]; then
    if [ -z "$LD_LIBRARY_PATH" ]; then
        setenv LD_LIBRARY_PATH $SMIDIR/$ODIR;
    else
        setenv LD_LIBRARY_PATH $SMIDIR/$ODIR\:$LD_LIBRARY_PATH;
    fi;
    export PATH="$SMIDIR/$ODIR:$PATH";
    # rehash; # ??
fi;

alias smiTrans="$SMIDIR/$ODIR/smiTrans";
alias smiGen="$SMIDIR/$ODIR/smiGen";
alias smiSM="$SMIDIR/$ODIR/smiSM";
alias smiSendCommand="$SMIDIR/$ODIR/smiSendCommand";
alias smiChangeOption="$SMIDIR/$ODIR/smiChangeOption";
alias smiPreproc="$SMIDIR/$ODIR/smiPreproc";
alias smiMake="$SMIDIR/$ODIR/smiMake";
alias smiKill="$SMIDIR/$ODIR/smiKill";
alias smiGUI="$SMIDIR/$ODIR/smiGUI";
alias SMIGUI="$SMIDIR/$ODIR/smiGUI.tcl";
#
if [ ! -d $SMIDIR/$ODIR ]; then
   echo "Created Directory : $SMIDIR/$ODIR";
   mkdir "$SMIDIR/$ODIR";
fi;

#exit
