////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Тестовый плагин для проверки работы.
[]
[Manual.Eng]
Test plugin to check how it working.
[]
[Arguments.Rus]
Аргумент1 = 1
Аргумент2 = 2
[]
[Arguments.Eng]
Argument1 = 1
Argument2 = 2
[]
}

library test_plugin;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, graphics,
 _crw_crwapi;

/////////////////////////////////////////////////////////
{$I _crw_plugin_declare.inc} // Declare CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:ICrwApi):Integer;     //
/////////////////////////////////////////////////////////
const
 swin = +1; // Source window reference
 twin = -1; // Target window reference
 cwin =  0; // Clipboard window reference
begin
 Result:=0;
 with CrwApi,SysApi,GuiApi,DanApi do
 try
  RedirectStdIn(Input);
  RedirectStdOut(Output);
  VerifyPluginDate(CrwApiEdition,Version);
  VerifyPluginType(Target,ForDataAnalysis);
  writeln('Hello,world!');
  Warning('Hello,world!');
  writeln('PluginName = ',PluginName);
  writeln('PluginSourceFileName = ',PluginSourceFileName);
  writeln('PluginBinaryFileName = ',PluginBinaryFileName);
  writeln('Plugin Arguments: '+EOL+Trim(GetArguments));
  if WindowExists(swin)
  then writeln('Source Caption: '+GetWindowCaption(1))
  else writeln('Source Curve Window not found.');
  if IsUsingSharedMemoryManager then writeln('UsingSharedMemoryManager');
  if IsUsingCommonMemoryManager then writeln('UsingCommonMemoryManager');
 except
  on E:Exception do begin
   if WindowExists(twin) then CurvesCount[twin]:=0;
   Echo(PluginName+RusEng(': ОШИБКА!',': ERROR!')); 
   if UsesBlaster then Voice('EXCEPTION');
   Echo(E.Message); Error(E.Message);
   Result:=-1;
  end;
 end;
end;

/////////////////////////////////////////////////////////
{$I _crw_plugin_exports.inc} // Exports CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID;        //
/////////////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
