//----------------------------------------------------------
// Consts
//----------------------------------------------------------
var CurrentHintingElementId = null; 
var IsBlockHideHint = false;
var IsVisibleHint = false;
var IsMouseOutHintingElement = true;
var HintBoxElement = null;

//----------------------------------------------------------
// Functions
//----------------------------------------------------------
function CalcElementX(element, startX) {
	var body = document.body; 
	var dx = (body.clientWidth - startX + body.scrollLeft < element.offsetWidth) ? element.offsetWidth + 15 : 0;
	var x = startX + 10 - dx;
	return (x - body.scrollLeft > 0) ? x : body.scrollLeft;
}

function CalcElementY(element, startY) {
	var body = document.body; 
	var dy = (body.clientHeight - startY + body.scrollTop < element.offsetHeight) ? element.offsetHeight + 15 : 0;
	var y = startY + 10 - dy;
	return (y - body.scrollTop > 0) ? y : scrollTop;
}

function GetInputElements() {
	var allInputElements = document.getElementsByTagName("input");
	var resultElements = new Array();
	var index = 0;
	for(var i = 0; i < allInputElements.length; i++) {
		var currentElement = allInputElements[i];
		if (currentElement.title) {
			resultElements[index++] = currentElement;
		}
	}
	return resultElements;
}

function GetHintBox() {
	return HintBoxElement ? HintBoxElement : (HintBoxElement = document.getElementById("hintbox"));
}

function SpecifyEvents() {
	document.onmouseover = OnMouseOverDocument;
	var hintbox = GetHintBox();
	hintbox.onmouseover = OnMouseOverHintBox;
	hintbox.onmouseout = OnMouseOutHintBox;
	var inputElements = GetInputElements();
	var currentElement;
	for(var i = 0; i < inputElements.length; i++) {
		currentElement = inputElements[i];
		currentElement.onmouseover = OnMouseOverHintingElement;
		currentElement.onmouseout = OnMouseOutHintingElement;
	}
}

function ShowHint(epageX, epageY, lastHintingElementId) {
	if (CurrentHintingElementId != lastHintingElementId) {
		return;
	}
	var hintbox = GetHintBox();
	if (hintbox.innerHTML) {
		hintbox.style.left = CalcElementX(hintbox, epageX) + "px";
		hintbox.style.top = CalcElementY(hintbox, epageY)  + "px";
		hintbox.style.width = "auto";
		if (hintbox.offsetWidth > 300) {
			hintbox.style.width = "300px";
		}
	}
}

function HideHint() {
	var hintbox = GetHintBox();
	hintbox.style.left = "-10000px";
	var lastElement = document.getElementById(CurrentHintingElementId);
	lastElement.title = hintbox.innerHTML;
	hintbox.innerHTML = "";
	IsVisibleHint = false;
	CurrentHintingElementId = null;
}

//----------------------------------------------------------
// HANDLES
//----------------------------------------------------------
function OnMouseOverDocument(e) {
	if(IsCtrlPressed(e)) {
		return;
	}
	if (IsBlockHideHint || !IsVisibleHint || !IsMouseOutHintingElement || !CurrentHintingElementId) {
		return;
	}
	HideHint();
}

function OnMouseOverHintingElement(e) {
	if (IsVisibleHint) {
		if(IsCtrlPressed(e)) {
			return;
		}
		if (CurrentHintingElementId == this.id) {
			IsMouseOutHintingElement = false;
			return;
		} else if(CurrentHintingElementId) {
			HideHint();
		}
	}
	IsVisibleHint = true;
	IsMouseOutHintingElement = false;
	var hintbox = GetHintBox();
	CurrentHintingElementId = this.id;
	hintbox.innerHTML = this.title;
	this.title = "";
	setTimeout("ShowHint(" + GetMousePageX(e) + ", " + GetMousePageY(e) + ",'" + CurrentHintingElementId + "');", 2000);
}

function OnMouseOutHintingElement(e) {
	IsMouseOutHintingElement = true;
}

function OnMouseOverHintBox(e) {
	IsBlockHideHint = true;
}

function OnMouseOutHintBox(e) {
	IsBlockHideHint = false;
}

//----------------------------------------------------------
// MAIN
//----------------------------------------------------------
AddHandler(window, "load", SpecifyEvents);