@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:CheckArguments
if "%~1" == "" goto :EOF
if not exist "%~f1" goto :EOF
set id="%~2"
set inf="%~3"
set obs="%~4"
set src="%~5"

:InitVariables
set tz=0
set ta=0
set tb=0
set uz=0.000
set ua=0.000
set ub=0.000
set /a line=0
set /a step=0
set /a zero=0
set /a maxline=1000000
set tabfile=%~dpnx1
set inifile=%~dpn1.INI
set initemp=%~dpn1.INI.TMP
set calfile=%~dpn1.CAL
set caltemp=%~dpn1.CAL.TMP
:InitializeFiles
call :DeleteFiles "%inifile%" "%initemp%" "%calfile%" "%caltemp%"
:ProcessTabFile
for /f "delims=" %%a in ('type "%tabfile%" ^| unix tr "," "\.-" ^| unix u2d') do call :ProcessTab %%a
if exist "%initemp%" call :PrintIniHead "%inifile%"
if exist "%initemp%" type "%initemp%" | unix sort -u -k1g | unix u2d | unix tee -a "%inifile%"
if exist "%initemp%" call :PrintIniTail "%inifile%"
call :PrintCalibrRTD "%caltemp%"
if exist "%caltemp%" type "%caltemp%" | unix uniq | unix u2d | unix tee -a "%calfile%"
unix filecase /u "%inifile%"
unix filecase /u "%calfile%"
:CleanupFiles
call :DeleteFiles "%initemp%" "%caltemp%"
goto :EOF

:ProcessTab
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if %line% GTR %maxline% goto :EOF
set /a T=%1
if %T% LSS 0 set /a step=-1
if %T% GTR 0 set /a step=+1
if "%T%" == "0" set /a zero+=1
if "%zero%" == "2" set /a step=+1
if "%T%" == "0" if "%step%" == "0" set /a step=+1
set /a iter=0
:Iteration
if "%~2" == "" goto :EOF
set /a relerr=1
if "%T%" == "0" set /a relerr=0
if "%line%" == "0" unix printf "%%-4s %%-5s %%-7s %%s\r\n" Data X   Y  RelErr                      | unix tee -a "%initemp%"
                   unix printf "%%-4s %%-5s %%-7s %%s\r\n" ""   %T% %2 %relerr%                    | unix tee -a "%initemp%"
if "%T%" == "0"    set tz=%T%
if "%T%" == "0"    set uz=%2
if "%line%" == "0" set ta=%T%
if "%line%" == "0" set ua=%2
set tb=%T%
set ub=%2
set /a T+=step
set /a iter+=1
set /a line+=1
shift
if %iter% LEQ 10 goto :Iteration
goto :EOF

:PrintIniHead
if "%~1" == "" goto :EOF
set target="%~f1"
unix printf "[]\r\n"                                                                                | unix tee -a %target%
unix printf ";*******************************************************************************\r\n"  | unix tee -a %target%
unix printf ";** Data table for:       %%s\r\n" %inf%                                               | unix tee -a %target%
unix printf ";** Actual/Obsolete id:   %%s / %%s\r\n" %id%  %obs%                                   | unix tee -a %target%
unix printf ";** Reference source:     %%s\r\n" %src%                                               | unix tee -a %target%
unix printf ";*******************************************************************************\r\n"  | unix tee -a %target%
unix printf ";** Data table contains:\r\n"                                                          | unix tee -a %target%
unix printf ";** X       - RTD temperature, \xB0C\r\n"                                              | unix tee -a %target%
unix printf ";** Y       - RTD resistance, Ohms\r\n"                                                | unix tee -a %target%
unix printf ";** RelErr  - relative error of this point, 0 = interpolation\r\n"                     | unix tee -a %target%
unix printf ";*******************************************************************************\r\n"  | unix tee -a %target%
unix printf "[]\r\n"                                                                                | unix tee -a %target%
unix printf "[RelationshipList]\r\n"                                                                | unix tee -a %target%
unix printf "Relationship = %%s\r\n" %id%                                                           | unix tee -a %target%
unix printf "[]\r\n"                                                                                | unix tee -a %target%
unix printf "[%%s]\r\n" %id%                                                                        | unix tee -a %target%
unix printf "FitMethod = Spline ; Use smoothing spline to fit\r\n"                                  | unix tee -a %target%
unix printf "Smooth = 20        ; Smooth parametr for spline\r\n"                                   | unix tee -a %target%
goto :EOF

:PrintIniTail
if "%~1" == "" goto :EOF
set target="%~f1"
unix printf "End Data\r\n"                                                                          | unix tee -a %target%
unix printf "[]\r\n"                                                                                | unix tee -a %target%
goto :EOF

:PrintCalibrRTD
if "%~1" == "" goto :EOF
set target="%~f1"
unix printf "[R(OHM)-T(C) calibration]\r\n"                                                        | unix tee -a %target%
unix printf "FitMethod = Polynom\r\n"                                                               | unix tee -a %target%
unix printf "TransformX = Line\r\n"                                                                 | unix tee -a %target%
unix printf "TransformY = %%s\r\n" %id%                                                             | unix tee -a %target%
unix printf "Power = 1\r\n"                                                                         | unix tee -a %target%
unix printf "Center = 0\r\n"                                                                        | unix tee -a %target%
unix printf "Scale = 1\r\n"                                                                         | unix tee -a %target%
unix printf "Bounds = %%s %%s\r\n" %ua% %ub%                                                        | unix tee -a %target%
unix printf "%%-4s %%-6s %%-6s %%-6s\r\n" "Data" "R(OHM)" "T(C)" "Weight"                          | unix tee -a %target%
unix printf "%%-4s %%-6s %%-6s %%-6s\r\n" "" %ua% %ta% 1                                            | unix tee -a %target%
unix printf "%%-4s %%-6s %%-6s %%-6s\r\n" "" %uz% %tz% 1                                            | unix tee -a %target%
unix printf "%%-4s %%-6s %%-6s %%-6s\r\n" "" %ub% %tb% 1                                            | unix tee -a %target%
unix printf "End Data\r\n"                                                                          | unix tee -a %target%
unix printf "Notice Text\r\n"                                                                       | unix tee -a %target%
unix printf "Standard calibration of %%s\r\n" %inf%                                                 | unix tee -a %target%
unix printf "Reference source: %%s\r\n" %src%                                                       | unix tee -a %target%
unix printf "Configuration example:\r\n"                                                            | unix tee -a %target%
unix printf "Link AnalogInput  0 with curve RTDResistance(OHM)\r\n"                                 | unix tee -a %target%
unix printf "Link AnalogOutput 0 with curve RTDTemperature(C) history 100\r\n"                     | unix tee -a %target%
unix printf "Calibration#0 = ~~\Resource\DaqSite\StdLib\Calibr\%~n1 R(OHM) T(C) Line %%s %%s %%s\r\n" %id% %ua% %ub% | unix tee -a %target%
unix printf "End Notice Text\r\n"                                                                   | unix tee -a %target%
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~f1" del /f /q "%~f1"
call :DeleteFiles %2 %3 %4 %5 %6 %7 %8 %9
goto :EOF
