#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

function fatal(){
 local date="$(date +%Y.%m.%d-%H:%M:%S)"; local script="$(basename ${BASH_SOURCE[0]})";
 if which notify-send; then notify-send -t 30000 -i dialog-error "$date: $script" "$1"; fi;
 1>&2 echo "-ne ";"\n$1\n\n";
 exit 1;
};

# Script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

declare Bitmaps="../bitmaps";
declare -i x=0;  declare -i y=0;
declare -i dx=0; declare -i dy=0;

function uniheat_main(){
 Bitmaps="~~/resource/daqsite/uniheat/bitmaps";
 add_uniheat_table 8  8  > "$scriptHOME/uh_8.crc";
 add_uniheat_table 16 8  > "$scriptHOME/uh_16.crc";
 add_uniheat_table 24 8  > "$scriptHOME/uh_24.crc";
 add_uniheat_table 32 8  > "$scriptHOME/uh_32.crc";
 add_uniheat_table 10 10 > "$scriptHOME/uh_10.crc";
 add_uniheat_table 20 10 > "$scriptHOME/uh_20.crc";
 add_uniheat_table 30 10 > "$scriptHOME/uh_30.crc";
 add_uniheat_properties  > "$scriptHOME/uh_prop.crc";
};

function add_uniheat_table(){
 add_general_map $1;
 for n in $(seq 1 $1); do add_uniheat $n $2; done;
};

function add_general_map(){
 echo "[Circuit]";
 echo "GeneralMap = $Bitmaps/uh_$1.bmp";
 echo "Name = ***_КОНТРОЛЬ_НАГРЕВАТЕЛЕЙ_UNIHEAT_***";
 echo "Hint = UniHeat: Панель контроля нагревателей";
 echo "[]";
 echo "";
 echo "[LedNarrowFont]";
 echo "CharSet = 204";
 echo "Color   = \$000000";
 echo "Height  = -13";
 echo "Name    = PT Sans Narrow";
 echo "Pitch   = Default";
 echo "Style   = []";
 echo "[]";
 echo "";
 echo "[BigLedFont]";
 echo "CharSet = 204";
 echo "Color   = \$000000";
 echo "Height  = -20";
 echo "Name    = PT Mono";
 echo "Pitch   = Fixed";
 echo "Style   = [Bold]";
 echo "[]";
 echo "";
};

function add_uniheat(){
 if [ -z "$1" ]; then return; fi;
 if [ -z "$2" ]; then return; fi;
 let "dx=( ( $1 - 1 ) % $2 ) * 125";
 let "dy=( ( $1 - 1 ) / $2 ) * 119";
 echo ";**********************";
 echo ";  Universal Heater $1";
 echo ";**********************";
 echo "";
 let "x=$dx+30";
 let "y=$dy+6";
 echo "[SensorList]";
 echo "Sensor = UH_PROP$1";
 echo "[UH_PROP$1]";
 echo "Pos = $x, $y";
 echo "LED = 7, 0, 0, %7s, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7g.bmp";
 echo "Hint = UniHeat: Наименование нагревателя $1";
 echo "[]";
 echo "";
 let "x=$dx+4";
 let "y=$dy+30";
 echo "[SensorList]";
 echo "Sensor = UH_BT$1";
 echo "[UH_BT$1]";
 echo "Pos = $x, $y";
 echo "Tag#1 = 0, $Bitmaps/uh_bt0.bmp";
 echo "Tag#2 = 1, $Bitmaps/uh_bt1.bmp";
 echo "Tag#3 = 2, $Bitmaps/uh_bt2.bmp";
 echo "Tag#4 = 3, $Bitmaps/uh_bt3.bmp";
 echo "Tag#5 = 4, $Bitmaps/uh_bt4.bmp";
 echo "tag#6 = 5, $Bitmaps/uh_bt5.bmp";
 echo "Hint = UniHeat: Кнопка включения нагревателя $1";
 echo "[]";
 echo "";
 let "x=$dx+59";
 let "y=$dy+31";
 echo "[SensorList]";
 echo "Sensor = UH_TNUM$1";
 echo "[UH_TNUM$1]";
 echo "Pos = $x, $y";
 echo "LED = 2, 0, 0, *, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led2w.bmp";
 echo "Hint = UniHeat: Номер температурного канала нагревателя $1";
 echo "[]";
 echo "";
 let "x=$dx+44";
 let "y=$dy+52";
 echo "[SensorList]";
 echo "Sensor = UH_TNAME$1";
 echo "[UH_TNAME$1]";
 echo "Pos = $x, $y";
 echo "LED = 4, 0, 0, *, [LedNarrowFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led4g.bmp";
 echo "Hint = UniHeat: Имя температурного канала нагревателя $1";
 echo "[]";
 echo "";
 let "x=$dx+30";
 let "y=$dy+71";
 echo "[SensorList]";
 echo "Sensor = UH_TGOAL$1";
 echo "[UH_TGOAL$1]";
 echo "Pos = $x, $y";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7w.bmp";
 echo "Hint = UniHeat: Целевая температура нагревателя $1, °C";
 echo "[]";
 echo "";
 let "x=$dx+30";
 let "y=$dy+93";
 echo "[SensorList]";
 echo "Sensor = UH_TREAL$1";
 echo "[UH_TREAL$1]";
 echo "Pos = $x, $y";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7c.bmp";
 echo "Hint = UniHeat: Реальная температура нагревателя $1, °C";
 echo "[]";
 echo "";
 let "x=$dx+104";
 let "y=$dy+31";
 echo "[SensorList]";
 echo "Sensor = UH_GATE$1";
 echo "[UH_GATE$1]";
 echo "Pos = $x, $y";
 echo "Tag#1 = 0, $Bitmaps/uh_gate0.bmp";
 echo "Tag#2 = 1, $Bitmaps/uh_gate1.bmp";
 echo "Hint = UniHeat: Индикатор сигнала на включение нагревателя $1";
 echo "[]";
 echo "";
 let "x=$dx+104";
 let "y=$dy+50";
 echo "[SensorList]";
 echo "Sensor = UH_BLK$1";
 echo "[UH_BLK$1]";
 echo "Pos = $x, $y";
 echo "Tag#1 = 0, $Bitmaps/uh_gate0.bmp";
 echo "Tag#2 = 1, $Bitmaps/uh_gate1.bmp";
 echo "Hint = UniHeat: Индикатор сигнала блокировки нагревателя $1";
 echo "[]";
 echo "";
 let "x=$dx+6";
 let "y=$dy+7";
 echo "[SensorList]";
 echo "Sensor = UH_HENABL$1";
 echo "[UH_HENABL$1]";
 echo "Pos = $x, $y";
 echo "LED = 0, 0, 0, *, [LedNarrowFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_enable0.bmp     OFF";
 echo "Tag#2 = 1, $Bitmaps/uh_enable1.bmp     ON";
 echo "Hint = UniHeat: Включение (разрешение) нагревателя $1";
 echo "[]";
 echo "";
};

function add_uniheat_properties(){
 echo "[Circuit]";
 echo "GeneralMap = $Bitmaps/uh_prop.bmp";
 echo "Name = ***_НАСТРОЙКА_НАГРЕВАТЕЛЕЙ_UNIHEAT_***";
 echo "Hint = UniHeat: Настройка нагревателей";
 echo "[]";
 echo "";
 echo "[LedNarrowFont]";
 echo "CharSet = 204";
 echo "Color   = \$000000";
 echo "Height  = -16";
 echo "Name    = PT Sans";
 echo "Pitch   = Default";
 echo "Style   = []";
 echo "[]";
 echo "";
 echo "[BigLedFont]";
 echo "CharSet = 204";
 echo "Color   = \$000000";
 echo "Height  = -20";
 echo "Name    = PT Mono";
 echo "Pitch   = Fixed";
 echo "Style   = [Bold]";
 echo "[]";
 echo "";
 echo "[ButtonFont]";
 echo "CharSet = 204";
 echo "Color   = \$000000";
 echo "Height  = -13";
 echo "Name    = PT Mono";
 echo "Pitch   = Fixed";
 echo "Style   = [Bold]";
 echo "[]";
 echo "";
 echo "[BoxFont]";
 echo "CharSet = 204";
 echo "Color   = \$000000";
 echo "Height  = -13";
 echo "Name    = PT Mono";
 echo "Pitch   = Fixed";
 echo "Style   = [Bold]";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_HENABLX";
 echo "[UH_HENABLX]";
 echo "Pos = 10, 15";
 echo "LED = 0, 0, 0, *, [BoxFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_enable0.bmp     X";
 echo "Tag#2 = 1, $Bitmaps/uh_enable1.bmp     V";
 echo "Hint = UniHeat: Разрешение работы нагревателя";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_HNAMEX";
 echo "[UH_HNAMEX]";
 echo "Pos = 169, 15";
 echo "LED = 7, 0, 0, %7s, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7g.bmp";
 echo "Hint = UniHeat: Наименование нагревателя";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_PENABLX";
 echo "[UH_PENABLX]";
 echo "Pos = 10, 55";
 echo "LED = 0, 0, 0, *, [BoxFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_enable0.bmp     X";
 echo "Tag#2 = 1, $Bitmaps/uh_enable1.bmp     V";
 echo "Hint = UniHeat: Разрешение блокировки по давлению";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_PBLKX";
 echo "[UH_PBLKX]";
 echo "Pos = 36, 76";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7w.bmp";
 echo "Hint = UniHeat: Верхнее давление блокировки";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_PREALX";
 echo "[UH_PREALX]";
 echo "Pos = 36, 98";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7c.bmp";
 echo "Hint = UniHeat: Реальное (текущее) давление";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_PNAMEX";
 echo "[UH_PNAMEX]";
 echo "Pos = 36, 120";
 echo "LED = 5, 0, 0, *, [LedNarrowFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led5g.bmp";
 echo "Hint = UniHeat: Имя датчика давления блокировки";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_PNUMX";
 echo "[UH_PNUMX]";
 echo "Pos = 102, 120";
 echo "LED = 2, 0, 0, *, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led2w.bmp";
 echo "Hint = UniHeat: Номер датчика давления блокировки";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_TENABLX";
 echo "[UH_TENABLX]";
 echo "Pos = 10, 145";
 echo "LED = 0, 0, 0, *, [BoxFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_enable0.bmp     X";
 echo "Tag#2 = 1, $Bitmaps/uh_enable1.bmp     V";
 echo "Hint = UniHeat: Разрешение блокировки по температуре";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_TBLKX";
 echo "[UH_TBLKX]";
 echo "Pos = 36, 166";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7w.bmp";
 echo "Hint = UniHeat: Верхняя тепература блокировки, °C";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_TREALX";
 echo "[UH_TREALX]";
 echo "Pos = 36, 188";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7c.bmp";
 echo "Hint = UniHeat: Реальная (текущая) температура, °C";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_TNAMEX";
 echo "[UH_TNAMEX]";
 echo "Pos = 36, 210";
 echo "LED = 4, 0, 0, *, [LedNarrowFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led5g.bmp";
 echo "Hint = UniHeat: Имя датчика температуры блокировки";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_TNUMX";
 echo "[UH_TNUMX]";
 echo "Pos = 102, 210";
 echo "LED = 2, 0, 0, *, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led2w.bmp";
 echo "Hint = UniHeat: Номер датчика температуры блокировки";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_WENABLX";
 echo "[UH_WENABLX]";
 echo "Pos = 10, 235";
 echo "LED = 0, 0, 0, *, [BoxFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_enable0.bmp     X";
 echo "Tag#2 = 1, $Bitmaps/uh_enable1.bmp     V";
 echo "Hint = UniHeat: Разрешение блокировки по таймеру";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_WDTX";
 echo "[UH_WDTX]";
 echo "Pos = 69, 256";
 echo "LED = 4, 1, 0, %4.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led4w.bmp";
 echo "Hint = UniHeat: Сторожевой таймер, сек";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_MODE";
 echo "[UH_MODE]";
 echo "Pos = 142, 59";
 echo "LED = 0, 0, 0, *, [BoxFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_mode0.bmp";
 echo "Tag#2 = 1, $Bitmaps/uh_mode1.bmp";
 echo "Hint = UniHeat: Режим работы нагревателя";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_MODE_N";
 echo "[UH_MODE_N]";
 echo "Pos = 165, 59";
 echo "LED = 0, 0, 0, *, [BoxFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7g.bmp     Нагрев";
 echo "Tag#2 = 1, $Bitmaps/uh_led7g.bmp     Охлаждение";
 echo "Hint = UniHeat: Режим работы нагревателя";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_TGOALX";
 echo "[UH_TGOALX]";
 echo "Pos = 165, 110";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7w.bmp";
 echo "Hint = UniHeat: Целевая тепература стабилизации, °C";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_DT2X";
 echo "[UH_DT2X]";
 echo "Pos = 165, 132";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7w.bmp";
 echo "Hint = UniHeat: dT2 - Верхний порог температуры, °C";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_DT1X";
 echo "[UH_DT1X]";
 echo "Pos = 165, 154";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7w.bmp";
 echo "Hint = UniHeat: dT1 - Нижний порог температуры, °C";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_Q1X";
 echo "[UH_Q1X]";
 echo "Pos = 165, 212";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7w.bmp";
 echo "Hint = UniHeat: Q1 - мощность начального нагрева";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_Q2X";
 echo "[UH_Q2X]";
 echo "Pos = 165, 234";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7w.bmp";
 echo "Hint = UniHeat: Q2 - мощность медленного нагрева (dT1)";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_Q3X";
 echo "[UH_Q3X]";
 echo "Pos = 165, 256";
 echo "LED = 7, 1, 0, %7.1f, [BigLedFont]";
 echo "Tag#1 = 0, $Bitmaps/uh_led7w.bmp";
 echo "Hint = UniHeat: Q3 - мощность легкого подогрева (dT2)";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_SOUNDX";
 echo "[UH_SOUNDX]";
 echo "Pos = 10, 297";
 echo "Tag#1 = 0, $Bitmaps/uh_snd0.bmp";
 echo "Tag#2 = 1, $Bitmaps/uh_snd1.bmp";
 echo "Hint = UniHeat: Разрешение звуковых эффектов";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_CHECKX";
 echo "[UH_CHECKX]";
 echo "Pos = 70, 295";
 echo "LED = 0, 0, 0, *";
 echo "Tag#1 = 0, $Bitmaps/uh_btn.bmp     Применить";
 echo "Hint = UniHeat: Применить внесенные изменения";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_CANCELX";
 echo "[UH_CANCELX]";
 echo "Pos = 168, 295";
 echo "LED = 0, 0, 0, *";
 echo "Tag#1 = 0, $Bitmaps/uh_btn.bmp     Отмена";
 echo "Hint = UniHeat: Отменить внесенные изменения";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_SAVEINIX";
 echo "[UH_SAVEINIX]";
 echo "Pos = 345, 303";
 echo "Tag#1 = 0, $Bitmaps/uh_ini.bmp     Запись";
 echo "Hint = UniHeat: Записать параметры в INI файл";
 echo "[]";
 echo "";
 echo "[SensorList]";
 echo "Sensor = UH_LOADINIX";
 echo "[UH_LOADINIX]";
 echo "Pos = 402, 303";
 echo "Tag#1 = 0, $Bitmaps/uh_ini.bmp     Чтение";
 echo "Hint = UniHeat: Прочитать параметры из INI файла";
 echo "[]";
};

function main(){
 uniheat_main "$@";
};

main "$@";

##############
## END OF FILE
##############
