 {
 Standard routines for Tags:
 procedure InitTag(var tag:Integer; name:String; typ:Integer);
 procedure UpdateTag(tag:Integer; newValue:String; min,max:Real);
 function  TagAsDump(tag:Integer):String;
 function  TagAsText(tag:Integer):String;
 procedure ClearStdTags;
 procedure InitStdTags;
 procedure FreeStdTags;
 procedure PollStdTags;
 }
 {
 Initialize and check tag.
 }      
 procedure InitTag(var tag:Integer; name:String; typ:Integer);
 begin
  tag:=FindTag(name);
  if (typ>0) and (TypeTag(tag)<>typ)
  then Trouble('Could not init tag: '+name);
  if (typ<0) and (TypeTag(tag)<>Abs(typ))
  then Problem('Could not init tag: '+name);
 end;
 {
 Update tag with new value and with range checking.
 }
 procedure UpdateTag(tag:Integer; newValue:String; min,max:Real);
 var rValue:Real;
 begin
  rValue:=0;
  if TypeTag(tag)=1 then begin
   rValue:=rVal(newValue);
   if rValue<min then rValue:=_Nan;
   if rValue>max then rValue:=_Nan;
   if not IsNan(rValue) then bNul(iSetTag(tag,Round(rValue)));
  end else
  if TypeTag(tag)=2 then begin
   rValue:=rVal(newValue);
   if rValue<min then rValue:=_Nan;
   if rValue>max then rValue:=_Nan;
   if not IsNan(rValue) then bNul(rSetTag(tag,rValue));
  end else
  if TypeTag(tag)=3 then begin
   bNul(sSetTag(tag,newValue));
  end;
 end;
 {
 Return tag content as dump string.
 }
 function TagAsDump(tag:Integer):String;
 begin
  if TypeTag(tag)=1 then TagAsDump:=Dump(iGetTag(tag)) else
  if TypeTag(tag)=2 then TagAsDump:=Dump(rGetTag(tag)) else
  if TypeTag(tag)=3 then TagAsDump:=     sGetTag(tag)  else TagAsDump:='';
 end;
 {
 Return tag content as ASCII text.
 }
 function TagAsText(tag:Integer):String;
 begin
  if TypeTag(tag)=1 then TagAsText:=Str(iGetTag(tag)) else
  if TypeTag(tag)=2 then TagAsText:=Str(rGetTag(tag)) else
  if TypeTag(tag)=3 then TagAsText:=    sGetTag(tag)  else TagAsText:='';
 end;
 {
 Clear standard Tags.
 }
 procedure ClearStdTags;
 begin
 end;
 {
 Initialize standard Tags.
 }
 procedure InitStdTags;
 begin
  ShouldPollStdTags:=false;
 end;
 {
 Finalize standard Tags.
 }
 procedure FreeStdTags;
 begin
 end;
 {
 Poll standard Tags.
 }
 procedure PollStdTags;
 begin
 end;
