 {
 ***********************************************************************
 Daq Pascal application program _mvtopu.
 Milli Volts to Physical Units converter
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Benchmark n   - Benchmark Print mode n =0/1 = OFF/ON.
|********************************************************
[]
 ***********************************************************************
 Программный драйвер DAQ PASCAL для одновременного перевода нескольких
 каналов милливольт в физические единицы по калибровке, а также сглаживания.
 Предполагается, что к аналоговым входам подключены преобразуемые данные,
 у которых по оси абсцисс X отложено время (то есть асцисса монотонно
 возрастает). Требование монотонности абсциссы СТРОГО ОБЯЗАТЕЛЬНО.
 Для сглаживания указывается атрибут SMOOTHING при подключении кривой ко входу.
 Можно также указать задержку Delay#n, смысл которой состоит в том, что
 сглаживание при симметричном расположении данных работает более устойчиво.
 Вводя задержку, равную обычно ширине окна сглаживания, можно получать
 сглаженный результат лучшего качества, хотя и позже по времени.
 Можно также указать историю History#n. При наличии истории будут обработаны
 все точки входных данных, а при отсутствии истории частота данных на выходе
 зависит от частоты опроса.
 Конфигурирование (пример для 3-х канального преобразователя):
 [DeviceList]
 Converter = device software program
 [Converter]
 Comment       = Устройство для калибровочных преобразований
 InquiryPeriod = 1
 DevicePolling = 10, tpNormal
 ProgramSource = ~~\Resource\DaqSite\StdLib\DaqPas\_mvtopu.pas
 AnalogFifo    = 1024
 DebugFlags    = 3
 OpenConsole   = 2
 Benchmark     = 0 ; Тест производительности
 DigitalInputs = 3
 AnalogInputs  = 3
 AnalogOutputs = 3
 Calibrations  = 3
 Delay#n       = 0 ; Задержка по умолчанию
 History#n     = 0 ; История по умолчанию
 ;**** Channel 0
 Delay#0       = 0
 History#1     = 1
 Link AnalogInput  0 with curve МиллиВолты#0
 Link AnalogOutput 0 with curve ФизЕдиницы#0 tolerance 1 0.001
 Calibration#0 = ..\calibr\_ch0.cal U(mV) PhysUnit * Line Line 0 10
 ;**** Channel 1
 Delay#1       = 0.05
 History#1     = 1
 Link AnalogInput  1 with curve МиллиВолты#1 smoothing 0.05 1 2 2
 Link AnalogOutput 1 with curve ФизЕдиницы#1 tolerance 1 0.001
 Calibration#1 = ..\calibr\_ch1.cal U(mV) PhysUnit * Line Line 0 10
 ;**** Channel 2
 Delay#2       = 0
 History#1     = 1
 Link AnalogInput  2 with curve МиллиВолты#2
 Link AnalogOutput 2 with curve ФизЕдиницы#2 tolerance 1 0.001
 Calibration#2 = ..\calibr\_ch2.cal U(mV) PhysUnit * Line Line 0 10
 Link DigitalInput 0 with curve Ворота bit 0
 Link DigitalInput 1 with curve Ворота bit 1
 Link DigitalInput 2 with curve Ворота bit 2
 ***********************************************************************
 }
program _mvtopu;                 { Milli Volts To Physical Units    }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 ChanLimit = 1023;               { Max. available channel number    }
 MaxPntNum = 1023;               { Max. num. points per cycle       }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 ChanMax   : Integer;            { Maximal channel number           }
 LastX     : array[0..ChanLimit] of Real;    { Last processed X     }
 Delay     : array[0..ChanLimit] of Real;    { Delay for processing }
 History   : array[0..ChanLimit] of Boolean; { History processing   }
 Buff_X    : array[0..MaxPntNum] of Real;    { Buffered X values    }
 Buff_Y    : array[0..MaxPntNum] of Real;    { Buffered Y values    }
 LastAo    : Real;               { Last analog output X value       }
 Benchmark : Boolean;            { Benchmark = performance tests    }
 Mode      : Integer;            { 1=_mvtopu, 2=_mvtotc             }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Try to read real variable, return default data if could not read.
 }
 function ReadRealDef(Name:String; DefData:Real):Real;
 var r:Real;
 begin
  r:=rval(ReadIni(Name));
  if IsNan(r) or IsInf(r) then ReadRealDef:=DefData else ReadRealDef:=r;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 var j:Integer; X,Y:Real;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  {
  Check program name.
  Set Mode=1 for _mvtopu and Mode=2 for _mvtotc.
  Another program name cause error.
  }
  Mode:=0;
  if IsSameText('_mvtopu',progname) then Mode:=1 else
  if IsSameText('_mvtotc',progname) then Mode:=2 else
  Trouble('Bad program name "'+ProgName+'", expect _mvtopu or _mvtotc');
  if Mode=1 then Success('mV to PU mode');
  if Mode=2 then Success('mV to TC mode');
  {
  Initialize variables
  }
  ChanMax:=NumAos-1;
  if ChanMax<0 then Trouble('No AnalogInputs connected.');
  if ChanMax>ChanLimit then Trouble('Too much AnalogInputs connected.');
  if ChanMax>ChanLimit then ChanMax:=ChanLimit;
  {
  Read Delay[i] and History[i] for each channel
  }
  X:=ReadRealDef('Delay#n',0);
  Y:=ReadRealDef('History#n',0);
  for j:=0 to ChanMax do begin
   Delay[j]:=Max(0,ReadRealDef('Delay#'+Str(j),X));
   History[j]:=Round(ReadRealDef('History#'+Str(j),Y))>0;
   LastX[j]:=_MinusInf;
  end;
  Benchmark:=val(ReadIni('Benchmark'))>0;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 var b:Boolean; X,Y,Xn,Xm,CurrX,mkSecFix,opCntFix,WindAi,WindCj,DelayAo:Real;
     j,NumPnt,Buff_N,ChanAo,ChanAi,ChanCj,CrvAo,CrvAi,CrvCj,LenAo,LenAi,LenCj:Integer;
 begin
  if Benchmark then begin
   mkSecFix:=mkSecNow;
   opCntFix:=vdpm_opcount;
  end;
  NumPnt:=0;
  for ChanAo:=0 to ChanMax do begin
   Buff_N:=0;
   ChanAi:=ChanAo*Mode;
   ChanCj:=ChanAi+Mode-1;
   CurrX:=LastX[ChanAo];
   CrvAo:=RefAo(ChanAo);
   CrvAi:=RefAi(ChanAi);
   CrvCj:=RefAi(ChanCj);
   DelayAo:=Delay[ChanAo];
   if History[ChanAo] then begin // Delay if History+Smooth
    WindAi:=getai_par(ChanAi,11); // Smoothing window width
    WindCj:=getai_par(ChanCj,11); // Smoothing window width
    if not IsNan(WindAi) then DelayAo:=Max(DelayAo,WindAi);
    if not IsNan(WindCj) then DelayAo:=Max(DelayAo,WindCj);
   end;
   if (CrvAo<>0) and (CrvAi<>0) and (CrvCj<>0) then
   if (RefDi(ChanAo)=0) or (DiWord(ChanAo,1)<>0) then begin
    {}
    b:=CrvLock(CrvAo);
    LenAo:=Round(CrvLen(CrvAo));
    if LenAo>0 then LastAo:=CrvX(CrvAo,LenAo) else LastAo:=_MinusInf;
    b:=CrvUnLock(CrvAo);
    {}
    LenCj:=Round(CrvLen(CrvCj));
    {}
    b:=CrvLock(CrvAi);
    LenAi:=Round(CrvLen(CrvAi));
    if LenAi=0 then CurrX:=LastAo else if LenCj>0 then begin
     Xn:=CrvX(CrvAi,LenAi);
     CurrX:=Max(CurrX,LastAo);
     if DelayAo=0 then begin
      if Xn>CurrX then begin
       if (LenAi=1) or not History[ChanAo] then begin
        Buff_X[Buff_N]:=Xn;
        Buff_Y[Buff_N]:=GetAi(ChanAi,Xn);
        Buff_N:=Buff_N+1;
        CurrX:=Xn;
       end else
       if CrvX(CrvAi,LenAi-1)<=CurrX then begin
        Buff_X[Buff_N]:=Xn;
        Buff_Y[Buff_N]:=GetAi(ChanAi,Xn);
        Buff_N:=Buff_N+1;
        CurrX:=Xn;
       end else begin
        j:=Round(CrvWhere(CrvAi,CurrX));
        while j<=LenAi do begin
         X:=CrvX(CrvAi,j);
         if X>CurrX then begin
          Buff_X[Buff_N]:=X;
          Buff_Y[Buff_N]:=GetAi(ChanAi,X);
          Buff_N:=Buff_N+1;
          CurrX:=X;
          if Buff_N>MaxPntNum then j:=LenAi;
         end;
         j:=j+1;
        end;
       end;
      end;
     end else begin
      Xm:=Xn-DelayAo;
      if Xm>CurrX then begin
       if History[ChanAo] then begin
        j:=Round(CrvWhere(CrvAi,CurrX));
        while j<=LenAi do begin
         X:=CrvX(CrvAi,j);
         if (X>Xm) and (Buff_N>0) then j:=LenAi else
         if X>CurrX then begin
          Buff_X[Buff_N]:=X;
          Buff_Y[Buff_N]:=GetAi(ChanAi,X);
          Buff_N:=Buff_N+1;
          CurrX:=X;
          if Buff_N>MaxPntNum then j:=LenAi;
         end;
         j:=j+1;
        end;
       end else begin
        j:=Round(CrvWhere(CrvAi,Xm));
        while j<=LenAi do begin
         X:=CrvX(CrvAi,j);
         if X>CurrX then begin
          Buff_X[Buff_N]:=X;
          Buff_Y[Buff_N]:=GetAi(ChanAi,X);
          Buff_N:=Buff_N+1;
          CurrX:=X;
          j:=LenAi;
         end;
         j:=j+1;
        end;
       end;
      end;
     end;
    end;
    b:=CrvUnlock(CrvAi);
   end;
   LastX[ChanAo]:=CurrX;
   {
   Data points is now collected in Buff_X,Buff_Y.
   Apply calibration if one assigned.
   }
   if Buff_N>0 then begin
    if RefCalibr(ChanAo)=0 then begin
     for j:=0 to Buff_N-1 do
     if not PutAo(ChanAo,Buff_X[j],Buff_Y[j])
     then Trouble('Fails PutAo '+Str(ChanAo));
    end else
    if Mode=1 then begin
     for j:=0 to Buff_N-1 do
     if not PutAo(ChanAo,Buff_X[j],Calibr(ChanAo,Buff_Y[j],0))
     then Trouble('Fails PutAo '+Str(ChanAo));
    end else begin
     for j:=0 to Buff_N-1 do
     if not PutAo(ChanAo,Buff_X[j],Calibr(ChanAo,Buff_Y[j],GetAi(ChanCj,Buff_X[j])))
     then Trouble('Fails PutAo '+Str(ChanAo));
    end;
    NumPnt:=NumPnt+Buff_N;
   end;
  end;
  {
  Print benchmark (performance) information.
  }
  if Benchmark then
  if DebugFlagEnabled(dfSuccess) then begin
   X:=mkSecNow-mkSecFix;
   Y:=vdpm_opcount-opCntFix;
   Success('Benchmark '+StrFix(X,6,0)+' mks; '
                       +StrFix(Y,6,0)+' ops; '
                       +StrFix(NumPnt,5,0)+' pts; '
                       +StrFix(X/NumPnt,7,2)+' mks/pts; '
                       +StrFix(Y/NumPnt,7,2)+' ops/pts; '
                       +StrFix(X/Y,7,2)+' mks/ops');
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Benchmark 1
   }
   if IsSameText(cmd,'@Benchmark') then begin
    Benchmark:=iValDef(Trim(arg),Ord(Benchmark))=1;
    Success(cmd+'='+Str(Ord(Benchmark)));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
