@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

set /a rateshist=300
set /a counthist=30

pushd "%~dp0\" && call :ComPortTable "%~n0.cfg"
popd
goto :EOF

:ComPortTable
if "%~1" == "" goto :EOF
set cfg=%~1
set /a ndo=0
set /a nport=0
call :DeleteFile                "%cfg%"
call :AddHeader              >  "%cfg%"
call :AddComPort COMS  *     >> "%cfg%"
for %%i in (1) do call :AddComPort COM%%i  COM%%i  >> "%cfg%"
call :AddDevice              >> "%cfg%"
goto :EOF

:DeleteFile
if "%~1" == "" goto :EOF
if exist "%~1" unix rm -f "%~1" 
unix true
goto :EOF

:AddHeader
echo ;***********************************
echo ; Adam traffic monitor configuration
echo ;***********************************
unix true
goto :EOF

:AddDevice
echo.
echo [DeviceList]
echo ^&AdamTraffic = device software program
echo [^&AdamTraffic]
echo Comment        = ADAM traffic monitor.
echo InquiryPeriod  = 1
echo DevicePolling  = 1000, tpHigher
echo ProgramSource  = ..\daqpas\adamtraffic.pas
echo DigitalFifo    = 1000
echo OpenConsole    = 2
echo DebugFlags     = 3
echo DigitalOutputs = !ndo!
echo []
echo.
unix true
goto :EOF

:AddComPort
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
echo.
echo [DataStorage]
echo AdamTraffic.%~1.BR.RX = Curve 0 10 Black  15 1 ; ADAM Byte Rate  Receiver    %~2
echo AdamTraffic.%~1.BR.TX = Curve 0 10 Black  15 1 ; ADAM Byte Rate  Transmitter %~2
echo AdamTraffic.%~1.PR.RX = Curve 0 10 Black  15 1 ; ADAM Poll Rate  Receiver    %~2
echo AdamTraffic.%~1.PR.TX = Curve 0 10 Black  15 1 ; ADAM Poll Rate  Transmitter %~2
echo AdamTraffic.%~1.BC.RX = Curve 0 10 Black  15 1 ; ADAM Byte Count Receiver    %~2
echo AdamTraffic.%~1.BC.TX = Curve 0 10 Black  15 1 ; ADAM Byte Count Transmitter %~2
echo AdamTraffic.%~1.PC.RX = Curve 0 10 Black  15 1 ; ADAM Poll Count Receiver    %~2
echo AdamTraffic.%~1.PC.TX = Curve 0 10 Black  15 1 ; ADAM Poll Count Transmitter %~2
echo []
echo.
echo [^&AdamTraffic]
echo Port!nport! = %~2
set /a nport=nport+1
echo Link DigitalOutput !ndo! with curve AdamTraffic.%~1.BR.RX history %rateshist% & set /a ndo=ndo+1
echo Link DigitalOutput !ndo! with curve AdamTraffic.%~1.BR.TX history %rateshist% & set /a ndo=ndo+1
echo Link DigitalOutput !ndo! with curve AdamTraffic.%~1.PR.RX history %rateshist% & set /a ndo=ndo+1
echo Link DigitalOutput !ndo! with curve AdamTraffic.%~1.PR.TX history %rateshist% & set /a ndo=ndo+1
echo Link DigitalOutput !ndo! with curve AdamTraffic.%~1.BC.RX history %counthist% & set /a ndo=ndo+1
echo Link DigitalOutput !ndo! with curve AdamTraffic.%~1.BC.TX history %counthist% & set /a ndo=ndo+1
echo Link DigitalOutput !ndo! with curve AdamTraffic.%~1.PC.RX history %counthist% & set /a ndo=ndo+1
echo Link DigitalOutput !ndo! with curve AdamTraffic.%~1.PC.TX history %counthist% & set /a ndo=ndo+1
echo []
echo.
unix true
goto :EOF
