@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem **************************************
rem I7018 devices config generator
rem **************************************

:Main
call :InitializeVariables
pushd "%~dp0" && call :I7018Devices
popd
goto :EOF

:SetUnixPath
for /f "tokens=* delims=" %%a in ('unix path') do set "%%a"
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set proxycfg=%~n0_proxy.cfg
set diccfg=%~n0_dic.cfg
set discfg=%~n0_dis.cfg
set devmsg=devPostMsg
set tabcrc=..\Circuits\%~n0_link.crc
set /a numhdwcfg=0
set /a numdev=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=650
set /a CTRL_TOP_STEP=70
set /a TABCRC_TOP=0
set /a TABCRC_STEP=80
set /a TABCRC_LEFT=0
set fileprefix=
set mainprefix=DEMO.MAIN
set lastport=0
goto :EOF

:I7018Devices
call :DeleteFiles %hdwcfg% %simcfg% %proxycfg% %tabcrc% %diccfg% %discfg%
call :I7018_PROXY_INIT %* >> %proxycfg%
REM ============================================COM PORT CONNECTION============================================================
rem      Device Connect DevLabel         Facility    ID    ComPort ComBaudrate     RS485Port UnitId Polling CheckSum WDReconnect DelayOnStart Calibrate Shortcut
rem call :I7018  COM     Камера 1         DEMO       P1    2       115200          1          1      10       1        1         0            1         0
rem call :I7018  COM     Ионопровод 1     DEMO       P2    1       115200          2          2      10       1        1         0            2         0
rem call :I7018  COM     Ионопровод 2     DEMO       P2    1       115200          2          2      10       1        1         0            0         0
REM ============================================TCP CONNECTION============================================================                    1         0
rem      Device Connect DevLabel         Facility    ID    TcpPort TcpClient    RS485Port  UnitId Polling   CheckSum WDReconnect DelayOnStart Calibrate Shortcut
rem call :I7018  TCP     Объем 1          DEMO       P1    5000    192.168.0.1  2          2      10        1        1           20000        1         0
rem call :I7018  TCP     Объем 2          DEMO       P1    5000    192.168.0.1  2          2      10        1        1           20000        2         0
rem call :I7018  TCP     Камера 2         DEMO       P2    5000    192.168.0.1  2          2      10        1        1           20000        0         0
rem call :I7018  TCP     Камера 3         DEMO       P3    5000    192.168.0.1  2          2      10        1        1           20000        2         0
REM ==============================================TCP CONNECTION===============================================================
rem  Device Connect DevLabel      Facilit       ID     TCPPort    TCPClient       RS485Port UnitId Polling  CheckSum WDReconnect DelayOnStart Calibrate Shortcut
call :I7018 TCP     I7018_1       DEMO       I7018.P1     5305    172.21.4.210    1          7      10         0        1        10000        1         0
rem call :I7018 TCP     I7018_2       DEMO       I7018.P2     5305    172.21.4.210    1          4      10         1        1        20000    2         0
rem call :I7018 TCP     I7018_3       DEMO       I7018.P3     5305    172.21.4.210    1          5      10         1        1        20000    0         0
REM ===========================================================================================================================
call :I7018_PROXY_END %* >> %proxycfg%
goto :EOF

:I7018
call :I7018_SET %*
call :I7018_HDW %*   >> %hdwcfg%
call :I7018_SIM %*   >> %simcfg%
call :I7018_DIC %*   >> %diccfg%
call :I7018_DIS %*   >> %discfg%
if not %lastport% == %RS485Port% (call :I7018_PROXY)
call :I7018_TABCRC   >> %tabcrc%
set /a numdev=numdev+1
set /a CTRL_TOP+=CTRL_TOP_STEP
set /a CTRL_TOP_IO+=CTRL_TOP_STEP
if "%numdev%" == "10" ( set /a CTRL_LEFT=CTRL_LEFT+465 )
if "%numdev%" == "10" ( set /a CTRL_TOP=0 )
goto :EOF


:I7018_PROXY
if "%ConnectionType%" == "COM" (call :I7018_PROXY_COM %* >> %proxycfg%)
if "%ConnectionType%" == "TCP" (call :I7018_PROXY_TCP %* >> %proxycfg%)
goto :EOF

:I7018_SET
set "ConnectionType=%~1" & shift &
set "DevLabel=%~1"       & shift &
set "FACN=%~1"           & shift & :: FACN - Facility name
set "IDEN=%~1"           & shift & :: IDEN - Identifier
set "ComPort=%~1"        & set "TCPPort=%~1"    & shift & :: Physical COM Port number
set "ComBaudrate=%~1"    & set "TCPClient=%~1"      & shift & :: Physical COM Port baudrate or IP
set "RS485Port=%~1"      & shift & :: Logical RS485 Port number
set "RS485UnitId=%~1"    & shift & :: RS485 Unit Id
set "RS485Polling=%~1"   & shift & :: RS485 Polling period, ms
set "CheckSum=%~1"       & shift & :: Use CheckSum
set "WDReconnect=%~1"    & shift & :: Do Reset State WD if WD event
set "DelayOnStart=%~1"   & shift & :: Wait time that device connected
set "Calibrate=%~1"      & shift & :: Calibrate mode 0/1/2 (no calib/phys unit/termocouple)
set "Shortcut=%~1"       & shift & :: Number channel of shortcut
set "FACP=%FACN:.=/%"            & :: Facility   DIM  path, i.e. FACN name with . to / replacement
set "FACF=%FACN:.=_%"            & :: Facility   file name, i.e. FACN name with . to _ replacement
set "IDNP=%IDEN:.=/%"            & :: Identifier file name, i.e. IDEN name with . to / replacement
set "IDNF=%IDEN:.=_%"            & :: Identifier file name, i.e. IDEN name with . to _ replacement
set /a calibr=Calibrate
goto :EOF

:I7018_PROXY_INIT
echo [TagList]
echo RS485PROXY.BYTERATE.RX  = Real 0
echo RS485PROXY.BYTERATE.TX  = Real 0
echo RS485PROXY.POLLRATE.RX  = Real 0
echo RS485PROXY.POLLRATE.TX  = Real 0
echo RS485PROXY.BUGSRATE.RX  = Real 0
echo RS485PROXY.BUGSRATE.TX  = Real 0
echo RS485PROXY.BUGSRATE.EX  = Real 0
echo RS485PROXY.BYTECOUNT.RX = Real 0
echo RS485PROXY.BYTECOUNT.TX = Real 0
echo RS485PROXY.POLLCOUNT.RX = Real 0
echo RS485PROXY.POLLCOUNT.TX = Real 0
echo RS485PROXY.BUGSCOUNT.RX = Real 0
echo RS485PROXY.BUGSCOUNT.TX = Real 0
echo RS485PROXY.BUGSCOUNT.EX = Real 0
echo []
echo.
echo [^&RS485Proxy.StartupScript]
echo @Reset
echo ;--- Задание таблицы портов (порт,протокол,описание)
echo ;--- Задание счетчиков приема/передачи/ошибок
goto :EOF

:I7018_PROXY_COM
echo ;--- Логический порт %RS485Port%
echo @Port %RS485Port% com port %ComPort% baudrate %ComBaudrate% parity none databits 8 stopbits 1
echo @PortByteCounters %RS485Port% RS485PROXY.BYTECOUNT.RX, RS485PROXY.BYTECOUNT.TX
echo @PortPollCounters %RS485Port% RS485PROXY.POLLCOUNT.RX, RS485PROXY.POLLCOUNT.TX
echo @PortErrorCounters %RS485Port% RS485PROXY.BUGSCOUNT.RX, RS485PROXY.BUGSCOUNT.TX, RS485PROXY.BUGSCOUNT.EX
echo @PortByteRates %RS485Port% RS485PROXY.BYTERATE.RX, RS485PROXY.BYTERATE.TX
echo @PortPollRates %RS485Port% RS485PROXY.POLLRATE.RX, RS485PROXY.POLLRATE.TX
echo @PortErrorRates %RS485Port% RS485PROXY.BUGSRATE.RX, RS485PROXY.BUGSRATE.TX, RS485PROXY.BUGSRATE.EX
echo @TimeGap %RS485Port% 0
set "lastport=%RS485Port%"
goto :EOF

:I7018_PROXY_TCP
echo ;--- Логический порт %RS485Port%
echo @Port %RS485Port% tcp port %TCPPort% client %TCPClient%
echo @PortByteCounters %RS485Port% RS485PROXY.BYTECOUNT.RX, RS485PROXY.BYTECOUNT.TX
echo @PortPollCounters %RS485Port% RS485PROXY.POLLCOUNT.RX, RS485PROXY.POLLCOUNT.TX
echo @PortErrorCounters %RS485Port% RS485PROXY.BUGSCOUNT.RX, RS485PROXY.BUGSCOUNT.TX, RS485PROXY.BUGSCOUNT.EX
echo @PortByteRates %RS485Port% RS485PROXY.BYTERATE.RX, RS485PROXY.BYTERATE.TX
echo @PortPollRates %RS485Port% RS485PROXY.POLLRATE.RX, RS485PROXY.POLLRATE.TX
echo @PortErrorRates %RS485Port% RS485PROXY.BUGSRATE.RX, RS485PROXY.BUGSRATE.TX, RS485PROXY.BUGSRATE.EX
echo @TimeGap %RS485Port% 0
set "lastport=%RS485Port%"
goto :EOF

:I7018_PROXY_END
echo ;--- 
echo @ZeroPortCounters
echo @View
echo @CpuProfiler start 1 60 7
echo []
goto :EOF

:I7018_Cal
echo Calibrations = 8
echo Calibration#0  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
echo Calibration#1  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
echo Calibration#2  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
echo Calibration#3  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
echo Calibration#4  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
echo Calibration#5  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
echo Calibration#6  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
echo Calibration#7  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
goto :EOF

:I7018_HDW
echo ;***************************
echo ;*****Driver for I7018******
echo ;***************************
echo [DeviceList]
echo ^&%FACN%.%IDEN%.CTRL = device software Program
echo [^&%FACN%.%IDEN%.CTRL]
echo Comment = Driver for IcpCon i-7018
echo InquiryPeriod = 0
echo DevicePolling = 1, tpNormal
echo DigitalFifo   = 1024
echo AnalogFifo    = 1024
echo ProgramSource    = ..\DaqPas\I7018_drv.pas
echo tagPrefix        = %FACN%.%IDEN%
echo OpenConsole      = 2         ; 0/1/2=Close/Show/Hide
echo DebugFlags       = 1         ; 1/2/4/8=Trouble/Success/Export/Import
echo EncryptMethod    = RC6
echo TrustedUsers     = [TrustedUsers]
echo DIM_GuiClickTag  = %FACN%.%IDEN%.DIMGUICLICK
echo RS485Port        = %RS485Port%
echo RS485UnitId      = %RS485UnitId%
echo RS485Timeout     = 250
echo RS485Deadline    = 60000
echo RS485Polling     = %RS485Polling%
echo Simulator        = 0         ; Must be 0 for driver
echo Checksum         = %CheckSum%         ; Checksum 0/1
echo WDReconnect      = %WDReconnect%         ; Watchdog Reconnect
echo DelayOnStart     = %DelayOnStart%     ;
echo Calibrate        = %Calibrate%        ; 0/1/2 - не калибровать/физические единицы/термопара
echo Shortcut         = %Shortcut%         ; Номер канала закоротки (0..7)/-1, чтобы не вычитать закоротку
echo AnalogOutputs    = 18        ; Аналоговые выходы
echo Link AnalogOutput 0  with curve %FACN%.%IDEN%.AI0         history 1024 ; Аналоговый ввод 0
echo Link AnalogOutput 1  with curve %FACN%.%IDEN%.AI1         history 1024 ; Аналоговый ввод 1
echo Link AnalogOutput 2  with curve %FACN%.%IDEN%.AI2         history 1024 ; Аналоговый ввод 2
echo Link AnalogOutput 3  with curve %FACN%.%IDEN%.AI3         history 1024 ; Аналоговый ввод 3
echo Link AnalogOutput 4  with curve %FACN%.%IDEN%.AI4         history 1024 ; Аналоговый ввод 4
echo Link AnalogOutput 5  with curve %FACN%.%IDEN%.AI5         history 1024 ; Аналоговый ввод 5
echo Link AnalogOutput 6  with curve %FACN%.%IDEN%.AI6         history 1024 ; Аналоговый ввод 6
echo Link AnalogOutput 7  with curve %FACN%.%IDEN%.AI7         history 1024 ; Аналоговый ввод 7
echo Link AnalogOutput 8  with curve %FACN%.%IDEN%.TCJ         history 1024 ; Температура холодного спая
echo Link AnalogOutput 9  with curve %FACN%.%IDEN%.SHIFT       history 1024 ; Величина смещения холодного спая
echo Link AnalogOutput 10 with curve %FACN%.%IDEN%.CALDATA.AI0 history 1024 ; Калиброванные значение аналогового ввода 0
echo Link AnalogOutput 11 with curve %FACN%.%IDEN%.CALDATA.AI1 history 1024 ; Калиброванные значение аналогового ввода 1
echo Link AnalogOutput 12 with curve %FACN%.%IDEN%.CALDATA.AI2 history 1024 ; Калиброванные значение аналогового ввода 2
echo Link AnalogOutput 13 with curve %FACN%.%IDEN%.CALDATA.AI3 history 1024 ; Калиброванные значение аналогового ввода 3
echo Link AnalogOutput 14 with curve %FACN%.%IDEN%.CALDATA.AI4 history 1024 ; Калиброванные значение аналогового ввода 4
echo Link AnalogOutput 15 with curve %FACN%.%IDEN%.CALDATA.AI5 history 1024 ; Калиброванные значение аналогового ввода 5
echo Link AnalogOutput 16 with curve %FACN%.%IDEN%.CALDATA.AI6 history 1024 ; Калиброванные значение аналогового ввода 6
echo Link AnalogOutput 17 with curve %FACN%.%IDEN%.CALDATA.AI7 history 1024 ; Калиброванные значение аналогового ввода 7
echo DigitalOutputs   = 4
echo Link DigitalOutput 0 with curve %FACN%.%IDEN%.STATE    history 1024 ; Состояние устройства
echo Link DigitalOutput 1 with curve %FACN%.%IDEN%.AIS      history 1024 ; Активные аналоговые вводы
echo Link DigitalOutput 2 with curve %FACN%.%IDEN%.RX       history 1024 ; Rx
echo Link DigitalOutput 3 with curve %FACN%.%IDEN%.TX       history 1024 ; Tx
if not "%Calibrate%" == "0" (call :I7018_Cal)
Rem echo Calibrations = 8
Rem echo Calibration#0  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
Rem echo Calibration#1  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
Rem echo Calibration#2  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
Rem echo Calibration#3  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
Rem echo Calibration#4  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
Rem echo Calibration#5  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
Rem echo Calibration#6  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
Rem echo Calibration#7  = ..\Calibr\default.cal   U(mV) O(pu) * Line Line 0 400
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\..\DEMO_DATA\I7018\%IDNF%_custom.ini
echo CustomIniSection  = [%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\..\DEMO_DATA\I7018\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 0
echo []
echo [ConfigFileList]
echo ConfigFile = ..\..\DEMO_DATA\I7018\%IDNF%_custom.ini
echo []
echo [%IDEN%.CustomParameters.TagList]
echo TagList = %FACN%.%IDEN%.POLL
echo TagList = %FACN%.%IDEN%.SHIFT
echo []
echo [DataStorage]
echo %FACN%.%IDEN%.AI0         = Curve 0 1000 Black 0  1 ; Аналоговый ввод 0
echo %FACN%.%IDEN%.AI1         = Curve 0 1000 Black 0  1 ; Аналоговый ввод 1
echo %FACN%.%IDEN%.AI2         = Curve 0 1000 Black 0  1 ; Аналоговый ввод 2
echo %FACN%.%IDEN%.AI3         = Curve 0 1000 Black 0  1 ; Аналоговый ввод 3
echo %FACN%.%IDEN%.AI4         = Curve 0 1000 Black 0  1 ; Аналоговый ввод 4
echo %FACN%.%IDEN%.AI5         = Curve 0 1000 Black 0  1 ; Аналоговый ввод 5
echo %FACN%.%IDEN%.AI6         = Curve 0 1000 Black 0  1 ; Аналоговый ввод 6
echo %FACN%.%IDEN%.AI7         = Curve 0 1000 Black 0  1 ; Аналоговый ввод 7
echo %FACN%.%IDEN%.TCJ         = Curve 0 1000 Black 0  1 ; Температура холодного спая
echo %FACN%.%IDEN%.SHIFT       = Curve 0 1000 Black 0  1 ; Величина смещения холодного спая
echo %FACN%.%IDEN%.CALDATA.AI0 = Curve 0 1000 Black 0  1 ; Калиброванные значение аналогового ввода 0
echo %FACN%.%IDEN%.CALDATA.AI1 = Curve 0 1000 Black 0  1 ; Калиброванные значение аналогового ввода 1
echo %FACN%.%IDEN%.CALDATA.AI2 = Curve 0 1000 Black 0  1 ; Калиброванные значение аналогового ввода 2
echo %FACN%.%IDEN%.CALDATA.AI3 = Curve 0 1000 Black 0  1 ; Калиброванные значение аналогового ввода 3
echo %FACN%.%IDEN%.CALDATA.AI4 = Curve 0 1000 Black 0  1 ; Калиброванные значение аналогового ввода 4
echo %FACN%.%IDEN%.CALDATA.AI5 = Curve 0 1000 Black 0  1 ; Калиброванные значение аналогового ввода 5
echo %FACN%.%IDEN%.CALDATA.AI6 = Curve 0 1000 Black 0  1 ; Калиброванные значение аналогового ввода 6
echo %FACN%.%IDEN%.CALDATA.AI7 = Curve 0 1000 Black 0  1 ; Калиброванные значение аналогового ввода 7
echo %FACN%.%IDEN%.STATE       = Curve 0 1000 Black 0  1 ; Состояние устройства
echo %FACN%.%IDEN%.AIS         = Curve 0 1000 Black 0  1 ; Активные аналоговые вводы
echo %FACN%.%IDEN%.RX          = Curve 0 1000 Black 0  1 ; Rx
echo %FACN%.%IDEN%.TX          = Curve 0 1000 Black 0  1 ; Tx
echo []
echo [TagList]
echo %FACN%.%IDEN%.DIMGUICLICK      = String ? ; Обрабочик "кликов" по DIM-серверу ( The DIM click sensor data )
echo %FACN%.%IDEN%.DIMCMDMY         = String ? ; Обработчик команд от клиента      ( The DIM command handler   )
echo %FACN%.%IDEN%.DIM.CLOCK        = String ?
echo %FACN%.%IDEN%.DIM.SERVID       = String ?
echo %FACN%.%IDEN%.POLL             = Integer 1 ; Активация окна для выбора команд для опроса
echo %FACN%.%IDEN%.RX               = Integer 0 ; Скорость получения данных
echo %FACN%.%IDEN%.TX               = Integer 0 ; Скорость отправки данных
echo %FACN%.%IDEN%.STATE            = Integer 0 ; Состояние устройства
echo %FACN%.%IDEN%.AI0              = Real 0 ;
echo %FACN%.%IDEN%.AI1              = Real 0 ;
echo %FACN%.%IDEN%.AI2              = Real 0 ;
echo %FACN%.%IDEN%.AI3              = Real 0 ;
echo %FACN%.%IDEN%.AI4              = Real 0 ;
echo %FACN%.%IDEN%.AI5              = Real 0 ;
echo %FACN%.%IDEN%.AI6              = Real 0 ;
echo %FACN%.%IDEN%.AI7              = Real 0 ;
echo %FACN%.%IDEN%.TCJ              = Real 0 ;
echo %FACN%.%IDEN%.SHIFT            = Real 0 ;
echo %FACN%.%IDEN%.AIS              = Integer 0 ;
echo %FACN%.%IDEN%.CALDATA.AI0      = Real 0 ;
echo %FACN%.%IDEN%.CALDATA.AI1      = Real 0 ;
echo %FACN%.%IDEN%.CALDATA.AI2      = Real 0 ;
echo %FACN%.%IDEN%.CALDATA.AI3      = Real 0 ;
echo %FACN%.%IDEN%.CALDATA.AI4      = Real 0 ;
echo %FACN%.%IDEN%.CALDATA.AI5      = Real 0 ;
echo %FACN%.%IDEN%.CALDATA.AI6      = Real 0 ;
echo %FACN%.%IDEN%.CALDATA.AI7      = Real 0 ;
echo %FACN%.%IDEN%.DEVCAL.AUTH      = Integer 0 ;
echo %FACN%.%IDEN%.DEVCAL.ZERO      = Integer 0 ;
echo %FACN%.%IDEN%.DEVCAL.RANGE     = Integer 0 ;
echo %FACN%.%IDEN%.NAME             = String  Null ; Имя устройства
echo %FACN%.%IDEN%.VERSION          = String  Null ; Версия устройства
echo %FACN%.%IDEN%.ADDRESS          = Integer 0 ; Адрес устройства
echo %FACN%.%IDEN%.BAUDRATE         = Integer 0 ; Скорость бод устройства
echo %FACN%.%IDEN%.CHECKSUM         = Integer 0 ; Производить контроль CHECKSUM?
echo %FACN%.%IDEN%.PARITY           = Integer 0 ; Параметры PARITY
echo %FACN%.%IDEN%.INPTYPE          = Integer 0 ; Параметры входных данных
echo %FACN%.%IDEN%.REJFILTER        = Integer 0 ; Параметры частотного фильтра
echo %FACN%.%IDEN%.DATATYPE         = Integer 0 ; Параметры формата данных
echo %FACN%.%IDEN%.WATCHDOG.TIMEOUT = Real 0    ; Значение WatchDog TimeOut
echo %FACN%.%IDEN%.WATCHDOG.ENABLE  = Integer 0 ; Состояние WatcDog
echo %FACN%.%IDEN%.WATCHDOG.STATUS  = Integer 0 ; Вкл./выкл. WatchDog
echo []
echo [Windows]
echo %FACN%.%IDEN%.CTRL = Circuit_Window
echo [%FACN%.%IDEN%.CTRL]
echo Circuit = ..\Circuits\I7018_ctrl.crc
echo Link sensor I7018.DIM.CLOCK        with tag   %FACN%.%IDEN%.DIM.CLOCK             device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.DIM.HOST         with tag   %FACN%.%IDEN%.DIM.SERVID            device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.POLL             with tag   %FACN%.%IDEN%.POLL                  device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.RX               with curve %FACN%.%IDEN%.RX                    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.TX               with curve %FACN%.%IDEN%.TX                    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.STATE            with curve %FACN%.%IDEN%.STATE                 device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI0              with curve %FACN%.%IDEN%.AI0                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI1              with curve %FACN%.%IDEN%.AI1                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI2              with curve %FACN%.%IDEN%.AI2                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI3              with curve %FACN%.%IDEN%.AI3                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI4              with curve %FACN%.%IDEN%.AI4                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI5              with curve %FACN%.%IDEN%.AI5                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI6              with curve %FACN%.%IDEN%.AI6                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI7              with curve %FACN%.%IDEN%.AI7                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.TCJ              with curve %FACN%.%IDEN%.TCJ                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.SHIFT            with tag   %FACN%.%IDEN%.SHIFT                 device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.CALDATA.AI0      with curve %FACN%.%IDEN%.CALDATA.AI0           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.CALDATA.AI1      with curve %FACN%.%IDEN%.CALDATA.AI1           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.CALDATA.AI2      with curve %FACN%.%IDEN%.CALDATA.AI2           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.CALDATA.AI3      with curve %FACN%.%IDEN%.CALDATA.AI3           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.CALDATA.AI4      with curve %FACN%.%IDEN%.CALDATA.AI4           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.CALDATA.AI5      with curve %FACN%.%IDEN%.CALDATA.AI5           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.CALDATA.AI6      with curve %FACN%.%IDEN%.CALDATA.AI6           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.CALDATA.AI7      with curve %FACN%.%IDEN%.CALDATA.AI7           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.DEVCAL.AUTH      with tag   %FACN%.%IDEN%.DEVCAL.AUTH           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.DEVCAL.ZERO      with tag   %FACN%.%IDEN%.DEVCAL.ZERO           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.DEVCAL.RANGE     with tag   %FACN%.%IDEN%.DEVCAL.RANGE          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.NAME             with tag   %FACN%.%IDEN%.NAME                  device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.VERSION          with tag   %FACN%.%IDEN%.VERSION               device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.ADDRESS          with tag   %FACN%.%IDEN%.ADDRESS               device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.BAUDRATE         with tag   %FACN%.%IDEN%.BAUDRATE              device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.CHECKSUM         with tag   %FACN%.%IDEN%.CHECKSUM              device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.PARITY           with tag   %FACN%.%IDEN%.PARITY                device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.INPTYPE          with tag   %FACN%.%IDEN%.INPTYPE               device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.REJFILTER        with tag   %FACN%.%IDEN%.REJFILTER             device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.DATATYPE         with tag   %FACN%.%IDEN%.DATATYPE              device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.WATCHDOG.TIMEOUT with tag   %FACN%.%IDEN%.WATCHDOG.TIMEOUT      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.WATCHDOG.ENABLE  with tag   %FACN%.%IDEN%.WATCHDOG.ENABLE       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.WATCHDOG.STATUS  with tag   %FACN%.%IDEN%.WATCHDOG.STATUS       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.LABEL            with                                           device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI0.ENABLE       with tag   %FACN%.%IDEN%.AIS                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI1.ENABLE       with tag   %FACN%.%IDEN%.AIS                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI2.ENABLE       with tag   %FACN%.%IDEN%.AIS                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI3.ENABLE       with tag   %FACN%.%IDEN%.AIS                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI4.ENABLE       with tag   %FACN%.%IDEN%.AIS                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI5.ENABLE       with tag   %FACN%.%IDEN%.AIS                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI6.ENABLE       with tag   %FACN%.%IDEN%.AIS                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7018.AI7.ENABLE       with tag   %FACN%.%IDEN%.AIS                   device ^&%FACN%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FACN%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinShow %FACN%.%IDEN%.CTRL
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Left=650^|Top=0^|Width=513^|Height=610
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FACN%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.SHOW @WinShow %FACN%.%IDEN%.CTRL
echo @cron.tab %FACN%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.HIDE @WinHide %FACN%.%IDEN%.CTRL
echo @cron.tab %FACN%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.SELECT @WinSelect %FACN%.%IDEN%.CTRL
echo @cron.job %mainprefix%.CTRL.HOME @cron.run %FACN%.%IDEN%.CTRL.HOME
echo @cron.job %mainprefix%.CTRL.HOME @cron.run %FACN%.%IDEN%.CTRL.HIDE
echo []
echo [%mainprefix%.CTRL]
echo Link sensor @cron+@cron.run+%FACN%.%IDEN%.CTRL.SELECT with device ^&%mainprefix%.CTRL
echo Link sensor %FACN%.%IDEN%.STATE  with curve %FACN%.%IDEN%.STATE    device ^&%FACN%.%IDEN%.CTRL
echo []
echo [Windows]
echo %FACN%.%IDEN%.PARAM.PLOT = Curve_Window
echo [%FACN%.%IDEN%.PARAM.PLOT]
echo AxisX = ^R{Hours}___^N^CTime, 0, 0.25
echo AxisY = ^CState channel^N^L___{Status}, 0, 1000
echo CurveList = %FACN%.%IDEN%.AI0         ; Аналоговый ввод 0
echo CurveList = %FACN%.%IDEN%.AI1         ; Аналоговый ввод 1
echo CurveList = %FACN%.%IDEN%.AI2         ; Аналоговый ввод 2
echo CurveList = %FACN%.%IDEN%.AI3         ; Аналоговый ввод 3
echo CurveList = %FACN%.%IDEN%.AI4         ; Аналоговый ввод 4
echo CurveList = %FACN%.%IDEN%.AI5         ; Аналоговый ввод 5
echo CurveList = %FACN%.%IDEN%.AI6         ; Аналоговый ввод 6
echo CurveList = %FACN%.%IDEN%.AI7         ; Аналоговый ввод 7
echo CurveList = %FACN%.%IDEN%.TCJ         ; Температура холодного спая
echo CurveList = %FACN%.%IDEN%.SHIFT       ; Величина смещения холодного спая
echo CurveList = %FACN%.%IDEN%.CALDATA.AI0 ; Калиброванные значение аналогового ввода 0
echo CurveList = %FACN%.%IDEN%.CALDATA.AI1 ; Калиброванные значение аналогового ввода 1
echo CurveList = %FACN%.%IDEN%.CALDATA.AI2 ; Калиброванные значение аналогового ввода 2
echo CurveList = %FACN%.%IDEN%.CALDATA.AI3 ; Калиброванные значение аналогового ввода 3
echo CurveList = %FACN%.%IDEN%.CALDATA.AI4 ; Калиброванные значение аналогового ввода 4
echo CurveList = %FACN%.%IDEN%.CALDATA.AI5 ; Калиброванные значение аналогового ввода 5
echo CurveList = %FACN%.%IDEN%.CALDATA.AI6 ; Калиброванные значение аналогового ввода 6
echo CurveList = %FACN%.%IDEN%.CALDATA.AI7 ; Калиброванные значение аналогового ввода 7
echo CurveList = %FACN%.%IDEN%.STATE       ; Состояние устройства
echo CurveList = %FACN%.%IDEN%.AIS         ; Активные аналоговые вводы
echo CurveList = %FACN%.%IDEN%.RX          ; Rx
echo CurveList = %FACN%.%IDEN%.TX          ; Tx
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.HOME 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinShow %FACN%.%IDEN%.PARAM.PLOT
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FACN%.%IDEN%.PARAM.PLOT^|Left=167^|Top=120^|Height=600^|Width=1000
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FACN%.%IDEN%.PARAM.PLOT^|Options=-Min,-Max,+Close,+VScroll,-HScroll,+StatusBar
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FACN%.%IDEN%.PARAM.PLOT^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.SHOW 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.SHOW @WinShow %FACN%.%IDEN%.PARAM.PLOT
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.HIDE 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HIDE @WinHide %FACN%.%IDEN%.PARAM.PLOT
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.SELECT 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.SELECT @WinSelect %FACN%.%IDEN%.PARAM.PLOT
echo @cron.job %mainprefix%.CTRL.HOME @cron.run %FACN%.%IDEN%.PARAM.PLOT.HOME
echo @cron.job %mainprefix%.CTRL.HOME @cron.run %FACN%.%IDEN%.PARAM.PLOT.HIDE
echo []
echo [^&DATSRV]
echo CurveList = %FACN%.%IDEN%.AI0         ; Аналоговый ввод 0
echo CurveList = %FACN%.%IDEN%.AI1         ; Аналоговый ввод 1
echo CurveList = %FACN%.%IDEN%.AI2         ; Аналоговый ввод 2
echo CurveList = %FACN%.%IDEN%.AI3         ; Аналоговый ввод 3
echo CurveList = %FACN%.%IDEN%.AI4         ; Аналоговый ввод 4
echo CurveList = %FACN%.%IDEN%.AI5         ; Аналоговый ввод 5
echo CurveList = %FACN%.%IDEN%.AI6         ; Аналоговый ввод 6
echo CurveList = %FACN%.%IDEN%.AI7         ; Аналоговый ввод 7
echo CurveList = %FACN%.%IDEN%.TCJ         ; Температура холодного спая
echo CurveList = %FACN%.%IDEN%.SHIFT       ; Величина смещения холодного спая
echo CurveList = %FACN%.%IDEN%.CALDATA.AI0 ; Калиброванные значение аналогового ввода 0
echo CurveList = %FACN%.%IDEN%.CALDATA.AI1 ; Калиброванные значение аналогового ввода 1
echo CurveList = %FACN%.%IDEN%.CALDATA.AI2 ; Калиброванные значение аналогового ввода 2
echo CurveList = %FACN%.%IDEN%.CALDATA.AI3 ; Калиброванные значение аналогового ввода 3
echo CurveList = %FACN%.%IDEN%.CALDATA.AI4 ; Калиброванные значение аналогового ввода 4
echo CurveList = %FACN%.%IDEN%.CALDATA.AI5 ; Калиброванные значение аналогового ввода 5
echo CurveList = %FACN%.%IDEN%.CALDATA.AI6 ; Калиброванные значение аналогового ввода 6
echo CurveList = %FACN%.%IDEN%.CALDATA.AI7 ; Калиброванные значение аналогового ввода 7
echo CurveList = %FACN%.%IDEN%.STATE       ; Состояние устройства
echo CurveList = %FACN%.%IDEN%.AIS         ; Активные аналоговые вводы
echo CurveList = %FACN%.%IDEN%.RX          ; Rx
echo CurveList = %FACN%.%IDEN%.TX          ; Tx
echo []
goto :EOF

:I7018_SIM
echo [^&%FACN%.%IDEN%.CTRL]
echo Simulator = 1
echo []
rem Include hardware config if one not done yet
if "%numhdwcfg%" == "0" ( set /a numhdwcfg=numhdwcfg+1 ) else ( goto :EOF )
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
echo.
goto :EOF

:I7018_DIS
unix dimcfg ^
  -n section "[&%FACN%.%IDEN%.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd   %FACP%/%IDNP%/DIMGUICLICK ^
  -n tag        %FACN%.%IDEN%.DIMGUICLICK ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dis_cmnd   %FACP%/%IDNP%/DIMCMDMY ^
  -n tag        %FACN%.%IDEN%.DIMCMDMY ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DIMCMDMY=%%**" ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDNP%/DIMGUICLICK ^
  -n tag        %FACN%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDNP%/DIMCMDMY ^
  -n tag        %FACN%.%IDEN%.DIMCMDMY ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/DIM/CLOCK+SERVID ^
  -n tag        %FACN%.%IDEN%.DIM.CLOCK ^
  -n tag        %FACN%.%IDEN%.DIM.SERVID ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/POLL ^
  -n tag        %FACN%.%IDEN%.POLL ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/STATE ^
  -n tag        %FACN%.%IDEN%.STATE ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/RX+TX ^
  -n tag        %FACN%.%IDEN%.RX ^
  -n tag        %FACN%.%IDEN%.TX ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/AI0+AI1+AI2+AI3+AI4+AI5+AI6+AI7+TCJ ^
  -n tag        %FACN%.%IDEN%.AI0 ^
  -n tag        %FACN%.%IDEN%.AI1 ^
  -n tag        %FACN%.%IDEN%.AI2 ^
  -n tag        %FACN%.%IDEN%.AI3 ^
  -n tag        %FACN%.%IDEN%.AI4 ^
  -n tag        %FACN%.%IDEN%.AI5 ^
  -n tag        %FACN%.%IDEN%.AI6 ^
  -n tag        %FACN%.%IDEN%.AI7 ^
  -n tag        %FACN%.%IDEN%.TCJ ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/SHIFT ^
  -n tag        %FACN%.%IDEN%.SHIFT ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/AIS ^
  -n tag        %FACN%.%IDEN%.AIS ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CALDATA/AI0+AI1+AI2+AI3+AI4+AI5+AI6+AI7 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI0 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI1 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI2 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI3 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI4 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI5 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI6 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI7 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/DEVCAL/AUTH+ZERO+RANGE ^
  -n tag        %FACN%.%IDEN%.DEVCAL.AUTH ^
  -n tag        %FACN%.%IDEN%.DEVCAL.ZERO ^
  -n tag        %FACN%.%IDEN%.DEVCAL.RANGE ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/NAME ^
  -n tag        %FACN%.%IDEN%.NAME ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/VERSION ^
  -n tag        %FACN%.%IDEN%.VERSION ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/ADDRESS ^
  -n tag        %FACN%.%IDEN%.ADDRESS ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/BAUDRATE ^
  -n tag        %FACN%.%IDEN%.BAUDRATE ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CHECKSUM ^
  -n tag        %FACN%.%IDEN%.CHECKSUM ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/PARITY ^
  -n tag        %FACN%.%IDEN%.PARITY ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/INPTYPE ^
  -n tag        %FACN%.%IDEN%.INPTYPE ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/REJFILTER ^
  -n tag        %FACN%.%IDEN%.REJFILTER ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/DATATYPE ^
  -n tag        %FACN%.%IDEN%.DATATYPE ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/WATCHDOG/TIMEOUT+ENABLE+STATUS ^
  -n tag        %FACN%.%IDEN%.WATCHDOG.TIMEOUT ^
  -n tag        %FACN%.%IDEN%.WATCHDOG.ENABLE ^
  -n tag        %FACN%.%IDEN%.WATCHDOG.STATUS ^
  -n end ^
echo.
goto :EOF

:I7018_DIC
unix dimcfg ^
  -n section "[&%FACN%.%IDEN%.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDNP%/DIMGUICLICK ^
  -n tag        %FACN%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/DIM/CLOCK+SERVID ^
  -n tag        %FACN%.%IDEN%.DIM.CLOCK ^
  -n tag        %FACN%.%IDEN%.DIM.SERVID ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/POLL ^
  -n tag        %FACN%.%IDEN%.POLL ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/STATE ^
  -n tag        %FACN%.%IDEN%.STATE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.STATE" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/RX+TX ^
  -n tag        %FACN%.%IDEN%.RX ^
  -n tag        %FACN%.%IDEN%.TX ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.RX" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.TX" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/AI0+AI1+AI2+AI3+AI4+AI5+AI6+AI7+TCJ ^
  -n tag        %FACN%.%IDEN%.AI0 ^
  -n tag        %FACN%.%IDEN%.AI1 ^
  -n tag        %FACN%.%IDEN%.AI2 ^
  -n tag        %FACN%.%IDEN%.AI3 ^
  -n tag        %FACN%.%IDEN%.AI4 ^
  -n tag        %FACN%.%IDEN%.AI5 ^
  -n tag        %FACN%.%IDEN%.AI6 ^
  -n tag        %FACN%.%IDEN%.AI7 ^
  -n tag        %FACN%.%IDEN%.TCJ ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.AI0" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.AI1" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.AI2" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.AI3" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.AI4" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.AI5" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.AI6" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.AI7" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.TCJ" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/SHIFT ^
  -n tag        %FACN%.%IDEN%.SHIFT ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.SHIFT" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/AIS ^
  -n tag        %FACN%.%IDEN%.AIS ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.AIS" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CALDATA/AI0+AI1+AI2+AI3+AI4+AI5+AI6+AI7 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI0 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI1 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI2 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI3 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI4 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI5 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI6 ^
  -n tag        %FACN%.%IDEN%.CALDATA.AI7 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CALDATA.AI0" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CALDATA.AI1" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CALDATA.AI2" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CALDATA.AI3" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CALDATA.AI4" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CALDATA.AI5" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CALDATA.AI6" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CALDATA.AI7" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/DEVCAL/AUTH+ZERO+RANGE ^
  -n tag        %FACN%.%IDEN%.DEVCAL.AUTH ^
  -n tag        %FACN%.%IDEN%.DEVCAL.ZERO ^
  -n tag        %FACN%.%IDEN%.DEVCAL.RANGE ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/NAME ^
  -n tag        %FACN%.%IDEN%.NAME ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/VERSION ^
  -n tag        %FACN%.%IDEN%.VERSION ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/ADDRESS ^
  -n tag        %FACN%.%IDEN%.ADDRESS ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/BAUDRATE ^
  -n tag        %FACN%.%IDEN%.BAUDRATE ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CHECKSUM ^
  -n tag        %FACN%.%IDEN%.CHECKSUM ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/PARITY ^
  -n tag        %FACN%.%IDEN%.PARITY ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/INPTYPE ^
  -n tag        %FACN%.%IDEN%.INPTYPE ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/REJFILTER ^
  -n tag        %FACN%.%IDEN%.REJFILTER ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/DATATYPE ^
  -n tag        %FACN%.%IDEN%.DATATYPE ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/WATCHDOG/TIMEOUT+ENABLE+STATUS ^
  -n tag        %FACN%.%IDEN%.WATCHDOG.TIMEOUT ^
  -n tag        %FACN%.%IDEN%.WATCHDOG.ENABLE ^
  -n tag        %FACN%.%IDEN%.WATCHDOG.STATUS ^
  -n end ^
echo.
goto :EOF

:I7018_TABCRC
set /a YPOS=TABCRC_TOP+90
echo [SensorList]
echo Sensor = @cron+@cron.run+%FACN%.%IDEN%.CTRL.SELECT
echo [@cron+@cron.run+%FACN%.%IDEN%.CTRL.SELECT]
echo Pos = 10, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:18\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_200_30_24_lightsteelblue1_ptmono.bmp %DevLabel%
echo Hint = %FACN%.%IDEN%.CTRL: Открыть окно управления %IDEN%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.STATE
echo [%FACN%.%IDEN%.STATE]
echo Pos = 220, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:18
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_200_30_24_silver.bmp "Выключен"
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_200_30_24_lime.bmp "Работает"
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_200_30_24_yellow.bmp "Timeout"
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_200_30_24_red.bmp "Refused"
echo Tag#5 = 4, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_200_30_24_firebrick.bmp "WatchDog"
echo Tag#6 = 5, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_200_30_24_red.bmp "Обрыв термпары"
echo Tag#7 = 6, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_200_30_24_yellow.bmp "Simulator"
echo Hint = Состояние устройства %DevLabel%
echo []
set /a TABCRC_TOP+=TABCRC_STEP
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
