 {
 ***********************************************************************
 Daq Pascal application program DemoPaint.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 }
program DemoPaint;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 tagThruWayValve1 : Integer;     { Through-way valve1 tag           }
 tagThruWayValve2 : Integer;     { Through-way valve2 tag           }
 tag3WayValve1    : Integer;     { Three-Way Valve1 tag             }
 tag3WayValve2    : Integer;     { Three-Way Valve2 tag             }
 tag3WayValve3    : Integer;     { Three-Way Valve3 tag             }
 tag3WayValve4    : Integer;     { Three-Way Valve4 tag             }
 tagAngleValve1   : Integer;     { Angle Valve1 tag                 }
 tagAngleValve2   : Integer;     { Angle Valve2 tag                 }
 tagAngleValve3   : Integer;     { Angle Valve3 tag                 }
 tagAngleValve4   : Integer;     { Angle Valve4 tag                 }
 tagManualValve1  : Integer;     { Manual Valve1 tag                }
 tagManualValve2  : Integer;     { Manual Valve2 tag                }
 tagManualValve3  : Integer;     { Manual Valve3 tag                }
 tagManualValve4  : Integer;     { Manual Valve4 tag                }
 tagSolenValve1   : Integer;     { Solenoid Valve1 tag              }
 tagSolenValve2   : Integer;     { Solenoid Valve2 tag              }
 tagSolenValve3   : Integer;     { Solenoid Valve3 tag              }
 tagSolenValve4   : Integer;     { Solenoid Valve4 tag              }
 tagMotorValve1   : Integer;     { Motorized Valve1 tag             }
 tagMotorValve2   : Integer;     { Motorized Valve2 tag             }
 tagMotorValve3   : Integer;     { Motorized Valve3 tag             }
 tagMotorValve4   : Integer;     { Motorized Valve4 tag             }
 tagPneumoValve1  : Integer;     { Pneumatic Valve1 tag             }
 tagPneumoValve2  : Integer;     { Pneumatic Valve2 tag             }
 tagPneumoValve3  : Integer;     { Pneumatic Valve3 tag             }
 tagPneumoValve4  : Integer;     { Pneumatic Valve4 tag             }
 tagRotaryGate1   : Integer;     { Rotary Gate1 tag                 }
 tagRotaryGate2   : Integer;     { Rotary Gate2 tag                 }
 tagValveGate1    : Integer;     { Valve  Gate1 tag                 }
 tagValveGate2    : Integer;     { Valve  Gate2 tag                 }
 tagDiffusionPump : Integer;     { Diffusion Pump tag               }
 tagSputIonPump   : Integer;     { Sputter ion pump tag             }
 tagRotDoublPump1 : Integer;     { Double-Stage Rotary pump 1 tag   }
 tagRotDoublPump2 : Integer;     { Double-Stage Rotary pump 2 tag   }
 tagRotDoublPump3 : Integer;     { Double-Stage Rotary pump 3 tag   }
 tagRotDoublPump4 : Integer;     { Double-Stage Rotary pump 4 tag   }
 tagRotSinglPump1 : Integer;     { Single-Stage Rotary pump 1 tag   }
 tagRotSinglPump2 : Integer;     { Single-Stage Rotary pump 2 tag   }
 tagRotSinglPump3 : Integer;     { Single-Stage Rotary pump 3 tag   }
 tagRotSinglPump4 : Integer;     { Single-Stage Rotary pump 4 tag   }
 tagTurbomolPump1 : Integer;     { Turbomolecular pump 1 tag        }
 tagTurbomolPump2 : Integer;     { Turbomolecular pump 2 tag        }
 tagTurbomolPump3 : Integer;     { Turbomolecular pump 3 tag        }
 tagTurbomolPump4 : Integer;     { Turbomolecular pump 4 tag        }
 tagRootsPump1    : Integer;     { Roots pump 1 tag                 }
 tagRootsPump2    : Integer;     { Roots pump 2 tag                 }
 tagRootsPump3    : Integer;     { Roots pump 3 tag                 }
 tagRootsPump4    : Integer;     { Roots pump 4 tag                 }
 tagSublimPump    : Integer;     { Sublimation pump tag             }
 tagPenningVac1   : Integer;     { Penning vacuometer 1 tag         }
 tagPenningVac2   : Integer;     { Penning vacuometer 2 tag         }
 tagPenningVac3   : Integer;     { Penning vacuometer 3 tag         }
 tagPenningVac4   : Integer;     { Penning vacuometer 4 tag         }
 tagLeakDetector  : Integer;     { Leak Detector tag                }
 tagIonizatVac1   : Integer;     { Ionization vacuometer 1 tag      }
 tagIonizatVac2   : Integer;     { Ionization vacuometer 2 tag      }
 tagIonizatVac3   : Integer;     { Ionization vacuometer 3 tag      }
 tagIonizatVac4   : Integer;     { Ionization vacuometer 4 tag      }
 tagThermalVac1   : Integer;     { Thermal vacuometer 1 tag         }
 tagCompressor1   : Integer;     { Compressor 1 tag                 }
 tagCompressor2   : Integer;     { Compressor 2 tag                 }
 tagCompressor3   : Integer;     { Compressor 3 tag                 }
 tagCompressor4   : Integer;     { Compressor 4 tag                 }


 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Xor bit on click (local version).
 }
 procedure ClickTagXorLocal(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  InitTag(tagThruWayValve1,'ThruWayValve1',1); // Valves
  InitTag(tagThruWayValve2,'ThruWayValve2',1);
  InitTag(tag3WayValve1,   '3WayValve1',   1);
  InitTag(tag3WayValve2,   '3WayValve2',   1);
  InitTag(tag3WayValve3,   '3WayValve3',   1);
  InitTag(tag3WayValve4,   '3WayValve4',   1);
  InitTag(tagAngleValve1,  'AngleValve1',  1);
  InitTag(tagAngleValve2,  'AngleValve2',  1);
  InitTag(tagAngleValve3,  'AngleValve3',  1);
  InitTag(tagAngleValve4,  'AngleValve4',  1);
  InitTag(tagSolenValve1,  'SolenValve1',  1);
  InitTag(tagSolenValve2,  'SolenValve2',  1);
  InitTag(tagSolenValve3,  'SolenValve3',  1);
  InitTag(tagSolenValve4,  'SolenValve4',  1);
  InitTag(tagMotorValve1,  'MotorValve1',  1);
  InitTag(tagMotorValve2,  'MotorValve2',  1);
  InitTag(tagMotorValve3,  'MotorValve3',  1);
  InitTag(tagMotorValve4,  'MotorValve4',  1);
  InitTag(tagPneumoValve1, 'PneumoValve1', 1);
  InitTag(tagPneumoValve2, 'PneumoValve2', 1);
  InitTag(tagPneumoValve3, 'PneumoValve3', 1);
  InitTag(tagPneumoValve4, 'PneumoValve4', 1);
  InitTag(tagManualValve1, 'ManualValve1', 1);
  InitTag(tagManualValve2, 'ManualValve2', 1);
  InitTag(tagManualValve3, 'ManualValve3', 1);
  InitTag(tagManualValve4, 'ManualValve4', 1);
  InitTag(tagRotaryGate1,  'RotaryGate1',  1);
  InitTag(tagRotaryGate2,  'RotaryGate2',  1);
  InitTag(tagValveGate1,   'ValveGate1',   1);
  InitTag(tagValveGate2,   'ValveGate2',   1);
  InitTag(tagDiffusionPump,'DiffusionPump',1); // Pumps
  InitTag(tagSputIonPump,  'SputIonPump',  1);
  InitTag(tagRotDoublPump1,'RotDoublPump1',1);
  InitTag(tagRotDoublPump2,'RotDoublPump2',1);
  InitTag(tagRotDoublPump3,'RotDoublPump3',1);
  InitTag(tagRotDoublPump4,'RotDoublPump4',1);
  InitTag(tagRotSinglPump1,'RotSinglPump1',1);
  InitTag(tagRotSinglPump2,'RotSinglPump2',1);
  InitTag(tagRotSinglPump3,'RotSinglPump3',1);
  InitTag(tagRotSinglPump4,'RotSinglPump4',1);
  InitTag(tagTurbomolPump1,'TurbomolPump1',1);
  InitTag(tagTurbomolPump2,'TurbomolPump2',1);
  InitTag(tagTurbomolPump3,'TurbomolPump3',1);
  InitTag(tagTurbomolPump4,'TurbomolPump4',1);
  InitTag(tagRootsPump1,   'RootsPump1',   1);
  InitTag(tagRootsPump2,   'RootsPump2',   1);
  InitTag(tagRootsPump3,   'RootsPump3',   1);
  InitTag(tagRootsPump4,   'RootsPump4',   1);
  InitTag(tagSublimPump,   'SublimPump',   1);
  InitTag(tagPenningVac1,  'PenningVac1',  1); // Vacuometers
  InitTag(tagPenningVac2,  'PenningVac2',  1);
  InitTag(tagPenningVac3,  'PenningVac3',  1);
  InitTag(tagPenningVac4,  'PenningVac4',  1);
  InitTag(tagIonizatVac1,  'IonizatVac1',  1);
  InitTag(tagIonizatVac2,  'IonizatVac2',  1);
  InitTag(tagIonizatVac3,  'IonizatVac3',  1);
  InitTag(tagIonizatVac4,  'IonizatVac4',  1);
  InitTag(tagThermalVac1,  'ThermalVac1',  1);
  InitTag(tagLeakDetector, 'LeakDetector', 1); // LeakDetector
  InitTag(tagCompressor1,  'Compressor1',  1); // Compressors
  InitTag(tagCompressor2,  'Compressor2',  1);
  InitTag(tagCompressor3,  'Compressor3',  1);
  InitTag(tagCompressor4,  'Compressor4',  1);
  iNul(ClickFilter(ClickFilter(1))); // Reset to defaults
  iNul(ClickAwaker(ClickAwaker(1))); // Reset to defaults
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   // Handle MouseDown/KeyDown
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    if (ClickButton=VK_LBUTTON) then begin
     Success('Click detected:'+EOL+ClickParams(''));
     if IsSameText(ClickSensor,'HELP') then begin
      Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
      bNul(Voice(snd_Click));
     end;
     //
     // Click on Valve Button
     //
     ClickTagXorLocal(tagThruWayValve1,1);
     ClickTagXorLocal(tagThruWayValve2,1);
     ClickTagXorLocal(tag3WayValve1,1);
     ClickTagXorLocal(tag3WayValve2,1);
     ClickTagXorLocal(tag3WayValve3,1);
     ClickTagXorLocal(tag3WayValve4,1);
     ClickTagXorLocal(tagAngleValve1,1);
     ClickTagXorLocal(tagAngleValve2,1);
     ClickTagXorLocal(tagAngleValve3,1);
     ClickTagXorLocal(tagAngleValve4,1);
     ClickTagXorLocal(tagSolenValve1,1);
     ClickTagXorLocal(tagSolenValve2,1);
     ClickTagXorLocal(tagSolenValve3,1);
     ClickTagXorLocal(tagSolenValve4,1);
     ClickTagXorLocal(tagMotorValve1,1);
     ClickTagXorLocal(tagMotorValve2,1);
     ClickTagXorLocal(tagMotorValve3,1);
     ClickTagXorLocal(tagMotorValve4,1);
     ClickTagXorLocal(tagPneumoValve1,1);
     ClickTagXorLocal(tagPneumoValve2,1);
     ClickTagXorLocal(tagPneumoValve3,1);
     ClickTagXorLocal(tagPneumoValve4,1);
     ClickTagXorLocal(tagManualValve1,1);
     ClickTagXorLocal(tagManualValve2,1);
     ClickTagXorLocal(tagManualValve3,1);
     ClickTagXorLocal(tagManualValve4,1);
     ClickTagXorLocal(tagRotaryGate1,1);
     ClickTagXorLocal(tagRotaryGate2,1);
     ClickTagXorLocal(tagValveGate1,1);
     ClickTagXorLocal(tagValveGate2,1);
     ClickTagXorLocal(tagDiffusionPump,1);
     ClickTagXorLocal(tagSputIonPump,1);
     ClickTagXorLocal(tagRotDoublPump1,1);
     ClickTagXorLocal(tagRotDoublPump2,1);
     ClickTagXorLocal(tagRotDoublPump3,1);
     ClickTagXorLocal(tagRotDoublPump4,1);
     ClickTagXorLocal(tagRotSinglPump1,1);
     ClickTagXorLocal(tagRotSinglPump2,1);
     ClickTagXorLocal(tagRotSinglPump3,1);
     ClickTagXorLocal(tagRotSinglPump4,1);
     ClickTagXorLocal(tagTurbomolPump1,1);
     ClickTagXorLocal(tagTurbomolPump2,1);
     ClickTagXorLocal(tagTurbomolPump3,1);
     ClickTagXorLocal(tagTurbomolPump4,1);
     ClickTagXorLocal(tagRootsPump1,1);
     ClickTagXorLocal(tagRootsPump2,1);
     ClickTagXorLocal(tagRootsPump3,1);
     ClickTagXorLocal(tagRootsPump4,1);
     ClickTagXorLocal(tagSublimPump,1);
     ClickTagXorLocal(tagPenningVac1,1);
     ClickTagXorLocal(tagPenningVac2,1);
     ClickTagXorLocal(tagPenningVac3,1);
     ClickTagXorLocal(tagPenningVac4,1);
     ClickTagXorLocal(tagIonizatVac1,1);
     ClickTagXorLocal(tagIonizatVac2,1);
     ClickTagXorLocal(tagIonizatVac3,1);
     ClickTagXorLocal(tagIonizatVac4,1);
     ClickTagXorLocal(tagThermalVac1,1);
     ClickTagXorLocal(tagCompressor1,1);
     ClickTagXorLocal(tagCompressor2,1);
     ClickTagXorLocal(tagCompressor3,1);
     ClickTagXorLocal(tagCompressor4,1);
     ClickTagXorLocal(tagLeakDetector,1);
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
