#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

##########################################################
## Script on make DAQ configuration integrity checksum. ##
##########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

function do_greetings(){
 echo "";
 echo "#####################################################";
 echo "# CRW-DAQ checksum secure script. Run on DAQ setup. #";
 echo "#####################################################";
 echo "";
};

function do_secure_checksum(){
 do_greetings;
 local workdir="$scriptHOME/..";
 pushd "$workdir" && do_make_checksum;
 popd;
};

function do_make_checksum(){
 echo "PWD $PWD";
 local exelist="*.exe *.dll *.bat *.cmd *.sh *.pas *.inc *.dpr *.lpr *.lpi";
 local cfglist="*.cfg *.crc *.sml";
 local exclude="temp/ data/ *.cal *.ini";
 ####################################################################################################################
 rm -fv checksum.md5;
 unix checksum -r -mchecksum "$exelist" -e "$exclude" >/dev/null;
 unix checksum -r -mcheckadd "$cfglist" -e "$exclude" >/dev/null;
 cat checkadd.md5 >> checksum.md5; rm -f checkadd.md5;
 cat checksum.md5;
 ####################################################################################################################
};

function main(){
 case $1 in
  -secure-checksum|--secure-checksum) do_secure_checksum; ;;
  *) ;;
 esac;
};

main "$@";

##############
## END OF FILE
##############
