---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Справка по EM2RS

---

**[demo_em2rs](../)** — демонстрационная кнофигурация драйвера шагового двигателя.

Документация: **[worksheet](worksheet/)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Назначение

**EM2RS** — Драйвер шагового двигателя **EM2RS-522** компании **Leadshine**

- Применяется системах с **ЧПУ** для управления шаговыми двигателями **NEMA 8, 11, 14, 17**.  
- Поддерживается коммуникационный протокол **Modbus RTU**.  
  Управление осуществляется через интерфейс **RS-485** или входы/выходы.  
  Имеются 7 настраиваемых входов и 3 оптоизолированных выхода.  
- Поддерживаются рабочие режимы: Движение на заданную позицию, Смещение на заданную позицию, Движение с заданной скоростью.  

Драйвер разработан с использованием библиотеки **[NetLibrary](../../../resource/daqsite/stdlib/include/_man_netlibrary.htm)**
и использует клиент **[&ModbusProxy](../../../resource/daqsite/modbusserver/modbusproxy.htm)**
в котором реализован протокол приемо-передачи **[modbus](../../../resource/tools/modbus/reference/)**.

**Задачи** драйвера:

- Задание скорости двигателя (мм/с`*`);  
- Задание величины перемещения (мм`**`);  
- Запуск движения шагового двигателя;  
- Отображение текущей позиции двигателя (мм`***`);  
- Отображение состояния концевых выключателей, подключенных к входам **D.in1**
  и **D.in2** контроллера (при замкнутом концевике, на кнопках движения  
  отображается "**|<—**" либо "**—>|**").  

> `*` Единица измерения задается на этапе конфигурирования - указывается
   в генераторе em2rs_devices.cmd, в таблице :EM2RSDevices,
   значения Unit и SpeedUnit.

> `**` В обычном режиме окно настройки параметров (EM2RS.Dx.PARAM) скрыто
  от пользователя. Оно доступно через диалог "Окна/Выбор окна" или клавиша F6;
  в диалоге "Инструменты", доступном по клику на метке девайса в окне управления
  контроллером; либо по кнопке "EM2RS.PARAM: Открыть окно диагностики"
  в панели команд ToolBar (Ctrl+Alt+1), окна управления контроллером.
  
> `***` Подробности смотри в [документации](worksheet/), раздел 5.4.
  Параметры Modbus RTU.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Конфигурирование и использование EM2RS


Для конфигурирования драйвера **EM2RS** используйте
файл-генератор **[em2rs_devices.cmd](../config/em2rs_devices.cmd)**
или **[em2rs_devices.sh](../config/em2rs_devices.sh)**.

В генераторе описывается таблица устройств __:EM2RSDevices__.  
В ней указываются следующие параметры:

- *DevLabel*      - Отображаемое имя устройства. Возможна запись нескольких слов через `_`;  
- *Facility*      - Имя (префикс) установки в составе которой будет работать драйвер;  
- *Identitier*    - Идентификатор устройства, который используется для разделения экземпляров драйвера (для каждого двигателя отдельный драйвер);  
- *ModbusPort*    - Номер **логического порта** Modbus - подробности см. в **[ModbusProxy](../../../resource/daqsite/modbusserver/modbusproxy.htm)**;  
- *UnitId*        - Адрес устройства **OSM** в сети **Modbus**;  
- *Polling*       - Период опроса **Modbus**, мс;  
- *SpeedUnit*     - Единицы измерения скорости;  
- *PosUnit*       - Единицы измерения текущего положения;  
- *MovUnit*       - Единицы измерения требуемой позиции/смещения.  

В зависимости от требуемого типа подключения (**COM**/**TCP**) указываются параметры:

- *ComPort*       - Номер физического **COM** порта;  
- *ComBaudrate*   - Скорость обмена физического **COM** порта;  

либо 

- *TCPPort*       - Порт **TCP** соединения;  
- *IP*            - Адрес **TCP** сосединения.  

Таблица логических портов **MODBUS** задается в секции **[&ModbusProxy.StartupScript]**
файла **[em2rs_devices.cfg](../config/em2rs_devices_hdw.cfg)**.
Присутствие данного файла в **DAQ**-системе обязательно.

Для использования драйвера **EM2RS** в целевой **DAQ**-системе,
необходимо скопировать файл-генератор **[em2rs_devices.cfg](../config/em2rs_devices_hdw.cfg)**
в каталог **`Config`**  **DAQ**-системы, сконфигурировать таблицу устройств
и запустить файл на исполнение.
После успешного выполнения генератора, в каталог **Config** будут добавлены файлы:

- *em2rs_devices_hdw.cfg*   - основная конфигурация драйвера;  
- *em2rs_devices_sim.cfg*   - симулятор драйвера;  
- *em2rs_devices_proxy.cfg* - таблица физических и логических портов;  
- *em2rs_devices_dic.cfg*   - клиенсткий DIM файл;  
- *em2rs_devices_dis.cfg*   - серверный DIM файл.  

 В каталог **Circuits** будет добавлен файл **em2rs_devices_link.crc** с описанием сенсоров:

- **@cron+@cron.run+EM2RS.XX.CTRL.SELECT** - Открыть окно управления драйвером **EM2RS**;  
- **EM2RS.XX.VALUE** - Текущая позиция двигателя.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Работа с энкодером (CS2RS)

Для установки режима работы с обратной связью необходимо:

- Указать верное разрешение экндера (количество меток на один оборот энкодера);
- **Установить дробление оборота на количество шагов на значение не меньшее, чем разрешение энкодера**;
- Переключить режим работы на работу с экнкодером (кнопка в правой верхней области мнемосхемы);
- Сохранить все параметры в EEPROM.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Калибровки EM2RS

Драйвер **EM2RS** имеет функционал преобразования шагов электродвигателя
в физические величины согласно калибровке: как линейной, так и нелинейной.
Подключение калибровки происходит в файле **em2rs_devices_hdw.cfg**
в секции описания драйвера:

``` ini
Calibrations   = 1
Calibration#0  = ..\Calibr\linear.CAL Step(st) Position(mm) Z SubZ Line 0 100
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Домкрат SX01-130-003

В драйвер встроена готовая **нелинейная калибровка** для домкрата **SX01-130-003**.  
Использовать со следующими параметрами:

![Управление домкратом](worksheet/lifting_jack.png)

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Решение проблем

---

### Сообщение **`Достигнут лимит калибровки`**  
Такое случается в основном на нелинейной калибровке, когда используется
обратное преобразование калибровки **invCalibr**.
Если такая проблема встретилась на линейной калибровке - увеличьте
значение **invCalibrLimit**, в остальных случаях см. далее.
  
> **function invCalibr(n:Integer; y,z,a,b:Real):Real;**
 - функция обратной калибровки по отношению к **calibr(n,x,z)**.
 Параметры **a**,**b** задают диапазон для возможных значений **x** (_a<=x<=b_).
 При удачном расчете функция возвратит такое значение **x**, что для него
 **calibr(n,x,z)=y**.
 При неудачном расчете (неверные входные параметры) функция возвратит **`_NaN`**.
 Функция может оказаться ресурсоемкой (она связана с решением уравнения
 итерационным методом), поэтому вызавать ее очень часто не стоит.

Диапазон работы функции ограничен, так как бывают моменты когда функция
находит несколько значений **x** (в результате **`_NaN`**).
Для нелинейных калибровок рекомендую ставить значение **invCalibrLimit**
равное максильманому значению калибровки **+40%**

### Не правильно работает DM2C-RS556 с внешним входом "CW ручное управление"
При назначении на любой DI режима "CCW ручное управление" устройство выдает неправильный статус своей работы. Проблема устройства, то есть не решаема, такое проявляется только на DM2C-RS556. Замените устройство на EM2RS или CS2RS, если хотите использовать данную функцию.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Список сокращений и аббревиатур

---

  Для именования кривых, тегов, сенсоров, окон и других программных объектов
  используются следующие **соглашения о наименовании**:
```
   Система:
    EM2RS Название
   Подсистема:
    D1 - EM2RS motor 1
    D2 - EM2RS motor 2
   Параметры:
     POLLRATE.RX   - Polling rate (Receive), Hz
    POLLRATE.TX   - Polling rate (Transmit), Hz
    ERROR.COUNT   - Error counter
    ENABLE        -
    PULSE         - Pulse/Revolution
    CTRLMODE      - Control Mode (CS2RS)
    MOTDIRECT     - Motor Direction
    POSERROR      - Allowed max pos follow error *
    FORCED        - Forced enable by software *
    POSLOOPKP     - Position loop Kp *
    VELLOOPKI     - Velocity loop Ki *
    VELLOOPKP     - Velocity loop Kp *
    POSLOOPKPH    - Position loop KpH *
    CMDTIME       - Command filter time *
    VELOTOC       - Vel swtch pnt: O to C loop *
    VELCTOO       - Vel swtch pnt: C to O loop *
    DELAYOTOC     - Delay of O to C loop *
    DELAYCTOO     - Delay of C to O loop *
    CFGINPUT1     - Input port DI1
    CFGINPUT2     - Input port DI2
    CFGINPUT3     - Input port DI3
    CFGINPUT4     - Input port DI4
    CFGINPUT5     - Input port DI5
    CFGINPUT6     - Input port DI6
    CFGINPUT7     - Input port DI7
    CFGOUTPUT1    - Output port DO1
    CFGOUTPUT2    - Output port DO2
    CFGOUTPUT3    - Output port DO3
    ALRMDETECT    - Alarm detection selection
    DIST2SEND     - Dist. 2send "In Pos" Out sign
    BUSVOLT       - Bus Voltage
    DISTATUS      - Digital Input Status
    DOSTATUS      - Digital Output Status
    PEAKCUR       - Peak Current
    HOLDINCLSD    - % of hold curr in closed-loop
    HOLDINOPEN    - % of hold curr in open-loop
    BAUDRATE      - Baudrate
    ADDRESS       - RS485 ID
    RS485TYPE     - Data type selection
    STBCURPER     - Standby Current Percentage
    JOGVEL        - JOG Velocity
    JOGINTER      - Interval
    JOGRUNTIME    - Running times
    JOGACCDEC     - Acc/Dec. time
    SOFTWARE      - Version Information
    FIRMWARE      - Firmare Version
    ENCODERES     - Encoder resolution
    MOTSTATUS     - Motion Status
    CTRLWORD      - Control Word
    SAVEWORD      - Save parameter status word
    CURALARM      - Current alarm
    PRCONTROL     - PR control register
    TRIGGER       - Trigger register
    SOFTLIMPOS    - Software limit positive
    SOFTLIMNEG    - Software limit positive
    HOMINGMODE    - Homing mode
    AFTERHOMING   - Move to specified location after homing
    HOMHIGHVEL    - Homing hight velocity
    HOMLOWVEL     - Homing low velocity
    HOMINGACC     - Homing Acc
    HOMINGDEC     - Homing Dec
    LIMSTOPTIME   - Limit stop time
    ESTOPTIME     - E-STOP time
    ACTPOS        - Actual position
    MOTPATH0      - Motion of path 0
    POSITION      - $6202 Position
    SPEED         - Velocity
    ACCELERAT     - Acc
    DECCELERAT    - Dec
   Например:
    EM2RS.D1.ENABLE    - Ток в обмотках
    EM2RS.D1.SPEED     - Скорость
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

 <img height=16 width=16 src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAADySURBVEhL7ZZBDoMgEEU9U7feyhNwHq/AhhM1Tbrrqt98+KEipalD0wUvaGaG8f9RN0whcV+W6zybLEhF0RCiwa7DZFF5M1AJzo91PbnyL7EZKMfezQhIURPik6K4aYTmjgaG4xO9xDCoMQyaHBtcEs457z1bCVIUy61avWEg2I0nY56gVq0OqgYYhB2aS3Eu+r4O2gYAKWCQ16mLoFYH/2dQwvr3BuxmiqBEPfqxHxnsYDcCGQMJ8cdyl0Xc2dMwQJ/mAqzE5HVStDEV7Dw2OI+8exmIYdDk5wYdjy2KDF9C40O8/9ERV+5huKjc+fgewhMcGb5AepwFjgAAAABJRU5ErkJggg=="/>
  EM2RS Copyright (c) 2001-2024 DaqGroup <daqgroup@mail.ru>.  
 <img height=16 width=16 src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAAQhJREFUSEvtljEOgzAUQ3MvbsUJOA9XYMmJ2qFbp5q+YH2VINQSlgorjRz//+3QKSkvePT9reuaLFkV05xLwEdHk4XzHGBJyc9xPLjiPzEH+KzavRFkhafMk1kpNoLvXQIaXh/4I66ALVwBu9gMmKZpGIaUknZxRHHDIj1wQ4p0kXqAhlWOwK4cFlj8OoAy84RhYVIVhUiki9QD4kxE1NcBpHKtQwGyiF5u1g7gPwYYuAtvzzkVkR1R1XqAarZghm4IVZTYINja4/UAZiLoFtGwCBZwH+lh1qV6gKA+uzAprE3hNMOFOLIZ0ApXwC7+L+DEZ4tZw4/w9WV+/tNRv5jRcOF88vM95xfHjbs66Lo86gAAAABJRU5ErkJggg=="/>
 CRW-DAQ Copyright (c) 2001-2024 Alexey Kuryakin <daqgroup@mail.ru>.

---
